/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty3;

import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;

@ChannelHandler.Sharable
public class Netty3OpenChannelsHandler
implements ChannelUpstreamHandler,
Releasable {
    final Set<Channel> openChannels = ConcurrentCollections.newConcurrentSet();
    final CounterMetric openChannelsMetric = new CounterMetric();
    final CounterMetric totalChannelsMetric = new CounterMetric();
    final Logger logger;
    final ChannelFutureListener remover = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            boolean removed = Netty3OpenChannelsHandler.this.openChannels.remove(future.getChannel());
            if (removed) {
                Netty3OpenChannelsHandler.this.openChannelsMetric.dec();
            }
            if (Netty3OpenChannelsHandler.this.logger.isTraceEnabled()) {
                Netty3OpenChannelsHandler.this.logger.trace("channel closed: {}", (Object)future.getChannel());
            }
        }
    };

    public Netty3OpenChannelsHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent evt;
        if (e instanceof ChannelStateEvent && (evt = (ChannelStateEvent)e).getState() == ChannelState.OPEN && Boolean.TRUE.equals(evt.getValue())) {
            boolean added;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("channel opened: {}", (Object)ctx.getChannel());
            }
            if (added = this.openChannels.add(ctx.getChannel())) {
                this.openChannelsMetric.inc();
                this.totalChannelsMetric.inc();
                ctx.getChannel().getCloseFuture().addListener(this.remover);
            }
        }
        ctx.sendUpstream(e);
    }

    public long numberOfOpenChannels() {
        return this.openChannelsMetric.count();
    }

    public long totalChannels() {
        return this.totalChannelsMetric.count();
    }

    @Override
    public void close() {
        for (Channel channel : this.openChannels) {
            channel.close().awaitUninterruptibly();
        }
    }
}

