/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.env.Environment;

class RemovePluginCommand
extends EnvironmentAwareCommand {
    private final OptionSpec<String> arguments;

    RemovePluginCommand() {
        super("removes a plugin from Elasticsearch");
        this.arguments = this.parser.nonOptions("plugin name");
    }

    @Override
    protected void execute(Terminal terminal2, OptionSet options, Environment env) throws Exception {
        String pluginName = this.arguments.value(options);
        this.execute(terminal2, pluginName, env);
    }

    void execute(Terminal terminal2, String pluginName, Environment env) throws IOException, UserException {
        if (pluginName == null) {
            throw new UserException(64, "plugin name is required");
        }
        terminal2.println("-> removing [" + Strings.coalesceToEmpty(pluginName) + "]...");
        Path pluginDir = env.pluginsFile().resolve(pluginName);
        if (!Files.exists(pluginDir, new LinkOption[0])) {
            String message = String.format(Locale.ROOT, "plugin [%s] not found; run 'elasticsearch-plugin list' to get list of installed plugins", pluginName);
            throw new UserException(78, message);
        }
        ArrayList<Path> pluginPaths = new ArrayList<Path>();
        Path pluginBinDir = env.binFile().resolve(pluginName);
        if (Files.exists(pluginBinDir, new LinkOption[0])) {
            if (!Files.isDirectory(pluginBinDir, new LinkOption[0])) {
                throw new UserException(74, "bin dir for " + pluginName + " is not a directory");
            }
            pluginPaths.add(pluginBinDir);
            terminal2.println(Terminal.Verbosity.VERBOSE, "removing [" + pluginBinDir + "]");
        }
        terminal2.println(Terminal.Verbosity.VERBOSE, "removing [" + pluginDir + "]");
        Path removing = pluginDir.resolve(".removing-" + pluginName);
        try (Stream<Path> paths = Files.list(pluginDir);){
            pluginPaths.addAll(paths.collect(Collectors.toList()));
        }
        try {
            Files.createFile(removing, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            terminal2.println(Terminal.Verbosity.VERBOSE, "marker file [" + removing + "] already exists");
        }
        pluginPaths.add(removing);
        pluginPaths.add(pluginDir);
        IOUtils.rm(pluginPaths.toArray(new Path[pluginPaths.size()]));
        Path pluginConfigDir = env.configFile().resolve(pluginName);
        if (Files.exists(pluginConfigDir, new LinkOption[0])) {
            String message = String.format(Locale.ROOT, "-> preserving plugin config files [%s] in case of upgrade; delete manually if not needed", pluginConfigDir);
            terminal2.println(message);
        }
    }
}

