/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.ckb.SoraniNormalizationFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.UpperCaseFilter;
import org.apache.lucene.analysis.cz.CzechStemFilter;
import org.apache.lucene.analysis.de.GermanNormalizationFilter;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.en.KStemFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.hi.HindiNormalizationFilter;
import org.apache.lucene.analysis.in.IndicNormalizationFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.KeywordRepeatFilter;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.apache.lucene.analysis.miscellaneous.ScandinavianFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.ScandinavianNormalizationFilter;
import org.apache.lucene.analysis.miscellaneous.TrimFilter;
import org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;
import org.apache.lucene.analysis.miscellaneous.UniqueTokenFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilter;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.TypeAsPayloadTokenFilter;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.ClassicFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.tr.ApostropheFilter;
import org.apache.lucene.analysis.util.ElisionFilter;
import org.elasticsearch.Version;
import org.elasticsearch.index.analysis.DelimitedPayloadTokenFilterFactory;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;

public enum PreBuiltTokenFilters {
    WORD_DELIMITER(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new WordDelimiterFilter(tokenStream, 451, null);
        }
    }
    ,
    WORD_DELIMITER_GRAPH(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new WordDelimiterGraphFilter(tokenStream, 451, null);
        }
    }
    ,
    STOP(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new StopFilter(tokenStream, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        }
    }
    ,
    TRIM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new TrimFilter(tokenStream);
        }
    }
    ,
    REVERSE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new ReverseStringFilter(tokenStream);
        }
    }
    ,
    ASCIIFOLDING(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new ASCIIFoldingFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    LENGTH(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new LengthFilter(tokenStream, 0, Integer.MAX_VALUE);
        }
    }
    ,
    COMMON_GRAMS(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new CommonGramsFilter(tokenStream, CharArraySet.EMPTY_SET);
        }
    }
    ,
    LOWERCASE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new LowerCaseFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    UPPERCASE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new UpperCaseFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    KSTEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new KStemFilter(tokenStream);
        }
    }
    ,
    PORTER_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new PorterStemFilter(tokenStream);
        }
    }
    ,
    STANDARD(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new StandardFilter(tokenStream);
        }
    }
    ,
    CLASSIC(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new ClassicFilter(tokenStream);
        }
    }
    ,
    NGRAM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new NGramTokenFilter(tokenStream);
        }
    }
    ,
    EDGE_NGRAM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new EdgeNGramTokenFilter(tokenStream, 1, 1);
        }
    }
    ,
    UNIQUE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new UniqueTokenFilter(tokenStream);
        }
    }
    ,
    TRUNCATE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new TruncateTokenFilter(tokenStream, 10);
        }
    }
    ,
    SNOWBALL(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new SnowballFilter(tokenStream, "English");
        }
    }
    ,
    STEMMER(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new PorterStemFilter(tokenStream);
        }
    }
    ,
    ELISION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new ElisionFilter(tokenStream, FrenchAnalyzer.DEFAULT_ARTICLES);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    ARABIC_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new ArabicStemFilter(tokenStream);
        }
    }
    ,
    BRAZILIAN_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new BrazilianStemFilter(tokenStream);
        }
    }
    ,
    CZECH_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new CzechStemFilter(tokenStream);
        }
    }
    ,
    DUTCH_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new SnowballFilter(tokenStream, new DutchStemmer());
        }
    }
    ,
    FRENCH_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new SnowballFilter(tokenStream, new FrenchStemmer());
        }
    }
    ,
    GERMAN_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new GermanStemFilter(tokenStream);
        }
    }
    ,
    RUSSIAN_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new SnowballFilter(tokenStream, "Russian");
        }
    }
    ,
    KEYWORD_REPEAT(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new KeywordRepeatFilter(tokenStream);
        }
    }
    ,
    ARABIC_NORMALIZATION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new ArabicNormalizationFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    PERSIAN_NORMALIZATION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new PersianNormalizationFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    TYPE_AS_PAYLOAD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new TypeAsPayloadTokenFilter(tokenStream);
        }
    }
    ,
    SHINGLE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new ShingleFilter(tokenStream);
        }
    }
    ,
    GERMAN_NORMALIZATION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new GermanNormalizationFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    HINDI_NORMALIZATION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new HindiNormalizationFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    INDIC_NORMALIZATION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new IndicNormalizationFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    SORANI_NORMALIZATION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new SoraniNormalizationFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    SCANDINAVIAN_NORMALIZATION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new ScandinavianNormalizationFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    SCANDINAVIAN_FOLDING(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new ScandinavianFoldingFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    APOSTROPHE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new ApostropheFilter(tokenStream);
        }
    }
    ,
    CJK_WIDTH(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new CJKWidthFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    DECIMAL_DIGIT(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new DecimalDigitFilter(tokenStream);
        }

        @Override
        protected boolean isMultiTermAware() {
            return true;
        }
    }
    ,
    CJK_BIGRAM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new CJKBigramFilter(tokenStream);
        }
    }
    ,
    DELIMITED_PAYLOAD_FILTER(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new DelimitedPayloadTokenFilter(tokenStream, '|', DelimitedPayloadTokenFilterFactory.DEFAULT_ENCODER);
        }
    }
    ,
    LIMIT(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version2) {
            return new LimitTokenCountFilter(tokenStream, 1, false);
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<TokenFilterFactory> cache;

    protected boolean isMultiTermAware() {
        return false;
    }

    public abstract TokenStream create(TokenStream var1, Version var2);

    private PreBuiltTokenFilters(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    public synchronized TokenFilterFactory getTokenFilterFactory(final Version version2) {
        TokenFilterFactory factory = this.cache.get(version2);
        if (factory == null) {
            final String finalName = this.name().toLowerCase(Locale.ROOT);
            factory = this.isMultiTermAware() ? new MultiTermAwareTokenFilterFactory(){

                @Override
                public String name() {
                    return finalName;
                }

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return PreBuiltTokenFilters.this.create(tokenStream, version2);
                }

                @Override
                public Object getMultiTermComponent() {
                    return this;
                }
            } : new TokenFilterFactory(){

                @Override
                public String name() {
                    return finalName;
                }

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return PreBuiltTokenFilters.this.create(tokenStream, version2);
                }
            };
            this.cache.put(version2, factory);
        }
        return factory;
    }

    public static PreBuiltTokenFilters getOrDefault(String name, PreBuiltTokenFilters defaultTokenFilter) {
        try {
            return PreBuiltTokenFilters.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultTokenFilter;
        }
    }

    private static interface MultiTermAwareTokenFilterFactory
    extends TokenFilterFactory,
    MultiTermAwareComponent {
    }
}

