/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.TermQueryPrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.LegacyPrefixTree;
import org.apache.lucene.spatial.prefix.tree.PackedQuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.elasticsearch.Version;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class GeoShapeFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "geo_shape";
    protected Explicit<Boolean> coerce;

    public GeoShapeFieldMapper(String simpleName, MappedFieldType fieldType, Explicit<Boolean> coerce, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, Defaults.FIELD_TYPE, indexSettings, multiFields, copyTo);
        this.coerce = coerce;
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        try {
            Shape shape = context.parseExternalValue(Shape.class);
            if (shape == null) {
                ShapeBuilder shapeBuilder = ShapeBuilder.parse(context.parser(), this);
                if (shapeBuilder == null) {
                    return null;
                }
                shape = shapeBuilder.build();
            }
            if (this.fieldType().pointsOnly() && !(shape instanceof Point)) {
                throw new MapperParsingException("[{" + this.fieldType().name() + "}] is configured for points only but a " + (shape instanceof JtsGeometry ? ((JtsGeometry)shape).getGeom().getGeometryType() : shape.getClass()) + " was found");
            }
            Field[] fields = this.fieldType().defaultStrategy().createIndexableFields(shape);
            if (fields == null || fields.length == 0) {
                return null;
            }
            for (Field field : fields) {
                if (!this.customBoost() && this.fieldType.boost() != 1.0f && Version.indexCreated(context.indexSettings()).before(Version.V_5_0_0_alpha1)) {
                    field.setBoost(this.fieldType().boost());
                }
                context.doc().add(field);
            }
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse [" + this.fieldType().name() + "]", e);
        }
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        GeoShapeFieldMapper gsfm = (GeoShapeFieldMapper)mergeWith;
        if (gsfm.coerce.explicit()) {
            this.coerce = gsfm.coerce;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        if (includeDefaults || !this.fieldType().tree().equals("geohash")) {
            builder.field("tree", this.fieldType().tree());
        }
        if (includeDefaults || this.fieldType().treeLevels() != 0) {
            builder.field("tree_levels", this.fieldType().treeLevels());
        }
        if (includeDefaults || this.fieldType().precisionInMeters() != -1.0) {
            builder.field("precision", DistanceUnit.METERS.toString(this.fieldType().precisionInMeters()));
        }
        if (includeDefaults || this.fieldType().strategyName() != Defaults.STRATEGY) {
            builder.field("strategy", this.fieldType().strategyName());
        }
        if (includeDefaults || this.fieldType().distanceErrorPct() != this.fieldType().defaultDistanceErrorPct) {
            builder.field("distance_error_pct", this.fieldType().distanceErrorPct());
        }
        if (includeDefaults || this.fieldType().orientation() != Defaults.ORIENTATION) {
            builder.field("orientation", (Object)this.fieldType().orientation());
        }
        if (includeDefaults || this.fieldType().pointsOnly()) {
            builder.field("points_only", this.fieldType().pointsOnly());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
    }

    public Explicit<Boolean> coerce() {
        return this.coerce;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class GeoShapeFieldType
    extends MappedFieldType {
        private String tree = "geohash";
        private String strategyName = Defaults.STRATEGY;
        private boolean pointsOnly = false;
        private int treeLevels = 0;
        private double precisionInMeters = -1.0;
        private Double distanceErrorPct;
        private double defaultDistanceErrorPct = 0.0;
        private ShapeBuilder.Orientation orientation = Defaults.ORIENTATION;
        private PrefixTreeStrategy defaultStrategy;
        private RecursivePrefixTreeStrategy recursiveStrategy;
        private TermQueryPrefixTreeStrategy termStrategy;

        public GeoShapeFieldType() {
        }

        protected GeoShapeFieldType(GeoShapeFieldType ref) {
            super(ref);
            this.tree = ref.tree;
            this.strategyName = ref.strategyName;
            this.pointsOnly = ref.pointsOnly;
            this.treeLevels = ref.treeLevels;
            this.precisionInMeters = ref.precisionInMeters;
            this.distanceErrorPct = ref.distanceErrorPct;
            this.defaultDistanceErrorPct = ref.defaultDistanceErrorPct;
            this.orientation = ref.orientation;
        }

        @Override
        public GeoShapeFieldType clone() {
            return new GeoShapeFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            GeoShapeFieldType that = (GeoShapeFieldType)o;
            return this.treeLevels == that.treeLevels && this.precisionInMeters == that.precisionInMeters && this.defaultDistanceErrorPct == that.defaultDistanceErrorPct && Objects.equals(this.tree, that.tree) && Objects.equals(this.strategyName, that.strategyName) && this.pointsOnly == that.pointsOnly && Objects.equals(this.distanceErrorPct, that.distanceErrorPct) && this.orientation == that.orientation;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.tree, this.strategyName, this.pointsOnly, this.treeLevels, this.precisionInMeters, this.distanceErrorPct, this.defaultDistanceErrorPct, this.orientation});
        }

        @Override
        public String typeName() {
            return GeoShapeFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void freeze() {
            LegacyPrefixTree prefixTree;
            super.freeze();
            if ("geohash".equals(this.tree)) {
                prefixTree = new GeohashPrefixTree(ShapeBuilder.SPATIAL_CONTEXT, GeoShapeFieldType.getLevels(this.treeLevels, this.precisionInMeters, Defaults.GEOHASH_LEVELS, true));
            } else if ("legacyquadtree".equals(this.tree)) {
                prefixTree = new QuadPrefixTree(ShapeBuilder.SPATIAL_CONTEXT, GeoShapeFieldType.getLevels(this.treeLevels, this.precisionInMeters, Defaults.QUADTREE_LEVELS, false));
            } else if ("quadtree".equals(this.tree)) {
                prefixTree = new PackedQuadPrefixTree(ShapeBuilder.SPATIAL_CONTEXT, GeoShapeFieldType.getLevels(this.treeLevels, this.precisionInMeters, Defaults.QUADTREE_LEVELS, false));
            } else {
                throw new IllegalArgumentException("Unknown prefix tree type [" + this.tree + "]");
            }
            this.recursiveStrategy = new RecursivePrefixTreeStrategy(prefixTree, this.name());
            this.recursiveStrategy.setDistErrPct(this.distanceErrorPct());
            this.recursiveStrategy.setPruneLeafyBranches(false);
            this.termStrategy = new TermQueryPrefixTreeStrategy(prefixTree, this.name());
            this.termStrategy.setDistErrPct(this.distanceErrorPct());
            this.defaultStrategy = this.resolveStrategy(this.strategyName);
            this.defaultStrategy.setPointsOnly(this.pointsOnly);
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            GeoShapeFieldType other = (GeoShapeFieldType)fieldType;
            if (!this.strategyName().equals(other.strategyName())) {
                conflicts.add("mapper [" + this.name() + "] has different [strategy]");
            }
            if (!this.tree().equals(other.tree())) {
                conflicts.add("mapper [" + this.name() + "] has different [tree]");
            }
            if (this.pointsOnly() != other.pointsOnly()) {
                conflicts.add("mapper [" + this.name() + "] has different points_only");
            }
            if (this.treeLevels() != other.treeLevels()) {
                conflicts.add("mapper [" + this.name() + "] has different [tree_levels]");
            }
            if (this.precisionInMeters() != other.precisionInMeters()) {
                conflicts.add("mapper [" + this.name() + "] has different [precision]");
            }
            if (strict) {
                if (this.orientation() != other.orientation()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [orientation] across all types.");
                }
                if (this.distanceErrorPct() != other.distanceErrorPct()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [distance_error_pct] across all types.");
                }
            }
        }

        private static int getLevels(int treeLevels, double precisionInMeters, int defaultLevels, boolean geoHash) {
            if (treeLevels > 0 || precisionInMeters >= 0.0) {
                return Math.max(treeLevels, precisionInMeters >= 0.0 ? (geoHash ? GeoUtils.geoHashLevelsForPrecision(precisionInMeters) : GeoUtils.quadTreeLevelsForPrecision(precisionInMeters)) : 0);
            }
            return defaultLevels;
        }

        public String tree() {
            return this.tree;
        }

        public void setTree(String tree) {
            this.checkIfFrozen();
            this.tree = tree;
        }

        public String strategyName() {
            return this.strategyName;
        }

        public void setStrategyName(String strategyName) {
            this.checkIfFrozen();
            this.strategyName = strategyName;
            if (this.strategyName.equals(SpatialStrategy.TERM)) {
                this.pointsOnly = true;
            }
        }

        public boolean pointsOnly() {
            return this.pointsOnly;
        }

        public void setPointsOnly(boolean pointsOnly) {
            this.checkIfFrozen();
            this.pointsOnly = pointsOnly;
        }

        public int treeLevels() {
            return this.treeLevels;
        }

        public void setTreeLevels(int treeLevels) {
            this.checkIfFrozen();
            this.treeLevels = treeLevels;
        }

        public double precisionInMeters() {
            return this.precisionInMeters;
        }

        public void setPrecisionInMeters(double precisionInMeters) {
            this.checkIfFrozen();
            this.precisionInMeters = precisionInMeters;
        }

        public double distanceErrorPct() {
            return this.distanceErrorPct == null ? this.defaultDistanceErrorPct : this.distanceErrorPct;
        }

        public void setDistanceErrorPct(double distanceErrorPct) {
            this.checkIfFrozen();
            this.distanceErrorPct = distanceErrorPct;
        }

        public void setDefaultDistanceErrorPct(double defaultDistanceErrorPct) {
            this.checkIfFrozen();
            this.defaultDistanceErrorPct = defaultDistanceErrorPct;
        }

        public ShapeBuilder.Orientation orientation() {
            return this.orientation;
        }

        public void setOrientation(ShapeBuilder.Orientation orientation) {
            this.checkIfFrozen();
            this.orientation = orientation;
        }

        public PrefixTreeStrategy defaultStrategy() {
            return this.defaultStrategy;
        }

        public PrefixTreeStrategy resolveStrategy(SpatialStrategy strategy) {
            return this.resolveStrategy(strategy.getStrategyName());
        }

        public PrefixTreeStrategy resolveStrategy(String strategyName) {
            if (SpatialStrategy.RECURSIVE.getStrategyName().equals(strategyName)) {
                return this.recursiveStrategy;
            }
            if (SpatialStrategy.TERM.getStrategyName().equals(strategyName)) {
                return this.termStrategy;
            }
            throw new IllegalArgumentException("Unknown prefix tree strategy [" + strategyName + "]");
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Geo fields do not support exact searching, use dedicated geo queries instead", new Object[0]);
        }

        @Override
        public FieldStats stats(IndexReader reader) throws IOException {
            int maxDoc = reader.maxDoc();
            FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(this.name());
            if (fi == null) {
                return null;
            }
            return new FieldStats.Text(maxDoc, -1L, -1L, -1L, this.isSearchable(), this.isAggregatable());
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if ("tree".equals(fieldName)) {
                    builder.fieldType().setTree(fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if ("tree_levels".equals(fieldName)) {
                    builder.fieldType().setTreeLevels(Integer.parseInt(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if ("precision".equals(fieldName)) {
                    builder.fieldType().setPrecisionInMeters(DistanceUnit.parse(fieldNode.toString(), DistanceUnit.DEFAULT, DistanceUnit.DEFAULT));
                    iterator.remove();
                    continue;
                }
                if ("distance_error_pct".equals(fieldName)) {
                    builder.fieldType().setDistanceErrorPct(Double.parseDouble(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if ("orientation".equals(fieldName)) {
                    builder.fieldType().setOrientation(ShapeBuilder.Orientation.fromString(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if ("strategy".equals(fieldName)) {
                    builder.fieldType().setStrategyName(fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if ("coerce".equals(fieldName)) {
                    builder.coerce(TypeParsers.nodeBooleanValue(fieldName, "coerce", fieldNode));
                    iterator.remove();
                    continue;
                }
                if (!"points_only".equals(fieldName) || builder.fieldType().strategyName.equals(SpatialStrategy.TERM.getStrategyName())) continue;
                boolean pointsOnly = TypeParsers.nodeBooleanValue(fieldName, "points_only", fieldNode);
                builder.fieldType().setPointsOnly(pointsOnly);
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, GeoShapeFieldMapper> {
        private Boolean coerce;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
        }

        @Override
        public GeoShapeFieldType fieldType() {
            return (GeoShapeFieldType)this.fieldType;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        @Override
        public GeoShapeFieldMapper build(Mapper.BuilderContext context) {
            GeoShapeFieldType geoShapeFieldType = (GeoShapeFieldType)this.fieldType;
            if (geoShapeFieldType.treeLevels() == 0 && geoShapeFieldType.precisionInMeters() < 0.0) {
                geoShapeFieldType.setDefaultDistanceErrorPct(0.025);
            }
            this.setupFieldType(context);
            return new GeoShapeFieldMapper(this.name, this.fieldType, this.coerce(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final String TREE = "geohash";
        public static final String STRATEGY = SpatialStrategy.RECURSIVE.getStrategyName();
        public static final boolean POINTS_ONLY = false;
        public static final int GEOHASH_LEVELS = GeoUtils.geoHashLevelsForPrecision("50m");
        public static final int QUADTREE_LEVELS = GeoUtils.quadTreeLevelsForPrecision("50m");
        public static final ShapeBuilder.Orientation ORIENTATION = ShapeBuilder.Orientation.RIGHT;
        public static final double LEGACY_DISTANCE_ERROR_PCT = 0.025;
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(false, false);
        public static final MappedFieldType FIELD_TYPE = new GeoShapeFieldType();

        static {
            FIELD_TYPE.setName("DoesNotExist");
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }

    public static class Names {
        public static final String TREE = "tree";
        public static final String TREE_GEOHASH = "geohash";
        public static final String TREE_QUADTREE = "quadtree";
        public static final String TREE_LEVELS = "tree_levels";
        public static final String TREE_PRESISION = "precision";
        public static final String DISTANCE_ERROR_PCT = "distance_error_pct";
        public static final String ORIENTATION = "orientation";
        public static final String STRATEGY = "strategy";
        public static final String STRATEGY_POINTS_ONLY = "points_only";
        public static final String COERCE = "coerce";
    }
}

