/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.env.Environment;

class AddFileKeyStoreCommand
extends EnvironmentAwareCommand {
    private final OptionSpec<Void> forceOption;
    private final OptionSpec<String> arguments;

    AddFileKeyStoreCommand() {
        super("Add a file setting to the keystore");
        this.forceOption = this.parser.acceptsAll(Arrays.asList("f", "force"), "Overwrite existing setting without prompting");
        this.arguments = this.parser.nonOptions("setting [filepath]");
    }

    @Override
    protected void execute(Terminal terminal2, OptionSet options, Environment env) throws Exception {
        KeyStoreWrapper keystore = KeyStoreWrapper.load(env.configFile());
        if (keystore == null) {
            throw new UserException(65, "Elasticsearch keystore not found. Use 'create' command to create one.");
        }
        keystore.decrypt(new char[0]);
        List<String> argumentValues = this.arguments.values(options);
        if (argumentValues.size() == 0) {
            throw new UserException(64, "Missing setting name");
        }
        String setting = argumentValues.get(0);
        if (keystore.getSettingNames().contains(setting) && !options.has(this.forceOption) && !terminal2.promptYesNo("Setting " + setting + " already exists. Overwrite?", false)) {
            terminal2.println("Exiting without modifying keystore.");
            return;
        }
        if (argumentValues.size() == 1) {
            throw new UserException(64, "Missing file name");
        }
        Path file = this.getPath(argumentValues.get(1));
        if (!Files.exists(file, new LinkOption[0])) {
            throw new UserException(74, "File [" + file.toString() + "] does not exist");
        }
        if (argumentValues.size() > 2) {
            throw new UserException(64, "Unrecognized extra arguments [" + String.join((CharSequence)", ", argumentValues.subList(2, argumentValues.size())) + "] after filepath");
        }
        keystore.setFile(setting, Files.readAllBytes(file));
        keystore.save(env.configFile());
    }

    @SuppressForbidden(reason="file arg for cli")
    private Path getPath(String file) {
        return PathUtils.get(file, new String[0]);
    }
}

