/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda;

import java.util.Locale;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;

public class FormatDateTimeFormatter {
    private final String format;
    private final DateTimeFormatter parser;
    private final DateTimeFormatter printer;
    private final Locale locale;

    public FormatDateTimeFormatter(String format, DateTimeFormatter parser2, Locale locale) {
        this(format, parser2, parser2, locale);
    }

    public FormatDateTimeFormatter(String format, DateTimeFormatter parser2, DateTimeFormatter printer, Locale locale) {
        this.format = format;
        this.locale = Objects.requireNonNull(locale, "A locale is required as JODA otherwise uses the default locale");
        this.printer = printer.withLocale(locale).withDefaultYear(1970);
        this.parser = parser2.withLocale(locale).withDefaultYear(1970);
    }

    public String format() {
        return this.format;
    }

    public DateTimeFormatter parser() {
        return this.parser;
    }

    public DateTimeFormatter printer() {
        return this.printer;
    }

    public Locale locale() {
        return this.locale;
    }
}

