/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.main;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class MainResponse
extends ActionResponse
implements ToXContentObject {
    private String nodeName;
    private Version version;
    private ClusterName clusterName;
    private String clusterUuid;
    private Build build;
    private boolean available;
    private static final ObjectParser<MainResponse, Void> PARSER = new ObjectParser(MainResponse.class.getName(), true, () -> new MainResponse());

    MainResponse() {
    }

    public MainResponse(String nodeName, Version version2, ClusterName clusterName, String clusterUuid, Build build, boolean available) {
        this.nodeName = nodeName;
        this.version = version2;
        this.clusterName = clusterName;
        this.clusterUuid = clusterUuid;
        this.build = build;
        this.available = available;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Version getVersion() {
        return this.version;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public String getClusterUuid() {
        return this.clusterUuid;
    }

    public Build getBuild() {
        return this.build;
    }

    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.nodeName);
        Version.writeVersion(this.version, out);
        this.clusterName.writeTo(out);
        out.writeString(this.clusterUuid);
        Build.writeBuild(this.build, out);
        out.writeBoolean(this.available);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodeName = in.readString();
        this.version = Version.readVersion(in);
        this.clusterName = new ClusterName(in);
        this.clusterUuid = in.readString();
        this.build = Build.readBuild(in);
        this.available = in.readBoolean();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.nodeName);
        builder.field("cluster_name", this.clusterName.value());
        builder.field("cluster_uuid", this.clusterUuid);
        builder.startObject("version").field("number", this.version.toString()).field("build_hash", this.build.shortHash()).field("build_date", this.build.date()).field("build_snapshot", this.build.isSnapshot()).field("lucene_version", this.version.luceneVersion.toString()).endObject();
        builder.field("tagline", "You Know, for Search");
        builder.endObject();
        return builder;
    }

    public static MainResponse fromXContent(XContentParser parser2) {
        return PARSER.apply(parser2, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MainResponse other = (MainResponse)o;
        return Objects.equals(this.nodeName, other.nodeName) && Objects.equals(this.version, other.version) && Objects.equals(this.clusterUuid, other.clusterUuid) && Objects.equals(this.build, other.build) && Objects.equals(this.available, other.available) && Objects.equals(this.clusterName, other.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.version, this.clusterUuid, this.build, this.clusterName, this.available);
    }

    static {
        PARSER.declareString((response, value) -> {
            response.nodeName = value;
        }, new ParseField("name", new String[0]));
        PARSER.declareString((response, value) -> {
            response.clusterName = new ClusterName((String)value);
        }, new ParseField("cluster_name", new String[0]));
        PARSER.declareString((response, value) -> {
            response.clusterUuid = value;
        }, new ParseField("cluster_uuid", new String[0]));
        PARSER.declareString((response, value) -> {}, new ParseField("tagline", new String[0]));
        PARSER.declareObject((response, value) -> {
            response.build = new Build((String)value.get("build_hash"), (String)value.get("build_date"), (Boolean)value.get("build_snapshot"));
            response.version = Version.fromString((String)value.get("number"));
            response.available = true;
        }, (parser2, context) -> parser2.map(), new ParseField("version", new String[0]));
    }
}

