/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.DocIdSetBuilder;
import org.locationtech.spatial4j.shape.Shape;

public abstract class AbstractPrefixTreeQuery
extends Query {
    protected final Shape queryShape;
    protected final String fieldName;
    protected final SpatialPrefixTree grid;
    protected final int detailLevel;

    public AbstractPrefixTreeQuery(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel) {
        this.queryShape = queryShape;
        this.fieldName = fieldName;
        this.grid = grid;
        this.detailLevel = detailLevel;
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((AbstractPrefixTreeQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(AbstractPrefixTreeQuery other) {
        return this.detailLevel == other.detailLevel && this.fieldName.equals(other.fieldName) && this.queryShape.equals(other.queryShape);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.queryShape.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + this.detailLevel;
        return result;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSet docSet = AbstractPrefixTreeQuery.this.getDocIdSet(context);
                if (docSet == null) {
                    return null;
                }
                DocIdSetIterator disi = docSet.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }
        };
    }

    protected abstract DocIdSet getDocIdSet(LeafReaderContext var1) throws IOException;

    public abstract class BaseTermsEnumTraverser {
        protected final LeafReaderContext context;
        protected final int maxDoc;
        protected final Terms terms;
        protected final TermsEnum termsEnum;
        protected PostingsEnum postingsEnum;

        public BaseTermsEnumTraverser(LeafReaderContext context) throws IOException {
            this.context = context;
            LeafReader reader = context.reader();
            this.maxDoc = reader.maxDoc();
            this.terms = reader.terms(AbstractPrefixTreeQuery.this.fieldName);
            this.termsEnum = this.terms != null ? this.terms.iterator() : null;
        }

        protected void collectDocs(BitSet bitSet) throws IOException {
            assert (this.termsEnum != null);
            this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
            bitSet.or(this.postingsEnum);
        }

        protected void collectDocs(DocIdSetBuilder docSetBuilder) throws IOException {
            assert (this.termsEnum != null);
            this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
            docSetBuilder.add(this.postingsEnum);
        }
    }
}

