/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointDistanceQuery;

public final class XGeoPointDistanceRangeQuery
extends GeoPointDistanceQuery {
    protected final double minRadiusMeters;

    public XGeoPointDistanceRangeQuery(String field, double centerLat, double centerLon, double minRadiusMeters, double maxRadiusMeters) {
        this(field, GeoPointField.TermEncoding.PREFIX, centerLat, centerLon, minRadiusMeters, maxRadiusMeters);
    }

    public XGeoPointDistanceRangeQuery(String field, GeoPointField.TermEncoding termEncoding, double centerLat, double centerLon, double minRadiusMeters, double maxRadius) {
        super(field, termEncoding, centerLat, centerLon, maxRadius);
        this.minRadiusMeters = minRadiusMeters;
    }

    @Override
    public Query rewrite(IndexReader reader) {
        Query q = super.rewrite(reader);
        if (this.minRadiusMeters == 0.0) {
            return q;
        }
        BooleanQuery.Builder bqb = new BooleanQuery.Builder();
        GeoPointDistanceQuery exclude = new GeoPointDistanceQuery(this.field, this.termEncoding, this.centerLat, this.centerLon, this.minRadiusMeters);
        bqb.add(new BooleanClause(q, BooleanClause.Occur.MUST));
        bqb.add(new BooleanClause(exclude, BooleanClause.Occur.MUST_NOT));
        return bqb.build();
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        return sb.append(" Center: [").append(this.centerLat).append(',').append(this.centerLon).append(']').append(" From Distance: ").append(this.minRadiusMeters).append(" m").append(" To Distance: ").append(this.radiusMeters).append(" m").append(" Lower Left: [").append(this.minLat).append(',').append(this.minLon).append(']').append(" Upper Right: [").append(this.maxLat).append(',').append(this.maxLon).append("]").toString();
    }

    public double getMinRadiusMeters() {
        return this.minRadiusMeters;
    }

    public double getMaxRadiusMeters() {
        return this.radiusMeters;
    }
}

