/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Boolean2ScorerSupplier;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.BooleanTopLevelScorers;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ReqExclBulkScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;

final class BooleanWeight
extends Weight {
    final Similarity similarity;
    final BooleanQuery query;
    final ArrayList<Weight> weights;
    final int maxCoord;
    final boolean disableCoord;
    final boolean needsScores;
    final float[] coords;

    BooleanWeight(BooleanQuery query, IndexSearcher searcher, boolean needsScores, boolean disableCoord) throws IOException {
        super(query);
        this.query = query;
        this.needsScores = needsScores;
        this.similarity = searcher.getSimilarity(needsScores);
        this.weights = new ArrayList();
        int i = 0;
        int maxCoord = 0;
        for (BooleanClause c : query) {
            Weight w = searcher.createWeight(c.getQuery(), needsScores && c.isScoring());
            this.weights.add(w);
            if (c.isScoring()) {
                ++maxCoord;
            }
            ++i;
        }
        this.maxCoord = maxCoord;
        this.coords = new float[maxCoord + 1];
        Arrays.fill(this.coords, 1.0f);
        this.coords[0] = 0.0f;
        if (maxCoord > 0 && needsScores && !disableCoord) {
            boolean seenActualCoord = false;
            for (i = 1; i < this.coords.length; ++i) {
                this.coords[i] = this.coord(i, maxCoord);
                seenActualCoord |= this.coords[i] != 1.0f;
            }
            this.disableCoord = !seenActualCoord;
        } else {
            this.disableCoord = true;
        }
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        int i = 0;
        for (BooleanClause clause : this.query) {
            if (clause.isScoring() || !this.needsScores && !clause.isProhibited()) {
                this.weights.get(i).extractTerms(terms);
            }
            ++i;
        }
    }

    @Override
    public float getValueForNormalization() throws IOException {
        float sum = 0.0f;
        int i = 0;
        for (BooleanClause clause : this.query) {
            float s2 = this.weights.get(i).getValueForNormalization();
            if (clause.isScoring()) {
                sum += s2;
            }
            ++i;
        }
        return sum;
    }

    public float coord(int overlap, int maxOverlap) {
        if (overlap == 0) {
            return 0.0f;
        }
        if (maxOverlap == 1) {
            return 1.0f;
        }
        return this.similarity.coord(overlap, maxOverlap);
    }

    @Override
    public void normalize(float norm, float boost) {
        for (Weight w : this.weights) {
            w.normalize(norm, boost);
        }
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        float coordFactor;
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        int coord = 0;
        float sum = 0.0f;
        boolean fail = false;
        int matchCount = 0;
        int shouldMatchCount = 0;
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            Explanation e = w.explain(context, doc);
            if (e.isMatch()) {
                if (c.isScoring()) {
                    subs.add(e);
                    sum += e.getValue();
                    ++coord;
                } else if (c.isRequired()) {
                    subs.add(Explanation.match(0.0f, "match on required clause, product of:", Explanation.match(0.0f, (Object)((Object)BooleanClause.Occur.FILTER) + " clause", new Explanation[0]), e));
                } else if (c.isProhibited()) {
                    subs.add(Explanation.noMatch("match on prohibited clause (" + c.getQuery().toString() + ")", e));
                    fail = true;
                }
                if (!c.isProhibited()) {
                    ++matchCount;
                }
                if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
                ++shouldMatchCount;
                continue;
            }
            if (!c.isRequired()) continue;
            subs.add(Explanation.noMatch("no match on required clause (" + c.getQuery().toString() + ")", e));
            fail = true;
        }
        if (fail) {
            return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
        }
        if (matchCount == 0) {
            return Explanation.noMatch("No matching clauses", subs);
        }
        if (shouldMatchCount < minShouldMatch) {
            return Explanation.noMatch("Failure to match minimum number of optional clauses: " + minShouldMatch, subs);
        }
        Explanation result = Explanation.match(sum, "sum of:", subs);
        float f = coordFactor = this.disableCoord ? 1.0f : this.coord(coord, this.maxCoord);
        if (coordFactor != 1.0f) {
            result = Explanation.match(sum * coordFactor, "product of:", result, Explanation.match(coordFactor, "coord(" + coord + "/" + this.maxCoord + ")", new Explanation[0]));
        }
        return result;
    }

    static BulkScorer disableScoring(final BulkScorer scorer) {
        return new BulkScorer(){

            @Override
            public int score(final LeafCollector collector, Bits acceptDocs, int min2, int max) throws IOException {
                LeafCollector noScoreCollector = new LeafCollector(){
                    FakeScorer fake = new FakeScorer();

                    @Override
                    public void setScorer(Scorer scorer) throws IOException {
                        collector.setScorer(this.fake);
                    }

                    @Override
                    public void collect(int doc) throws IOException {
                        this.fake.doc = doc;
                        collector.collect(doc);
                    }
                };
                return scorer.score(noScoreCollector, acceptDocs, min2, max);
            }

            @Override
            public long cost() {
                return scorer.cost();
            }
        };
    }

    BulkScorer optionalBulkScorer(LeafReaderContext context) throws IOException {
        ArrayList<BulkScorer> optional = new ArrayList<BulkScorer>();
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BulkScorer subScorer;
            BooleanClause c = cIter.next();
            if (c.getOccur() != BooleanClause.Occur.SHOULD || (subScorer = w.bulkScorer(context)) == null) continue;
            optional.add(subScorer);
        }
        if (optional.size() == 0) {
            return null;
        }
        if (this.query.getMinimumNumberShouldMatch() > optional.size()) {
            return null;
        }
        if (optional.size() == 1) {
            BulkScorer opt = (BulkScorer)optional.get(0);
            if (!this.disableCoord && this.maxCoord > 1) {
                return new BooleanTopLevelScorers.BoostedBulkScorer(opt, this.coord(1, this.maxCoord));
            }
            return opt;
        }
        return new BooleanScorer(this, this.disableCoord, this.maxCoord, optional, Math.max(1, this.query.getMinimumNumberShouldMatch()), this.needsScores);
    }

    private BulkScorer requiredBulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer scorer = null;
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            if (!c.isRequired()) continue;
            if (scorer != null) {
                return null;
            }
            scorer = w.bulkScorer(context);
            if (scorer == null) {
                return null;
            }
            if (!c.isScoring()) {
                if (!this.needsScores) continue;
                scorer = BooleanWeight.disableScoring(scorer);
                continue;
            }
            assert (this.maxCoord == 1);
        }
        return scorer;
    }

    BulkScorer booleanScorer(LeafReaderContext context) throws IOException {
        Scorer prohibitedScorer;
        BulkScorer positiveScorer;
        int numOptionalClauses = this.query.getClauses(BooleanClause.Occur.SHOULD).size();
        int numRequiredClauses = this.query.getClauses(BooleanClause.Occur.MUST).size() + this.query.getClauses(BooleanClause.Occur.FILTER).size();
        if (numRequiredClauses == 0) {
            positiveScorer = this.optionalBulkScorer(context);
            if (positiveScorer == null) {
                return null;
            }
            long costThreshold = this.query.getMinimumNumberShouldMatch() <= 1 ? -1L : (long)(context.reader().maxDoc() / 3);
            if (positiveScorer.cost() < costThreshold) {
                return null;
            }
        } else if (numRequiredClauses == 1 && numOptionalClauses == 0 && this.query.getMinimumNumberShouldMatch() == 0) {
            positiveScorer = this.requiredBulkScorer(context);
        } else {
            return null;
        }
        if (positiveScorer == null) {
            return null;
        }
        ArrayList<Scorer> prohibited = new ArrayList<Scorer>();
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            Scorer scorer;
            BooleanClause c = cIter.next();
            if (!c.isProhibited() || (scorer = w.scorer(context)) == null) continue;
            prohibited.add(scorer);
        }
        if (prohibited.isEmpty()) {
            return positiveScorer;
        }
        Scorer scorer = prohibitedScorer = prohibited.size() == 1 ? (Scorer)prohibited.get(0) : new DisjunctionSumScorer(this, prohibited, this.coords, false);
        if (prohibitedScorer.twoPhaseIterator() != null) {
            return null;
        }
        return new ReqExclBulkScorer(positiveScorer, prohibitedScorer.iterator());
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer bulkScorer = this.booleanScorer(context);
        if (bulkScorer != null) {
            return bulkScorer;
        }
        return super.bulkScorer(context);
    }

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context);
        if (scorerSupplier == null) {
            return null;
        }
        return scorerSupplier.get(false);
    }

    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>> scorers = new EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>>(BooleanClause.Occur.class);
        for (BooleanClause.Occur occur : BooleanClause.Occur.values()) {
            scorers.put(occur, new ArrayList());
        }
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            ScorerSupplier subScorer = w.scorerSupplier(context);
            if (subScorer == null) {
                if (!c.isRequired()) continue;
                return null;
            }
            ((Collection)scorers.get((Object)c.getOccur())).add(subScorer);
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() == minShouldMatch) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).addAll((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD));
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
            minShouldMatch = 0;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).isEmpty()) {
            return null;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() < minShouldMatch) {
            return null;
        }
        if (!this.needsScores && minShouldMatch == 0 && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).size() + ((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).size() > 0) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
        }
        return new Boolean2ScorerSupplier(this, scorers, this.disableCoord, this.coords, this.maxCoord, this.needsScores, minShouldMatch);
    }
}

