/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdTermState;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IntBlockPool;
import org.apache.lucene.util.RecyclingByteBlockAllocator;
import org.apache.lucene.util.RecyclingIntBlockAllocator;
import org.apache.lucene.util.StringHelper;

public class MemoryIndex {
    private static final boolean DEBUG = false;
    private final SortedMap<String, Info> fields = new TreeMap<String, Info>();
    private final boolean storeOffsets;
    private final boolean storePayloads;
    private final ByteBlockPool byteBlockPool;
    private final IntBlockPool intBlockPool;
    private final IntBlockPool.SliceWriter postingsWriter;
    private final BytesRefArray payloadsBytesRefs;
    private Counter bytesUsed;
    private boolean frozen = false;
    private Similarity normSimilarity = IndexSearcher.getDefaultSimilarity();
    private FieldType defaultFieldType = new FieldType();

    public MemoryIndex() {
        this(false);
    }

    public MemoryIndex(boolean storeOffsets) {
        this(storeOffsets, false);
    }

    public MemoryIndex(boolean storeOffsets, boolean storePayloads) {
        this(storeOffsets, storePayloads, 0L);
    }

    MemoryIndex(boolean storeOffsets, boolean storePayloads, long maxReusedBytes) {
        this.storeOffsets = storeOffsets;
        this.storePayloads = storePayloads;
        this.defaultFieldType.setIndexOptions(storeOffsets ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        this.defaultFieldType.setStoreTermVectors(true);
        this.bytesUsed = Counter.newCounter();
        int maxBufferedByteBlocks = (int)(maxReusedBytes / 2L / 32768L);
        int maxBufferedIntBlocks = (int)((maxReusedBytes - (long)(maxBufferedByteBlocks * 32768)) / 32768L);
        assert ((long)(maxBufferedByteBlocks * 32768 + maxBufferedIntBlocks * 8192 * 4) <= maxReusedBytes);
        this.byteBlockPool = new ByteBlockPool(new RecyclingByteBlockAllocator(32768, maxBufferedByteBlocks, this.bytesUsed));
        this.intBlockPool = new IntBlockPool(new RecyclingIntBlockAllocator(8192, maxBufferedIntBlocks, this.bytesUsed));
        this.postingsWriter = new IntBlockPool.SliceWriter(this.intBlockPool);
        this.payloadsBytesRefs = storePayloads ? new BytesRefArray(this.bytesUsed) : null;
    }

    public void addField(String fieldName, String text, Analyzer analyzer) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (analyzer == null) {
            throw new IllegalArgumentException("analyzer must not be null");
        }
        TokenStream stream = analyzer.tokenStream(fieldName, text);
        this.storeTerms(this.getInfo(fieldName, this.defaultFieldType), stream, 1.0f, analyzer.getPositionIncrementGap(fieldName), analyzer.getOffsetGap(fieldName));
    }

    public static MemoryIndex fromDocument(Iterable<? extends IndexableField> document, Analyzer analyzer) {
        return MemoryIndex.fromDocument(document, analyzer, false, false, 0L);
    }

    public static MemoryIndex fromDocument(Iterable<? extends IndexableField> document, Analyzer analyzer, boolean storeOffsets, boolean storePayloads) {
        return MemoryIndex.fromDocument(document, analyzer, storeOffsets, storePayloads, 0L);
    }

    public static MemoryIndex fromDocument(Iterable<? extends IndexableField> document, Analyzer analyzer, boolean storeOffsets, boolean storePayloads, long maxReusedBytes) {
        MemoryIndex mi = new MemoryIndex(storeOffsets, storePayloads, maxReusedBytes);
        for (IndexableField indexableField : document) {
            mi.addField(indexableField, analyzer);
        }
        return mi;
    }

    public <T> TokenStream keywordTokenStream(final Collection<T> keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException("keywords must not be null");
        }
        return new TokenStream(){
            private Iterator<T> iter;
            private int start;
            private final CharTermAttribute termAtt;
            private final OffsetAttribute offsetAtt;
            {
                this.iter = keywords.iterator();
                this.start = 0;
                this.termAtt = this.addAttribute(CharTermAttribute.class);
                this.offsetAtt = this.addAttribute(OffsetAttribute.class);
            }

            @Override
            public boolean incrementToken() {
                if (!this.iter.hasNext()) {
                    return false;
                }
                Object obj = this.iter.next();
                if (obj == null) {
                    throw new IllegalArgumentException("keyword must not be null");
                }
                String term = obj.toString();
                this.clearAttributes();
                this.termAtt.setEmpty().append(term);
                this.offsetAtt.setOffset(this.start, this.start + this.termAtt.length());
                this.start += term.length() + 1;
                return true;
            }
        };
    }

    public void addField(String fieldName, TokenStream stream) {
        this.addField(fieldName, stream, 1.0f);
    }

    public void addField(IndexableField field, Analyzer analyzer) {
        this.addField(field, analyzer, 1.0f);
    }

    public void addField(IndexableField field, Analyzer analyzer, float boost) {
        Object docValuesValue;
        int positionIncrementGap;
        TokenStream tokenStream;
        int offsetGap;
        Info info = this.getInfo(field.name(), field.fieldType());
        if (analyzer != null) {
            offsetGap = analyzer.getOffsetGap(field.name());
            tokenStream = field.tokenStream(analyzer, null);
            positionIncrementGap = analyzer.getPositionIncrementGap(field.name());
        } else {
            offsetGap = 1;
            tokenStream = field.tokenStream(null, null);
            positionIncrementGap = 0;
        }
        if (tokenStream != null) {
            this.storeTerms(info, tokenStream, boost, positionIncrementGap, offsetGap);
        }
        DocValuesType docValuesType = field.fieldType().docValuesType();
        switch (docValuesType) {
            case NONE: {
                docValuesValue = null;
                break;
            }
            case BINARY: 
            case SORTED: 
            case SORTED_SET: {
                docValuesValue = field.binaryValue();
                break;
            }
            case NUMERIC: 
            case SORTED_NUMERIC: {
                docValuesValue = field.numericValue();
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown doc values type [" + (Object)((Object)docValuesType) + "]");
            }
        }
        if (docValuesValue != null) {
            this.storeDocValues(info, docValuesType, docValuesValue);
        }
        if (field.fieldType().pointDimensionCount() > 0) {
            this.storePointValues(info, field.binaryValue());
        }
    }

    public void addField(String fieldName, TokenStream stream, float boost) {
        this.addField(fieldName, stream, boost, 0);
    }

    public void addField(String fieldName, TokenStream stream, float boost, int positionIncrementGap) {
        this.addField(fieldName, stream, boost, positionIncrementGap, 1);
    }

    public void addField(String fieldName, TokenStream tokenStream, float boost, int positionIncrementGap, int offsetGap) {
        Info info = this.getInfo(fieldName, this.defaultFieldType);
        this.storeTerms(info, tokenStream, boost, positionIncrementGap, offsetGap);
    }

    private Info getInfo(String fieldName, IndexableFieldType fieldType) {
        if (this.frozen) {
            throw new IllegalArgumentException("Cannot call addField() when MemoryIndex is frozen");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        Info info = (Info)this.fields.get(fieldName);
        if (info == null) {
            info = new Info(this.createFieldInfo(fieldName, this.fields.size(), fieldType), this.byteBlockPool);
            this.fields.put(fieldName, info);
        }
        if (fieldType.pointDimensionCount() != info.fieldInfo.getPointDimensionCount() && fieldType.pointDimensionCount() > 0) {
            info.fieldInfo.setPointDimensions(fieldType.pointDimensionCount(), fieldType.pointNumBytes());
        }
        if (fieldType.docValuesType() != info.fieldInfo.getDocValuesType() && fieldType.docValuesType() != DocValuesType.NONE) {
            info.fieldInfo.setDocValuesType(fieldType.docValuesType());
        }
        return info;
    }

    private FieldInfo createFieldInfo(String fieldName, int ord, IndexableFieldType fieldType) {
        IndexOptions indexOptions = this.storeOffsets ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        return new FieldInfo(fieldName, ord, fieldType.storeTermVectors(), fieldType.omitNorms(), this.storePayloads, indexOptions, fieldType.docValuesType(), -1L, Collections.emptyMap(), fieldType.pointDimensionCount(), fieldType.pointNumBytes());
    }

    private void storePointValues(Info info, BytesRef pointValue) {
        if (info.pointValues == null) {
            Info.access$202(info, new BytesRef[4]);
        }
        Info.access$202(info, ArrayUtil.grow(info.pointValues, info.pointValuesCount + 1));
        ((Info)info).pointValues[((Info)info).pointValuesCount++] = BytesRef.deepCopyOf(pointValue);
    }

    private void storeDocValues(Info info, DocValuesType docValuesType, Object docValuesValue) {
        String fieldName = ((Info)info).fieldInfo.name;
        DocValuesType existingDocValuesType = info.fieldInfo.getDocValuesType();
        if (existingDocValuesType == DocValuesType.NONE) {
            info.fieldInfo = new FieldInfo(((Info)info).fieldInfo.name, ((Info)info).fieldInfo.number, info.fieldInfo.hasVectors(), info.fieldInfo.hasPayloads(), info.fieldInfo.hasPayloads(), info.fieldInfo.getIndexOptions(), docValuesType, -1L, info.fieldInfo.attributes(), info.fieldInfo.getPointDimensionCount(), info.fieldInfo.getPointNumBytes());
        } else if (existingDocValuesType != docValuesType) {
            throw new IllegalArgumentException("Can't add [" + (Object)((Object)docValuesType) + "] doc values field [" + fieldName + "], because [" + (Object)((Object)existingDocValuesType) + "] doc values field already exists");
        }
        switch (docValuesType) {
            case NUMERIC: {
                if (((Info)info).numericProducer.dvLongValues != null) {
                    throw new IllegalArgumentException("Only one value per field allowed for [" + (Object)((Object)docValuesType) + "] doc values field [" + fieldName + "]");
                }
                ((Info)info).numericProducer.dvLongValues = new long[]{(Long)docValuesValue};
                ++((Info)info).numericProducer.count;
                break;
            }
            case SORTED_NUMERIC: {
                if (((Info)info).numericProducer.dvLongValues == null) {
                    ((Info)info).numericProducer.dvLongValues = new long[4];
                }
                ((Info)info).numericProducer.dvLongValues = ArrayUtil.grow(((Info)info).numericProducer.dvLongValues, ((Info)info).numericProducer.count + 1);
                ((Info)info).numericProducer.dvLongValues[((Info)info).numericProducer.count++] = (Long)docValuesValue;
                break;
            }
            case BINARY: {
                if (((Info)info).binaryProducer.dvBytesValuesSet != null) {
                    throw new IllegalArgumentException("Only one value per field allowed for [" + (Object)((Object)docValuesType) + "] doc values field [" + fieldName + "]");
                }
                ((Info)info).binaryProducer.dvBytesValuesSet = new BytesRefHash(this.byteBlockPool);
                ((Info)info).binaryProducer.dvBytesValuesSet.add((BytesRef)docValuesValue);
                break;
            }
            case SORTED: {
                if (((Info)info).binaryProducer.dvBytesValuesSet != null) {
                    throw new IllegalArgumentException("Only one value per field allowed for [" + (Object)((Object)docValuesType) + "] doc values field [" + fieldName + "]");
                }
                ((Info)info).binaryProducer.dvBytesValuesSet = new BytesRefHash(this.byteBlockPool);
                ((Info)info).binaryProducer.dvBytesValuesSet.add((BytesRef)docValuesValue);
                break;
            }
            case SORTED_SET: {
                if (((Info)info).binaryProducer.dvBytesValuesSet == null) {
                    ((Info)info).binaryProducer.dvBytesValuesSet = new BytesRefHash(this.byteBlockPool);
                }
                ((Info)info).binaryProducer.dvBytesValuesSet.add((BytesRef)docValuesValue);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown doc values type [" + (Object)((Object)docValuesType) + "]");
            }
        }
    }

    private void storeTerms(Info info, TokenStream tokenStream, float boost, int positionIncrementGap, int offsetGap) {
        if (boost <= 0.0f) {
            throw new IllegalArgumentException("boost factor must be greater than 0.0");
        }
        int pos = -1;
        int offset = 0;
        if (info.numTokens == 0) {
            info.boost = boost;
        } else if (info.numTokens > 0) {
            pos = info.lastPosition + positionIncrementGap;
            offset = info.lastOffset + offsetGap;
            Info info2 = info;
            info2.boost = info2.boost * boost;
        }
        try (TokenStream stream = tokenStream;){
            TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAttribute = stream.addAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offsetAtt = stream.addAttribute(OffsetAttribute.class);
            PayloadAttribute payloadAtt = this.storePayloads ? stream.addAttribute(PayloadAttribute.class) : null;
            stream.reset();
            while (stream.incrementToken()) {
                info.numTokens++;
                int posIncr = posIncrAttribute.getPositionIncrement();
                if (posIncr == 0) {
                    info.numOverlapTokens++;
                }
                pos += posIncr;
                int ord = info.terms.add(termAtt.getBytesRef());
                if (ord < 0) {
                    ord = -ord - 1;
                    this.postingsWriter.reset(((Info)info).sliceArray.end[ord]);
                } else {
                    ((Info)info).sliceArray.start[ord] = this.postingsWriter.startNewSlice();
                }
                int n = ord;
                ((Info)info).sliceArray.freq[n] = ((Info)info).sliceArray.freq[n] + 1;
                info.sumTotalTermFreq++;
                this.postingsWriter.writeInt(pos);
                if (this.storeOffsets) {
                    this.postingsWriter.writeInt(offsetAtt.startOffset() + offset);
                    this.postingsWriter.writeInt(offsetAtt.endOffset() + offset);
                }
                if (this.storePayloads) {
                    BytesRef payload = payloadAtt.getPayload();
                    int pIndex = payload == null || payload.length == 0 ? -1 : this.payloadsBytesRefs.append(payload);
                    this.postingsWriter.writeInt(pIndex);
                }
                ((Info)info).sliceArray.end[ord] = this.postingsWriter.getCurrentOffset();
            }
            stream.end();
            if (info.numTokens > 0) {
                info.lastPosition = pos;
                info.lastOffset = offsetAtt.endOffset() + offset;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSimilarity(Similarity similarity) {
        if (this.frozen) {
            throw new IllegalArgumentException("Cannot set Similarity when MemoryIndex is frozen");
        }
        if (this.normSimilarity == similarity) {
            return;
        }
        this.normSimilarity = similarity;
        for (Info info : this.fields.values()) {
            info.norms = null;
        }
    }

    public IndexSearcher createSearcher() {
        MemoryIndexReader reader = new MemoryIndexReader();
        IndexSearcher searcher = new IndexSearcher(reader);
        searcher.setSimilarity(this.normSimilarity);
        searcher.setQueryCache(null);
        return searcher;
    }

    public void freeze() {
        this.frozen = true;
        for (Info info : this.fields.values()) {
            info.freeze();
        }
    }

    public float search(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        IndexSearcher searcher = this.createSearcher();
        try {
            float score;
            final float[] scores = new float[1];
            searcher.search(query, new SimpleCollector(){
                private Scorer scorer;

                @Override
                public void collect(int doc) throws IOException {
                    scores[0] = this.scorer.score();
                }

                @Override
                public void setScorer(Scorer scorer) {
                    this.scorer = scorer;
                }

                @Override
                public boolean needsScores() {
                    return true;
                }
            });
            float f = score = scores[0];
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toStringDebug() {
        StringBuilder result = new StringBuilder(256);
        int sumPositions = 0;
        int sumTerms = 0;
        BytesRef spare = new BytesRef();
        BytesRefBuilder payloadBuilder = this.storePayloads ? new BytesRefBuilder() : null;
        for (Map.Entry<String, Info> entry : this.fields.entrySet()) {
            String fieldName = entry.getKey();
            Info info = entry.getValue();
            info.sortTerms();
            result.append(fieldName + ":\n");
            SliceByteStartArray sliceArray = info.sliceArray;
            int numPositions = 0;
            IntBlockPool.SliceReader postingsReader = new IntBlockPool.SliceReader(this.intBlockPool);
            for (int j = 0; j < info.terms.size(); ++j) {
                int iters;
                int ord = info.sortedTerms[j];
                info.terms.get(ord, spare);
                int freq = sliceArray.freq[ord];
                result.append("\t'" + spare + "':" + freq + ":");
                postingsReader.reset(sliceArray.start[ord], sliceArray.end[ord]);
                result.append(" [");
                int n = iters = this.storeOffsets ? 3 : 1;
                while (!postingsReader.endOfSlice()) {
                    int payloadIndex;
                    result.append("(");
                    for (int k = 0; k < iters; ++k) {
                        result.append(postingsReader.readInt());
                        if (k >= iters - 1) continue;
                        result.append(", ");
                    }
                    if (this.storePayloads && (payloadIndex = postingsReader.readInt()) != -1) {
                        result.append(", " + this.payloadsBytesRefs.get(payloadBuilder, payloadIndex));
                    }
                    result.append(")");
                    if (postingsReader.endOfSlice()) continue;
                    result.append(", ");
                }
                result.append("]");
                result.append("\n");
                numPositions += freq;
            }
            result.append("\tterms=" + info.terms.size());
            result.append(", positions=" + numPositions);
            result.append("\n");
            sumPositions += numPositions;
            sumTerms += info.terms.size();
        }
        result.append("\nfields=" + this.fields.size());
        result.append(", terms=" + sumTerms);
        result.append(", positions=" + sumPositions);
        return result.toString();
    }

    public void reset() {
        this.fields.clear();
        this.normSimilarity = IndexSearcher.getDefaultSimilarity();
        this.byteBlockPool.reset(false, false);
        this.intBlockPool.reset(true, false);
        if (this.payloadsBytesRefs != null) {
            this.payloadsBytesRefs.clear();
        }
        this.frozen = false;
    }

    private static final class SliceByteStartArray
    extends BytesRefHash.DirectBytesStartArray {
        int[] start;
        int[] end;
        int[] freq;

        public SliceByteStartArray(int initSize) {
            super(initSize);
        }

        @Override
        public int[] init() {
            int[] ord = super.init();
            this.start = new int[ArrayUtil.oversize(ord.length, 4)];
            this.end = new int[ArrayUtil.oversize(ord.length, 4)];
            this.freq = new int[ArrayUtil.oversize(ord.length, 4)];
            assert (this.start.length >= ord.length);
            assert (this.end.length >= ord.length);
            assert (this.freq.length >= ord.length);
            return ord;
        }

        @Override
        public int[] grow() {
            int[] ord = super.grow();
            if (this.start.length < ord.length) {
                this.start = ArrayUtil.grow(this.start, ord.length);
                this.end = ArrayUtil.grow(this.end, ord.length);
                this.freq = ArrayUtil.grow(this.freq, ord.length);
            }
            assert (this.start.length >= ord.length);
            assert (this.end.length >= ord.length);
            assert (this.freq.length >= ord.length);
            return ord;
        }

        @Override
        public int[] clear() {
            this.end = null;
            this.start = null;
            return super.clear();
        }
    }

    private final class MemoryIndexReader
    extends LeafReader {
        private final PointValues pointValues;
        private Fields memoryFields;

        private MemoryIndexReader() {
            this.memoryFields = new MemoryFields(MemoryIndex.this.fields);
            boolean hasPointValues = false;
            for (Info info : MemoryIndex.this.fields.values()) {
                info.prepareDocValuesAndPointValues();
                if (info.pointValues == null) continue;
                hasPointValues = true;
            }
            this.pointValues = hasPointValues ? new MemoryIndexPointValues() : null;
        }

        @Override
        public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
            MemoryIndexReader.addCoreClosedListenerAsReaderClosedListener(this, listener);
        }

        @Override
        public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
            MemoryIndexReader.removeCoreClosedListenerAsReaderClosedListener(this, listener);
        }

        private Info getInfoForExpectedDocValuesType(String fieldName, DocValuesType expectedType) {
            if (expectedType == DocValuesType.NONE) {
                return null;
            }
            Info info = (Info)MemoryIndex.this.fields.get(fieldName);
            if (info == null) {
                return null;
            }
            if (info.fieldInfo.getDocValuesType() != expectedType) {
                return null;
            }
            return info;
        }

        @Override
        public Bits getLiveDocs() {
            return null;
        }

        @Override
        public FieldInfos getFieldInfos() {
            FieldInfo[] fieldInfos = new FieldInfo[MemoryIndex.this.fields.size()];
            int i = 0;
            for (Info info : MemoryIndex.this.fields.values()) {
                fieldInfos[i++] = info.fieldInfo;
            }
            return new FieldInfos(fieldInfos);
        }

        @Override
        public NumericDocValues getNumericDocValues(String field) {
            Info info = this.getInfoForExpectedDocValuesType(field, DocValuesType.NUMERIC);
            if (info != null) {
                return ((Info)info).numericProducer.numericDocValues;
            }
            return null;
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field) {
            return this.getSortedDocValues(field, DocValuesType.BINARY);
        }

        @Override
        public SortedDocValues getSortedDocValues(String field) {
            return this.getSortedDocValues(field, DocValuesType.SORTED);
        }

        private SortedDocValues getSortedDocValues(String field, DocValuesType docValuesType) {
            Info info = this.getInfoForExpectedDocValuesType(field, docValuesType);
            if (info != null) {
                return ((Info)info).binaryProducer.sortedDocValues;
            }
            return null;
        }

        @Override
        public SortedNumericDocValues getSortedNumericDocValues(String field) {
            Info info = this.getInfoForExpectedDocValuesType(field, DocValuesType.SORTED_NUMERIC);
            if (info != null) {
                return ((Info)info).numericProducer.sortedNumericDocValues;
            }
            return null;
        }

        @Override
        public SortedSetDocValues getSortedSetDocValues(String field) {
            final Info info = this.getInfoForExpectedDocValuesType(field, DocValuesType.SORTED_SET);
            if (info != null) {
                return new SortedSetDocValues(){
                    int index = 0;

                    @Override
                    public long nextOrd() {
                        if (this.index >= ((Info)info).binaryProducer.dvBytesValuesSet.size()) {
                            return -1L;
                        }
                        return this.index++;
                    }

                    @Override
                    public void setDocument(int docID) {
                        this.index = 0;
                    }

                    @Override
                    public BytesRef lookupOrd(long ord) {
                        return info.binaryProducer.getValue((int)ord);
                    }

                    @Override
                    public long getValueCount() {
                        return ((Info)info).binaryProducer.dvBytesValuesSet.size();
                    }
                };
            }
            return null;
        }

        @Override
        public Bits getDocsWithField(String field) throws IOException {
            Info info = (Info)MemoryIndex.this.fields.get(field);
            if (info != null && info.fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                return new Bits.MatchAllBits(1);
            }
            return null;
        }

        @Override
        public PointValues getPointValues() {
            return this.pointValues;
        }

        @Override
        public void checkIntegrity() throws IOException {
        }

        @Override
        public Fields fields() {
            return this.memoryFields;
        }

        @Override
        public Fields getTermVectors(int docID) {
            if (docID == 0) {
                return this.fields();
            }
            return null;
        }

        @Override
        public int numDocs() {
            return 1;
        }

        @Override
        public int maxDoc() {
            return 1;
        }

        @Override
        public void document(int docID, StoredFieldVisitor visitor) {
        }

        @Override
        protected void doClose() {
        }

        @Override
        public NumericDocValues getNormValues(String field) {
            Info info = (Info)MemoryIndex.this.fields.get(field);
            if (info == null || info.fieldInfo.omitsNorms()) {
                return null;
            }
            return info.getNormDocValues();
        }

        @Override
        public Sort getIndexSort() {
            return null;
        }

        private class MemoryIndexPointValues
        extends PointValues {
            private MemoryIndexPointValues() {
            }

            @Override
            public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return;
                }
                BytesRef[] values = info.pointValues;
                if (values == null) {
                    return;
                }
                visitor.grow(info.pointValuesCount);
                for (int i = 0; i < info.pointValuesCount; ++i) {
                    visitor.visit(0, values[i].bytes);
                }
            }

            @Override
            public long estimatePointCount(String fieldName, PointValues.IntersectVisitor visitor) {
                return 1L;
            }

            @Override
            public byte[] getMinPackedValue(String fieldName) throws IOException {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return null;
                }
                BytesRef[] values = info.pointValues;
                if (values != null) {
                    return info.minPackedValue;
                }
                return null;
            }

            @Override
            public byte[] getMaxPackedValue(String fieldName) throws IOException {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return null;
                }
                BytesRef[] values = info.pointValues;
                if (values != null) {
                    return info.maxPackedValue;
                }
                return null;
            }

            @Override
            public int getNumDimensions(String fieldName) throws IOException {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return 0;
                }
                return info.fieldInfo.getPointDimensionCount();
            }

            @Override
            public int getBytesPerDimension(String fieldName) throws IOException {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return 0;
                }
                return info.fieldInfo.getPointNumBytes();
            }

            @Override
            public long size(String fieldName) {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return 0L;
                }
                BytesRef[] values = info.pointValues;
                if (values != null) {
                    return info.pointValuesCount;
                }
                return 0L;
            }

            @Override
            public int getDocCount(String fieldName) {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return 0;
                }
                BytesRef[] values = info.pointValues;
                if (values != null) {
                    return 1;
                }
                return 0;
            }
        }

        private class MemoryPostingsEnum
        extends PostingsEnum {
            private final IntBlockPool.SliceReader sliceReader;
            private int posUpto;
            private boolean hasNext;
            private int doc = -1;
            private int freq;
            private int pos;
            private int startOffset;
            private int endOffset;
            private int payloadIndex;
            private final BytesRefBuilder payloadBuilder;

            public MemoryPostingsEnum() {
                this.sliceReader = new IntBlockPool.SliceReader(MemoryIndex.this.intBlockPool);
                this.payloadBuilder = MemoryIndex.this.storePayloads ? new BytesRefBuilder() : null;
            }

            public PostingsEnum reset(int start, int end, int freq) {
                this.sliceReader.reset(start, end);
                this.posUpto = 0;
                this.hasNext = true;
                this.doc = -1;
                this.freq = freq;
                return this;
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                this.pos = -1;
                if (this.hasNext) {
                    this.hasNext = false;
                    this.doc = 0;
                    return 0;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public int advance(int target) throws IOException {
                return this.slowAdvance(target);
            }

            @Override
            public int freq() throws IOException {
                return this.freq;
            }

            @Override
            public int nextPosition() {
                ++this.posUpto;
                assert (this.posUpto <= this.freq);
                assert (!this.sliceReader.endOfSlice()) : " stores offsets : " + this.startOffset;
                int pos = this.sliceReader.readInt();
                if (MemoryIndex.this.storeOffsets) {
                    this.startOffset = this.sliceReader.readInt();
                    this.endOffset = this.sliceReader.readInt();
                }
                if (MemoryIndex.this.storePayloads) {
                    this.payloadIndex = this.sliceReader.readInt();
                }
                return pos;
            }

            @Override
            public int startOffset() {
                return this.startOffset;
            }

            @Override
            public int endOffset() {
                return this.endOffset;
            }

            @Override
            public BytesRef getPayload() {
                if (this.payloadBuilder == null || this.payloadIndex == -1) {
                    return null;
                }
                return MemoryIndex.this.payloadsBytesRefs.get(this.payloadBuilder, this.payloadIndex);
            }

            @Override
            public long cost() {
                return 1L;
            }
        }

        private class MemoryTermsEnum
        extends TermsEnum {
            private final Info info;
            private final BytesRef br = new BytesRef();
            int termUpto = -1;

            public MemoryTermsEnum(Info info) {
                this.info = info;
                info.sortTerms();
            }

            private final int binarySearch(BytesRef b, BytesRef bytesRef, int low, int high, BytesRefHash hash, int[] ords) {
                int mid = 0;
                while (low <= high) {
                    mid = low + high >>> 1;
                    hash.get(ords[mid], bytesRef);
                    int cmp = bytesRef.compareTo(b);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                assert (bytesRef.compareTo(b) != 0);
                return -(low + 1);
            }

            @Override
            public boolean seekExact(BytesRef text) {
                this.termUpto = this.binarySearch(text, this.br, 0, this.info.terms.size() - 1, this.info.terms, this.info.sortedTerms);
                return this.termUpto >= 0;
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef text) {
                this.termUpto = this.binarySearch(text, this.br, 0, this.info.terms.size() - 1, this.info.terms, this.info.sortedTerms);
                if (this.termUpto < 0) {
                    this.termUpto = -this.termUpto - 1;
                    if (this.termUpto >= this.info.terms.size()) {
                        return TermsEnum.SeekStatus.END;
                    }
                    this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                return TermsEnum.SeekStatus.FOUND;
            }

            @Override
            public void seekExact(long ord) {
                assert (ord < (long)this.info.terms.size());
                this.termUpto = (int)ord;
                this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
            }

            @Override
            public BytesRef next() {
                ++this.termUpto;
                if (this.termUpto >= this.info.terms.size()) {
                    return null;
                }
                this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
                return this.br;
            }

            @Override
            public BytesRef term() {
                return this.br;
            }

            @Override
            public long ord() {
                return this.termUpto;
            }

            @Override
            public int docFreq() {
                return 1;
            }

            @Override
            public long totalTermFreq() {
                return ((Info)this.info).sliceArray.freq[this.info.sortedTerms[this.termUpto]];
            }

            @Override
            public PostingsEnum postings(PostingsEnum reuse, int flags) {
                if (reuse == null || !(reuse instanceof MemoryPostingsEnum)) {
                    reuse = new MemoryPostingsEnum();
                }
                int ord = this.info.sortedTerms[this.termUpto];
                return ((MemoryPostingsEnum)reuse).reset(((Info)this.info).sliceArray.start[ord], ((Info)this.info).sliceArray.end[ord], ((Info)this.info).sliceArray.freq[ord]);
            }

            @Override
            public void seekExact(BytesRef term, TermState state) throws IOException {
                assert (state != null);
                this.seekExact(((OrdTermState)state).ord);
            }

            @Override
            public TermState termState() throws IOException {
                OrdTermState ts = new OrdTermState();
                ts.ord = this.termUpto;
                return ts;
            }
        }

        private class MemoryFields
        extends Fields {
            private final Map<String, Info> fields;

            public MemoryFields(Map<String, Info> fields) {
                this.fields = fields;
            }

            @Override
            public Iterator<String> iterator() {
                return this.fields.entrySet().stream().filter(e -> ((Info)e.getValue()).numTokens > 0).map(Map.Entry::getKey).iterator();
            }

            @Override
            public Terms terms(String field) {
                final Info info = this.fields.get(field);
                if (info == null || info.numTokens <= 0) {
                    return null;
                }
                return new Terms(){

                    @Override
                    public TermsEnum iterator() {
                        return new MemoryTermsEnum(info);
                    }

                    @Override
                    public long size() {
                        return info.terms.size();
                    }

                    @Override
                    public long getSumTotalTermFreq() {
                        return info.sumTotalTermFreq;
                    }

                    @Override
                    public long getSumDocFreq() {
                        return info.terms.size();
                    }

                    @Override
                    public int getDocCount() {
                        return this.size() > 0L ? 1 : 0;
                    }

                    @Override
                    public boolean hasFreqs() {
                        return true;
                    }

                    @Override
                    public boolean hasOffsets() {
                        return MemoryIndex.this.storeOffsets;
                    }

                    @Override
                    public boolean hasPositions() {
                        return true;
                    }

                    @Override
                    public boolean hasPayloads() {
                        return MemoryIndex.this.storePayloads;
                    }
                };
            }

            @Override
            public int size() {
                int size = 0;
                for (String fieldName : this) {
                    ++size;
                }
                return size;
            }
        }
    }

    private static final class NumericDocValuesProducer {
        long[] dvLongValues;
        int count;
        final NumericDocValues numericDocValues = new NumericDocValues(){

            @Override
            public long get(int docID) {
                return dvLongValues[0];
            }
        };
        final SortedNumericDocValues sortedNumericDocValues = new SortedNumericDocValues(){

            @Override
            public void setDocument(int doc) {
            }

            @Override
            public long valueAt(int index) {
                return dvLongValues[index];
            }

            @Override
            public int count() {
                return count;
            }
        };

        private NumericDocValuesProducer() {
        }

        private void prepareForUsage() {
            Arrays.sort(this.dvLongValues, 0, this.count);
        }
    }

    private static final class BinaryDocValuesProducer {
        BytesRefHash dvBytesValuesSet;
        final SortedDocValues sortedDocValues;
        final BytesRef spare = new BytesRef();
        int[] bytesIds;

        private BinaryDocValuesProducer() {
            this.sortedDocValues = new SortedDocValues(){

                @Override
                public int getOrd(int docID) {
                    return 0;
                }

                @Override
                public BytesRef lookupOrd(int ord) {
                    return this.getValue(ord);
                }

                @Override
                public int getValueCount() {
                    return 1;
                }
            };
        }

        private void prepareForUsage() {
            this.bytesIds = this.dvBytesValuesSet.sort();
        }

        private BytesRef getValue(int index) {
            return this.dvBytesValuesSet.get(this.bytesIds[index], this.spare);
        }
    }

    private final class Info {
        private FieldInfo fieldInfo;
        private transient NumericDocValues norms;
        private BytesRefHash terms;
        private SliceByteStartArray sliceArray;
        private transient int[] sortedTerms;
        private int numTokens;
        private int numOverlapTokens;
        private float boost;
        private long sumTotalTermFreq;
        private int lastPosition;
        private int lastOffset;
        private BinaryDocValuesProducer binaryProducer;
        private NumericDocValuesProducer numericProducer;
        private boolean preparedDocValuesAndPointValues;
        private BytesRef[] pointValues;
        private byte[] minPackedValue;
        private byte[] maxPackedValue;
        private int pointValuesCount;

        private Info(FieldInfo fieldInfo, ByteBlockPool byteBlockPool) {
            this.fieldInfo = fieldInfo;
            this.sliceArray = new SliceByteStartArray(16);
            this.terms = new BytesRefHash(byteBlockPool, 16, this.sliceArray);
            this.binaryProducer = new BinaryDocValuesProducer();
            this.numericProducer = new NumericDocValuesProducer();
        }

        void freeze() {
            this.sortTerms();
            this.prepareDocValuesAndPointValues();
            this.getNormDocValues();
        }

        void sortTerms() {
            if (this.sortedTerms == null) {
                this.sortedTerms = this.terms.sort();
            }
        }

        void prepareDocValuesAndPointValues() {
            if (!this.preparedDocValuesAndPointValues) {
                DocValuesType dvType = this.fieldInfo.getDocValuesType();
                if (dvType == DocValuesType.NUMERIC || dvType == DocValuesType.SORTED_NUMERIC) {
                    this.numericProducer.prepareForUsage();
                }
                if (dvType == DocValuesType.BINARY || dvType == DocValuesType.SORTED || dvType == DocValuesType.SORTED_SET) {
                    this.binaryProducer.prepareForUsage();
                }
                if (this.pointValues != null) {
                    assert (this.pointValues[0].bytes.length == this.pointValues[0].length) : "BytesRef should wrap a precise byte[], BytesRef.deepCopyOf() should take care of this";
                    int numDimensions = this.fieldInfo.getPointDimensionCount();
                    int numBytesPerDimension = this.fieldInfo.getPointNumBytes();
                    this.minPackedValue = (byte[])this.pointValues[0].bytes.clone();
                    this.maxPackedValue = (byte[])this.pointValues[0].bytes.clone();
                    for (int i = 0; i < this.pointValuesCount; ++i) {
                        BytesRef pointValue = this.pointValues[i];
                        assert (pointValue.bytes.length == pointValue.length) : "BytesRef should wrap a precise byte[], BytesRef.deepCopyOf() should take care of this";
                        for (int dim = 0; dim < numDimensions; ++dim) {
                            int offset = dim * numBytesPerDimension;
                            if (StringHelper.compare(numBytesPerDimension, pointValue.bytes, offset, this.minPackedValue, offset) < 0) {
                                System.arraycopy(pointValue.bytes, offset, this.minPackedValue, offset, numBytesPerDimension);
                            }
                            if (StringHelper.compare(numBytesPerDimension, pointValue.bytes, offset, this.maxPackedValue, offset) <= 0) continue;
                            System.arraycopy(pointValue.bytes, offset, this.maxPackedValue, offset, numBytesPerDimension);
                        }
                    }
                }
                this.preparedDocValuesAndPointValues = true;
            }
        }

        NumericDocValues getNormDocValues() {
            if (this.norms == null) {
                FieldInvertState invertState = new FieldInvertState(this.fieldInfo.name, this.fieldInfo.number, this.numTokens, this.numOverlapTokens, 0, this.boost);
                final long value = MemoryIndex.this.normSimilarity.computeNorm(invertState);
                this.norms = new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        if (docID != 0) {
                            throw new IndexOutOfBoundsException();
                        }
                        return value;
                    }
                };
            }
            return this.norms;
        }

        static /* synthetic */ BytesRef[] access$202(Info x0, BytesRef[] x1) {
            x0.pointValues = x1;
            return x1;
        }
    }
}

