/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene54;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene54.Lucene54DocValuesConsumer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.packed.DirectReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;

final class Lucene54DocValuesProducer
extends DocValuesProducer
implements Closeable {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedSetEntry> sortedNumerics;
    private final Map<String, NumericEntry> ords;
    private final Map<String, NumericEntry> ordIndexes;
    private final int numFields;
    private final AtomicLong ramBytesUsed;
    private final IndexInput data;
    private final int maxDoc;
    private final Map<String, MonotonicBlockPackedReader> addressInstances;
    private final Map<String, ReverseTermsIndex> reverseIndexInstances;
    private final Map<String, DirectMonotonicReader.Meta> directAddressesMeta;
    private final boolean merging;

    Lucene54DocValuesProducer(Lucene54DocValuesProducer original) throws IOException {
        this.numerics = new HashMap<String, NumericEntry>();
        this.binaries = new HashMap<String, BinaryEntry>();
        this.sortedSets = new HashMap<String, SortedSetEntry>();
        this.sortedNumerics = new HashMap<String, SortedSetEntry>();
        this.ords = new HashMap<String, NumericEntry>();
        this.ordIndexes = new HashMap<String, NumericEntry>();
        this.addressInstances = new HashMap<String, MonotonicBlockPackedReader>();
        this.reverseIndexInstances = new HashMap<String, ReverseTermsIndex>();
        this.directAddressesMeta = new HashMap<String, DirectMonotonicReader.Meta>();
        assert (Thread.holdsLock(original));
        this.numerics.putAll(original.numerics);
        this.binaries.putAll(original.binaries);
        this.sortedSets.putAll(original.sortedSets);
        this.sortedNumerics.putAll(original.sortedNumerics);
        this.ords.putAll(original.ords);
        this.ordIndexes.putAll(original.ordIndexes);
        this.numFields = original.numFields;
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.data = original.data.clone();
        this.maxDoc = original.maxDoc;
        this.addressInstances.putAll(original.addressInstances);
        this.reverseIndexInstances.putAll(original.reverseIndexInstances);
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene54DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int numFields;
        int version2;
        block20: {
            this.numerics = new HashMap<String, NumericEntry>();
            this.binaries = new HashMap<String, BinaryEntry>();
            this.sortedSets = new HashMap<String, SortedSetEntry>();
            this.sortedNumerics = new HashMap<String, SortedSetEntry>();
            this.ords = new HashMap<String, NumericEntry>();
            this.ordIndexes = new HashMap<String, NumericEntry>();
            this.addressInstances = new HashMap<String, MonotonicBlockPackedReader>();
            this.reverseIndexInstances = new HashMap<String, ReverseTermsIndex>();
            this.directAddressesMeta = new HashMap<String, DirectMonotonicReader.Meta>();
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.maxDoc = state.segmentInfo.maxDoc();
            this.merging = false;
            this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
            version2 = -1;
            numFields = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version2 = CodecUtil.checkIndexHeader(in, metaCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    numFields = this.readFields(in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(in, priorE);
                    }
                }
                CodecUtil.checkFooter(in, priorE);
            }
        }
        this.numFields = numFields;
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version22 = CodecUtil.checkIndexHeader(this.data, dataCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
            if (version2 != version22) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version2 + ", data=" + version22, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private void readSortedField(FieldInfo info, IndexInput meta) throws IOException {
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt", meta);
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt", meta);
        }
        BinaryEntry b = this.readBinaryEntry(info, meta);
        this.binaries.put(info.name, b);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt", meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt", meta);
        }
        NumericEntry n = this.readNumericEntry(info, meta);
        this.ords.put(info.name, n);
    }

    private void readSortedSetFieldWithAddresses(FieldInfo info, IndexInput meta) throws IOException {
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
        }
        BinaryEntry b = this.readBinaryEntry(info, meta);
        this.binaries.put(info.name, b);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
        }
        NumericEntry n1 = this.readNumericEntry(info, meta);
        this.ords.put(info.name, n1);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
        }
        NumericEntry n2 = this.readNumericEntry(info, meta);
        this.ordIndexes.put(info.name, n2);
    }

    private void readSortedSetFieldWithTable(FieldInfo info, IndexInput meta) throws IOException {
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
        }
        BinaryEntry b = this.readBinaryEntry(info, meta);
        this.binaries.put(info.name, b);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
        }
        NumericEntry n = this.readNumericEntry(info, meta);
        this.ords.put(info.name, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int numFields = 0;
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            SortedSetEntry ss;
            ++numFields;
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(info.name, this.readNumericEntry(info, meta));
            } else if (type == 1) {
                BinaryEntry b = this.readBinaryEntry(info, meta);
                this.binaries.put(info.name, b);
            } else if (type == 2) {
                this.readSortedField(info, meta);
            } else if (type == 3) {
                ss = this.readSortedSetEntry(meta);
                this.sortedSets.put(info.name, ss);
                if (ss.format == 0) {
                    this.readSortedSetFieldWithAddresses(info, meta);
                } else if (ss.format == 2) {
                    this.readSortedSetFieldWithTable(info, meta);
                } else {
                    if (ss.format != 1) throw new AssertionError();
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
                    }
                    if (meta.readByte() != 2) {
                        throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", meta);
                    }
                    this.readSortedField(info, meta);
                }
            } else {
                if (type != 4) throw new CorruptIndexException("invalid type: " + type, meta);
                ss = this.readSortedSetEntry(meta);
                this.sortedNumerics.put(info.name, ss);
                if (ss.format == 0) {
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", meta);
                    }
                    if (meta.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", meta);
                    }
                    this.numerics.put(info.name, this.readNumericEntry(info, meta));
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", meta);
                    }
                    if (meta.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", meta);
                    }
                    NumericEntry ordIndex = this.readNumericEntry(info, meta);
                    this.ordIndexes.put(info.name, ordIndex);
                } else if (ss.format == 2) {
                    if (meta.readVInt() != info.number) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", meta);
                    }
                    if (meta.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", meta);
                    }
                    NumericEntry n = this.readNumericEntry(info, meta);
                    this.ords.put(info.name, n);
                } else {
                    if (ss.format != 1) throw new AssertionError();
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", meta);
                    }
                    if (meta.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", meta);
                    }
                    this.numerics.put(info.name, this.readNumericEntry(info, meta));
                }
            }
            fieldNumber = meta.readVInt();
        }
        return numFields;
    }

    private NumericEntry readNumericEntry(FieldInfo info, IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        if (entry.format == 5) {
            entry.numDocsWithValue = meta.readVLong();
            int blockShift = meta.readVInt();
            entry.monotonicMeta = DirectMonotonicReader.loadMeta(meta, entry.numDocsWithValue, blockShift);
            this.ramBytesUsed.addAndGet(entry.monotonicMeta.ramBytesUsed());
            this.directAddressesMeta.put(info.name, entry.monotonicMeta);
        }
        entry.offset = meta.readLong();
        entry.count = meta.readVLong();
        switch (entry.format) {
            case 4: {
                entry.minValue = meta.readLong();
                if (entry.count <= Integer.MAX_VALUE) break;
                throw new CorruptIndexException("illegal CONST_COMPRESSED count: " + entry.count, meta);
            }
            case 1: {
                entry.minValue = meta.readLong();
                entry.gcd = meta.readLong();
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 2: {
                int uniqueValues = meta.readVInt();
                if (uniqueValues > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, got=" + uniqueValues, meta);
                }
                entry.table = new long[uniqueValues];
                for (int i = 0; i < uniqueValues; ++i) {
                    entry.table[i] = meta.readLong();
                }
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(entry.table));
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 0: {
                entry.minValue = meta.readLong();
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 3: {
                int blockShift = meta.readVInt();
                entry.monotonicMeta = DirectMonotonicReader.loadMeta(meta, this.maxDoc + 1, blockShift);
                this.ramBytesUsed.addAndGet(entry.monotonicMeta.ramBytesUsed());
                this.directAddressesMeta.put(info.name, entry.monotonicMeta);
                break;
            }
            case 5: {
                byte numberType = meta.readByte();
                switch (numberType) {
                    case 0: {
                        entry.numberType = Lucene54DocValuesConsumer.NumberType.VALUE;
                        break;
                    }
                    case 1: {
                        entry.numberType = Lucene54DocValuesConsumer.NumberType.ORDINAL;
                        break;
                    }
                    default: {
                        throw new CorruptIndexException("Number type can only be 0 or 1, got=" + numberType, meta);
                    }
                }
                int fieldNumber = meta.readVInt();
                if (fieldNumber != info.number) {
                    throw new CorruptIndexException("Field numbers mistmatch: " + fieldNumber + " != " + info.number, meta);
                }
                byte dvFormat = meta.readByte();
                if (dvFormat != 0) {
                    throw new CorruptIndexException("Formats mistmatch: " + dvFormat + " != " + 0, meta);
                }
                entry.nonMissingValues = this.readNumericEntry(info, meta);
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format + ", input=", meta);
            }
        }
        entry.endOffset = meta.readLong();
        return entry;
    }

    private BinaryEntry readBinaryEntry(FieldInfo info, IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        entry.minLength = meta.readVInt();
        entry.maxLength = meta.readVInt();
        entry.count = meta.readVLong();
        entry.offset = meta.readLong();
        switch (entry.format) {
            case 0: {
                break;
            }
            case 2: {
                entry.addressesOffset = meta.readLong();
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                entry.reverseIndexOffset = meta.readLong();
                break;
            }
            case 1: {
                entry.addressesOffset = meta.readLong();
                int blockShift = meta.readVInt();
                entry.addressesMeta = DirectMonotonicReader.loadMeta(meta, entry.count + 1L, blockShift);
                this.ramBytesUsed.addAndGet(entry.addressesMeta.ramBytesUsed());
                this.directAddressesMeta.put(info.name, entry.addressesMeta);
                entry.addressesEndOffset = meta.readLong();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format, meta);
            }
        }
        return entry;
    }

    SortedSetEntry readSortedSetEntry(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        entry.format = meta.readVInt();
        if (entry.format == 2) {
            int totalTableLength = meta.readInt();
            if (totalTableLength > 256) {
                throw new CorruptIndexException("SORTED_SET_TABLE cannot have more than 256 values in its dictionary, got=" + totalTableLength, meta);
            }
            entry.table = new long[totalTableLength];
            for (int i = 0; i < totalTableLength; ++i) {
                entry.table[i] = meta.readLong();
            }
            this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(entry.table));
            int tableSize = meta.readInt();
            if (tableSize > totalTableLength + 1) {
                throw new CorruptIndexException("SORTED_SET_TABLE cannot have more set ids than ords in its dictionary, got " + totalTableLength + " ords and " + tableSize + " sets", meta);
            }
            entry.tableOffsets = new int[tableSize + 1];
            for (int i = 1; i < entry.tableOffsets.length; ++i) {
                entry.tableOffsets[i] = entry.tableOffsets[i - 1] + meta.readInt();
            }
            this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(entry.tableOffsets));
        } else if (entry.format != 1 && entry.format != 0) {
            throw new CorruptIndexException("Unknown format: " + entry.format, meta);
        }
        return entry;
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.name);
        return this.getNumeric(entry);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public synchronized Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.addAll(Accountables.namedAccountables("addresses field", this.addressInstances));
        resources.addAll(Accountables.namedAccountables("reverse index field", this.reverseIndexInstances));
        resources.addAll(Accountables.namedAccountables("direct addresses meta field", this.directAddressesMeta));
        return Collections.unmodifiableList(resources);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.numFields + ")";
    }

    LongValues getNumeric(NumericEntry entry) throws IOException {
        switch (entry.format) {
            case 4: {
                final long constant = entry.minValue;
                final Bits live = this.getLiveBits(entry.missingOffset, (int)entry.count);
                return new LongValues(){

                    @Override
                    public long get(long index) {
                        return live.get((int)index) ? constant : 0L;
                    }
                };
            }
            case 0: {
                RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, entry.endOffset - entry.offset);
                final long delta = entry.minValue;
                final LongValues values = DirectReader.getInstance(slice, entry.bitsPerValue, 0L);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return delta + values.get(id);
                    }
                };
            }
            case 1: {
                RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, entry.endOffset - entry.offset);
                final long min2 = entry.minValue;
                final long mult = entry.gcd;
                final LongValues quotientReader = DirectReader.getInstance(slice, entry.bitsPerValue, 0L);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return min2 + mult * quotientReader.get(id);
                    }
                };
            }
            case 2: {
                RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, entry.endOffset - entry.offset);
                final long[] table = entry.table;
                final LongValues ords = DirectReader.getInstance(slice, entry.bitsPerValue, 0L);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return table[(int)ords.get(id)];
                    }
                };
            }
            case 5: {
                long missingValue;
                SparseBits docsWithField = this.getSparseLiveBits(entry);
                LongValues values = this.getNumeric(entry.nonMissingValues);
                switch (entry.numberType) {
                    case ORDINAL: {
                        missingValue = -1L;
                        break;
                    }
                    case VALUE: {
                        missingValue = 0L;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                return new SparseLongValues(docsWithField, values, missingValue);
            }
        }
        throw new AssertionError();
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryEntry bytes = this.binaries.get(field.name);
        switch (bytes.format) {
            case 0: {
                return this.getFixedBinary(field, bytes);
            }
            case 1: {
                return this.getVariableBinary(field, bytes);
            }
            case 2: {
                return this.getCompressedBinary(field, bytes);
            }
        }
        throw new AssertionError();
    }

    private BinaryDocValues getFixedBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        final IndexInput data = this.data.slice("fixed-binary", bytes.offset, bytes.count * (long)bytes.maxLength);
        final BytesRef term = new BytesRef(bytes.maxLength);
        final byte[] buffer = term.bytes;
        final int length = term.length = bytes.maxLength;
        return new LongBinaryDocValues(){

            @Override
            public BytesRef get(long id) {
                try {
                    data.seek(id * (long)length);
                    data.readBytes(buffer, 0, buffer.length);
                    return term;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private BinaryDocValues getVariableBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        RandomAccessInput addressesData = this.data.randomAccessSlice(bytes.addressesOffset, bytes.addressesEndOffset - bytes.addressesOffset);
        final LongValues addresses = DirectMonotonicReader.getInstance(bytes.addressesMeta, addressesData);
        final IndexInput data = this.data.slice("var-binary", bytes.offset, bytes.addressesOffset - bytes.offset);
        final BytesRef term = new BytesRef(Math.max(0, bytes.maxLength));
        final byte[] buffer = term.bytes;
        return new LongBinaryDocValues(){

            @Override
            public BytesRef get(long id) {
                long startAddress = addresses.get(id);
                long endAddress = addresses.get(id + 1L);
                int length = (int)(endAddress - startAddress);
                try {
                    data.seek(startAddress);
                    data.readBytes(buffer, 0, length);
                    term.length = length;
                    return term;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getIntervalInstance(FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses = this.addressInstances.get(field.name);
        if (addresses == null) {
            this.data.seek(bytes.addressesOffset);
            long size = bytes.count + 15L >>> 4;
            addresses = MonotonicBlockPackedReader.of(this.data, bytes.packedIntsVersion, bytes.blockSize, size, false);
            if (!this.merging) {
                this.addressInstances.put(field.name, addresses);
                this.ramBytesUsed.addAndGet(addresses.ramBytesUsed() + 4L);
            }
        }
        return addresses;
    }

    private synchronized ReverseTermsIndex getReverseIndexInstance(FieldInfo field, BinaryEntry bytes) throws IOException {
        ReverseTermsIndex index = this.reverseIndexInstances.get(field.name);
        if (index == null) {
            index = new ReverseTermsIndex();
            this.data.seek(bytes.reverseIndexOffset);
            long size = bytes.count + 1023L >>> 10;
            index.termAddresses = MonotonicBlockPackedReader.of(this.data, bytes.packedIntsVersion, bytes.blockSize, size, false);
            long dataSize = this.data.readVLong();
            PagedBytes pagedBytes = new PagedBytes(15);
            pagedBytes.copy(this.data, dataSize);
            index.terms = pagedBytes.freeze(true);
            if (!this.merging) {
                this.reverseIndexInstances.put(field.name, index);
                this.ramBytesUsed.addAndGet(index.ramBytesUsed());
            }
        }
        return index;
    }

    private BinaryDocValues getCompressedBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses = this.getIntervalInstance(field, bytes);
        ReverseTermsIndex index = this.getReverseIndexInstance(field, bytes);
        assert (addresses.size() > 0L);
        IndexInput slice = this.data.slice("terms", bytes.offset, bytes.addressesOffset - bytes.offset);
        return new CompressedBinaryDocValues(bytes, addresses, index, slice);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        final int valueCount = (int)this.binaries.get((Object)field.name).count;
        final BinaryDocValues binary = this.getBinary(field);
        NumericEntry entry = this.ords.get(field.name);
        final LongValues ordinals = this.getNumeric(entry);
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)ordinals.get(docID);
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                return binary.get(ord);
            }

            @Override
            public int getValueCount() {
                return valueCount;
            }

            @Override
            public int lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return (int)((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private LongValues getOrdIndexInstance(FieldInfo field, NumericEntry entry) throws IOException {
        RandomAccessInput data = this.data.randomAccessSlice(entry.offset, entry.endOffset - entry.offset);
        return DirectMonotonicReader.getInstance(entry.monotonicMeta, data);
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedSetEntry ss = this.sortedNumerics.get(field.name);
        if (ss.format == 1) {
            NumericEntry numericEntry = this.numerics.get(field.name);
            LongValues values = this.getNumeric(numericEntry);
            Bits docsWithField = numericEntry.format == 5 ? ((SparseLongValues)values).docsWithField : this.getLiveBits(numericEntry.missingOffset, this.maxDoc);
            return DocValues.singleton(values, docsWithField);
        }
        if (ss.format == 0) {
            NumericEntry numericEntry = this.numerics.get(field.name);
            final LongValues values = this.getNumeric(numericEntry);
            final LongValues ordIndex = this.getOrdIndexInstance(field, this.ordIndexes.get(field.name));
            return new SortedNumericDocValues(){
                long startOffset;
                long endOffset;

                @Override
                public void setDocument(int doc) {
                    this.startOffset = ordIndex.get(doc);
                    this.endOffset = ordIndex.get((long)doc + 1L);
                }

                @Override
                public long valueAt(int index) {
                    return values.get(this.startOffset + (long)index);
                }

                @Override
                public int count() {
                    return (int)(this.endOffset - this.startOffset);
                }
            };
        }
        if (ss.format == 2) {
            NumericEntry entry = this.ords.get(field.name);
            final LongValues ordinals = this.getNumeric(entry);
            final long[] table = ss.table;
            final int[] offsets = ss.tableOffsets;
            return new SortedNumericDocValues(){
                int startOffset;
                int endOffset;

                @Override
                public void setDocument(int doc) {
                    int ord = (int)ordinals.get(doc);
                    this.startOffset = offsets[ord];
                    this.endOffset = offsets[ord + 1];
                }

                @Override
                public long valueAt(int index) {
                    return table[this.startOffset + index];
                }

                @Override
                public int count() {
                    return this.endOffset - this.startOffset;
                }
            };
        }
        throw new AssertionError();
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry ss = this.sortedSets.get(field.name);
        switch (ss.format) {
            case 1: {
                SortedDocValues values = this.getSorted(field);
                return DocValues.singleton(values);
            }
            case 0: {
                return this.getSortedSetWithAddresses(field);
            }
            case 2: {
                return this.getSortedSetTable(field, ss);
            }
        }
        throw new AssertionError();
    }

    private SortedSetDocValues getSortedSetWithAddresses(FieldInfo field) throws IOException {
        final long valueCount = this.binaries.get((Object)field.name).count;
        final LongBinaryDocValues binary = (LongBinaryDocValues)this.getBinary(field);
        final LongValues ordinals = this.getNumeric(this.ords.get(field.name));
        final LongValues ordIndex = this.getOrdIndexInstance(field, this.ordIndexes.get(field.name));
        return new RandomAccessOrds(){
            long startOffset;
            long offset;
            long endOffset;

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                long ord = ordinals.get(this.offset);
                ++this.offset;
                return ord;
            }

            @Override
            public void setDocument(int docID) {
                this.startOffset = this.offset = ordIndex.get(docID);
                this.endOffset = ordIndex.get((long)docID + 1L);
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                return binary.get(ord);
            }

            @Override
            public long getValueCount() {
                return valueCount;
            }

            @Override
            public long lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }

            @Override
            public long ordAt(int index) {
                return ordinals.get(this.startOffset + (long)index);
            }

            @Override
            public int cardinality() {
                return (int)(this.endOffset - this.startOffset);
            }
        };
    }

    private SortedSetDocValues getSortedSetTable(FieldInfo field, SortedSetEntry ss) throws IOException {
        final long valueCount = this.binaries.get((Object)field.name).count;
        final LongBinaryDocValues binary = (LongBinaryDocValues)this.getBinary(field);
        final LongValues ordinals = this.getNumeric(this.ords.get(field.name));
        final long[] table = ss.table;
        final int[] offsets = ss.tableOffsets;
        return new RandomAccessOrds(){
            int offset;
            int startOffset;
            int endOffset;

            @Override
            public void setDocument(int docID) {
                int ord = (int)ordinals.get(docID);
                this.offset = this.startOffset = offsets[ord];
                this.endOffset = offsets[ord + 1];
            }

            @Override
            public long ordAt(int index) {
                return table[this.startOffset + index];
            }

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                return table[this.offset++];
            }

            @Override
            public int cardinality() {
                return this.endOffset - this.startOffset;
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                return binary.get(ord);
            }

            @Override
            public long getValueCount() {
                return valueCount;
            }

            @Override
            public long lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private Bits getLiveBits(long offset, final int count) throws IOException {
        if (offset == -2L) {
            return new Bits.MatchNoBits(count);
        }
        if (offset == -1L) {
            return new Bits.MatchAllBits(count);
        }
        int length = (int)((long)count + 7L >>> 3);
        final RandomAccessInput in = this.data.randomAccessSlice(offset, length);
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    return (in.readByte(index >> 3) & 1 << (index & 7)) != 0;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int length() {
                return count;
            }
        };
    }

    private SparseBits getSparseLiveBits(NumericEntry entry) throws IOException {
        RandomAccessInput docIdsData = this.data.randomAccessSlice(entry.missingOffset, entry.offset - entry.missingOffset);
        LongValues docIDs = DirectMonotonicReader.getInstance(entry.monotonicMeta, docIdsData);
        return new SparseBits(this.maxDoc, entry.numDocsWithValue, docIDs);
    }

    @Override
    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue(this.getSortedSet(field), this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue(this.getSortedNumeric(field), this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue(this.getSorted(field), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.name);
                return this.getLiveBits(be.missingOffset, this.maxDoc);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.name);
                if (ne.format == 5) {
                    return this.getSparseLiveBits(ne);
                }
                return this.getLiveBits(ne.missingOffset, this.maxDoc);
            }
        }
        throw new AssertionError();
    }

    @Override
    public synchronized DocValuesProducer getMergeInstance() throws IOException {
        return new Lucene54DocValuesProducer(this);
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static final class CompressedBinaryDocValues
    extends LongBinaryDocValues {
        final long numValues;
        final long numIndexValues;
        final int maxTermLength;
        final MonotonicBlockPackedReader addresses;
        final IndexInput data;
        final CompressedBinaryTermsEnum termsEnum;
        final PagedBytes.Reader reverseTerms;
        final MonotonicBlockPackedReader reverseAddresses;
        final long numReverseIndexValues;

        public CompressedBinaryDocValues(BinaryEntry bytes, MonotonicBlockPackedReader addresses, ReverseTermsIndex index, IndexInput data) throws IOException {
            this.maxTermLength = bytes.maxLength;
            this.numValues = bytes.count;
            this.addresses = addresses;
            this.numIndexValues = addresses.size();
            this.data = data;
            this.reverseTerms = index.terms;
            this.reverseAddresses = index.termAddresses;
            this.numReverseIndexValues = this.reverseAddresses.size();
            this.termsEnum = this.getTermsEnum(data);
        }

        @Override
        public BytesRef get(long id) {
            try {
                this.termsEnum.seekExact(id);
                return this.termsEnum.term();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        long lookupTerm(BytesRef key) {
            try {
                switch (this.termsEnum.seekCeil(key)) {
                    case FOUND: {
                        return this.termsEnum.ord();
                    }
                    case NOT_FOUND: {
                        return -this.termsEnum.ord() - 1L;
                    }
                }
                return -this.numValues - 1L;
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
        }

        TermsEnum getTermsEnum() {
            try {
                return this.getTermsEnum(this.data.clone());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private CompressedBinaryTermsEnum getTermsEnum(IndexInput input) throws IOException {
            return new CompressedBinaryTermsEnum(input);
        }

        class CompressedBinaryTermsEnum
        extends TermsEnum {
            private long currentOrd = -1L;
            private long currentBlockStart;
            private final IndexInput input;
            private final int[] offsets = new int[16];
            private final byte[] buffer = new byte[31];
            private final BytesRef term;
            private final BytesRef firstTerm;
            private final BytesRef scratch;

            CompressedBinaryTermsEnum(IndexInput input) throws IOException {
                this.term = new BytesRef(CompressedBinaryDocValues.this.maxTermLength);
                this.firstTerm = new BytesRef(CompressedBinaryDocValues.this.maxTermLength);
                this.scratch = new BytesRef();
                this.input = input;
                input.seek(0L);
            }

            private void readHeader() throws IOException {
                this.firstTerm.length = this.input.readVInt();
                this.input.readBytes(this.firstTerm.bytes, 0, this.firstTerm.length);
                this.input.readBytes(this.buffer, 0, 15);
                if (this.buffer[0] == -1) {
                    this.readShortAddresses();
                } else {
                    this.readByteAddresses();
                }
                this.currentBlockStart = this.input.getFilePointer();
            }

            private void readByteAddresses() throws IOException {
                int addr = 0;
                for (int i = 1; i < this.offsets.length; ++i) {
                    this.offsets[i] = addr += 2 + (this.buffer[i - 1] & 0xFF);
                }
            }

            private void readShortAddresses() throws IOException {
                this.input.readBytes(this.buffer, 15, 16);
                int addr = 0;
                for (int i = 1; i < this.offsets.length; ++i) {
                    int x = i << 1;
                    this.offsets[i] = addr += 2 + (this.buffer[x - 1] << 8 | this.buffer[x] & 0xFF);
                }
            }

            private void readFirstTerm() throws IOException {
                this.term.length = this.firstTerm.length;
                System.arraycopy(this.firstTerm.bytes, this.firstTerm.offset, this.term.bytes, 0, this.term.length);
            }

            private void readTerm(int offset) throws IOException {
                int start = this.input.readByte() & 0xFF;
                System.arraycopy(this.firstTerm.bytes, this.firstTerm.offset, this.term.bytes, 0, start);
                int suffix = this.offsets[offset] - this.offsets[offset - 1] - 1;
                this.input.readBytes(this.term.bytes, start, suffix);
                this.term.length = start + suffix;
            }

            @Override
            public BytesRef next() throws IOException {
                ++this.currentOrd;
                if (this.currentOrd >= CompressedBinaryDocValues.this.numValues) {
                    return null;
                }
                int offset = (int)(this.currentOrd & 0xFL);
                if (offset == 0) {
                    this.readHeader();
                    this.readFirstTerm();
                } else {
                    this.readTerm(offset);
                }
                return this.term;
            }

            long binarySearchIndex(BytesRef text) throws IOException {
                long low = 0L;
                long high = CompressedBinaryDocValues.this.numReverseIndexValues - 1L;
                while (low <= high) {
                    long mid = low + high >>> 1;
                    CompressedBinaryDocValues.this.reverseTerms.fill(this.scratch, CompressedBinaryDocValues.this.reverseAddresses.get(mid));
                    int cmp = this.scratch.compareTo(text);
                    if (cmp < 0) {
                        low = mid + 1L;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1L;
                        continue;
                    }
                    return mid;
                }
                return high;
            }

            long binarySearchBlock(BytesRef text, long low, long high) throws IOException {
                while (low <= high) {
                    long mid = low + high >>> 1;
                    this.input.seek(CompressedBinaryDocValues.this.addresses.get(mid));
                    this.term.length = this.input.readVInt();
                    this.input.readBytes(this.term.bytes, 0, this.term.length);
                    int cmp = this.term.compareTo(text);
                    if (cmp < 0) {
                        low = mid + 1L;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1L;
                        continue;
                    }
                    return mid;
                }
                return high;
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                long block;
                long indexPos = this.binarySearchIndex(text);
                if (indexPos < 0L) {
                    block = 0L;
                } else {
                    long low = indexPos << 6;
                    long high = Math.min(CompressedBinaryDocValues.this.numIndexValues - 1L, low + 63L);
                    block = Math.max(low, this.binarySearchBlock(text, low, high));
                }
                this.input.seek(CompressedBinaryDocValues.this.addresses.get(block));
                this.currentOrd = (block << 4) - 1L;
                while (this.next() != null) {
                    int cmp = this.term.compareTo(text);
                    if (cmp == 0) {
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (cmp <= 0) continue;
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                return TermsEnum.SeekStatus.END;
            }

            @Override
            public void seekExact(long ord) throws IOException {
                long block = ord >>> 4;
                if (block != this.currentOrd >>> 4) {
                    this.input.seek(CompressedBinaryDocValues.this.addresses.get(block));
                    this.readHeader();
                }
                this.currentOrd = ord;
                int offset = (int)(ord & 0xFL);
                if (offset == 0) {
                    this.readFirstTerm();
                } else {
                    this.input.seek(this.currentBlockStart + (long)this.offsets[offset - 1]);
                    this.readTerm(offset);
                }
            }

            @Override
            public BytesRef term() throws IOException {
                return this.term;
            }

            @Override
            public long ord() throws IOException {
                return this.currentOrd;
            }

            @Override
            public int docFreq() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long totalTermFreq() throws IOException {
                return -1L;
            }

            @Override
            public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class ReverseTermsIndex
    implements Accountable {
        public MonotonicBlockPackedReader termAddresses;
        public PagedBytes.Reader terms;

        ReverseTermsIndex() {
        }

        @Override
        public long ramBytesUsed() {
            return this.termAddresses.ramBytesUsed() + this.terms.ramBytesUsed();
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable("term bytes", this.terms));
            resources.add(Accountables.namedAccountable("term addresses", this.termAddresses));
            return Collections.unmodifiableList(resources);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(size=" + this.termAddresses.size() + ")";
        }
    }

    static abstract class LongBinaryDocValues
    extends BinaryDocValues {
        LongBinaryDocValues() {
        }

        @Override
        public final BytesRef get(int docID) {
            return this.get((long)docID);
        }

        abstract BytesRef get(long var1);
    }

    static class SortedSetEntry {
        int format;
        long[] table;
        int[] tableOffsets;

        private SortedSetEntry() {
        }
    }

    static class BinaryEntry {
        long missingOffset;
        long offset;
        int format;
        public long count;
        int minLength;
        int maxLength;
        public long addressesOffset;
        public long addressesEndOffset;
        public DirectMonotonicReader.Meta addressesMeta;
        public long reverseIndexOffset;
        public int packedIntsVersion;
        public int blockSize;

        private BinaryEntry() {
        }
    }

    static class NumericEntry {
        long missingOffset;
        public long offset;
        public long endOffset;
        public int bitsPerValue;
        int format;
        public long count;
        public DirectMonotonicReader.Meta monotonicMeta;
        long minValue;
        long gcd;
        long[] table;
        long numDocsWithValue;
        NumericEntry nonMissingValues;
        Lucene54DocValuesConsumer.NumberType numberType;

        private NumericEntry() {
        }
    }

    static class SparseLongValues
    extends LongValues {
        final SparseBits docsWithField;
        final LongValues values;
        final long missingValue;

        SparseLongValues(SparseBits docsWithField, LongValues values, long missingValue) {
            this.docsWithField = docsWithField;
            this.values = values;
            this.missingValue = missingValue;
        }

        @Override
        public long get(long docId) {
            if (this.docsWithField.get(docId)) {
                return this.values.get(this.docsWithField.index);
            }
            return this.missingValue;
        }
    }

    static class SparseBits
    implements Bits {
        final long maxDoc;
        final long docIDsLength;
        final long firstDocId;
        final LongValues docIds;
        long index;
        long docId;
        long nextDocId;

        SparseBits(long maxDoc, long docIDsLength, LongValues docIDs) {
            if (docIDsLength > 0L && maxDoc <= docIDs.get(docIDsLength - 1L)) {
                throw new IllegalArgumentException("maxDoc must be > the last element of docIDs");
            }
            this.maxDoc = maxDoc;
            this.docIDsLength = docIDsLength;
            this.docIds = docIDs;
            this.firstDocId = docIDsLength == 0L ? maxDoc : docIDs.get(0);
            this.reset();
        }

        private void reset() {
            this.index = -1L;
            this.docId = -1L;
            this.nextDocId = this.firstDocId;
        }

        private long gallop(long docId) {
            ++this.index;
            this.docId = this.nextDocId;
            long hiIndex = this.index + 1L;
            while (true) {
                if (hiIndex >= this.docIDsLength) {
                    hiIndex = this.docIDsLength;
                    this.nextDocId = this.maxDoc;
                    break;
                }
                long hiDocId = this.docIds.get(hiIndex);
                if (hiDocId > docId) {
                    this.nextDocId = hiDocId;
                    break;
                }
                long delta = hiIndex - this.index;
                this.index = hiIndex;
                this.docId = hiDocId;
                hiIndex += delta << 1;
            }
            return hiIndex;
        }

        private void binarySearch(long hiIndex, long docId) {
            while (this.index + 1L < hiIndex) {
                long midIndex = this.index + hiIndex >>> 1;
                long midDocId = this.docIds.get(midIndex);
                if (midDocId > docId) {
                    hiIndex = midIndex;
                    this.nextDocId = midDocId;
                    continue;
                }
                this.index = midIndex;
                this.docId = midDocId;
            }
        }

        private boolean checkInvariants(long nextIndex, long docId) {
            assert (this.docId <= docId);
            assert (this.nextDocId > docId);
            assert (this.index == -1L && this.docId == -1L || this.docId == this.docIds.get(this.index));
            assert (nextIndex == this.docIDsLength && this.nextDocId == this.maxDoc || this.nextDocId == this.docIds.get(nextIndex));
            return true;
        }

        private void exponentialSearch(long docId) {
            long hiIndex = this.gallop(docId);
            assert (this.checkInvariants(hiIndex, docId));
            this.binarySearch(hiIndex, docId);
        }

        boolean get(long docId) {
            if (docId < this.docId) {
                this.reset();
            }
            if (docId >= this.nextDocId) {
                this.exponentialSearch(docId);
            }
            assert (this.checkInvariants(this.index + 1L, docId));
            return docId == this.docId;
        }

        @Override
        public boolean get(int index) {
            return this.get((long)index);
        }

        @Override
        public int length() {
            return Math.toIntExact(this.maxDoc);
        }
    }
}

