/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.medline;

import de.julielab.medline.IDocumentDeleter;
import de.julielab.medline.MedlineDocumentDeletionException;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedlineDataTableDocumentDeleter
implements IDocumentDeleter {
    private static final Logger log = LoggerFactory.getLogger(MedlineDataTableDocumentDeleter.class);
    private DataBaseConnector dbc;

    public void setDbc(DataBaseConnector dbc) {
        this.dbc = dbc;
    }

    @Override
    public void deleteDocuments(List<String> docIds) {
        log.info("Deleting {} documents marked for deletion in update file from table \"{}\".", (Object)docIds.size(), (Object)"_data._data");
        this.dbc.deleteFromTableSimplePK("_data._data", docIds);
    }

    @Override
    public void configure(HierarchicalConfiguration<ImmutableNode> deletionConfiguration) throws MedlineDocumentDeletionException {
    }

    @Override
    public Set<String> getNames() {
        return new HashSet<String>(Arrays.asList("medline", this.getClass().getCanonicalName()));
    }
}

