/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.hiddenConfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiddenConfig {
    private static final int USER = 0;
    private static final int PASS = 1;
    private Logger LOG = LoggerFactory.getLogger(HiddenConfig.class);
    private Map<String, String[]> authentication = new HashMap<String, String[]>();
    private File configFile;

    public HiddenConfig() {
        String home = System.getProperty("user.home");
        String fileSeparator = System.getProperty("file.separator");
        String fileStr = home + fileSeparator + ".dbcUser";
        File homeDir = new File(home);
        File homeConfigFile = new File(fileStr);
        String directPath = System.getProperty("dbcTest.hiddenConfigPath");
        if (directPath != null) {
            this.configFile = new File(directPath);
        } else if (homeDir.exists()) {
            this.configFile = homeConfigFile;
        } else {
            this.LOG.warn("No home directory found and the \"dbcTest.hiddenConfigPath\" is not set; thus, the configuration file is stored in the working directory.");
            this.configFile = new File(homeConfigFile.getName());
        }
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e1) {
                this.LOG.error("Could not create " + this.configFile.getPath());
            }
        }
        if (!this.configFile.canRead()) {
            this.LOG.error("Could not read from " + this.configFile.getPath());
        }
        FileReader fr = null;
        try {
            fr = new FileReader(this.configFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader br = new BufferedReader(fr);
        try {
            while (br.ready()) {
                String DBConnectionName = br.readLine();
                if (this.authentication.get(DBConnectionName) != null) {
                    this.LOG.error("You must not have multiple entries for one DBConnections name!");
                    throw new IOException();
                }
                String[] userAndPass = new String[]{br.readLine(), br.readLine()};
                this.authentication.put(DBConnectionName, userAndPass);
                if (br.readLine() != null) continue;
                String msg = "Your .dbcUser file has malformed content.";
                this.LOG.error(msg);
                throw new IOException("The CoStoSys credentials caching file at " + this.configFile + " file has malformed content.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getUsername(String DBConnectionName) {
        return this.getFromMap(DBConnectionName, 0);
    }

    public String getPassword(String DBConnectionName) {
        return this.getFromMap(DBConnectionName, 1);
    }

    private String getFromMap(String DBConnectionName, int what) {
        if (this.authentication.containsKey(DBConnectionName)) {
            return this.authentication.get(DBConnectionName)[what];
        }
        this.createEntry(DBConnectionName);
        return this.getFromMap(DBConnectionName, what);
    }

    private void createEntry(String DBConnectionName) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                System.out.println("This is the interactive credentials entry dialog to access the database with name " + DBConnectionName + ". Do you wish to enter your credentials now - Y/N ?");
                String answer = null;
                try {
                    answer = in.readLine();
                }
                catch (IOException e) {
                    this.LOG.error("Could not read from comandline!?", e);
                }
                if (!answer.equalsIgnoreCase("Y")) {
                    if (!answer.equalsIgnoreCase("N")) continue;
                    System.out.println("Aborting...");
                    System.exit(0);
                    continue;
                }
                break;
            }
        }
        catch (Exception e1) {
            this.LOG.error("An error occurred during the user-interactive dialog to create a new login for the database {}. If you are running into this error with a program that is not meant to be interactive, you have create the login entry beforehand. You can do this by doing something with the DataBaseConnector, e.g. showing all tables with the -t switch. Alternatively, you can directly edit the hidden configuration file. By default, it is found at ${HOME}/.dbcUser. The original error was: ", (Object)DBConnectionName, (Object)e1);
            e1.printStackTrace();
        }
        String[] userAndPass = new String[2];
        System.out.println("Please enter your username for " + DBConnectionName);
        try {
            userAndPass[0] = in.readLine();
            System.out.println("Please enter your password for " + DBConnectionName);
            userAndPass[1] = in.readLine();
            this.authentication.put(DBConnectionName, userAndPass);
        }
        catch (IOException e) {
            this.LOG.error("Could not read from comandline!?", e);
        }
        try {
            if (this.configFile.exists() && this.configFile.canWrite()) {
                String lineSeparator = System.getProperty("line.separator");
                FileWriter fw = new FileWriter(this.configFile, true);
                fw.write(DBConnectionName);
                fw.write(lineSeparator);
                fw.write(userAndPass[0]);
                fw.write(lineSeparator);
                fw.write(userAndPass[1]);
                fw.write(lineSeparator);
                fw.write(lineSeparator);
                fw.close();
            }
        }
        catch (IOException e) {
            this.LOG.error("Could not write to hidden file.", e);
        }
    }
}

