/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.medline;

import de.julielab.medline.IDocumentDeleter;
import de.julielab.medline.MedlineDataTableDocumentDeleter;
import de.julielab.medline.MedlineDocumentDeletionException;
import de.julielab.medline.MedlineUpdateException;
import de.julielab.xml.JulieXMLTools;
import de.julielab.xmlData.dataBase.CoStoSysConnection;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Updater {
    private static final Logger log = LoggerFactory.getLogger(Updater.class);
    public static final String UPDATE_TABLE = "_data._medline_update_files";
    public static final String COLUMN_FILENAME = "update_file_name";
    public static final String COLUMN_IS_IMPORTED = "is_imported";
    public static final String COLUMN_TIMESTAMP = "timestamp_of_import";
    private final String medlineFile;
    private ServiceLoader<IDocumentDeleter> documentDeleterLoader;
    private HierarchicalConfiguration<ImmutableNode> configuration;

    public Updater(HierarchicalConfiguration<ImmutableNode> configuration) {
        this.configuration = configuration;
        this.medlineFile = configuration.getString("update.directory");
        this.documentDeleterLoader = ServiceLoader.load(IDocumentDeleter.class);
    }

    public void process(DataBaseConnector dbc) throws MedlineUpdateException, IOException {
        log.info("Updating from {} into database at {}", (Object)this.medlineFile, (Object)dbc.getDbURL());
        File[] updateFiles = this.getMedlineFiles(this.medlineFile);
        List<File> unprocessedMedlineUpdates = Updater.getUnprocessedMedlineUpdates(updateFiles, dbc);
        this.configureDocumentDeleters();
        String[] configuredDeleters = this.configuration.getStringArray("documentdeletions.deletion.deleter");
        for (File file : unprocessedMedlineUpdates) {
            log.info("Processing file {}.", (Object)file.getAbsoluteFile());
            dbc.updateFromXML(file.getAbsolutePath(), "_data._data");
            List<String> pmidsToDelete = Updater.getPmidsToDelete(file);
            for (IDocumentDeleter documentDeleter : this.documentDeleterLoader) {
                if (!documentDeleter.hasName(configuredDeleters)) continue;
                if (documentDeleter instanceof MedlineDataTableDocumentDeleter) {
                    ((MedlineDataTableDocumentDeleter)documentDeleter).setDbc(dbc);
                }
                documentDeleter.deleteDocuments(pmidsToDelete);
            }
            this.markFileAsImported(file, dbc);
        }
    }

    protected File[] getMedlineFiles(String medlinePathString) throws FileNotFoundException {
        File medlinePath = new File(medlinePathString);
        if (!medlinePath.exists()) {
            throw new FileNotFoundException("File \"" + medlinePathString + "\" was not found.");
        }
        if (!medlinePath.isDirectory()) {
            return new File[]{medlinePath};
        }
        File[] medlineFiles = medlinePath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String filename = file.getName();
                return filename.endsWith("gz") || filename.endsWith("gzip") || filename.endsWith("zip");
            }
        });
        if (medlineFiles == null || medlineFiles.length == 0) {
            log.info("No (g)zipped files found in directory {}. No update will be performed.", (Object)medlinePathString);
            System.exit(0);
        }
        return medlineFiles;
    }

    private void configureDocumentDeleters() throws MedlineDocumentDeletionException {
        if (this.configuration.containsKey("documentdeletions.deletion")) {
            List deletionConfigs = this.configuration.configurationsAt("documentdeletions.deletion");
            for (HierarchicalConfiguration deletionConf : deletionConfigs) {
                for (IDocumentDeleter documentDeleter : this.documentDeleterLoader) {
                    if (!documentDeleter.hasName(deletionConf.getString("documentdeletions.deletion.deleter"))) continue;
                    documentDeleter.configure((HierarchicalConfiguration<ImmutableNode>)deletionConf);
                }
            }
        }
    }

    private static List<File> getUnprocessedMedlineUpdates(File[] updateFiles, DataBaseConnector dbc) {
        ArrayList<File> unprocessedFiles = new ArrayList<File>();
        try (CoStoSysConnection coStoSysConnection = dbc.obtainOrReserveConnection();){
            Connection conn = coStoSysConnection.getConnection();
            HashSet<String> updateFileNameSet = new HashSet<String>();
            for (File f : updateFiles) {
                updateFileNameSet.add(f.getName());
            }
            try {
                Statement st = conn.createStatement();
                boolean exists = dbc.tableExists(UPDATE_TABLE);
                if (!exists) {
                    String createUpdateTable = String.format("CREATE TABLE %s (%s TEXT PRIMARY KEY,%s BOOLEAN DEFAULT FALSE,%s TIMESTAMP WITHOUT TIME ZONE)", UPDATE_TABLE, COLUMN_FILENAME, COLUMN_IS_IMPORTED, COLUMN_TIMESTAMP);
                    st.execute(createUpdateTable);
                }
                HashSet<String> filenamesInDBSet = new HashSet<String>();
                ResultSet rs = st.executeQuery(String.format("SELECT %s from %s", COLUMN_FILENAME, UPDATE_TABLE));
                while (rs.next()) {
                    String filename = rs.getString(COLUMN_FILENAME);
                    filenamesInDBSet.add(filename);
                }
                updateFileNameSet.removeAll(filenamesInDBSet);
                conn.setAutoCommit(false);
                PreparedStatement ps = conn.prepareStatement(String.format("INSERT INTO %s VALUES (?)", UPDATE_TABLE));
                for (String filename : updateFileNameSet) {
                    ps.setString(1, filename);
                    ps.addBatch();
                }
                ps.executeBatch();
                conn.commit();
                conn.setAutoCommit(true);
                String sql = String.format("SELECT %s FROM %s WHERE %s = FALSE", COLUMN_FILENAME, UPDATE_TABLE, COLUMN_IS_IMPORTED);
                rs = st.executeQuery(sql);
                HashSet<String> unprocessedFileSet = new HashSet<String>();
                while (rs.next()) {
                    unprocessedFileSet.add(rs.getString(COLUMN_FILENAME));
                }
                for (File updateFile : updateFiles) {
                    if (!unprocessedFileSet.contains(updateFile.getName())) continue;
                    unprocessedFiles.add(updateFile);
                }
                Collections.sort(unprocessedFiles, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return f1.getName().compareTo(f2.getName());
                    }
                });
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return unprocessedFiles;
    }

    private static List<String> getPmidsToDelete(File file) {
        ArrayList<String> pmidsToDelete = new ArrayList<String>();
        String forEachXpath = "/MedlineCitationSet/DeleteCitation/PMID";
        ArrayList fields = new ArrayList();
        HashMap<String, String> field = new HashMap<String, String>();
        field.put("name", "pmid");
        field.put("xpath", ".");
        fields.add(field);
        int bufferSize = 1000;
        Iterator it = JulieXMLTools.constructRowIterator((String)file.getAbsolutePath(), (int)bufferSize, (String)forEachXpath, fields, (boolean)false);
        while (it.hasNext()) {
            Map row = (Map)it.next();
            String pmid = (String)row.get("pmid");
            pmidsToDelete.add(pmid);
        }
        return pmidsToDelete;
    }

    private void markFileAsImported(File file, DataBaseConnector dbc) {
        try (CoStoSysConnection coStoSysConnection = dbc.obtainOrReserveConnection();){
            Connection conn = coStoSysConnection.getConnection();
            String sql = null;
            try {
                sql = String.format("UPDATE %s SET %s = TRUE, %s = '" + new Timestamp(System.currentTimeMillis()) + "' WHERE %s = '%s'", UPDATE_TABLE, COLUMN_IS_IMPORTED, COLUMN_TIMESTAMP, COLUMN_FILENAME, file.getName());
                conn.createStatement().execute(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                log.error("SQL command was: {}", sql);
            }
        }
    }
}

