/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.dataBase;

import de.julielab.xmlData.dataBase.ConnectionClosable;
import de.julielab.xmlData.dataBase.DBCIterator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Exchanger;

public abstract class DBCThreadedIterator<E>
extends DBCIterator<E> {
    protected Exchanger<List<E>> listExchanger = new Exchanger();
    protected ConnectionClosable backgroundThread;
    private Iterator<E> currentListIter;
    private boolean hasNext = true;

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        E next = this.currentListIter.next();
        if (!this.currentListIter.hasNext()) {
            this.update();
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void update() {
        try {
            List list = this.listExchanger.exchange(null);
            while (list != null && list.isEmpty()) {
                list = this.listExchanger.exchange(null);
            }
            if (list == null) {
                this.hasNext = false;
            } else {
                this.currentListIter = list.iterator();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public abstract void close();

    public abstract void join() throws InterruptedException;
}

