/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.config;

import com.ximpleware.AutoPilot;
import com.ximpleware.EOFException;
import com.ximpleware.EncodingException;
import com.ximpleware.EntityException;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.PilotException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.xmlData.config.ConfigBase;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class DBConfig
extends ConfigBase {
    private static final String XPATH_CONF_DB_INFO = "//DBConnectionInformation";
    private static final String XPATH_CONF_ACTIVE_DB_NAME = "//activeDBConnection";
    private static final String XPATH_CONF_ACTIVE_PG_SCHEMA = "//activePostgresSchema";
    private static final String XPATH_CONF_ACTIVE_DATA_PG_SCHEMA = "//activeDataPostgresSchema";
    private static final String XPATH_CONF_DBs = "//DBConnectionInformation/DBConnections";
    private static final String XPATH_CONF_DB = "//DBConnectionInformation/DBConnections/DBConnection";
    private static final String XPATH_CONF_MAX_CON = "//DBConnectionInformation/maxActiveDBConnections";
    private static final String XPATH_CONF_TEMPLATE = "//DBConnectionInformation/DBConnections/DBConnection[@name='%s']";
    private static final String XPATH_CONF_URL_TEMPLATE = "//DBConnectionInformation/DBConnections/DBConnection[@name='%s']";
    private static final String ATTRIBUTE_URL = "url";
    private String url;
    private String activePGSchema;
    private int maxConnections = 5;
    private String activeDatabase;
    private String activeDataPGSchema;

    public DBConfig(byte[] configData) throws VTDException {
        try {
            this.activePGSchema = DBConfig.getActiveConfig(configData, XPATH_CONF_ACTIVE_PG_SCHEMA).toLowerCase();
            this.activeDataPGSchema = DBConfig.getActiveConfig(configData, XPATH_CONF_ACTIVE_DATA_PG_SCHEMA).toLowerCase();
            this.activeDatabase = DBConfig.getActiveConfig(configData, XPATH_CONF_ACTIVE_DB_NAME);
            this.buildDatabaseValues(this.activeDatabase, configData);
            VTDGen vg = new VTDGen();
            vg.setDoc(configData);
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            String maxConnString = this.stringFromXpath(ap, XPATH_CONF_MAX_CON);
            if (!StringUtils.isBlank((CharSequence)maxConnString)) {
                this.maxConnections = Integer.parseInt(maxConnString);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildDatabaseValues(String activeDatabase, byte[] mergedConfData) throws EncodingException, EOFException, EntityException, ParseException, XPathParseException, XPathEvalException, NavException, PilotException {
        VTDGen vg = new VTDGen();
        vg.setDoc(mergedConfData);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.selectXPath(String.format("//DBConnectionInformation/DBConnections/DBConnection[@name='%s']", activeDatabase));
        if (ap.evalXPath() != -1) {
            int attrIndex = vn.getAttrVal(ATTRIBUTE_URL);
            if (attrIndex != -1) {
                this.url = vn.toString(attrIndex);
            }
        } else {
            throw new IllegalArgumentException("There is no database connection named \"" + activeDatabase + "\" defined in the configuration.");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getActivePGSchema() {
        return this.activePGSchema;
    }

    public String getActiveDataPGSchema() {
        return this.activeDataPGSchema;
    }

    public void setActivePGSchema(String pgSchema) {
        this.activePGSchema = pgSchema;
    }

    public String getActiveDatabase() {
        return this.activeDatabase;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public String toString() {
        String str = "Database URL: " + this.url + "\n";
        str = str + "Active Postgres schema: " + this.activePGSchema + "\n";
        str = str + "Max open connections: " + this.maxConnections;
        return str;
    }
}

