/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.cli;

import de.julielab.xml.JulieXMLTools;
import de.julielab.xmlData.cli.QueryOptions;
import de.julielab.xmlData.cli.QueryPubMed;
import de.julielab.xmlData.cli.TableNotFoundException;
import de.julielab.xmlData.config.TableSchemaDoesNotExistException;
import de.julielab.xmlData.dataBase.DBCIterator;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import de.julielab.xmlData.dataBase.SubsetStatus;
import de.julielab.xmlData.dataBase.util.TableSchemaMismatchException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLI {
    private static final String DELIMITER = "\n--------------------------------------------------------------------------------\n";
    private static final Logger LOG = LoggerFactory.getLogger(CLI.class);
    private static boolean verbose = false;
    public static String[] USER_SCHEME_DEFINITION = new String[]{"dbcconfiguration.xml", "costosys.xml", "costosysconfiguration.xml"};
    private static final String KEY_PART_SEPERATOR = "\t";
    private static final String FILE_SEPERATOR = System.getProperty("file.separator");

    private static void logMessage(String msg) {
        if (!verbose) {
            return;
        }
        LOG.info(msg);
    }

    public static void main(String[] args) throws SQLException, TableSchemaMismatchException {
        String superTableName;
        String fileStr;
        String subsetTableName;
        String password;
        String user;
        String msg;
        long time = System.currentTimeMillis();
        boolean updateMode = false;
        boolean error = false;
        Mode mode = Mode.ERROR;
        Options options = CLI.getOptions();
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.error("Can't parse arguments: " + e.getMessage());
            CLI.printHelp(options);
            System.exit(1);
        }
        verbose = cmd.hasOption('v');
        if (verbose) {
            LOG.info("Verbose logging enabled.");
        }
        if (cmd.hasOption("h")) {
            error = true;
        }
        if (cmd.hasOption("i")) {
            mode = Mode.IMPORT;
        }
        if (cmd.hasOption("u")) {
            mode = Mode.IMPORT;
            updateMode = true;
        }
        if (cmd.hasOption("q")) {
            mode = Mode.QUERY;
        }
        if (cmd.getOptionValue("s") != null) {
            mode = Mode.SUBSET;
        }
        if (cmd.getOptionValue("re") != null) {
            mode = Mode.RESET;
        }
        if (cmd.getOptionValue("st") != null) {
            mode = Mode.STATUS;
        }
        if (cmd.hasOption("t")) {
            mode = Mode.TABLES;
        }
        if (cmd.hasOption("lts")) {
            mode = Mode.LIST_TABLE_SCHEMAS;
        }
        if (cmd.hasOption("td")) {
            mode = Mode.TABLE_DEFINITION;
        }
        if (cmd.hasOption("sch")) {
            mode = Mode.SCHEME;
        }
        if (cmd.hasOption("ch")) {
            mode = Mode.CHECK;
        }
        if (cmd.hasOption("dc")) {
            mode = Mode.DEFAULT_CONFIG;
        }
        if (cmd.hasOption("dt")) {
            mode = Mode.DROP_TABLE;
        }
        String dbcConfigPath = CLI.findConfigurationFile();
        if (cmd.hasOption("dbc")) {
            dbcConfigPath = cmd.getOptionValue("dbc");
        }
        File conf = new File(dbcConfigPath);
        String dbUrl = cmd.getOptionValue('U');
        if (dbUrl == null) {
            msg = "No database URL given. Using value in configuration file";
            CLI.logMessage(msg);
        }
        if ((user = cmd.getOptionValue("n")) == null) {
            msg = "No database username given. Using value in configuration file";
            CLI.logMessage(msg);
        }
        if ((password = cmd.getOptionValue("p")) == null) {
            msg = "No password given. Using value in configuration file";
            CLI.logMessage(msg);
        }
        String serverName = cmd.getOptionValue("srv");
        String dbName = cmd.getOptionValue("db");
        String pgSchema = cmd.getOptionValue("pgs");
        if (!((serverName != null && dbName != null) ^ dbUrl != null || serverName == null && dbName == null && dbUrl == null || conf.exists())) {
            LOG.error("No base configuration has been found. Thus, you must specify server name and database name or the complete URL with -u (but not both).");
            System.exit(1);
        }
        DataBaseConnector dbc = null;
        try {
            if (conf.exists()) {
                CLI.logMessage(String.format("Using configuration file at %s", conf));
                dbc = dbUrl == null ? new DataBaseConnector(serverName, dbName, user, password, pgSchema, (InputStream)new FileInputStream(conf)) : new DataBaseConnector(dbUrl, user, password, pgSchema, new FileInputStream(conf));
            } else {
                CLI.logMessage(String.format("No custom configuration found (should be located at %s). Using default configuration.", Stream.of(USER_SCHEME_DEFINITION).collect(Collectors.joining(" or "))));
                dbc = dbUrl == null ? new DataBaseConnector(serverName, dbName, user, password, pgSchema, null) : new DataBaseConnector(dbUrl, user, password, pgSchema, null);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String tableName = cmd.getOptionValue("td");
        if (tableName == null) {
            tableName = cmd.getOptionValue("ch");
        }
        if ((subsetTableName = cmd.getOptionValue("s")) == null) {
            subsetTableName = cmd.getOptionValue("re");
        }
        if (subsetTableName == null) {
            subsetTableName = cmd.getOptionValue("renp");
        }
        if (subsetTableName == null) {
            subsetTableName = cmd.getOptionValue("st");
        }
        if ((fileStr = cmd.getOptionValue("f")) == null) {
            fileStr = cmd.getOptionValue("i");
        }
        if (fileStr == null) {
            fileStr = cmd.getOptionValue("u");
        }
        if ((superTableName = cmd.getOptionValue("z")) == null) {
            superTableName = dbc.getActiveDataTable();
        }
        String queryStr = cmd.getOptionValue("q");
        String subsetJournalFileName = cmd.getOptionValue("j");
        String subsetQuery = cmd.getOptionValue("o");
        String randomSubsetSize = cmd.getOptionValue("r");
        String whereClause = cmd.getOptionValue("w");
        String xpath = cmd.getOptionValue("x");
        String baseOutDir = cmd.getOptionValue("out");
        String batchSize = cmd.getOptionValue("bs");
        String limit = cmd.getOptionValue("l");
        String tableSchema = cmd.getOptionValue("ts") != null ? cmd.getOptionValue("ts") : dbc.getActiveTableSchema();
        boolean useDelimiter = baseOutDir != null ? false : cmd.hasOption("d");
        boolean returnPubmedArticleSet = cmd.hasOption("pas");
        boolean mirrorSubset = cmd.hasOption("m");
        boolean all4Subset = cmd.hasOption("a");
        Integer numberRefHops = cmd.hasOption("rh") ? Integer.valueOf(Integer.parseInt(cmd.getOptionValue("rh"))) : null;
        String comment = null;
        if (tableSchema.matches("[0-9]+")) {
            tableSchema = dbc.getConfig().getTableSchemaNames().get(Integer.parseInt(tableSchema));
        }
        switch (mode) {
            case QUERY: {
                QueryOptions qo = new QueryOptions();
                qo.fileStr = fileStr;
                qo.queryStr = queryStr;
                qo.useDelimiter = useDelimiter;
                qo.pubmedArticleSet = returnPubmedArticleSet;
                qo.xpath = xpath;
                qo.baseOutDirStr = baseOutDir;
                qo.batchSizeStr = batchSize;
                qo.limitStr = limit;
                qo.tableName = superTableName;
                qo.tableSchema = tableSchema;
                qo.whereClause = whereClause;
                qo.numberRefHops = numberRefHops;
                error = CLI.doQuery(dbc, qo);
                break;
            }
            case IMPORT: {
                error = CLI.doImportOrUpdate(dbc, fileStr, queryStr, superTableName, comment, updateMode);
                break;
            }
            case SUBSET: {
                error = CLI.doSubset(dbc, subsetTableName, fileStr, queryStr, superTableName, subsetJournalFileName, subsetQuery, mirrorSubset, whereClause, all4Subset, randomSubsetSize, numberRefHops, comment);
                break;
            }
            case RESET: {
                if (subsetTableName == null) {
                    LOG.error("You must provide the name of the subset table to reset.");
                    error = true;
                    break;
                }
                boolean files = cmd.hasOption("f");
                try {
                    if (!files || StringUtils.isBlank((CharSequence)fileStr)) {
                        String lc;
                        boolean np = cmd.hasOption("np");
                        boolean ne = cmd.hasOption("ne");
                        String string = lc = cmd.hasOption("lc") ? cmd.getOptionValue("lc") : null;
                        if (np) {
                            CLI.logMessage("table reset is restricted to non-processed table rows");
                        }
                        if (ne) {
                            CLI.logMessage("table reset is restricted to table row without errors");
                        }
                        if (lc != null) {
                            CLI.logMessage("table reset is restricted to rows with last component " + lc);
                        }
                        if (!np && !ne && lc == null) {
                            String input;
                            SubsetStatus status = dbc.status(subsetTableName, EnumSet.of(DataBaseConnector.StatusElement.IN_PROCESS, DataBaseConnector.StatusElement.IS_PROCESSED, DataBaseConnector.StatusElement.TOTAL));
                            long inProcess = status.inProcess;
                            long isProcessed = status.isProcessed;
                            long total = status.total;
                            if (total > 10000L && inProcess + isProcessed >= total / 2L && (input = CLI.getYesNoAnswer("The subset table \"" + subsetTableName + "\" is in process or already processed over 50%. Do you really wish to reset it completely into an unprocessed state? (yes/no)")).equals("no")) {
                                System.exit(0);
                            }
                        }
                        dbc.resetSubset(subsetTableName, np, ne, lc);
                        break;
                    }
                    CLI.logMessage("Resetting all documents identified by the IDs in file \"" + fileStr + "\".");
                    try {
                        List<Object[]> pkValues = CLI.asListOfArrays(fileStr);
                        dbc.resetSubset(subsetTableName, pkValues);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (TableNotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
            case STATUS: {
                error = CLI.doStatus(dbc, subsetTableName);
                break;
            }
            case TABLES: {
                for (String s : dbc.getTables()) {
                    System.out.println(s);
                }
                break;
            }
            case TABLE_DEFINITION: {
                for (String s : dbc.getTableDefinition(tableName)) {
                    System.out.println(s);
                }
                break;
            }
            case LIST_TABLE_SCHEMAS: {
                System.out.println("The following table schema names are contained in the current configuration:\n");
                List<String> tableSchemaNames = dbc.getConfig().getTableSchemaNames();
                IntStream.range(0, tableSchemaNames.size()).mapToObj(i -> i + " " + (String)tableSchemaNames.get(i)).forEach(System.out::println);
                break;
            }
            case SCHEME: {
                System.out.println(dbc.getScheme());
                break;
            }
            case CHECK: {
                dbc.checkTableDefinition(tableName);
                break;
            }
            case DEFAULT_CONFIG: {
                System.out.println(new String(dbc.getEffectiveConfiguration()));
                break;
            }
            case DROP_TABLE: {
                CLI.dropTableInteractively(dbc, cmd.getOptionValue("dt"));
                break;
            }
        }
        if (error) {
            System.exit(1);
        }
        time = System.currentTimeMillis() - time;
        LOG.info(String.format("Processing took %d seconds.", time / 1000L));
    }

    public static String findConfigurationFile() {
        File workingDirectory = new File(".");
        HashSet<String> possibleConfigFileNames = new HashSet<String>(Arrays.asList(USER_SCHEME_DEFINITION));
        for (String file : workingDirectory.list()) {
            if (!possibleConfigFileNames.contains(file.toLowerCase())) continue;
            return file;
        }
        return "<none found>";
    }

    private static void dropTableInteractively(DataBaseConnector dbc, String tableName) {
        try {
            if (!dbc.tableExists(tableName)) {
                if (tableName.contains(".")) {
                    System.err.println("Table \"" + tableName + "\" does not exist in database " + dbc.getDbURL() + ".");
                } else {
                    System.err.println("Table \"" + tableName + "\" does not exist in database " + dbc.getDbURL() + " in active schema " + dbc.getActivePGSchema() + ".");
                }
                return;
            }
            String unqualifiedTableName = tableName.contains(".") ? tableName.substring(tableName.indexOf(".") + 1) : tableName;
            String schema = tableName.contains(".") ? tableName.substring(0, tableName.indexOf(".")) : dbc.getActivePGSchema();
            System.out.println("Found table \"" + unqualifiedTableName + "\" in schema " + schema + " in database " + dbc.getDbURL() + ". Do you really want to drop it (y/n)?");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String response = in.readLine().toLowerCase();
            while (!(response.equals("y") || response.equals("yes") || response.equals("n") || response.equals("no"))) {
                System.out.println("Please specify y(es) or n(o).");
                response = in.readLine().toLowerCase();
            }
            if (response.startsWith("y")) {
                System.out.println("Dropping table \"" + unqualifiedTableName + "\" in Postgres schema \"" + schema + "\" of database " + dbc.getDbURL());
                dbc.dropTable(String.join((CharSequence)".", schema, unqualifiedTableName));
            } else {
                System.out.println("User canceled. Aborting process.");
            }
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
    }

    private static String getYesNoAnswer(String question) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String input = "";
        try {
            while (!input.equals("yes") && !input.equals("no")) {
                System.out.println(question);
                input = br.readLine();
            }
        }
        catch (IOException e) {
            LOG.error("Something went wrong while reading from STDIN: ", (Throwable)e);
            System.exit(1);
        }
        return input;
    }

    private static boolean doStatus(DataBaseConnector dbc, String subsetTableName) {
        boolean error = false;
        try {
            if (subsetTableName == null) {
                LOG.error("You must provide the name of a subset table to display its status.");
                error = true;
            } else {
                SubsetStatus status = dbc.status(subsetTableName, EnumSet.allOf(DataBaseConnector.StatusElement.class));
                System.out.println(status);
            }
        }
        catch (TableSchemaDoesNotExistException e) {
            LOG.error(e.getMessage());
            error = true;
        }
        catch (TableNotFoundException e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
        return error;
    }

    private static boolean doSubset(DataBaseConnector dbc, String subsetTableName, String fileStr, String queryStr, String superTableName, String subsetJournalFileName, String subsetQuery, boolean mirrorSubset, String whereClause, boolean all4Subset, String randomSubsetSize, Integer numberRefHops, String comment) throws SQLException {
        boolean error = false;
        ArrayList<String> ids = null;
        String condition = null;
        error = CLI.checkSchema(dbc, subsetTableName);
        if (!error) {
            if (subsetJournalFileName != null) {
                try {
                    ids = CLI.asList(subsetJournalFileName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (ids.size() == 0) {
                    LOG.error(subsetJournalFileName + " is empty.");
                    error = true;
                }
                StringBuilder sb = new StringBuilder();
                for (String id : ids) {
                    sb.append(", ").append(id);
                }
                condition = "nlm_id";
                comment = "Subset created " + new Date().toString() + " by matching with " + superTableName + " on " + condition + ": " + sb.substring(2);
            } else if (subsetQuery != null) {
                CLI.logMessage("Querying PubMed for: " + subsetQuery);
                ids = QueryPubMed.query(subsetQuery);
                if (ids.size() == 0) {
                    LOG.error("No results for your query.");
                    error = true;
                } else {
                    LOG.info("PubMed delivered " + ids.size() + " results.");
                }
                condition = "pmid";
                comment = "Subset created " + new Date().toString() + " by matching with " + superTableName + " on PubMed-query: " + subsetQuery;
            } else if (all4Subset) {
                CLI.logMessage("Creating subset by matching all entries from table " + superTableName + ".");
                comment = "Subset created " + new Date().toString() + " by matching with " + superTableName;
            } else if (whereClause != null) {
                comment = "Subset created " + new Date().toString() + " by selecting rows from " + superTableName + " with where clause \"" + whereClause + "\"";
            } else if (randomSubsetSize != null) {
                try {
                    new Integer(randomSubsetSize);
                    comment = "Subset created " + new Date().toString() + " by randomly selecting " + randomSubsetSize + " rows from " + superTableName + ".";
                }
                catch (NumberFormatException e) {
                    LOG.error(randomSubsetSize + " is not a number!");
                    error = true;
                }
            } else if (fileStr != null) {
                try {
                    ids = CLI.asList(fileStr);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (ids.size() == 0) {
                    LOG.error(fileStr + " is empty.");
                    error = true;
                }
                condition = dbc.getFieldConfiguration(dbc.getActiveTableSchema()).getPrimaryKey()[0];
                comment = "Subset created " + new Date().toString() + " by matching with " + superTableName + " on " + ids.size() + " " + condition + "s;";
            } else if (mirrorSubset) {
                comment = "Subset created " + new Date().toString() + " as to mirror " + superTableName + ";";
            } else {
                error = true;
                LOG.error("You must choose a way to define the subset.");
            }
            comment = CLI.escapeSingleQuotes(comment);
        }
        if (!dbc.tableExists(superTableName)) {
            CLI.logMessage("Checking whether super table " + superTableName + " exists...");
            LOG.error("Table " + superTableName + " doesn't exist!");
            error = true;
        }
        if (!error) {
            if (!dbc.tableExists(subsetTableName)) {
                CLI.logMessage("No table with the name \"" + subsetTableName + "\" exists, creating new subset table...");
                dbc.createSubsetTable(subsetTableName, superTableName, numberRefHops, comment);
                CLI.logMessage("Created table " + subsetTableName);
            } else {
                LOG.error("Table " + subsetTableName + " allready exists.");
            }
            if (dbc.isEmpty(subsetTableName) && !error) {
                if (all4Subset) {
                    dbc.initSubset(subsetTableName, superTableName);
                } else if (whereClause != null) {
                    dbc.initSubsetWithWhereClause(subsetTableName, superTableName, whereClause);
                } else if (ids != null && ids.size() > 0) {
                    dbc.initSubset(ids, subsetTableName, superTableName, condition);
                } else if (mirrorSubset) {
                    dbc.initMirrorSubset(subsetTableName, superTableName, true);
                } else if (randomSubsetSize != null) {
                    dbc.initRandomSubset(new Integer(randomSubsetSize), subsetTableName, superTableName);
                }
                CLI.logMessage("Subset defined.");
            } else {
                LOG.error(subsetTableName + " is not empty, please use another table.");
                error = true;
            }
        }
        return error;
    }

    private static boolean doImportOrUpdate(DataBaseConnector dbc, String fileStr, String queryStr, String superTableName, String comment, boolean updateMode) throws SQLException {
        boolean error = false;
        if (fileStr != null) {
            if (!dbc.tableExists(superTableName)) {
                error = CLI.checkSchema(dbc, superTableName);
                comment = "Data table created " + new Date().toString() + " by importing data from path " + fileStr;
                if (!error) {
                    dbc.createTable(superTableName, comment);
                    CLI.logMessage("Created table " + superTableName);
                }
            }
            if (dbc.isEmpty(superTableName) && !updateMode) {
                dbc.importFromXMLFile(fileStr, superTableName);
            } else {
                CLI.logMessage("Table is not empty or update mode was explicitly specified, processing Updates.");
                dbc.updateFromXML(fileStr, superTableName);
                CLI.logMessage("Updates finished.");
            }
        } else {
            LOG.error("You must specify a file or directory to retrieve XML files from.");
            error = true;
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doQuery(DataBaseConnector dbc, QueryOptions qo) {
        boolean createDirectory;
        boolean error = false;
        String queryStr = qo.queryStr;
        String fileStr = qo.fileStr;
        String tableName = qo.tableName;
        String tableSchema = qo.tableSchema;
        boolean useDelimiter = qo.useDelimiter;
        boolean pubmedArticleSet = qo.pubmedArticleSet;
        String xpath = qo.xpath;
        String baseOutFile = qo.baseOutDirStr;
        String batchSizeStr = qo.batchSizeStr;
        String limitStr = qo.limitStr;
        Integer numberRefHops = qo.numberRefHops;
        File outfile = null;
        int batchSize = 0;
        BufferedWriter bw = null;
        boolean keysExplicitlyGiven = fileStr != null || queryStr != null;
        long limit = limitStr != null ? (long)Integer.parseInt(limitStr) : -1L;
        boolean bl = createDirectory = baseOutFile != null && !pubmedArticleSet;
        if (verbose) {
            CLI.logMessage("Creating " + (createDirectory ? "directory" : "file") + " " + baseOutFile + " to write query results to.");
        }
        if (createDirectory) {
            outfile = new File(baseOutFile);
            if (!outfile.exists()) {
                CLI.logMessage("Directory " + outfile.getAbsolutePath() + " does not exist and will be created (as well as sub dircetories for file batches if required).");
                outfile.mkdir();
            }
            CLI.logMessage("Writing queried documents to " + outfile.getAbsolutePath());
            if (batchSizeStr != null) {
                try {
                    batchSize = Integer.parseInt(batchSizeStr);
                    CLI.logMessage("Dividing query result files in batches of " + batchSize);
                    if (batchSize < 1) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    LOG.error("Error parsing \"{}\" into an integer. Please deliver a positive numeric value for the batch size of files.");
                }
            }
        }
        if (!error) {
            List<Object> keys = new ArrayList();
            if (fileStr != null) {
                try {
                    keys = CLI.asListOfArrays(fileStr);
                }
                catch (IOException e1) {
                    LOG.error("Could not open '" + new File(fileStr).getAbsolutePath() + "'.");
                    error = true;
                }
            }
            if (queryStr != null) {
                for (String pmid : queryStr.split(",")) {
                    keys.add(pmid.split(KEY_PART_SEPERATOR));
                }
            }
            try {
                if (!error) {
                    DBCIterator<byte[][]> it = null;
                    if (!keysExplicitlyGiven) {
                        it = dbc.querySubset(tableName, qo.whereClause, limit, numberRefHops, tableSchema);
                    } else if (keys.size() > 0) {
                        it = dbc.retrieveColumnsByTableSchema(keys, tableName, tableSchema);
                    } else {
                        throw new IllegalStateException("No query keys have been explicitly given (e.g. in a file) nor should the whole table be queried.");
                    }
                    int i = 0;
                    int batchNumber = -1;
                    File outDir = outfile;
                    if (pubmedArticleSet) {
                        if (null != baseOutFile) {
                            CLI.logMessage("Creating a single file with a PubmedArticleSet and writing it to " + baseOutFile);
                            bw = new BufferedWriter(new FileWriter(baseOutFile));
                        }
                        CLI.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE PubmedArticleSet SYSTEM \"http://dtd.nlm.nih.gov/ncbi/pubmed/out/pubmed_170101.dtd\">\n<PubmedArticleSet>", bw);
                    }
                    while (it.hasNext()) {
                        byte[][] idAndXML = (byte[][])it.next();
                        if (outfile != null) {
                            if (batchSize > 0 && i % batchSize == 0) {
                                String subDirectoryName = ++batchNumber > -1 && batchSize > 0 ? Integer.toString(batchNumber) : "";
                                String subDirPath = outfile.getAbsolutePath() + FILE_SEPERATOR + subDirectoryName;
                                outDir = new File(subDirPath);
                                outDir.mkdir();
                            }
                            String filename = new String(idAndXML[0]);
                            if (!pubmedArticleSet) {
                                if (bw != null) {
                                    bw.close();
                                }
                                bw = new BufferedWriter(new FileWriter(outDir + FILE_SEPERATOR + filename));
                            }
                        }
                        if (xpath == null) {
                            StringBuilder sb = new StringBuilder();
                            if (pubmedArticleSet) {
                                sb.append("<PubmedArticle>\n");
                            }
                            sb.append(new String(idAndXML[1], "UTF-8"));
                            if (pubmedArticleSet) {
                                sb.append("\n</PubmedArticle>");
                            }
                            CLI.print(sb.toString(), bw);
                        } else {
                            String[][] values;
                            String[][] stringArray = values = CLI.getXpathValues(idAndXML[1], xpath);
                            int n = stringArray.length;
                            for (int j = 0; j < n; ++j) {
                                String[] valuesOfXpath;
                                for (String singleValue : valuesOfXpath = stringArray[j]) {
                                    CLI.print(singleValue, bw);
                                }
                            }
                        }
                        if (useDelimiter) {
                            System.out.println(DELIMITER);
                        }
                        ++i;
                    }
                    if (pubmedArticleSet) {
                        CLI.print("</PubmedArticleSet>", bw);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return error;
    }

    private static void print(String string, BufferedWriter bw) throws IOException {
        if (bw == null) {
            System.out.println(string);
        } else {
            bw.write(string + "\n");
        }
    }

    private static String[][] getXpathValues(byte[] next, String xpaths) {
        String[] xpathArray = xpaths.split(",");
        ArrayList fields = new ArrayList();
        for (String xpath : xpathArray) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("name", xpath);
            field.put("xpath", xpath);
            field.put("returnXMLFragment", "true");
            field.put("returnValuesAsArray", "true");
            fields.add(field);
        }
        String[][] retStrings = new String[xpathArray.length][];
        Iterator it = JulieXMLTools.constructRowIterator((byte[])next, (int)1024, (String)".", fields, (String)"your result");
        if (it.hasNext()) {
            Map row = (Map)it.next();
            for (int i = 0; i < xpathArray.length; ++i) {
                String[] values = (String[])row.get(xpathArray[i]);
                if (values == null) {
                    values = new String[]{"XPath " + xpaths + " does not exist in this document."};
                }
                retStrings[i] = values;
            }
            if (it.hasNext()) {
                LOG.warn("There are more results for the XPath {} then expected and not all have been returned. Please contact a developer for help.", (Object)xpaths);
            }
        }
        return retStrings;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(160);
        formatter.printHelp(CLI.class.getName(), options);
    }

    private static Options getOptions() {
        Options options = new Options();
        OptionGroup modes = new OptionGroup();
        modes.addOption(CLI.buildOption("i", "import", "Import data into the _data table", "file/dir to import"));
        modes.addOption(CLI.buildOption("u", "update", "Update _data table", "file/dir to update from"));
        modes.addOption(CLI.buildOption("s", "subset", "Define a subset table; use -f, -o, -a, -m, -w or -r to specify the subsets source.", "name of the new subset table"));
        modes.addOption(CLI.buildOption("re", "reset", "Resets a subset table to a not-yet-processed state. Flags:\n-np only reset non-processed items\n-ne only reset items without errors\n-lc to reset only those items with the given last component\n-f a partial reset can be achieved by specifying a file containing one primary key value for each document to be resetted", "subset table name"));
        modes.addOption(CLI.buildOption("st", "status", "Show the processing status of a subset table.", "subset table name"));
        OptionBuilder.withLongOpt((String)"query");
        OptionBuilder.withDescription((String)"Query a table (default: _data._data) for XMLs. You can enter the primary keys directly or use -f to specify a file. If you define none of both, the whole table will be returned.\nUse -d to display delimiters between the results.\nUse -z to specify the target table. If the table is a subset, only documents in this subset will be returned.\nUse -l to set a limit of returned documents.\nUse -x to specify an XPath expression go extract specific parts of the queried XML documents.\nUse -out to save the query results to file.");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"your query");
        modes.addOption(OptionBuilder.create((String)"q"));
        modes.addOption(CLI.buildOption("h", "help", "Displays all possible parameters.", new String[0]));
        modes.addOption(CLI.buildOption("t", "tables", "Displays all tables in the active scheme.", new String[0]));
        modes.addOption(CLI.buildOption("td", "tabledefinition", "Displays the columns of a table.", "the table"));
        modes.addOption(CLI.buildOption("ds", "displayscheme", "Displays the active scheme.", new String[0]));
        modes.addOption(CLI.buildOption("ch", "check", "Checks if a table confirms to its definition (for subsets: only primary keys!)", "table"));
        modes.addOption(CLI.buildOption("dc", "defaultconfig", "Prints the defaultConfiguration.", new String[0]));
        modes.addOption(CLI.buildOption("dt", "droptable", "Drops the given table.", "table"));
        modes.addOption(CLI.buildOption("lts", "listtableschemas", "Displays all table schema names in the configuration. The showed name index can be used as value for the -ts option.", new String[0]));
        modes.setRequired(true);
        options.addOptionGroup(modes);
        OptionGroup exclusive = new OptionGroup();
        exclusive.addOption(CLI.buildOption("f", "file", "Set the file used for query, subset creation or partial subset reset.", "file"));
        exclusive.addOption(CLI.buildOption("o", "online", "Defines the subset by a PubMed query - remember to wrap it in double quotation marks!", "query"));
        exclusive.addOption(CLI.buildOption("a", "all", "Use all entries of the _data table for the subset.", new String[0]));
        exclusive.addOption(CLI.buildOption("r", "random", "Generates a random subset, you must provide its size as a parameter. Often used with -z.", "size"));
        exclusive.addOption(CLI.buildOption("m", "mirror", "Creates a subset table which mirrors the database table. I.e. when the data table gets new records, the mirror subset(s) will be updated accordingly.", new String[0]));
        exclusive.addOption(CLI.buildOption("w", "where", "Uses a SQL WHERE clause during subset definition.", "condition"));
        exclusive.addOption(CLI.buildOption("j", "journals", "Define a subset by providing a file with journal names.", "file"));
        exclusive.addOption(CLI.buildOption("l", "limit", "For use with -q. Restricts the number of documents returned.", "limit"));
        options.addOption(CLI.buildOption("np", "not processed", "Flag for -re(set) mode to restrict to non-processed table rows. May be combined with -ne, -lc.", new String[0]));
        options.addOption(CLI.buildOption("ne", "no errors", "Flag for -re(set) mode to restrict to table rows without errors. May be combined with -np, -lc.", new String[0]));
        options.addOption(CLI.buildOption("lc", "last component", "Option for -re(set) mode to restrict to table rows to a given last component identifier. May be combined with -np, -ne.", "component name"));
        options.addOptionGroup(exclusive);
        options.addOption(CLI.buildOption("z", "superset", "Provides a superset name for definition of a subset or the name of a data table.", "name of the superset table"));
        options.addOption(CLI.buildOption("v", "verbose", "Activate verbose informational ouput of the tool's actions", new String[0]));
        options.addOption(CLI.buildOption("d", "delimiter", "Display a line of \"-\" as delimiter between the results.", new String[0]));
        options.addOption(CLI.buildOption("pas", "pubmedarticleset", "For use with -q. The queried documents will be interpreted as Medline XML documents and will be enclosed in PubmedArticleSet.", new String[0]));
        options.addOption(CLI.buildOption("out", "out", "The file or directory where query results are written to. By default, a directory will be created and it will be filled with one file per document. The files will have the name of their database primary key. Modifying parameters:\nUse -bs to create subdirectories for batches of files.\nUse -pas to create no directory but a single XML file representing a PubmedArticleSet. This assumes that the queried documents are Medline or Pubmed XML documents.", "output directory"));
        options.addOption(CLI.buildOption("bs", "batchsize", "The number of queried documents (by -q and -out) which should be written in one directory. Subdirectories will be created at need.", "batchsize"));
        options.addOption(CLI.buildOption("x", "xpath", "When querying documents using -q, you may specify one or more XPath expressions to restrict the output to the elements referenced by your XPath expressions. Several XPaths must be delimited by a single comma.", "xpath"));
        options.addOption(CLI.buildOption("rh", "referencehops", "The maximum number of allowed hops to tables referenced with a foreign key when creating subset tables.", "max number of hops"));
        options.addOption(CLI.buildOption("ts", "tableschema", "Table Schema to use; currently only supported by -q mode. The name can be given or the index as retrieved by the -lts mode.", "schemaname"));
        options.addOption(CLI.buildOption("U", "url", "URL to database server (e.g. jdbc:postgresql://<host name>/<db name>)", "url"));
        options.addOption(CLI.buildOption("n", "username", "username for database", "username"));
        options.addOption(CLI.buildOption("p", "pass", "password for database", "password"));
        options.addOption(CLI.buildOption("pgs", "pgschema", "Postgres Schema to use", "schema"));
        options.addOption(CLI.buildOption("srv", "server", "Server name to connect to", "servername"));
        options.addOption(CLI.buildOption("db", "database", "Database to connect to", "database"));
        options.addOption(CLI.buildOption("dbc", "databaseconfiguration", "XML file specifying the user configuration (defaults to dbcConfiguration.xml).", "Config File"));
        return options;
    }

    private static Option buildOption(String shortName, String longName, String description, String ... arguments) {
        OptionBuilder.withLongOpt((String)longName);
        OptionBuilder.withDescription((String)description);
        OptionBuilder.hasArgs((int)arguments.length);
        for (String argument : arguments) {
            OptionBuilder.withArgName((String)argument);
        }
        return OptionBuilder.create((String)shortName);
    }

    private static boolean checkSchema(DataBaseConnector dbc, String tableName) {
        boolean error = false;
        String[] tablePath = tableName.split("\\.");
        if (tablePath.length == 2 && !dbc.schemaExists(tablePath[0])) {
            dbc.createSchema(tablePath[0]);
        } else if (tablePath.length > 2) {
            LOG.error(String.format("The table path %s is invalid. Only table names of the form 'tablename' or 'schemaname.tablename'are accepted.", tableName));
        }
        return error;
    }

    private static String escapeSingleQuotes(String comment) {
        return comment.replaceAll("'", "\\\\'");
    }

    private static List<Object[]> asListOfArrays(String fileStr) throws IOException {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        File file = new File(fileStr);
        if (file != null) {
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line = br.readLine();
                while (line != null) {
                    list.add(line.split(KEY_PART_SEPERATOR));
                    line = br.readLine();
                }
            }
        }
        return list;
    }

    private static ArrayList<String> asList(String fileStr) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(fileStr);
        if (file != null) {
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line = br.readLine();
                while (line != null) {
                    list.add(line);
                    line = br.readLine();
                }
            }
        }
        return list;
    }

    private static enum Mode {
        IMPORT,
        QUERY,
        SUBSET,
        RESET,
        STATUS,
        ERROR,
        TABLES,
        LIST_TABLE_SCHEMAS,
        TABLE_DEFINITION,
        SCHEME,
        CHECK,
        DEFAULT_CONFIG,
        DROP_TABLE;

    }
}

