/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.dataBase;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import de.julielab.hiddenConfig.HiddenConfig;
import de.julielab.xml.JulieXMLConstants;
import de.julielab.xml.JulieXMLTools;
import de.julielab.xmlData.cli.TableNotFoundException;
import de.julielab.xmlData.config.ConfigReader;
import de.julielab.xmlData.config.DBConfig;
import de.julielab.xmlData.config.FieldConfig;
import de.julielab.xmlData.config.FieldConfigurationManager;
import de.julielab.xmlData.dataBase.DBCIterator;
import de.julielab.xmlData.dataBase.SubsetStatus;
import de.julielab.xmlData.dataBase.ThreadedColumnsIterator;
import de.julielab.xmlData.dataBase.ThreadedColumnsToRetrieveIterator;
import de.julielab.xmlData.dataBase.util.TableSchemaMismatchException;
import de.julielab.xmlData.dataBase.util.UnobtainableConnectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBaseConnector {
    public static final String DEFAULT_PIPELINE_STATE = "<none>";
    @Deprecated
    public static final int META_IN_ARRAY = 2;
    public static final LinkedHashMap<String, String> subsetColumns;
    private static final int DEFAULT_QUERY_BATCH_SIZE = 1000;
    private static final int BUFFER_SIZE = 1000;
    private static final String DEFAULT_FIELD = "xml";
    private static final String DEFAULT_TABLE = "_data._data";
    private static final int commitBatchSize = 100;
    private static final int RETRIEVE_MARK_LIMIT = 1000;
    private static final int ID_SUBLIST_SIZE = 1000;
    private static final Map<String, HikariDataSource> pools;
    private static Logger LOG;
    private static Thread commitThread;
    private FieldConfigurationManager fieldConfigs;
    private DBConfig dbConfig;
    private String activeDataSchema;
    private String activeDataTable;
    private String activeTableSchema;
    private byte[] effectiveConfiguration;
    private int queryBatchSize = 1000;
    private String dbURL;
    private String user;
    private String password;
    private DataSource dataSource;
    private ConfigReader config;

    public DataBaseConnector(String configPath) throws FileNotFoundException {
        this(DataBaseConnector.findConfigurationFile(configPath));
    }

    public DataBaseConnector(InputStream configStream) {
        this.config = new ConfigReader(configStream);
        this.dbConfig = this.config.getDatabaseConfig();
        this.dbURL = this.dbConfig.getUrl();
        this.fieldConfigs = this.config.getFieldConfigs();
        this.activeDataSchema = this.config.getActiveDataSchema();
        this.activeDataTable = this.config.getActiveDataTable().contains(".") ? this.config.getActiveDataTable() : this.activeDataSchema + "." + this.config.getActiveDataTable();
        this.activeTableSchema = this.config.getActiveSchemaName();
        this.effectiveConfiguration = this.config.getMergedConfigData();
        if (!StringUtils.isBlank(this.dbConfig.getActiveDatabase()) && (StringUtils.isBlank(this.user) || StringUtils.isBlank(this.password))) {
            HiddenConfig hc = new HiddenConfig();
            this.user = hc.getUsername(this.dbConfig.getActiveDatabase());
            this.password = hc.getPassword(this.dbConfig.getActiveDatabase());
            LOG.info("Connecting to " + this.dbURL + " as " + this.user);
        } else {
            LOG.warn("No active database configured in configuration file or configuration file is empty or does not exist.");
        }
    }

    public DataBaseConnector(InputStream configStream, int queryBatchSize) {
        this(configStream);
        this.queryBatchSize = queryBatchSize;
    }

    public DataBaseConnector(String dbUrl, String user, String password, String pgSchema, InputStream fieldDefinition) {
        this(dbUrl, user, password, pgSchema, 1000, fieldDefinition);
    }

    public DataBaseConnector(String serverName, String dbName, String user, String password, String pgSchema, InputStream fieldDefinition) {
        this(serverName, dbName, user, password, pgSchema, 1000, fieldDefinition);
    }

    public DataBaseConnector(String dbUrl, String user, String password, String pgSchema, int queryBatchSize, InputStream configStream) {
        this(configStream, queryBatchSize);
        this.setCredentials(dbUrl, user, password, pgSchema);
    }

    public DataBaseConnector(String serverName, String dbName, String user, String password, String pgSchema, int queryBatchSize, InputStream configStream) {
        this(configStream, queryBatchSize);
        String dbUrl = null;
        if (dbName != null && serverName != null) {
            dbUrl = "jdbc:postgresql://" + serverName + ":5432/" + dbName;
        } else {
            if (dbName != null) {
                dbUrl = this.dbConfig.getUrl().replaceFirst("/[^/]+$", "/" + dbName);
            }
            if (serverName != null) {
                dbUrl = this.dbConfig.getUrl().replaceFirst("(.*//)[^/:]+(.*)", "$1" + serverName + "$2");
            }
        }
        this.setCredentials(dbUrl, user, password, pgSchema);
    }

    public DataBaseConnector(String dbUrl, String user, String password) {
        this(dbUrl, user, password, null, 1000, null);
    }

    private static InputStream findConfigurationFile(String configPath) throws FileNotFoundException {
        InputStream is;
        LOG.debug("Loading DatabaseConnector configuration file from path \"{}\"", (Object)configPath);
        File dbcConfigFile = new File(configPath);
        if (dbcConfigFile.exists()) {
            LOG.debug("Found database configuration at file {}", (Object)dbcConfigFile);
            is = new FileInputStream(configPath);
        } else {
            String cpResource = configPath.startsWith("/") ? configPath : "/" + configPath;
            LOG.debug("The database configuration file could not be found as a file at {}. Trying to lookup configuration as a classpath resource at {}", (Object)dbcConfigFile, (Object)cpResource);
            is = DataBaseConnector.class.getResourceAsStream(cpResource);
            if (is != null) {
                LOG.debug("Found database configuration file as classpath resource at {}", (Object)cpResource);
            }
        }
        if (is == null) {
            throw new IllegalArgumentException("DatabaseConnector configuration " + configPath + " could not be found as file or a classpath resource.");
        }
        return is;
    }

    public ConfigReader getConfig() {
        return this.config;
    }

    private void setCredentials(String dbUrl, String user, String password, String pgSchema) {
        if (dbUrl != null) {
            this.dbURL = dbUrl;
        }
        if (user != null) {
            this.user = user;
        }
        if (password != null) {
            this.password = password;
        }
        if (pgSchema != null) {
            this.setActivePGSchema(pgSchema);
        }
        if (dbUrl != null || user != null || password != null || pgSchema != null) {
            LOG.info("Connecting to " + this.dbURL + " as " + this.user + " in Postgres Schema " + pgSchema);
        }
    }

    public void setHost(String host) {
        if (host != null) {
            this.dbURL = this.dbURL.replaceFirst("(.*//)[^/:]+(.*)", "$1" + host + "$2");
            LOG.debug("Setting database host to {}. DB URL is now {}", (Object)host, (Object)this.dbURL);
        }
    }

    public void setPort(String port) {
        this.setPort(Integer.parseInt(port));
    }

    public void setPort(Integer port) {
        if (port != null) {
            this.dbURL = this.dbURL.replaceFirst(":[0-9]+", ":" + port);
            LOG.debug("Setting database port to {}. DB URL is now {}", (Object)port, (Object)this.dbURL);
        }
    }

    public void setUser(String user) {
        this.user = user;
        LOG.debug("Setting database user for {} to {}", (Object)this.dbURL, (Object)user);
    }

    public void setPassword(String password) {
        this.password = password;
        LOG.debug("Changing database password.");
    }

    public Connection getConn() {
        Connection conn = null;
        if (null == this.dataSource) {
            LOG.debug("Setting up connection pool data source");
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setPoolName("costosys-" + System.nanoTime());
            hikariConfig.setJdbcUrl(this.dbURL);
            hikariConfig.setUsername(this.user);
            hikariConfig.setPassword(this.password);
            hikariConfig.setConnectionTestQuery("SELECT TRUE");
            hikariConfig.setMaximumPoolSize(this.dbConfig.getMaxConnections());
            hikariConfig.setRegisterMbeans(true);
            HikariDataSource ds = pools.compute(this.dbURL, (url, source) -> source == null ? new HikariDataSource(hikariConfig) : source);
            if (ds.isClosed()) {
                ds = new HikariDataSource(hikariConfig);
            }
            pools.put(this.dbURL, ds);
            this.dataSource = ds;
        }
        try {
            int retries = 0;
            do {
                try {
                    LOG.trace("Waiting for SQL connection to become free...");
                    if (LOG.isTraceEnabled()) {
                        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                        try {
                            String poolNameStr = ((HikariDataSource)this.dataSource).getPoolName();
                            ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + poolNameStr + ")");
                            HikariPoolMXBean poolProxy = JMX.newMXBeanProxy(mBeanServer, poolName, HikariPoolMXBean.class);
                            int totalConnections = poolProxy.getTotalConnections();
                            int idleConnections = poolProxy.getIdleConnections();
                            int activeConnections = poolProxy.getActiveConnections();
                            int threadsAwaitingConnection = poolProxy.getThreadsAwaitingConnection();
                            LOG.trace("Pool {} has {} total connections", (Object)poolName, (Object)totalConnections);
                            LOG.trace("Pool {} has {} idle connections left", (Object)poolName, (Object)idleConnections);
                            LOG.trace("Pool {} has {} active connections", (Object)poolName, (Object)activeConnections);
                            LOG.trace("Pool {} has {} threads awaiting a connection", (Object)poolName, (Object)threadsAwaitingConnection);
                        }
                        catch (MalformedObjectNameException e) {
                            e.printStackTrace();
                        }
                    }
                    conn = this.dataSource.getConnection();
                    LOG.trace("SQL connection obtained.");
                    Statement stm = conn.createStatement();
                    if (!this.schemaExists(this.dbConfig.getActivePGSchema(), conn)) {
                        this.createSchema(this.dbConfig.getActivePGSchema(), conn);
                    }
                    if (!this.schemaExists(this.dbConfig.getActiveDataPGSchema(), conn)) {
                        this.createSchema(this.dbConfig.getActiveDataPGSchema(), conn);
                    }
                    stm.execute(String.format("SET search_path TO %s", this.dbConfig.getActivePGSchema()));
                    stm.close();
                }
                catch (SQLException e) {
                    LOG.warn("Could not obtain a database connection within the timeout. Trying again. Number of try: {}", (Object)(++retries));
                    MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                    try {
                        String poolNameStr = ((HikariDataSource)this.dataSource).getPoolName();
                        ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + poolNameStr + ")");
                        HikariPoolMXBean poolProxy = JMX.newMXBeanProxy(mBeanServer, poolName, HikariPoolMXBean.class);
                        int totalConnections = poolProxy.getTotalConnections();
                        int idleConnections = poolProxy.getIdleConnections();
                        int activeConnections = poolProxy.getActiveConnections();
                        int threadsAwaitingConnection = poolProxy.getThreadsAwaitingConnection();
                        LOG.warn("Pool {} has {} total connections", (Object)poolName, (Object)totalConnections);
                        LOG.warn("Pool {} has {} idle connections left", (Object)poolName, (Object)idleConnections);
                        LOG.warn("Pool {} has {} active connections", (Object)poolName, (Object)activeConnections);
                        LOG.warn("Pool {} has {} threads awaiting a connection", (Object)poolName, (Object)threadsAwaitingConnection);
                    }
                    catch (MalformedObjectNameException e1) {
                        e1.printStackTrace();
                    }
                    if (retries != 900) continue;
                    throw e;
                }
            } while (conn == null);
            if (retries > 0) {
                LOG.warn("It took {} retries to obtain a connection", (Object)retries);
            }
        }
        catch (SQLException e) {
            LOG.error("Could not connect with " + this.dbURL);
            throw new UnobtainableConnectionException("No database connection could be obtained from the connection pool. This can have one of two causes: Firstly, the application might just use all connections concurrently. Then, a higher number of maximum active database connections in the CoStoSys configuration might help. This number is currently set to " + this.config.getDatabaseConfig().getMaxConnections() + ". The other possibility are programming errors where connections are retrieved but not closed. Closing connections means to return them to the pool. It must always be made sure that connections are closed when they are no longer required. If database iterators are used. i.e. subclasses of DBCIterator, make sure to fully read the iterators. Otherwise, they might keep a permanent connection to the database while waiting to be consumed.", e);
        }
        return conn;
    }

    public String getActiveDataTable() {
        return this.activeDataTable;
    }

    public byte[] getEffectiveConfiguration() {
        return this.effectiveConfiguration;
    }

    public String getActiveDataPGSchema() {
        return this.activeDataSchema;
    }

    public String getActivePGSchema() {
        return this.dbConfig.getActivePGSchema();
    }

    public void setActivePGSchema(String pgSchema) {
        this.dbConfig.setActivePGSchema(pgSchema);
    }

    public String getActiveTableSchema() {
        return this.activeTableSchema;
    }

    public void setActiveTableSchema(String schemaName) {
        this.activeTableSchema = schemaName;
    }

    public FieldConfig getActiveTableFieldConfiguration() {
        return this.fieldConfigs.get(this.activeTableSchema);
    }

    public List<Object[]> retrieveAndMark(String subsetTableName, String readerComponent, String hostName, String pid) throws TableSchemaMismatchException {
        return this.retrieveAndMark(subsetTableName, readerComponent, hostName, pid, 1000, null);
    }

    public List<Object[]> retrieveAndMark(String subsetTableName, String readerComponent, String hostName, String pid, int limit, String order) throws TableSchemaMismatchException {
        return this.retrieveAndMark(subsetTableName, this.activeTableSchema, readerComponent, hostName, pid, limit, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> retrieveAndMark(String subsetTableName, String schemaName, String readerComponent, String hostName, String pid, int limit, String order) throws TableSchemaMismatchException {
        this.checkTableDefinition(subsetTableName, schemaName);
        ArrayList<Object[]> ids = new ArrayList<Object[]>(limit);
        String sql = null;
        Connection conn = null;
        boolean idsRetrieved = false;
        while (!idsRetrieved) {
            try {
                String orderCommand;
                FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
                conn = this.getConn();
                conn.setAutoCommit(false);
                Statement st = conn.createStatement();
                String string = orderCommand = order == null ? "" : order;
                if (!orderCommand.equals("") && !orderCommand.trim().toUpperCase().startsWith("ORDER BY")) {
                    orderCommand = "ORDER BY " + orderCommand;
                }
                String joinStatement = Stream.of(fieldConfig.getPrimaryKey()).map(pk -> "t." + pk + "=subquery." + pk).collect(Collectors.joining(" AND "));
                String returnColumns = Stream.of(fieldConfig.getPrimaryKey()).map(pk -> "t." + pk).collect(Collectors.joining(","));
                sql = "UPDATE " + subsetTableName + " AS t SET " + "is_in_process" + " = TRUE, " + "last_component" + " = '" + readerComponent + "', " + "host_name" + " = '" + hostName + "', " + "pid" + " = '" + pid + "'," + "processing_timestamp" + " = 'now' FROM (SELECT " + fieldConfig.getPrimaryKeyString() + " FROM " + subsetTableName + " WHERE " + "is_in_process" + " = FALSE AND " + "is_processed" + " = FALSE " + orderCommand + " LIMIT " + limit + " FOR UPDATE SKIP LOCKED) AS subquery WHERE " + joinStatement + " RETURNING " + returnColumns;
                try (ResultSet res = st.executeQuery(sql);){
                    String[] pks = fieldConfig.getPrimaryKey();
                    while (res.next()) {
                        String[] values = new String[pks.length];
                        for (int i = 0; i < pks.length; ++i) {
                            values[i] = res.getObject(i + 1);
                        }
                        ids.add(values);
                    }
                    idsRetrieved = true;
                }
                conn.commit();
            }
            catch (SQLException e) {
                if (!(e.getMessage().contains("deadlock detected") || e.getNextException() != null && e.getNextException().getMessage().contains("deadlock detected"))) {
                    LOG.error("Error while retrieving document IDs and marking them to be in process. Sent SQL command: {}.", (Object)sql, (Object)e);
                    SQLException nextException = e.getNextException();
                    if (null == nextException) break;
                    LOG.error("Next exception: {}", nextException);
                    break;
                }
                LOG.debug("Database deadlock has been detected while trying to retrieve document IDs and marking them to be processed. Tying again.");
                try {
                    conn.commit();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("The following IDs were retrieved from table {}: {}", (Object)subsetTableName, (Object)ids.stream().map(Arrays::toString).collect(Collectors.joining("; ")));
        }
        return ids;
    }

    public int countUnprocessed(String subsetTableName) {
        return this.countUnprocessed(subsetTableName, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countUnprocessed(String subsetTableName, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        int rows = 0;
        Connection conn = this.getConn();
        try {
            ResultSet res = conn.createStatement().executeQuery("SELECT count(" + fieldConfig.getPrimaryKey()[0] + ") FROM " + subsetTableName + " WHERE " + "is_processed" + " = FALSE;");
            if (res.next()) {
                rows = res.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rows;
    }

    public int countRowsOfDataTable(String tableName, String whereCondition) {
        return this.countRowsOfDataTable(tableName, whereCondition, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countRowsOfDataTable(String tableName, String whereCondition, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        int rows = 0;
        Connection conn = this.getConn();
        try {
            whereCondition = whereCondition != null ? (!(whereCondition = whereCondition.trim()).toUpperCase().startsWith("WHERE") ? " WHERE " + whereCondition : " " + whereCondition) : "";
            ResultSet res = conn.createStatement().executeQuery("SELECT count(" + fieldConfig.getPrimaryKeyString() + ") FROM " + tableName + whereCondition);
            if (res.next()) {
                rows = res.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rows;
    }

    public boolean hasUnfetchedRows(String tableName) {
        return this.hasUnfetchedRows(tableName, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnfetchedRows(String tableName, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        Connection conn = this.getConn();
        try {
            ResultSet res = conn.createStatement().executeQuery("SELECT " + fieldConfig.getPrimaryKeyString() + " FROM " + tableName + " WHERE " + "is_in_process" + " = FALSE AND " + "is_processed" + " = FALSE LIMIT 1");
            boolean bl = res.next();
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void deleteFromTable(String table, List<Object[]> ids) {
        String sql = "DELETE FROM " + table + " WHERE ";
        this.modifyTable(sql, ids);
    }

    public <T> void deleteFromTableSimplePK(String table, List<T> ids) {
        String sql = "DELETE FROM " + table + " WHERE ";
        ArrayList<Object[]> objectIds = new ArrayList<Object[]>(ids.size());
        for (T id : ids) {
            objectIds.add(new Object[]{id});
        }
        this.modifyTable(sql, objectIds);
    }

    public void markAsProcessed(String table, List<Object[]> ids) {
        String sql = "UPDATE " + table + " SET " + "is_processed" + " = TRUE WHERE ";
        this.modifyTable(sql, ids);
    }

    public void modifyTable(String sql, List<Object[]> ids) {
        this.modifyTable(sql, ids, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyTable(String sql, List<Object[]> ids, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        Connection conn = this.getConn();
        String where = StringUtils.join((Object[])fieldConfig.expandPKNames("%s = ?"), " AND ");
        String fullSQL = sql + where;
        PreparedStatement ps = null;
        try {
            conn.setAutoCommit(false);
            ps = conn.prepareStatement(fullSQL);
        }
        catch (SQLException e) {
            LOG.error("Couldn't prepare: " + fullSQL);
            e.printStackTrace();
        }
        String[] pks = fieldConfig.getPrimaryKey();
        for (Object[] id : ids) {
            for (int i = 0; i < id.length; ++i) {
                try {
                    this.setPreparedStatementParameterWithType(i + 1, ps, id[i], pks[i], fieldConfig);
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                ps.addBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            ps.executeBatch();
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void setPreparedStatementParameterWithType(int position, PreparedStatement ps, Object value, String fieldName, FieldConfig fieldConfig) throws SQLException {
        ps.setObject(position, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReferencedTable(String referencingTable) {
        if (referencingTable == null) {
            throw new IllegalArgumentException("Name of referencing table may not be null.");
        }
        String referencedTable = null;
        Connection conn = this.getConn();
        try {
            ResultSet imported;
            String pgSchema = this.dbConfig.getActivePGSchema();
            String tableName = referencingTable;
            if (referencingTable.contains(".")) {
                pgSchema = referencingTable.replaceFirst("\\..*$", "");
                tableName = referencingTable.substring(referencingTable.indexOf(46) + 1);
            }
            if ((imported = conn.getMetaData().getImportedKeys("", pgSchema, tableName.toLowerCase())).next()) {
                String pkTableSchema = imported.getString(2);
                String pkTableName = imported.getString(3);
                referencedTable = pkTableSchema != null ? pkTableSchema + "." + pkTableName : pkTableName;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return referencedTable;
    }

    private void createSchema(String schemaName, Connection conn) {
        String sqlStr = "CREATE SCHEMA " + schemaName;
        try {
            conn.createStatement().execute(sqlStr);
            LOG.info("PostgreSQL schema \"{}\" does not exist, it is being created.", (Object)schemaName);
        }
        catch (SQLException e) {
            LOG.error(sqlStr);
            e.printStackTrace();
        }
    }

    public void createSchema(String schemaName) {
        Connection conn = this.getConn();
        this.createSchema(schemaName, conn);
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createTable(String tableName, String comment) throws SQLException {
        this.createTable(tableName, this.activeTableSchema, comment);
    }

    public void createTable(String tableName, String schemaName, String comment) throws SQLException {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        ArrayList<String> columns = this.getTableCreationColumns(tableName, fieldConfig);
        this.createTable(tableName, columns, comment);
        if (fieldConfig.getPrimaryKey().length > 0) {
            this.alterTable(String.format("ADD CONSTRAINT %s_unique UNIQUE (%s)", tableName.replace(".", ""), fieldConfig.getPrimaryKeyString()), tableName);
        }
    }

    public void createTable(String tableName, String referenceTableName, String schemaName, String comment) throws SQLException {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        ArrayList<String> columns = this.getTableCreationColumns(tableName, fieldConfig);
        columns.add(String.format("CONSTRAINT %s_fkey FOREIGN KEY (%s) REFERENCES %s ON DELETE CASCADE", tableName.replace(".", ""), fieldConfig.getPrimaryKeyString(), referenceTableName));
        this.createTable(tableName, columns, comment);
        if (fieldConfig.getPrimaryKey().length > 0) {
            this.alterTable(String.format("ADD CONSTRAINT %s_unique UNIQUE (%s)", tableName.replace(".", ""), fieldConfig.getPrimaryKeyString()), tableName);
        }
    }

    private ArrayList<String> getTableCreationColumns(String tableName, FieldConfig fieldConfig) {
        ArrayList<String> columns = new ArrayList<String>();
        for (Map<String, String> field : fieldConfig.getFields()) {
            StringBuilder columnStrBuilder = new StringBuilder();
            columnStrBuilder.append(field.get("name"));
            columnStrBuilder.append(" ");
            columnStrBuilder.append(field.get("type"));
            columns.add(columnStrBuilder.toString());
        }
        if (fieldConfig.getPrimaryKey().length > 0) {
            columns.add(String.format("CONSTRAINT %s_pkey PRIMARY KEY (%s)", tableName.replace(".", ""), fieldConfig.getPrimaryKeyString()));
        }
        return columns;
    }

    private void createTable(String tableName, List<String> columns, String comment) throws SQLException {
        Connection conn = this.getConn();
        StringBuilder sb = new StringBuilder("CREATE TABLE " + tableName + " (");
        for (String column : columns) {
            sb.append(", " + column);
        }
        sb.append(");");
        String sqlString = sb.toString().replaceFirst(", ", "");
        try {
            Statement st = conn.createStatement();
            st.execute(sqlString);
            st.execute("COMMENT ON TABLE " + tableName + " IS '" + comment + "';");
        }
        catch (SQLException e) {
            System.err.println(sqlString);
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void createSubsetTable(String subsetTable, String supersetTable, Integer maxNumberRefHops, String comment) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, maxNumberRefHops, comment, this.activeTableSchema);
    }

    public void createSubsetTable(String subsetTable, String supersetTable, String comment) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, null, comment, this.activeTableSchema);
    }

    public void createSubsetTable(String subsetTable, String supersetTable, Integer posOfDataTable, String comment, String schemaName) throws SQLException {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        String effectiveDataTable = this.getReferencedTable(supersetTable, posOfDataTable);
        ArrayList<String> columns = new ArrayList<String>();
        List<Map<String, String>> fields = fieldConfig.getFields();
        HashSet<String> pks = new HashSet<String>(Arrays.asList(fieldConfig.getPrimaryKey()));
        for (Map<String, String> map : fields) {
            String name = map.get("name");
            if (!pks.contains(name)) continue;
            columns.add(name + " " + map.get("type"));
        }
        for (Map.Entry entry : subsetColumns.entrySet()) {
            columns.add((String)entry.getKey() + " " + (String)entry.getValue());
        }
        String pkStr = fieldConfig.getPrimaryKeyString();
        columns.add(String.format("CONSTRAINT %s_pkey PRIMARY KEY (%s)", subsetTable.replace(".", ""), pkStr));
        columns.add(String.format("CONSTRAINT %s_fkey FOREIGN KEY (%s) REFERENCES %s ON DELETE CASCADE", subsetTable.replace(".", ""), pkStr, effectiveDataTable));
        this.createTable(subsetTable, columns, comment);
        this.createIndex(subsetTable, "is_processed", "is_in_process");
    }

    public void createIndex(String table, String ... columns) throws SQLException {
        Connection conn = this.getConn();
        String sql = String.format("CREATE INDEX %s_idx ON %s (%s)", table.replace(".", ""), table, String.join((CharSequence)",", columns));
        conn.createStatement().execute(sql);
        conn.close();
    }

    public String getReferencedTable(String startTable, Integer posOfDataTable) throws SQLException {
        if (posOfDataTable == null) {
            posOfDataTable = 1;
        }
        HashSet<String> blacklist = new HashSet<String>();
        String effectiveDataTable = startTable;
        String lasttable = "";
        for (int currentDatatablePosition = this.isDataTable(startTable) ? 1 : 0; this.isSubsetTable(effectiveDataTable) || currentDatatablePosition < posOfDataTable; ++currentDatatablePosition) {
            if (blacklist.contains(effectiveDataTable)) {
                if (effectiveDataTable.equals(lasttable)) {
                    throw new IllegalStateException("The table \"" + lasttable + "\" has a foreign key on itself. This is not allowed.");
                }
                throw new IllegalStateException("Fatal error: There is a circel in the foreign key chain. The table \"" + effectiveDataTable + "\" has been found twice when following the foreign key chain of the table \"" + startTable + "\".");
            }
            blacklist.add(effectiveDataTable);
            lasttable = effectiveDataTable;
            effectiveDataTable = this.getNextDataTable(effectiveDataTable);
        }
        return effectiveDataTable;
    }

    public String getNextDataTable(String referencingTable) throws SQLException {
        String referencedTable = this.getReferencedTable(referencingTable);
        while (this.isSubsetTable(referencedTable)) {
            referencedTable = this.getReferencedTable(referencedTable);
        }
        return referencedTable;
    }

    public String getNextOrThisDataTable(String referencingTable) throws SQLException {
        if (this.isDataTable(referencingTable)) {
            return referencingTable;
        }
        return this.getNextDataTable(referencingTable);
    }

    public boolean isSubsetTable(String table) throws SQLException {
        if (table == null) {
            return false;
        }
        try (Connection conn = this.getConn();){
            String pgSchema = this.dbConfig.getActivePGSchema();
            String tableName = table;
            if (table.contains(".")) {
                pgSchema = table.replaceFirst("\\..*$", "");
                tableName = table.substring(table.indexOf(46) + 1);
            }
            ResultSet columns = conn.getMetaData().getColumns(null, pgSchema, tableName.toLowerCase(), null);
            int numSubsetColumnsFound = 0;
            while (columns.next()) {
                String columnName = columns.getString(4);
                if (!subsetColumns.keySet().contains(columnName)) continue;
                ++numSubsetColumnsFound;
            }
            boolean bl = numSubsetColumnsFound == subsetColumns.size();
            return bl;
        }
    }

    public boolean isDataTable(String table) throws SQLException {
        return !this.isSubsetTable(table);
    }

    public boolean dropTable(String table) throws SQLException {
        try (Connection conn = this.getConn();){
            Statement stmt = conn.createStatement();
            String sql = "DROP TABLE " + table;
            boolean bl = stmt.execute(sql);
            return bl;
        }
    }

    public boolean tableExists(Connection conn, String tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException("The passed table name is null.");
        }
        try {
            Statement stmt = conn.createStatement();
            String pureTableName = tableName;
            String schemaName = this.dbConfig.getActivePGSchema();
            if (tableName.contains(".")) {
                String[] split = tableName.split("\\.");
                schemaName = split[0];
                pureTableName = split[1];
            }
            String sql = String.format("select schemaname,tablename from pg_tables where schemaname = '%s' and tablename = '%s'", schemaName.toLowerCase(), pureTableName.toLowerCase());
            LOG.trace("Checking whether table {} in schema {} exists.", (Object)pureTableName, (Object)schemaName);
            LOG.trace("Sent query (names have been lowercased to match Postgres table names): {}", (Object)sql);
            ResultSet res = stmt.executeQuery(sql);
            return res.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            SQLException ne = e.getNextException();
            if (null != ne) {
                ne.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) {
        Connection conn = this.getConn();
        try {
            boolean bl = this.tableExists(conn, tableName);
            return bl;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean schemaExists(String schemaName, Connection conn) {
        try {
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM pg_namespace WHERE nspname = '" + schemaName + "'");
            return rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean schemaExists(String schemaName) {
        Connection conn = this.getConn();
        boolean exists = this.schemaExists(schemaName, conn);
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(String tableName) {
        Connection conn = this.getConn();
        String sqlStr = "SELECT * FROM " + tableName + " LIMIT 1";
        try {
            Statement st = conn.createStatement();
            ResultSet res = st.executeQuery(sqlStr);
            boolean bl = !res.next();
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                LOG.error(sqlStr);
            }
        }
        return false;
    }

    public void defineRandomSubset(int size, String subsetTable, String supersetTable, String comment) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, comment);
        this.initRandomSubset(size, subsetTable, supersetTable);
    }

    public void defineRandomSubset(int size, String subsetTable, String supersetTable, String comment, String schemaName) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, null, schemaName, comment);
        this.initRandomSubset(size, subsetTable, supersetTable, schemaName);
    }

    public void defineSubset(List<String> values, String subsetTable, String supersetTable, String columnToTest, String comment) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, comment);
        this.initSubset(values, subsetTable, supersetTable, columnToTest);
    }

    public void defineSubset(List<String> values, String subsetTable, String supersetTable, String columnToTest, String comment, String schemaName) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, null, comment, schemaName);
        this.initSubset(values, subsetTable, supersetTable, columnToTest, schemaName);
    }

    public void defineSubset(String subsetTable, String supersetTable, String comment) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, comment);
        this.initSubset(subsetTable, supersetTable);
    }

    public void defineSubset(String subsetTable, String supersetTable, String comment, String schemaName) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, null, comment, schemaName);
        this.initSubset(subsetTable, supersetTable, schemaName);
    }

    public void defineSubsetWithWhereClause(String subsetTable, String supersetTable, String conditionToCheck, String comment) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, comment);
        this.initSubsetWithWhereClause(subsetTable, supersetTable, conditionToCheck);
    }

    public void defineSubsetWithWhereClause(String subsetTable, String supersetTable, String conditionToCheck, String comment, String schemaName) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, null, comment, schemaName);
        this.initSubsetWithWhereClause(subsetTable, supersetTable, conditionToCheck, schemaName);
    }

    public void defineMirrorSubset(String subsetTable, String supersetTable, boolean performUpdate, String comment) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, comment);
        this.initMirrorSubset(subsetTable, supersetTable, performUpdate);
    }

    public void defineMirrorSubset(String subsetTable, String supersetTable, boolean performUpdate, Integer maxNumberRefHops, String comment) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, maxNumberRefHops, comment);
        this.initMirrorSubset(subsetTable, supersetTable, performUpdate);
    }

    public void defineMirrorSubset(String subsetTable, String supersetTable, boolean performUpdate, String comment, String schemaName) throws SQLException {
        this.createSubsetTable(subsetTable, supersetTable, null, comment, schemaName);
        this.initMirrorSubset(subsetTable, supersetTable, performUpdate, schemaName);
    }

    public void initRandomSubset(int size, String subsetTable, String supersetTable) {
        this.initRandomSubset(size, subsetTable, supersetTable, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRandomSubset(int size, String subsetTable, String superSetTable, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        Connection conn = this.getConn();
        String sql = "INSERT INTO " + subsetTable + " (SELECT %s FROM " + superSetTable + " ORDER BY RANDOM() LIMIT " + size + ");";
        sql = String.format(sql, fieldConfig.getPrimaryKeyString());
        try {
            conn.createStatement().execute(sql);
        }
        catch (SQLException e) {
            LOG.error(sql);
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void initSubset(List<String> values, String subsetTable, String supersetTable, String columnToTest) {
        this.initSubset(values, subsetTable, supersetTable, columnToTest, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSubset(List<String> values, String subsetTable, String supersetTable, String columnToTest, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        int idSize = values.size();
        Connection conn = this.getConn();
        String sql = null;
        try {
            Statement st = conn.createStatement();
            for (int i = 0; i < idSize; i += 1000) {
                List<String> subList = i + 1000 - 1 < idSize ? values.subList(i, i + 1000) : values.subList(i, idSize);
                String expansionString = columnToTest + " = %s";
                if (fieldConfig.isOfStringType(columnToTest)) {
                    // empty if block
                }
                expansionString = columnToTest + " = '%s'";
                Object[] expandedIDs = JulieXMLTools.expandArrayEntries(subList, expansionString);
                String where = StringUtils.join(expandedIDs, " OR ");
                sql = "INSERT INTO " + subsetTable + " (SELECT " + fieldConfig.getPrimaryKeyString() + " FROM " + supersetTable + " WHERE " + where + ")";
                st.execute(sql);
            }
        }
        catch (SQLException e) {
            LOG.error("SQLError while initializing subset {}. SQL query was: {}", (Object)subsetTable, (Object)sql);
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void initSubset(String subsetTable, String supersetTable) {
        this.initSubset(subsetTable, supersetTable, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSubset(String subsetTable, String supersetTable, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        if (fieldConfig.getPrimaryKey().length == 0) {
            throw new IllegalStateException("Not subset tables corresponding to table scheme \"" + fieldConfig.getName() + "\" can be created since this scheme does not define a primary key.");
        }
        Connection conn = this.getConn();
        try {
            String pkStr = fieldConfig.getPrimaryKeyString();
            Statement st = conn.createStatement();
            String stStr = String.format("INSERT INTO %s (%s) (SELECT %s FROM %s);", subsetTable, pkStr, pkStr, supersetTable);
            st.execute(stStr);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void initSubsetWithWhereClause(String subsetTable, String supersetTable, String whereClause) {
        this.initSubsetWithWhereClause(subsetTable, supersetTable, whereClause, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSubsetWithWhereClause(String subsetTable, String supersetTable, String whereClause, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        Connection conn = this.getConn();
        String stStr = null;
        try {
            if (!whereClause.toUpperCase().startsWith("WHERE")) {
                whereClause = "WHERE " + whereClause;
            }
            String pkStr = fieldConfig.getPrimaryKeyString();
            Statement st = conn.createStatement();
            stStr = String.format("INSERT INTO %s (%s) (SELECT %s FROM %s %s);", subsetTable, pkStr, pkStr, supersetTable, whereClause);
            st.execute(stStr);
        }
        catch (SQLException e) {
            LOG.error(stStr);
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void initMirrorSubset(String subsetTable, String supersetTable, boolean performUpdate) throws SQLException {
        this.initMirrorSubset(subsetTable, supersetTable, performUpdate, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMirrorSubset(String subsetTable, String supersetTable, boolean performUpdate, String schemaName) throws SQLException {
        String mirrorTableName = this.getMirrorCollectionTableName(supersetTable);
        if (!subsetTable.contains(".")) {
            subsetTable = this.dbConfig.getActivePGSchema().concat(".").concat(subsetTable);
        }
        if (!this.tableExists(mirrorTableName)) {
            ArrayList<String> columns = new ArrayList<String>();
            columns.add("datatablename text");
            columns.add("subsettablename text");
            columns.add("performreset boolean DEFAULT true");
            columns.add(String.format("CONSTRAINT %s_pkey PRIMARY KEY (%s)", mirrorTableName.replace(".", ""), "subsettablename"));
            this.createTable(mirrorTableName, columns, "This table disposes the names of subset tables which mirror the data table " + supersetTable + ". These subset tables will be updated as " + supersetTable + " will obtains updates (insertions as well as deletions).");
        }
        this.initSubset(subsetTable, supersetTable, schemaName);
        Connection conn = this.getConn();
        String sql = null;
        try {
            Statement st = conn.createStatement();
            sql = String.format("INSERT INTO %s VALUES ('%s','%s',%b)", mirrorTableName, supersetTable, subsetTable, performUpdate);
            st.execute(sql);
        }
        catch (SQLException e) {
            LOG.error("Error executing SQL command: " + sql, e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private LinkedHashMap<String, Boolean> getMirrorSubsetNames(Connection conn, String tableName) {
        String mirrorTableName = this.getMirrorCollectionTableName(tableName);
        if (!this.tableExists(conn, mirrorTableName)) {
            return null;
        }
        if (!tableName.contains(".")) {
            tableName = this.dbConfig.getActivePGSchema() + "." + tableName;
        }
        LinkedHashMap<String, Boolean> mirrorSubsetList = new LinkedHashMap<String, Boolean>();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(String.format("SELECT %s,%s FROM %s WHERE datatablename='%s'", "subsettablename", "performreset", mirrorTableName, tableName));
            while (rs.next()) {
                String mirrorTable = rs.getString(1);
                Boolean performUpdate = rs.getBoolean(2);
                String refDataTable = this.getReferencedTable(mirrorTable);
                if (refDataTable == null || !refDataTable.equals(tableName)) continue;
                mirrorSubsetList.put(mirrorTable, performUpdate);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mirrorSubsetList;
    }

    private String getMirrorCollectionTableName(String tableName) {
        String[] dataTablePath = tableName.split("\\.");
        String dataTableSchema = null;
        if (dataTablePath.length > 1) {
            dataTableSchema = dataTablePath[0];
        }
        return dataTableSchema != null ? dataTableSchema + "." + "_mirrorSubsets" : this.getActiveDataPGSchema() + "." + "_mirrorSubsets";
    }

    public void resetSubset(String subsetTableName) {
        this.resetSubset(subsetTableName, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSubset(String subsetTableName, boolean whereNotProcessed, boolean whereNoErrors, String lastComponent) {
        Connection conn = this.getConn();
        String stStr = null;
        try {
            ArrayList<String> constraints = new ArrayList<String>();
            if (whereNotProcessed) {
                constraints.add("is_processed = FALSE");
            }
            if (whereNoErrors) {
                constraints.add("has_errors = FALSE");
            }
            if (lastComponent != null) {
                constraints.add("last_component = '" + lastComponent + "'");
            }
            Statement st = conn.createStatement();
            stStr = String.format("UPDATE %s SET %s = FALSE, %s = FALSE, %s='%s', %s = FALSE, %s = NULL, %s = NULL WHERE (%s = TRUE OR %s = TRUE)", subsetTableName, "is_in_process", "is_processed", "last_component", DEFAULT_PIPELINE_STATE, "has_errors", "log", "processing_timestamp", "is_processed", "is_in_process");
            if (!constraints.isEmpty()) {
                stStr = stStr + " AND " + constraints.stream().collect(Collectors.joining(" AND "));
            }
            st.execute(stStr);
        }
        catch (SQLException e) {
            LOG.error("Error executing SQL command: " + stStr, e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public int[] resetSubset(String subsetTableName, List<Object[]> pkValues) {
        return this.resetSubset(subsetTableName, pkValues, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] performBatchUpdate(List<Object[]> pkValues, String sqlFormatString, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        Connection conn = this.getConn();
        String stStr = null;
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        try {
            int[] results;
            conn.setAutoCommit(false);
            String whereArgument = StringUtils.join((Object[])fieldConfig.expandPKNames("%s = ?"), " AND ");
            stStr = String.format(sqlFormatString, whereArgument);
            LOG.trace("Performing batch update with SQL command: {}", (Object)stStr);
            PreparedStatement ps = conn.prepareStatement(stStr);
            int i = 0;
            for (Object[] id : pkValues) {
                for (int j = 0; j < id.length; ++j) {
                    this.setPreparedStatementParameterWithType(j + 1, ps, id[j], fieldConfig.getPrimaryKey()[j], fieldConfig);
                }
                ps.addBatch();
                if (i >= 100) {
                    int[] results2;
                    for (int result : results2 = ps.executeBatch()) {
                        resultList.add(result);
                    }
                    conn.commit();
                    ps.clearBatch();
                    i = 0;
                }
                ++i;
            }
            for (int result : results = ps.executeBatch()) {
                resultList.add(result);
            }
            conn.commit();
        }
        catch (SQLException e) {
            LOG.error("Error executing SQL command: " + stStr, e);
        }
        finally {
            try {
                conn.setAutoCommit(true);
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        int[] ret = new int[resultList.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)resultList.get(i);
        }
        return ret;
    }

    public int[] resetSubset(String subsetTableName, List<Object[]> pkValues, String schemaName) {
        String updateFormatString = "UPDATE " + subsetTableName + " SET " + "is_processed" + "=FALSE, " + "is_in_process" + "= FALSE, " + "last_component" + "='" + DEFAULT_PIPELINE_STATE + "' WHERE %s";
        return this.performBatchUpdate(pkValues, updateFormatString, schemaName);
    }

    public int[] determineExistingSubsetRows(String subsetTableName, List<Object[]> pkValues, String schemaName) {
        String updateFormatString = "UPDATE " + subsetTableName + " SET has_errors = has_errors where %s";
        return this.performBatchUpdate(pkValues, updateFormatString, schemaName);
    }

    public void importFromXML(Iterable<byte[]> xmls, String identifier, String tableName) {
        this.importFromXML(xmls, tableName, identifier, this.activeTableSchema);
    }

    public void importFromXML(Iterable<byte[]> xmls, String tableName, String identifier, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        for (byte[] xml : xmls) {
            Iterator<Map<String, Object>> it = JulieXMLTools.constructRowIterator(xml, 1000, fieldConfig.getForEachXPath(), fieldConfig.getFields(), identifier);
            this.importFromRowIterator(it, tableName);
        }
    }

    public void importFromXMLFile(String fileStr, String tableName) {
        this.importFromXMLFile(fileStr, tableName, this.activeTableSchema);
    }

    public void importFromXMLFile(String fileStr, String tableName, String schemaName) {
        LOG.info("Starting import...");
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        File fileOrDir = new File(fileStr);
        Object[] fileNames = !fileOrDir.isDirectory() ? new String[]{fileStr} : fileOrDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".zip") || arg1.endsWith(".gz") || arg1.endsWith(".xml");
            }
        });
        Arrays.sort(fileNames);
        XMLPreparer xp = new XMLPreparer(fileOrDir, fieldConfig);
        for (Object fileName : fileNames) {
            LOG.info("Importing " + (String)fileName);
            Iterator<Map<String, Object>> it = xp.prepare((String)fileName);
            this.importFromRowIterator(it, tableName, null, true, schemaName);
        }
    }

    public void updateFromXML(String fileStr, String tableName) {
        this.updateFromXML(fileStr, tableName, this.activeTableSchema);
    }

    public void updateFromXML(String fileStr, String tableName, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        ArrayList<String> pks = new ArrayList<String>();
        List<Map<String, String>> fields = fieldConfig.getFields();
        for (Map<String, String> field : fields) {
            if (!field.containsKey("primaryKey") || !field.get("primaryKey").equals(true)) continue;
            pks.add(field.get("name"));
        }
        LOG.info("Starting update...");
        File fileOrDir = new File(fileStr);
        Object[] fileNames = !fileOrDir.isDirectory() ? new String[]{fileStr} : fileOrDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".zip") || arg1.endsWith(".gz") || arg1.endsWith(".xml");
            }
        });
        Arrays.sort(fileNames);
        XMLPreparer xp = new XMLPreparer(fileOrDir, fieldConfig);
        for (Object fileName : fileNames) {
            LOG.info("Updating from " + (String)fileName);
            Iterator<Map<String, Object>> fileIt = xp.prepare((String)fileName);
            this.updateFromRowIterator(fileIt, tableName, null, true, schemaName);
        }
    }

    public void importFromRowIterator(Iterator<Map<String, Object>> it, String tableName) {
        this.importFromRowIterator(it, tableName, null, true, this.activeTableSchema);
    }

    public void importFromRowIterator(Iterator<Map<String, Object>> it, String tableName, String tableSchema) {
        this.importFromRowIterator(it, tableName, null, true, tableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromRowIterator(Iterator<Map<String, Object>> it, String tableName, Connection externalConn, boolean commit, String schemaName) {
        if (!it.hasNext()) {
            return;
        }
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        String dataImportStmtString = this.constructImportStatementString(tableName, fieldConfig);
        String mirrorUpdateStmtString = this.constructMirrorInsertStatementString(fieldConfig);
        Connection conn = null != externalConn ? externalConn : this.getConn();
        try {
            LinkedHashMap<String, Boolean> mirrorNames = this.getMirrorSubsetNames(conn, tableName);
            if (null == externalConn) {
                conn.setAutoCommit(false);
            }
            PreparedStatement psDataImport = conn.prepareStatement(dataImportStmtString);
            ArrayList<PreparedStatement> mirrorStatements = null;
            if (mirrorNames != null) {
                mirrorStatements = new ArrayList<PreparedStatement>();
                for (String mirror : mirrorNames.keySet()) {
                    mirrorStatements.add(conn.prepareStatement(String.format(mirrorUpdateStmtString, mirror)));
                }
            }
            List<Map<String, String>> fields = fieldConfig.getFields();
            int i = 0;
            while (it.hasNext()) {
                Map<String, Object> row = it.next();
                for (int j = 0; j < fields.size(); ++j) {
                    Map<String, String> field = fields.get(j);
                    String fieldName = field.get("name");
                    this.setPreparedStatementParameterWithType(j + 1, psDataImport, row.get(fieldName), fieldName, fieldConfig);
                }
                psDataImport.addBatch();
                if (mirrorStatements != null) {
                    for (PreparedStatement ps : mirrorStatements) {
                        for (int j = 0; j < fieldConfig.getPrimaryKey().length; ++j) {
                            String fieldName = fieldConfig.getPrimaryKey()[j];
                            this.setPreparedStatementParameterWithType(j + 1, ps, row.get(fieldName), fieldName, fieldConfig);
                        }
                        ps.addBatch();
                    }
                }
                if (++i < 100) continue;
                psDataImport.executeBatch();
                if (mirrorStatements != null) {
                    for (PreparedStatement ps : mirrorStatements) {
                        ps.executeBatch();
                    }
                }
                if (commit) {
                    conn.commit();
                }
                psDataImport = conn.prepareStatement(dataImportStmtString);
                i = 0;
            }
            if (i > 0) {
                psDataImport.executeBatch();
                if (commit) {
                    conn.commit();
                }
                if (mirrorStatements != null) {
                    for (PreparedStatement ps : mirrorStatements) {
                        ps.executeBatch();
                    }
                }
                if (commit) {
                    conn.commit();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            SQLException nextException = e.getNextException();
            if (nextException != null) {
                LOG.error("Next exception: ", nextException);
            }
        }
        finally {
            try {
                if (commitThread != null) {
                    commitThread.join();
                }
                if (null == externalConn) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateFromRowIterator(Iterator<Map<String, Object>> it, String tableName) {
        this.updateFromRowIterator(it, tableName, null, true, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFromRowIterator(Iterator<Map<String, Object>> it, String tableName, Connection externalConn, boolean commit, String schemaName) {
        if (!it.hasNext()) {
            return;
        }
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        String statementString = this.constructUpdateStatementString(tableName, fieldConfig);
        String mirrorInsertStmtString = this.constructMirrorInsertStatementString(fieldConfig);
        Connection conn = null != externalConn ? externalConn : this.getConn();
        try {
            Object key;
            LinkedHashMap<String, Boolean> mirrorNames = this.getMirrorSubsetNames(conn, tableName);
            ArrayList<PreparedStatement> mirrorStatements = null;
            if (mirrorNames != null) {
                mirrorStatements = new ArrayList<PreparedStatement>();
                for (String mirror : mirrorNames.keySet()) {
                    mirrorStatements.add(conn.prepareStatement(String.format(mirrorInsertStmtString, mirror)));
                }
            }
            if (null == externalConn) {
                conn.setAutoCommit(false);
            }
            int i = 0;
            PreparedStatement ps = conn.prepareStatement(statementString);
            List<Map<String, String>> fields = fieldConfig.getFields();
            String[] primaryKey = fieldConfig.getPrimaryKey();
            int numAlreadyExisted = 0;
            HashMap<String, Map<String, Object>> rowsByPk = new HashMap<String, Map<String, Object>>(1000);
            while (it.hasNext()) {
                Map<String, Object> row = it.next();
                StringBuilder rowPrimaryKey = new StringBuilder();
                for (int j = 0; j < primaryKey.length; ++j) {
                    String keyFieldName = primaryKey[j];
                    key = row.get(keyFieldName);
                    rowPrimaryKey.append(key);
                }
                String pk = rowPrimaryKey.toString();
                if (rowsByPk.containsKey(pk)) {
                    ++numAlreadyExisted;
                }
                rowsByPk.put(pk, row);
            }
            ArrayList<Map<String, Object>> cache = new ArrayList<Map<String, Object>>(100);
            for (Map row : rowsByPk.values()) {
                for (int j = 0; j < fields.size() + primaryKey.length; ++j) {
                    if (j < fields.size()) {
                        Map<String, String> field = fields.get(j);
                        String fieldName = field.get("name");
                        this.setPreparedStatementParameterWithType(j + 1, ps, row.get(fieldName), null, null);
                        continue;
                    }
                    key = primaryKey[j - fields.size()];
                    Object keyValue = row.get(key);
                    this.setPreparedStatementParameterWithType(j + 1, ps, keyValue, null, null);
                }
                ps.addBatch();
                cache.add(row);
                if (++i < 100) continue;
                LOG.trace("Committing batch of size {}", (Object)i);
                this.executeAndCommitUpdate(tableName, externalConn != null ? externalConn : conn, commit, schemaName, fieldConfig, mirrorNames, mirrorStatements, ps, cache);
                cache.clear();
                i = 0;
            }
            if (i > 0) {
                LOG.trace("Commiting last batch of size {}", (Object)i);
                this.executeAndCommitUpdate(tableName, externalConn != null ? externalConn : conn, commit, schemaName, fieldConfig, mirrorNames, mirrorStatements, ps, cache);
            }
            String msg = "Updated {} documents. {} documents were skipped because there existed documents with same primary keys multiple times in the data. In those cases, the last occurrence of the document was inserted into the database";
            if (numAlreadyExisted == 0) {
                LOG.debug(msg, (Object)rowsByPk.size(), (Object)numAlreadyExisted);
            } else {
                LOG.warn(msg, (Object)rowsByPk.size(), (Object)numAlreadyExisted);
            }
        }
        catch (SQLException e) {
            LOG.error("SQL error while updating table {}. Database configuration is: {}. Table schema configuration is: {}", tableName, this.dbConfig, fieldConfig);
            e.printStackTrace();
            SQLException nextException = e.getNextException();
            if (null != nextException) {
                LOG.error("Next exception was: ", nextException);
                nextException.printStackTrace();
            }
        }
        finally {
            try {
                if (commitThread != null) {
                    commitThread.join();
                }
                if (null == externalConn) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void executeAndCommitUpdate(String tableName, Connection externalConn, boolean commit, String schemaName, FieldConfig fieldConfig, LinkedHashMap<String, Boolean> mirrorNames, List<PreparedStatement> mirrorStatements, PreparedStatement ps, ArrayList<Map<String, Object>> cache) throws SQLException {
        int[] returned = ps.executeBatch();
        ArrayList<Map<String, Object>> toInsert = new ArrayList<Map<String, Object>>(100);
        ArrayList<Map<String, Object>> toResetRows = new ArrayList<Map<String, Object>>(100);
        ArrayList<Object[]> toResetPKs = new ArrayList<Object[]>();
        this.fillUpdateLists(cache, returned, toInsert, toResetPKs, toResetRows, fieldConfig);
        this.importFromRowIterator(toInsert.iterator(), tableName, externalConn, commit, schemaName);
        LOG.trace("Committing updates to the data table.");
        externalConn.commit();
        if (mirrorNames != null) {
            LOG.trace("Applying updates to mirror subsets:");
            ArrayList<Map<String, Object>> toInsertMirror = new ArrayList<Map<String, Object>>(100);
            Iterator<String> mirrorNamesIt = mirrorNames.keySet().iterator();
            Iterator<PreparedStatement> mirrorStatementsIt = mirrorStatements.iterator();
            for (int j = 0; j < mirrorNames.size(); ++j) {
                String mirrorName = mirrorNamesIt.next();
                LOG.trace("Applying to mirror subset \"{}\"", (Object)mirrorName);
                if (mirrorNames.get(mirrorName).booleanValue()) {
                    LOG.trace("Resetting updated rows.");
                    returned = this.resetSubset(mirrorName, toResetPKs, schemaName);
                } else {
                    LOG.trace("Updates rows are NOT reset.");
                    returned = this.determineExistingSubsetRows(mirrorName, toResetPKs, schemaName);
                }
                this.fillUpdateLists(toResetRows, returned, toInsertMirror, null, null, fieldConfig);
                if (toInsertMirror.size() > 0) {
                    LOG.trace("{} updated rows where not found in this mirror subset. They will be added");
                    PreparedStatement mirrorPS = mirrorStatementsIt.next();
                    for (Map map : toInsertMirror) {
                        for (int k = 0; k < fieldConfig.getPrimaryKey().length; ++k) {
                            String fieldName = fieldConfig.getPrimaryKey()[k];
                            this.setPreparedStatementParameterWithType(k + 1, mirrorPS, map.get(fieldName), fieldName, fieldConfig);
                        }
                        mirrorPS.addBatch();
                    }
                    mirrorPS.executeBatch();
                    toInsertMirror.clear();
                    continue;
                }
                LOG.trace("All updated rows exist in the mirror subset.");
            }
        }
        if (commit) {
            LOG.trace("Committing updates.");
            externalConn.commit();
        }
    }

    private void fillUpdateLists(List<Map<String, Object>> cache, int[] returned, List<Map<String, Object>> toInsert, List<Object[]> toResetPKs, List<Map<String, Object>> toResetRows, FieldConfig fieldConfig) {
        for (int j = 0; j < returned.length; ++j) {
            Map<String, Object> newRow = cache.get(j);
            if (returned[j] <= 0) {
                toInsert.add(newRow);
                continue;
            }
            if (null != toResetPKs) {
                Object[] pkValues = new Object[fieldConfig.getPrimaryKey().length];
                for (int k = 0; k < pkValues.length; ++k) {
                    String pkColumn = fieldConfig.getPrimaryKey()[k];
                    pkValues[k] = newRow.get(pkColumn);
                }
                toResetPKs.add(pkValues);
            }
            if (null == toResetRows) continue;
            toResetRows.add(newRow);
        }
    }

    private String constructMirrorInsertStatementString(FieldConfig fieldConfig) {
        String stmtTemplate = "INSERT INTO %s (%s) VALUES (%s)";
        String pkStr = fieldConfig.getPrimaryKeyString();
        Object[] wildCards = new String[fieldConfig.getPrimaryKey().length];
        for (int i = 0; i < wildCards.length; ++i) {
            wildCards[i] = "?";
        }
        String wildCardStr = StringUtils.join(wildCards, ",");
        return String.format(stmtTemplate, "%s", pkStr, wildCardStr);
    }

    private String constructImportStatementString(String tableName, FieldConfig fieldDefinition) {
        String stmtTemplate = "INSERT INTO %s (%s) VALUES (%s)";
        List<Map<String, String>> fields = fieldDefinition.getFields();
        StringBuilder columnsStrBuilder = new StringBuilder();
        StringBuilder valuesStrBuilder = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            columnsStrBuilder.append(fields.get(i).get("name"));
            if (fields.get(i).get("type").equals(DEFAULT_FIELD)) {
                valuesStrBuilder.append("XMLPARSE(CONTENT ?)");
            } else {
                valuesStrBuilder.append("?");
            }
            if (i >= fields.size() - 1) continue;
            columnsStrBuilder.append(",");
            valuesStrBuilder.append(",");
        }
        return String.format(stmtTemplate, tableName, columnsStrBuilder.toString(), valuesStrBuilder.toString());
    }

    private String constructUpdateStatementString(String tableName, FieldConfig fieldDefinition) {
        String stmtTemplate = "UPDATE %s SET %s WHERE %s";
        List<Map<String, String>> fields = fieldDefinition.getFields();
        StringBuilder newValueStrBuilder = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            newValueStrBuilder.append(fields.get(i).get("name"));
            if (fields.get(i).get("type").equals(DEFAULT_FIELD)) {
                newValueStrBuilder.append("=XMLPARSE(CONTENT ?)");
            } else {
                newValueStrBuilder.append("=?");
            }
            if (i >= fields.size() - 1) continue;
            newValueStrBuilder.append(",");
        }
        String[] primaryKeys = fieldDefinition.getPrimaryKey();
        StringBuilder conditionStrBuilder = new StringBuilder();
        for (int i = 0; i < primaryKeys.length; ++i) {
            String key = primaryKeys[i];
            conditionStrBuilder.append(key).append("=?");
            if (i >= primaryKeys.length - 1) continue;
            conditionStrBuilder.append(" AND ");
        }
        String statementString = String.format(stmtTemplate, tableName, newValueStrBuilder.toString(), conditionStrBuilder.toString());
        LOG.trace("PreparedStatement update command: {}", (Object)statementString);
        return statementString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterTable(String action, String tableName) {
        Connection conn = this.getConn();
        String sqlString = "ALTER TABLE " + tableName + " " + action;
        try {
            Statement st = conn.createStatement();
            st.execute(sqlString);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public DBCIterator<byte[][]> queryWithTime(List<Object[]> ids, String table, String timestamp) {
        return this.queryWithTime(ids, table, timestamp, this.activeTableSchema);
    }

    public DBCIterator<byte[][]> queryWithTime(List<Object[]> ids, String table, String timestamp, String schemaName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        String timestampWhere = fieldConfig.getTimestampFieldName() + " > " + timestamp;
        return new ThreadedColumnsToRetrieveIterator(this, ids, table, timestampWhere, schemaName);
    }

    public DBCIterator<Object[]> queryAll(List<String> fields, String table) {
        return new ThreadedColumnsIterator(this, fields, table);
    }

    public DBCIterator<Object[]> query(String table, List<String> fields) {
        return new ThreadedColumnsIterator(this, fields, table);
    }

    public DBCIterator<Object[]> query(String table, List<String> fields, long limit) {
        return new ThreadedColumnsIterator(this, fields, table, limit);
    }

    public DBCIterator<Object[]> query(List<String[]> keys, String table) {
        return new ThreadedColumnsIterator(this, keys, Collections.singletonList(DEFAULT_FIELD), table, this.activeTableSchema);
    }

    public DBCIterator<Object[]> query(List<String[]> keys, String table, String schemaName) {
        return new ThreadedColumnsIterator(this, keys, Collections.singletonList(DEFAULT_FIELD), table, schemaName);
    }

    public DBCIterator<byte[][]> retrieveColumnsByTableSchema(List<Object[]> ids, String table) {
        return this.retrieveColumnsByTableSchema(ids, table, this.activeTableSchema);
    }

    public DBCIterator<byte[][]> retrieveColumnsByTableSchema(List<Object[]> ids, String table, String schemaName) {
        return new ThreadedColumnsToRetrieveIterator(this, ids, table, schemaName);
    }

    public DBCIterator<byte[][]> retrieveColumnsByTableSchema(List<Object[]> ids, String[] tables, String[] schemaNames) {
        return new ThreadedColumnsToRetrieveIterator(this, ids, tables, schemaNames);
    }

    public DBCIterator<byte[][]> queryDataTable(String tableName, String whereCondition) {
        return this.queryDataTable(tableName, whereCondition, this.activeTableSchema);
    }

    public DBCIterator<byte[][]> queryDataTable(String tableName, String whereCondition, String schemaName) {
        if (!this.tableExists(tableName)) {
            throw new IllegalArgumentException("Table \"" + tableName + "\" does not exist.");
        }
        final FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        String query = null;
        String selectedColumns = StringUtils.join((Object[])fieldConfig.getColumnsToRetrieve(), ",");
        query = whereCondition != null && !whereCondition.trim().toUpperCase().startsWith("WHERE") && !whereCondition.trim().toUpperCase().matches("LIMIT +[0-9]+") ? String.format("SELECT %s FROM %s WHERE %s", selectedColumns, tableName, whereCondition) : (whereCondition != null ? String.format("SELECT %s FROM %s %s", selectedColumns, tableName, whereCondition) : String.format("SELECT %s FROM %s", selectedColumns, tableName));
        final String finalQuery = query;
        try {
            DBCIterator<byte[][]> it = new DBCIterator<byte[][]>(){
                private Connection conn;
                private ResultSet rs;
                private boolean hasNext;
                {
                    this.conn = DataBaseConnector.this.getConn();
                    this.rs = this.doQuery(this.conn);
                    this.hasNext = this.rs.next();
                }

                private ResultSet doQuery(Connection conn) throws SQLException {
                    conn.setAutoCommit(false);
                    Statement stmt = conn.createStatement();
                    stmt.setFetchSize(DataBaseConnector.this.queryBatchSize);
                    return stmt.executeQuery(finalQuery);
                }

                @Override
                public boolean hasNext() {
                    if (!this.hasNext) {
                        this.close();
                    }
                    return this.hasNext;
                }

                @Override
                public byte[][] next() {
                    if (this.hasNext) {
                        List<Map<String, String>> fields = fieldConfig.getFields();
                        try {
                            byte[][] retrievedData = new byte[fieldConfig.getColumnsToRetrieve().length][];
                            for (int i = 0; i < retrievedData.length; ++i) {
                                retrievedData[i] = this.rs.getBytes(i + 1);
                                if (!Boolean.parseBoolean(fields.get(i).get(JulieXMLConstants.GZIP))) continue;
                                retrievedData[i] = JulieXMLTools.unGzipData(retrievedData[i]);
                            }
                            this.hasNext = this.rs.next();
                            if (!this.hasNext) {
                                this.close();
                            }
                            return retrievedData;
                        }
                        catch (IOException | SQLException e) {
                            this.hasNext = false;
                            e.printStackTrace();
                        }
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void close() {
                    try {
                        if (!this.conn.isClosed()) {
                            this.conn.commit();
                            this.conn.setAutoCommit(true);
                            this.conn.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            };
            return it;
        }
        catch (SQLException e) {
            LOG.error("Error while executing SQL statement \"" + finalQuery + "\"");
            e.printStackTrace();
            return null;
        }
    }

    public DBCIterator<byte[][]> querySubset(String tableName, long limitParam) throws SQLException {
        return this.querySubset(tableName, null, limitParam, 0, this.activeTableSchema);
    }

    public int getQueryBatchSize() {
        return this.queryBatchSize;
    }

    public void setQueryBatchSize(int queryBatchSize) {
        this.queryBatchSize = queryBatchSize;
    }

    public DBCIterator<byte[][]> querySubset(String tableName, final String whereClause, final long limitParam, Integer numberRefHops, final String schemaName) throws SQLException {
        if (!this.tableExists(tableName)) {
            throw new IllegalArgumentException("Table \"" + tableName + "\" does not exist.");
        }
        final FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        final String dataTable = this.getReferencedTable(tableName, numberRefHops);
        if (dataTable.equals(tableName)) {
            String newWhereClause = whereClause;
            if (newWhereClause == null && limitParam > 0L) {
                newWhereClause = "";
            }
            if (limitParam > 0L && !newWhereClause.toLowerCase().matches(".*limit +[0-9]+.*")) {
                newWhereClause = newWhereClause + " LIMIT " + limitParam;
            }
            return this.queryDataTable(tableName, newWhereClause, schemaName);
        }
        final Connection conn = this.getConn();
        try {
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            stmt.setFetchSize(this.queryBatchSize);
            String sql = "SELECT (" + fieldConfig.getPrimaryKeyString() + ") FROM " + tableName;
            final ResultSet outerKeyRS = stmt.executeQuery(sql);
            final DataBaseConnector dbc = this;
            DBCIterator<byte[][]> it = new DBCIterator<byte[][]>(){
                private long returnedDocs = 0L;
                private ResultSet keyRS = outerKeyRS;
                private long limit = limitParam <= 0L ? Long.MAX_VALUE : limitParam;
                private Iterator<byte[][]> xmlIt;

                @Override
                public boolean hasNext() {
                    if (this.returnedDocs >= this.limit) {
                        return false;
                    }
                    try {
                        if (this.xmlIt == null || !this.xmlIt.hasNext()) {
                            ArrayList<Object[]> ids = new ArrayList<Object[]>();
                            String[] pks = fieldConfig.getPrimaryKey();
                            for (int currentBatchSize = 0; currentBatchSize < DataBaseConnector.this.queryBatchSize && this.keyRS.next(); ++currentBatchSize) {
                                String[] values = new String[pks.length];
                                for (int i = 0; i < pks.length; ++i) {
                                    values[i] = (String)this.keyRS.getObject(i + 1);
                                }
                                ids.add(values);
                            }
                            this.xmlIt = whereClause != null ? new ThreadedColumnsToRetrieveIterator(dbc, conn, ids, dataTable, whereClause, schemaName) : new ThreadedColumnsToRetrieveIterator(dbc, conn, ids, dataTable, schemaName);
                            boolean xmlItHasNext = this.xmlIt.hasNext();
                            if (!xmlItHasNext) {
                                this.close();
                            }
                            return xmlItHasNext;
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    return true;
                }

                @Override
                public byte[][] next() {
                    if (!this.hasNext()) {
                        this.close();
                        return null;
                    }
                    ++this.returnedDocs;
                    return this.xmlIt.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void close() {
                    ((ThreadedColumnsToRetrieveIterator)this.xmlIt).close();
                    try {
                        if (!conn.isClosed()) {
                            conn.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            };
            return it;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Pair<Integer, List<Map<String, String>>> getNumColumnsAndFields(boolean joined, String[] schemaNames) {
        int numColumns = 0;
        List<Object> fields = new ArrayList();
        if (!joined) {
            FieldConfig fieldConfig = this.fieldConfigs.get(schemaNames[0]);
            numColumns = fieldConfig.getColumnsToRetrieve().length;
            fields = fieldConfig.getFields();
        } else {
            for (int i = 0; i < schemaNames.length; ++i) {
                FieldConfig fieldConfig = this.fieldConfigs.get(schemaNames[i]);
                int num = fieldConfig.getColumnsToRetrieve().length;
                numColumns += num;
                List<Map<String, String>> fieldsPartly = fieldConfig.getFieldsToRetrieve();
                fields.addAll(fieldsPartly);
            }
        }
        return new ImmutablePair<Integer, List<Map<String, String>>>(numColumns, fields);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getNumRows(String tableName) {
        try (Connection conn = this.getConn();){
            String sql = String.format("SELECT sum(1) as %s FROM %s", "total", tableName);
            ResultSet resultSet = conn.createStatement().executeQuery(sql);
            if (!resultSet.next()) return 0L;
            long l = resultSet.getLong("total");
            return l;
        }
        catch (SQLException e) {
            LOG.error("Error when trying to determine size of table {}: {}", (Object)tableName, (Object)e);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubsetStatus status(String subsetTableName, Set<StatusElement> statusElementsToReturn) throws TableNotFoundException {
        if (!this.tableExists(subsetTableName)) {
            throw new TableNotFoundException("The subset table \"" + subsetTableName + "\" does not exist.");
        }
        SubsetStatus status = new SubsetStatus();
        Connection conn = null;
        try {
            StringJoiner joiner = new StringJoiner(",");
            String sumFmtString = "sum(case when %s=TRUE then 1 end) as %s";
            if (statusElementsToReturn.contains((Object)StatusElement.HAS_ERRORS)) {
                joiner.add(String.format(sumFmtString, "has_errors", "has_errors"));
            }
            if (statusElementsToReturn.contains((Object)StatusElement.IS_PROCESSED)) {
                joiner.add(String.format(sumFmtString, "is_processed", "is_processed"));
            }
            if (statusElementsToReturn.contains((Object)StatusElement.IN_PROCESS)) {
                joiner.add(String.format(sumFmtString, "is_in_process", "is_in_process"));
            }
            if (statusElementsToReturn.contains((Object)StatusElement.TOTAL)) {
                joiner.add(String.format("sum(1) as %s", "total"));
            }
            conn = this.getConn();
            String sql = String.format("SELECT " + joiner.toString() + " FROM %s", subsetTableName);
            Statement stmt = conn.createStatement();
            ResultSet res = stmt.executeQuery(sql);
            if (res.next()) {
                if (statusElementsToReturn.contains((Object)StatusElement.HAS_ERRORS)) {
                    status.hasErrors = res.getLong("has_errors");
                }
                if (statusElementsToReturn.contains((Object)StatusElement.IN_PROCESS)) {
                    status.inProcess = res.getLong("is_in_process");
                }
                if (statusElementsToReturn.contains((Object)StatusElement.IS_PROCESSED)) {
                    status.isProcessed = res.getLong("is_processed");
                }
                if (statusElementsToReturn.contains((Object)StatusElement.TOTAL)) {
                    status.total = res.getLong("total");
                }
            }
            if (statusElementsToReturn.contains((Object)StatusElement.LAST_COMPONENT)) {
                TreeMap<String, Long> pipelineStates = new TreeMap<String, Long>();
                status.pipelineStates = pipelineStates;
                String pipelineStateSql = String.format("SELECT %s,count(%s) from %s group by %s", "last_component", "last_component", subsetTableName, "last_component");
                ResultSet res2 = stmt.executeQuery(pipelineStateSql);
                while (res2.next()) {
                    pipelineStates.put(res2.getString(1) != null ? res2.getString(1) : "<empty>", res2.getLong(2));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getTables() {
        Connection conn = this.getConn();
        ArrayList<String> tables = new ArrayList<String>();
        try {
            ResultSet res = conn.getMetaData().getTables(null, this.dbConfig.getActivePGSchema(), null, new String[]{"TABLE"});
            while (res.next()) {
                tables.add(res.getString("TABLE_NAME"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableDefinition(String tableName) {
        String schema;
        Connection conn = this.getConn();
        ArrayList<String> columns = new ArrayList<String>();
        if (tableName.contains(".")) {
            schema = tableName.split("\\.")[0];
            tableName = tableName.split("\\.")[1];
        } else {
            schema = this.dbConfig.getActivePGSchema();
        }
        try {
            ResultSet res = conn.getMetaData().getColumns(null, schema, tableName, null);
            while (res.next()) {
                columns.add(res.getString("COLUMN_NAME"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return columns;
    }

    public String getScheme() {
        String scheme = "none";
        try {
            ResultSet res = this.getConn().createStatement().executeQuery("SHOW search_path;");
            if (res.next()) {
                scheme = res.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return scheme;
    }

    public FieldConfig getFieldConfiguration() {
        return this.fieldConfigs.get(this.activeTableSchema);
    }

    public void addFieldConfiguration(FieldConfig config) {
        this.fieldConfigs.put(config.getName(), config);
    }

    public FieldConfig getFieldConfiguration(String schemaName) {
        return this.fieldConfigs.get(schemaName);
    }

    public void checkTableDefinition(String tableName) throws TableSchemaMismatchException {
        this.checkTableDefinition(tableName, this.activeTableSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTableDefinition(String tableName, String schemaName) throws TableSchemaMismatchException {
        String tableType;
        if (!this.tableExists(tableName)) {
            throw new IllegalArgumentException("The table '" + tableName + "' does not exist.");
        }
        FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
        ArrayList<Object> actualColumns = new ArrayList();
        ArrayList<String> definedColumns = new ArrayList<String>();
        if (this.getReferencedTable(tableName = tableName.toLowerCase()) == null) {
            tableType = "data";
            actualColumns = new ArrayList<String>(this.getTableDefinition(tableName));
            for (Map<String, String> m : fieldConfig.getFields()) {
                definedColumns.add(m.get("name"));
            }
        } else {
            String schema;
            tableType = "subset";
            for (Map<String, String> m : fieldConfig.getFields()) {
                if (!new Boolean(m.get("primaryKey")).booleanValue()) continue;
                definedColumns.add(m.get("name"));
            }
            if (tableName.contains(".")) {
                schema = tableName.split("\\.")[0];
                tableName = tableName.split("\\.")[1];
            } else {
                schema = this.dbConfig.getActivePGSchema();
            }
            HashSet<String> pkNames = new HashSet<String>();
            Connection conn = this.getConn();
            try {
                ResultSet res = conn.getMetaData().getImportedKeys("", schema, tableName);
                while (res.next()) {
                    pkNames.add(res.getString("FKCOLUMN_NAME"));
                }
                res = conn.getMetaData().getColumns(null, schema, tableName, null);
                while (res.next()) {
                    if (!pkNames.contains(res.getString("COLUMN_NAME"))) continue;
                    actualColumns.add(res.getString("COLUMN_NAME"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(definedColumns);
        Collections.sort(actualColumns);
        if (!definedColumns.equals(actualColumns)) {
            String columnType = tableType.equals("subset") ? "primary key " : "";
            throw new TableSchemaMismatchException("The existing " + tableType + " table \"" + tableName + "\" has the following " + columnType + "columns: \"" + StringUtils.join(actualColumns, " ") + "\". However, the CoStoSys table schema \"" + schemaName + "\" that is used to operate on that table specifies a different set of " + columnType + "columns:" + StringUtils.join(definedColumns, " ") + ". The active table schema is specified in the CoStoSys XML coniguration file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessed(String subsetTableName, ArrayList<byte[][]> primaryKeyList) {
        Connection conn = this.getConn();
        FieldConfig fieldConfig = this.fieldConfigs.get(this.activeTableSchema);
        String whereArgument = StringUtils.join((Object[])fieldConfig.expandPKNames("%s = ?"), " AND ");
        String update = "UPDATE " + subsetTableName + " SET is_processed = TRUE, is_in_process = FALSE WHERE " + whereArgument;
        try {
            conn.setAutoCommit(false);
            PreparedStatement processed = conn.prepareStatement(update);
            for (byte[][] primaryKey : primaryKeyList) {
                for (int i = 0; i < primaryKey.length; ++i) {
                    processed.setString(i + 1, new String(primaryKey[i]));
                }
                processed.addBatch();
            }
            processed.executeBatch();
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(String subsetTableName, ArrayList<byte[][]> primaryKeyList, HashMap<byte[][], String> logException) {
        Connection conn = this.getConn();
        FieldConfig fieldConfig = this.fieldConfigs.get(this.activeTableSchema);
        String whereArgument = StringUtils.join((Object[])fieldConfig.expandPKNames("%s = ?"), " AND ");
        String update = "UPDATE " + subsetTableName + " SET has_errors = TRUE, log = ? WHERE " + whereArgument;
        try {
            conn.setAutoCommit(false);
            PreparedStatement processed = conn.prepareStatement(update);
            for (byte[][] primaryKey : primaryKeyList) {
                for (int i = 0; i < primaryKey.length; ++i) {
                    processed.setString(1, logException.get(primaryKey));
                    processed.setString(i + 2, new String(primaryKey[i]));
                }
                processed.addBatch();
            }
            processed.executeBatch();
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public List<Integer> getPrimaryKeyIndices() {
        FieldConfig fieldConfig = this.fieldConfigs.get(this.activeTableSchema);
        List<Integer> pkIndices = fieldConfig.getPrimaryKeyFieldNumbers();
        return pkIndices;
    }

    public void checkTableSchemaCompatibility(String referenceSchema, String[] schemaNames) throws TableSchemaMismatchException {
        String[] schemas = new String[schemaNames.length + 1];
        schemas[0] = referenceSchema;
        System.arraycopy(schemaNames, 0, schemas, 1, schemaNames.length);
        this.checkTableSchemaCompatibility(schemas);
    }

    public void checkTableSchemaCompatibility(String ... schemaNames) throws TableSchemaMismatchException {
        if (null == schemaNames || schemaNames.length == 0) {
            LOG.warn("No table schema names were passed - nothing to check.");
            return;
        }
        List<String> referenceKey = null;
        String referenceSchemaName = null;
        ArrayList<String> notMatchingSchemaNames = new ArrayList<String>();
        for (String schemaName : schemaNames) {
            FieldConfig fieldConfig = this.fieldConfigs.get(schemaName);
            String[] primaryKey = fieldConfig.getPrimaryKey();
            List<String> asList = Arrays.asList(primaryKey);
            Collections.sort(asList);
            if (null == referenceKey) {
                referenceKey = asList;
                referenceSchemaName = schemaName;
                continue;
            }
            if (referenceKey.equals(asList)) continue;
            notMatchingSchemaNames.add(schemaName);
        }
        if (!notMatchingSchemaNames.isEmpty()) {
            throw new TableSchemaMismatchException("Found incompatibility of table schema definitions with schemas " + StringUtils.join((Object[])schemaNames, ", ") + ": There were at least one table schema pair that is not compatible to each other because their primary keys differ. The table schema \"" + referenceSchemaName + "\" has the primary key \"" + this.fieldConfigs.get(referenceSchemaName).getPrimaryKeyString() + "\" which differs from the table schema(s) \"" + StringUtils.join(notMatchingSchemaNames, ", ") + "\".");
        }
    }

    public String getDbURL() {
        return this.dbURL;
    }

    public void setDbURL(String uri) {
        this.dbURL = uri;
    }

    public void close() {
        LOG.debug("Shutting down DataBaseConnector, closing data source.");
        if (this.dataSource instanceof HikariDataSource) {
            ((HikariDataSource)this.dataSource).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseReachable() {
        Connection conn = null;
        try {
            conn = this.getConn();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.warn("Got error when trying to connect to {}: {}", (Object)this.getDbURL(), (Object)e.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.warn("Couldn't close connection: ", e);
                }
            }
        }
        return false;
    }

    public synchronized FieldConfig addXmiDocumentFieldConfiguration(List<Map<String, String>> primaryKey, boolean doGzip) {
        String referenceSchema = doGzip ? "xmi_complete_cas_gzip" : "xmi_complete_cas";
        return this.addPKAdaptedFieldConfiguration(primaryKey, referenceSchema, "-complete-cas-xmi-autogenerated");
    }

    public synchronized FieldConfig addPKAdaptedFieldConfiguration(List<Map<String, String>> primaryKey, String fieldConfigurationForAdaption, String fieldConfigurationNameSuffix) {
        FieldConfig ret;
        List pkNames = primaryKey.stream().map(map -> (String)map.get("name")).collect(Collectors.toList());
        String fieldConfigName = StringUtils.join(pkNames, "-") + fieldConfigurationNameSuffix;
        if (!this.fieldConfigs.containsKey(fieldConfigName)) {
            ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>(primaryKey);
            FieldConfig xmiConfig = this.fieldConfigs.get(fieldConfigurationForAdaption);
            HashSet<Integer> xmiConfigPkIndices = new HashSet<Integer>(xmiConfig.getPrimaryKeyFieldNumbers());
            IntStream.range(0, xmiConfig.getFields().size()).filter(i -> !xmiConfigPkIndices.contains(i)).mapToObj(i -> xmiConfig.getFields().get(i)).forEach(fields::add);
            ret = new FieldConfig(fields, "", fieldConfigName);
            this.fieldConfigs.put(ret.getName(), ret);
        } else {
            ret = this.fieldConfigs.get(this.fieldConfigs.get(fieldConfigName));
        }
        return ret;
    }

    public synchronized FieldConfig addXmiTextFieldConfiguration(List<Map<String, String>> primaryKey, boolean doGzip) {
        String referenceSchema = doGzip ? "xmi_text_gzip" : "xmi_text";
        return this.addPKAdaptedFieldConfiguration(primaryKey, referenceSchema, "-xmi-text-autogenerated");
    }

    public synchronized FieldConfig addXmiAnnotationFieldConfiguration(List<Map<String, String>> primaryKey, boolean doGzip) {
        FieldConfig ret;
        List pkNames = primaryKey.stream().map(map -> (String)map.get("name")).collect(Collectors.toList());
        String fieldConfigName = StringUtils.join(pkNames, "-") + "-xmi-annotations-autogenerated";
        if (!this.fieldConfigs.containsKey(fieldConfigName)) {
            ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
            primaryKey.stream().map(HashMap::new).forEach(fields::add);
            fields.forEach(pkField -> pkField.put("retrieve", "false"));
            FieldConfig xmiConfig = this.fieldConfigs.get(doGzip ? "xmi_annotation_gzip" : "xmi_annotation");
            HashSet<Integer> xmiConfigPkIndices = new HashSet<Integer>(xmiConfig.getPrimaryKeyFieldNumbers());
            IntStream.range(0, xmiConfig.getFields().size()).filter(i -> !xmiConfigPkIndices.contains(i)).mapToObj(i -> xmiConfig.getFields().get(i)).forEach(fields::add);
            ret = new FieldConfig(fields, "", fieldConfigName);
            this.fieldConfigs.put(ret.getName(), ret);
        } else {
            ret = this.fieldConfigs.get(this.fieldConfigs.get(fieldConfigName));
        }
        return ret;
    }

    static {
        pools = new ConcurrentHashMap<String, HikariDataSource>();
        LOG = LoggerFactory.getLogger(DataBaseConnector.class);
        commitThread = null;
        subsetColumns = new LinkedHashMap();
        subsetColumns.put("log", "text");
        subsetColumns.put("is_processed", "boolean DEFAULT false");
        subsetColumns.put("is_in_process", "boolean DEFAULT false");
        subsetColumns.put("last_component", "text DEFAULT '<none>'");
        subsetColumns.put("has_errors", "boolean DEFAULT false");
        subsetColumns.put("pid", "character varying(10)");
        subsetColumns.put("host_name", "character varying(100)");
        subsetColumns.put("processing_timestamp", "timestamp without time zone");
    }

    private class XMLPreparer {
        private final FieldConfig fieldConfig;
        private File fileOrDir;

        protected XMLPreparer(File fileOrDir, FieldConfig fieldConfig) {
            this.fileOrDir = fileOrDir;
            this.fieldConfig = fieldConfig;
        }

        protected Iterator<Map<String, Object>> prepare(String fileName) {
            String xmlFilePath = this.fileOrDir.getAbsolutePath();
            if (this.fileOrDir.isDirectory()) {
                xmlFilePath = xmlFilePath + "/" + fileName;
            }
            File xmlFile = new File(xmlFilePath);
            boolean hugeFile = false;
            if (!fileName.endsWith(".zip") && xmlFile.length() >= 0x40000000L) {
                LOG.info("File is larger than 1GB. Trying VTD huge.");
                hugeFile = true;
            }
            return JulieXMLTools.constructRowIterator(xmlFilePath, 1000, this.fieldConfig.getForEachXPath(), this.fieldConfig.getFields(), hugeFile);
        }
    }

    public static enum StatusElement {
        HAS_ERRORS,
        IS_PROCESSED,
        IN_PROCESS,
        TOTAL,
        LAST_COMPONENT;

    }
}

