/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.dataBase;

import de.julielab.xml.JulieXMLConstants;
import de.julielab.xml.JulieXMLTools;
import de.julielab.xmlData.config.FieldConfig;
import de.julielab.xmlData.dataBase.ConnectionClosable;
import de.julielab.xmlData.dataBase.DBCThreadedIterator;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Exchanger;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedColumnsIterator
extends DBCThreadedIterator<Object[]> {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadedColumnsIterator.class);
    private DataBaseConnector dbc;

    public ThreadedColumnsIterator(DataBaseConnector dbc, List<String[]> keys, List<String> fields, String table, String schemaName) {
        this(dbc, null, keys, fields, table, schemaName);
    }

    public ThreadedColumnsIterator(DataBaseConnector dbc, Connection conn, List<String[]> keys, List<String> fields, String table, String schemaName) {
        this(dbc, conn, keys, fields, table, -1L, schemaName);
    }

    public ThreadedColumnsIterator(DataBaseConnector dbc, Connection conn, List<String[]> keys, List<String> fields, String table, long limit, String schemaName) {
        LOG.trace("Initializing iterator to read {} values from table {} for the columns {}", new Object[]{keys.size(), table, fields});
        this.dbc = dbc;
        this.backgroundThread = new ResToListThread(conn, this.listExchanger, keys, fields, table, limit, schemaName);
        this.update();
    }

    public ThreadedColumnsIterator(DataBaseConnector dbc, List<String> fields, String table) {
        this(dbc, null, fields, table);
    }

    public ThreadedColumnsIterator(DataBaseConnector dbc, Connection conn, List<String> fields, String table) {
        this(dbc, conn, fields, table, -1L);
    }

    public ThreadedColumnsIterator(DataBaseConnector dbc, List<String> fields, String table, long limit) {
        this(dbc, null, fields, table, limit);
    }

    public ThreadedColumnsIterator(DataBaseConnector dbc, Connection conn, List<String> fields, String table, long limit) {
        LOG.trace("Initializing iterator to read all values from table {} for the columns {}", (Object)table, fields);
        this.dbc = dbc;
        this.backgroundThread = new ListFromDBThread(conn, this.listExchanger, fields, table, limit);
        this.update();
    }

    public void closeConnection() {
        this.backgroundThread.closeConnection();
    }

    private class ListFromDBThread
    extends Thread
    implements ConnectionClosable {
        private final Logger log = LoggerFactory.getLogger(ListFromDBThread.class);
        private final List<String> fields;
        private Boolean autoCommit;
        private Exchanger<List<Object[]>> listExchanger;
        private List<Object[]> currentList;
        private String selectFrom;
        private ResultSet res;
        private Connection conn;
        private boolean closeConnection;

        public ListFromDBThread(Connection conn, Exchanger<List<Object[]>> listExchanger, List<String> fields, String table, long limit) {
            this.listExchanger = listExchanger;
            this.fields = fields;
            this.selectFrom = String.format("SELECT %s FROM %s %s", StringUtils.join(fields, (String)","), table, limit > 0L ? " LIMIT " + limit : "");
            this.log.trace("Reading data from table {} with SQL: {}", (Object)table, (Object)this.selectFrom);
            try {
                this.closeConnection = conn == null;
                Connection connection = this.conn = conn != null ? conn : ThreadedColumnsIterator.this.dbc.getConn();
                if (conn != null) {
                    this.autoCommit = this.conn.getAutoCommit();
                }
                this.conn.setAutoCommit(false);
                Statement st = this.conn.createStatement();
                this.log.trace("Setting fetch size to {}", (Object)ThreadedColumnsIterator.this.dbc.getQueryBatchSize());
                st.setFetchSize(ThreadedColumnsIterator.this.dbc.getQueryBatchSize());
                this.res = st.executeQuery(this.selectFrom);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                while (this.updateCurrentList()) {
                    this.log.trace("Sending result list of size {} to top thread.", (Object)this.currentList.size());
                    this.listExchanger.exchange(this.currentList);
                }
                this.log.trace("No more results were retrieved from the ResultSet. Finishing retrieval.");
                this.conn.setAutoCommit(true);
                this.listExchanger.exchange(null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }

        private boolean updateCurrentList() {
            int i;
            this.currentList = new ArrayList<Object[]>();
            Function<String, Boolean> unzip = fieldName -> Boolean.parseBoolean(ThreadedColumnsIterator.this.dbc.getFieldConfiguration(ThreadedColumnsIterator.this.dbc.getActiveTableSchema()).getField((String)fieldName).get(JulieXMLConstants.GZIP));
            try {
                this.log.trace("Retrieving data from the ResultSet");
                for (i = 0; i < ThreadedColumnsIterator.this.dbc.getQueryBatchSize() && this.res.next(); ++i) {
                    Object[] columnValues = new Object[this.fields.size()];
                    for (int j = 0; j < this.fields.size(); ++j) {
                        Object o = this.res.getObject(j + 1);
                        if (unzip.apply(this.fields.get(j)).booleanValue()) {
                            o = JulieXMLTools.unGzipData((byte[])((byte[])o));
                        }
                        columnValues[j] = o;
                    }
                    this.currentList.add(columnValues);
                }
                this.log.trace("Received {} data rows from the ResultSet", (Object)this.currentList.size());
            }
            catch (IOException | SQLException e) {
                e.printStackTrace();
            }
            return i > 0;
        }

        @Override
        public void closeConnection() {
            try {
                if (this.autoCommit != null) {
                    this.conn.setAutoCommit(this.autoCommit);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (this.closeConnection) {
                    this.conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private class FromDBThread
    extends Thread
    implements ConnectionClosable {
        private final Logger log = LoggerFactory.getLogger(FromDBThread.class);
        private final boolean closeConnection;
        private Iterator<String[]> keyIter;
        private Exchanger<ResultSet> resExchanger;
        private String statement;
        private ResultSet currentRes;
        private Connection conn;
        private FieldConfig fieldConfig;
        private long limit;

        public FromDBThread(Connection conn, Exchanger<ResultSet> resExchanger, List<String[]> keys, List<String> fields, String table, long limit, String schemaName) {
            this.limit = limit;
            this.closeConnection = conn == null;
            this.conn = conn != null ? conn : ThreadedColumnsIterator.this.dbc.getConn();
            this.resExchanger = resExchanger;
            this.fieldConfig = ThreadedColumnsIterator.this.dbc.getFieldConfiguration(schemaName);
            this.statement = "SELECT " + StringUtils.join(fields, (String)",") + " FROM " + table + " WHERE ";
            this.log.trace("Retrieving data for {} primary keys from the database with SQL statement: {}", (Object)keys.size(), (Object)this.statement);
            this.keyIter = keys.iterator();
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                while (this.keyIter.hasNext()) {
                    this.currentRes = this.getFromDB();
                    this.log.trace("Sending a new ResultSet to the ResultSet reading thread");
                    this.resExchanger.exchange(this.currentRes);
                }
                this.resExchanger.exchange(null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (this.closeConnection) {
                        this.conn.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }

        private ResultSet getFromDB() {
            ResultSet rs = null;
            StringBuilder sql = new StringBuilder(this.statement);
            Object[] values = null;
            try {
                Statement st = this.conn.createStatement();
                String[] pks = this.fieldConfig.getPrimaryKey();
                for (int i = 0; this.keyIter.hasNext() && i < ThreadedColumnsIterator.this.dbc.getQueryBatchSize(); ++i) {
                    values = this.keyIter.next();
                    for (int j = 0; j < pks.length; ++j) {
                        if (this.fieldConfig.isOfStringType(pks[j])) {
                            sql.append(pks[j]).append("='").append(values[j]).append("'");
                        } else {
                            sql.append(pks[j]).append("=").append(values[j]);
                        }
                        if (j >= pks.length - 1) continue;
                        sql.append(" AND ");
                    }
                    sql.append(" OR ");
                }
                sql.delete(sql.length() - 4, sql.length());
                String limit = this.limit > 0L ? " LIMIT " + this.limit : "";
                rs = st.executeQuery(sql.toString() + limit);
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.err.println(sql.toString());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.error("Configuration file and query are incompatible.");
                String wrongLine = "";
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        wrongLine = wrongLine + values[i];
                    }
                }
                LOG.error("Error in line beginning with: " + wrongLine);
            }
            return rs;
        }

        @Override
        public void closeConnection() {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private class ResToListThread
    extends Thread
    implements ConnectionClosable {
        private final Logger log = LoggerFactory.getLogger(ResToListThread.class);
        private final List<String> fields;
        private final FromDBThread fromDBThread;
        private Exchanger<List<Object[]>> listExchanger;
        private Exchanger<ResultSet> resExchanger = new Exchanger();
        private ResultSet currentRes;
        private List<Object[]> currentList;

        ResToListThread(Connection conn, Exchanger<List<Object[]>> listExchanger, List<String[]> keys, List<String> fields, String table, long limit, String schemaName) {
            this.listExchanger = listExchanger;
            this.fields = fields;
            this.fromDBThread = new FromDBThread(conn, this.resExchanger, keys, this.fields, table, limit, schemaName);
            try {
                this.log.trace("Retrieving first ResultSet from the database thread");
                this.currentRes = this.resExchanger.exchange(null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            Function<String, Boolean> unzip = fieldName -> Boolean.parseBoolean(ThreadedColumnsIterator.this.dbc.getFieldConfiguration(ThreadedColumnsIterator.this.dbc.getActiveTableSchema()).getField((String)fieldName).get(JulieXMLConstants.GZIP));
            try {
                while (this.currentRes != null) {
                    this.log.trace("ResultSet has more entries, reading the next");
                    this.currentList = new ArrayList<Object[]>();
                    while (this.currentRes.next()) {
                        Object[] columnValues = new Object[this.fields.size()];
                        for (int i = 0; i < this.fields.size(); ++i) {
                            Object bytes = this.currentRes.getObject(i + 1);
                            if (unzip.apply(this.fields.get(i)).booleanValue()) {
                                bytes = JulieXMLTools.unGzipData((byte[])((byte[])bytes));
                            }
                            columnValues[i] = bytes;
                        }
                        this.currentList.add(columnValues);
                    }
                    if (!this.currentList.isEmpty()) {
                        this.log.trace("Sending result list to top thread");
                        this.listExchanger.exchange(this.currentList);
                    }
                    this.currentRes = this.resExchanger.exchange(null);
                }
                this.listExchanger.exchange(null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void closeConnection() {
            this.fromDBThread.closeConnection();
        }
    }
}

