/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.dataBase;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringJoiner;

public class SubsetStatus {
    private static final DecimalFormat df = new DecimalFormat("#,###,###,##0.00");
    public Long total;
    public Long inProcess;
    public Long isProcessed;
    public Long hasErrors;
    public SortedMap<String, Long> pipelineStates;

    public String toString() {
        StringJoiner sj = new StringJoiner(", ");
        if (this.hasErrors != null) {
            sj.add("have errors: " + this.hasErrors);
        }
        if (this.inProcess != null) {
            sj.add("in process: " + this.inProcess);
        }
        if (this.isProcessed != null) {
            sj.add("is processed: " + this.isProcessed);
        }
        if (this.total != null && this.inProcess != null && this.isProcessed != null) {
            sj.add("untouched: " + String.valueOf(this.total - this.inProcess - this.isProcessed));
        }
        if (this.total != null) {
            sj.add("total: " + this.total);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sj.toString());
        sb.append("\n");
        if (this.inProcess != null && this.total != null) {
            sb.append("   ");
            sb.append(String.valueOf(df.format((double)this.inProcess.longValue() / (double)this.total.longValue() * 100.0)));
            sb.append("% in process\n");
        }
        if (this.isProcessed != null && this.total != null) {
            sb.append("   ");
            sb.append(String.valueOf(df.format((double)this.isProcessed.longValue() / (double)this.total.longValue() * 100.0)));
            sb.append("% is processed\n");
        }
        if (this.pipelineStates != null) {
            sb.append("Pipeline states:\n");
            for (Map.Entry<String, Long> entry : this.pipelineStates.entrySet()) {
                sb.append("  ");
                sb.append(entry.getKey());
                sb.append(":  ");
                sb.append(entry.getValue());
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

