/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.dataBase;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class BatchInserter {
    private final int batchSize;
    private final PreparedStatement ps;
    private final Class<?>[] classes;
    private int counter;
    private boolean autoCommit;
    private boolean finished;
    private final int[] targetSqlTypes;

    public BatchInserter(PreparedStatement ps, Class<?>[] classes, int[] targetSqlTypes) throws SQLException {
        this.ps = ps;
        this.classes = classes;
        this.targetSqlTypes = targetSqlTypes;
        this.counter = 0;
        this.batchSize = 1000;
        this.autoCommit = ps.getConnection().getAutoCommit();
        this.finished = false;
        ps.getConnection().setAutoCommit(false);
    }

    public void addData(Object ... obs) throws SQLException {
        int i = 0;
        try {
            this.checkFinished();
            if (obs.length != this.classes.length) {
                throw new IllegalStateException(this.classes.length + " objects expected for insertion into database, " + obs.length + " were passed.");
            }
            for (i = 0; i < obs.length; ++i) {
                Object o = obs[i];
                if (null != o && !o.getClass().equals(this.classes[i])) {
                    throw new IllegalArgumentException("Position " + i + " of the PreparedStatement expects an instance of class '" + this.classes[i].getCanonicalName() + "', however an instance of class '" + o.getClass().getCanonicalName() + "' has been passed.");
                }
                if (null != this.targetSqlTypes) {
                    this.ps.setObject(i + 1, o, this.targetSqlTypes[i]);
                    continue;
                }
                this.ps.setObject(i + 1, o);
            }
            this.ps.addBatch();
            ++this.counter;
            if (this.counter == this.batchSize) {
                this.commit();
                this.counter = 0;
            }
        }
        catch (PSQLException e) {
            throw new PSQLException(e.getMessage() + " (Parameter " + (i + 1) + " (index 1-basiert))", new PSQLState(e.getSQLState()), (Throwable)e);
        }
    }

    public void commitTail() throws SQLException {
        this.checkFinished();
        this.commit();
        this.ps.getConnection().setAutoCommit(this.autoCommit);
        this.finished = true;
    }

    private void commit() throws SQLException {
        this.checkFinished();
        Connection connection = this.ps.getConnection();
        this.ps.executeBatch();
        connection.commit();
    }

    private void checkFinished() {
        if (this.finished) {
            throw new IllegalStateException("This BatchInserter has finished its work and cannot be used any more.");
        }
    }
}

