/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.config;

import com.ximpleware.AutoPilot;
import com.ximpleware.EOFException;
import com.ximpleware.EncodingException;
import com.ximpleware.EntityException;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.PilotException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.xml.JulieXMLTools;
import de.julielab.xmlData.config.ConfigBase;
import de.julielab.xmlData.config.TableSchemaDoesNotExistException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldConfig
extends ConfigBase {
    private static final Logger log = LoggerFactory.getLogger(FieldConfig.class);
    private static final String XPATH_CONF_SCHEMA_INFO = "//DBSchemaInformation";
    private static final String XPATH_CONF_SCHEMES = "//DBSchemaInformation/tableSchemas";
    private static final String XPATH_CONF_SCHEME = "//DBSchemaInformation/tableSchemas/tableSchema";
    private static final String XPATH_CONF_FIELD_TEMPLATE = "//DBSchemaInformation/tableSchemas/tableSchema[@name='%s']/field";
    private static final String XPATH_CONF_ACTIVE_SCHEME_TEMPLATE = "//DBSchemaInformation/tableSchemas/tableSchema[@name='%s']";
    private List<Map<String, String>> fields;
    private Map<String, Map<String, String>> fieldNameMap;
    private String forEachXPath;
    private String[] primaryKey;
    private String[] columns;
    private String[] columnsToRetrieve;
    private String timestampFieldName = null;
    private List<Integer> primaryKeyFieldNumbers = null;
    private byte[] configData;
    private final String name;

    public String getName() {
        return this.name;
    }

    public FieldConfig(byte[] configData, String schemaName) throws VTDException {
        this.configData = configData;
        this.name = schemaName;
        this.buildFields(configData, schemaName);
    }

    public FieldConfig(List<Map<String, String>> fields, String forEachXPath, String schemaName) {
        this.forEachXPath = forEachXPath;
        this.name = schemaName;
        this.fields = fields;
        this.fieldNameMap = new HashMap<String, Map<String, String>>();
        for (Map<String, String> field2 : fields) {
            String name = field2.get("name");
            if (name == null) {
                throw new IllegalArgumentException("The passed field configuration contains the field \"" + field2 + "\" that does specify the required \"" + "name" + "\" property");
            }
            if (field2.get("type") == null) {
                throw new IllegalArgumentException("The passed field configuration contains the field \"" + field2 + "\" that does specify the required \"" + "type" + "\" property");
            }
            this.fieldNameMap.put(name, field2);
            if (field2.get("timestamp") == null || !Boolean.parseBoolean(field2.get("timestamp"))) continue;
            this.timestampFieldName = name;
        }
        this.primaryKey = (String[])fields.stream().filter(field -> Boolean.parseBoolean((String)field.get("primaryKey"))).map(field -> (String)field.get("name")).toArray(String[]::new);
        this.columns = (String[])fields.stream().map(field -> (String)field.get("name")).toArray(String[]::new);
        this.columnsToRetrieve = (String[])fields.stream().filter(field -> Boolean.parseBoolean((String)field.get("retrieve"))).map(field -> (String)field.get("name")).toArray(String[]::new);
        this.primaryKeyFieldNumbers = new ArrayList<Integer>();
        for (int i = 0; i < fields.size(); ++i) {
            Map<String, String> field2;
            field2 = fields.get(i);
            if (!Boolean.parseBoolean(field2.get("primaryKey"))) continue;
            this.primaryKeyFieldNumbers.add(i);
        }
    }

    private void buildFields(byte[] mergedConfData, String activeSchemeName) throws EncodingException, EOFException, EntityException, ParseException, XPathParseException, XPathEvalException, NavException, PilotException {
        int attrIndex;
        VTDGen vg = new VTDGen();
        vg.setDoc(mergedConfData);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.selectXPath(String.format(XPATH_CONF_ACTIVE_SCHEME_TEMPLATE, activeSchemeName));
        if (ap.evalXPath() != -1 && (attrIndex = vn.getAttrVal("forEach")) != -1) {
            this.forEachXPath = vn.toString(attrIndex);
        }
        ap.selectXPath(String.format(XPATH_CONF_FIELD_TEMPLATE, activeSchemeName));
        AutoPilot ap2 = new AutoPilot(vn);
        this.fields = new ArrayList<Map<String, String>>();
        this.fieldNameMap = new HashMap<String, Map<String, String>>();
        boolean xPathFound = false;
        while (ap.evalXPath() != -1) {
            xPathFound = true;
            LinkedHashMap<String, String> field = new LinkedHashMap<String, String>();
            String fieldName = null;
            int i = -1;
            ap2.selectAttr("*");
            while ((i = ap2.iterateAttr()) != -1) {
                String attrName = vn.toString(i);
                String attrValue = vn.toRawString(i + 1);
                if (attrName.equals("type") && !FieldConfig.isKnownType(attrValue)) {
                    throw new IllegalArgumentException("Type \"" + attrValue + "\" is not supported by this tool.");
                }
                field.put(attrName, attrValue);
                if (attrName.equals("name")) {
                    fieldName = attrValue;
                }
                if (!attrName.equals("timestamp") || !Boolean.parseBoolean(attrValue)) continue;
                this.timestampFieldName = fieldName;
            }
            this.fields.add(field);
            this.fieldNameMap.put(fieldName, field);
        }
        if (!xPathFound) {
            throw new TableSchemaDoesNotExistException("No field schema with name \"" + activeSchemeName + "\" was found.");
        }
    }

    public List<Map<String, String>> getFields() {
        return this.fields;
    }

    public Map<String, String> getField(String fieldName) {
        return this.fieldNameMap.get(fieldName);
    }

    public String getForEachXPath() {
        return this.forEachXPath;
    }

    public void setForEachXPath(String forEachXPath) {
        this.forEachXPath = forEachXPath;
    }

    public static boolean isKnownType(String type) {
        return FieldConfig.isStringType(type) || FieldConfig.isTimestampWithoutTZType(type) || FieldConfig.isStringTypeArray(type) || FieldConfig.isIntegerType(type) || FieldConfig.isBooleanType(type) || FieldConfig.isBinaryDataType(type) || FieldConfig.isXmlType(type);
    }

    public static boolean isBinaryDataType(String type) {
        return type.equals("bytea");
    }

    public static boolean isStringTypeArray(String type) {
        return type.equals("text[]") || type.equals("varchar[]");
    }

    public static boolean isXmlType(String type) {
        return type.equals("xml");
    }

    public static boolean isBooleanType(String type) {
        return type.equals("boolean");
    }

    public static boolean isTimestampWithoutTZType(String type) {
        return type.equals("timestamp without time zone");
    }

    public boolean isOfTimestampWithoutTZType(String fieldName) {
        return FieldConfig.isTimestampWithoutTZType(this.fieldNameMap.get(fieldName).get("type"));
    }

    public static boolean isStringType(String type) {
        return type.equals("text");
    }

    public static boolean isIntegerType(String type) {
        return type.equals("integer");
    }

    public boolean isOfStringType(String fieldName) {
        return FieldConfig.isStringType(this.fieldNameMap.get(fieldName).get("type"));
    }

    public boolean isOfStringType(Map<String, String> field) {
        return FieldConfig.isStringType(field.get("type"));
    }

    public boolean isOfIntegerType(Map<String, String> field) {
        return FieldConfig.isIntegerType(field.get("type"));
    }

    public boolean isOfBinaryDataType(Map<String, String> field) {
        return FieldConfig.isBinaryDataType(field.get("type"));
    }

    public String[] getPrimaryKey() {
        if (this.primaryKey == null) {
            this.primaryKey = (String[])this.getPrimaryKeyFields().map(field -> (String)field.get("name")).toArray(String[]::new);
        }
        return this.primaryKey;
    }

    public Stream<Map<String, String>> getPrimaryKeyFields() {
        return this.fields.stream().filter(field -> Boolean.parseBoolean((String)field.get("primaryKey")));
    }

    public List<Integer> getPrimaryKeyFieldNumbers() {
        if (this.primaryKeyFieldNumbers == null) {
            ArrayList<Integer> fieldNumbers = new ArrayList<Integer>();
            int i = 0;
            for (Map<String, String> field : this.fields) {
                if (Boolean.parseBoolean(field.get("primaryKey"))) {
                    fieldNumbers.add(i);
                }
                ++i;
            }
            this.primaryKeyFieldNumbers = fieldNumbers;
        }
        return this.primaryKeyFieldNumbers;
    }

    public String[] getColumnsToRetrieve() {
        if (this.columnsToRetrieve == null) {
            ArrayList<String> retrieveColumnNames = new ArrayList<String>();
            for (Map<String, String> field : this.fields) {
                if (!Boolean.parseBoolean(field.get("retrieve"))) continue;
                retrieveColumnNames.add(field.get("name"));
            }
            this.columnsToRetrieve = new String[retrieveColumnNames.size()];
            retrieveColumnNames.toArray(this.columnsToRetrieve);
        }
        return this.columnsToRetrieve;
    }

    public List<Map<String, String>> getFieldsToRetrieve() {
        ArrayList<Map<String, String>> fieldsToRetrieve = new ArrayList<Map<String, String>>();
        for (Map<String, String> field : this.fields) {
            if (!Boolean.parseBoolean(field.get("retrieve"))) continue;
            fieldsToRetrieve.add(field);
        }
        return fieldsToRetrieve;
    }

    public String getPrimaryKeyString() {
        return StringUtils.join((Object[])this.getPrimaryKey(), (String)",");
    }

    public String[] expandPKNames(String[] fmtStrs) {
        return JulieXMLTools.expandArrayEntries((Object[])this.getPrimaryKey(), (String[])fmtStrs);
    }

    public String[] expandPKNames(String fmtStr) {
        return JulieXMLTools.expandArrayEntries((Object[])this.getPrimaryKey(), (String)fmtStr);
    }

    public String getTimestampFieldName() {
        return this.timestampFieldName;
    }

    public String toString() {
        ArrayList<String> strList = new ArrayList<String>();
        strList.add("Schema configuration for \"" + this.name + "\":");
        for (Map<String, String> field : this.fields) {
            strList.add("\n");
            strList.add("Field \"" + field.get("name") + "\":");
            for (String attr : field.keySet()) {
                strList.add(attr + "=\"" + field.get(attr) + "\"");
            }
        }
        return StringUtils.join(strList, (String)"\n");
    }

    public String getConfigText() {
        if (this.configData != null) {
            return new String(this.configData);
        }
        return "<no XML definition available>";
    }

    public String[] getColumns() {
        if (this.columns == null) {
            ArrayList<String> columnNames = new ArrayList<String>();
            for (Map<String, String> field : this.fields) {
                columnNames.add(field.get("name"));
            }
            this.columns = new String[columnNames.size()];
            columnNames.toArray(this.columns);
        }
        return this.columns;
    }

    public static Map<String, String> createField(String ... configuration) {
        if (configuration.length % 2 == 1) {
            throw new IllegalArgumentException("An even number of arguments is required. The even indexes are field property keys, the odd indexes are the values to the previous key.");
        }
        HashMap<String, String> field = new HashMap<String, String>();
        for (int i = 0; i < configuration.length; i += 2) {
            String s = configuration[i];
            field.put(s, configuration[i + 1]);
        }
        return field;
    }
}

