/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.config;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathParseException;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigBase {
    protected static final Logger LOG = LoggerFactory.getLogger(DataBaseConnector.class);

    protected byte[] extractConfigData(byte[] confData, String xpath) throws IOException, VTDException {
        VTDGen vg = new VTDGen();
        vg.setDoc(confData);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.selectXPath(xpath);
        StringBuilder sb = new StringBuilder();
        while (ap.evalXPath() != -1) {
            long fragment = vn.getElementFragment();
            int offset = (int)fragment;
            int length = (int)(fragment >> 32);
            sb.append(vn.toRawString(offset, length));
        }
        byte[] configData = sb.toString().getBytes();
        return configData;
    }

    public static String getActiveConfig(byte[] data, String activePath) throws IOException, VTDException {
        int textNodeIndex;
        VTDGen vg = new VTDGen();
        vg.setDoc(data);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.selectXPath(activePath);
        if (ap.evalXPath() != -1 && (textNodeIndex = vn.getText()) != -1) {
            return vn.toRawString(textNodeIndex);
        }
        return null;
    }

    protected String stringFromXpath(AutoPilot ap, String xpath) throws XPathParseException {
        ap.selectXPath(xpath);
        String string = ap.evalXPathToString();
        ap.resetXPath();
        return string;
    }
}

