/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.cli;

import com.ximpleware.AutoPilot;
import com.ximpleware.EOFException;
import com.ximpleware.EncodingException;
import com.ximpleware.EntityException;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.xml.JulieXMLTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;

public class QueryPubMed {
    private static final String SITE = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi";
    private static final String RETMAX = "100000000";
    private static final int BUFFERSIZE = 1024;
    private static final String XPATH = "/eSearchResult/IdList/Id";

    public static ArrayList<String> query(String query) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(SITE).append("?term=").append(URLEncoder.encode(query, "UTF-8")).append("&retmax=").append(RETMAX).append("&tool=julie-medline-manager").append("&email=julielab@listserv.uni-jena.de");
            URL url = new URL(queryBuilder.toString());
            InputStream stream = url.openStream();
            VTDGen vg = new VTDGen();
            vg.setDoc(JulieXMLTools.readStream((InputStream)stream, (int)1024));
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            ap.selectXPath(XPATH);
            while (ap.evalXPath() != -1) {
                long fragment = vn.getContentFragment();
                int offset = (int)fragment;
                int length = (int)(fragment >> 32);
                ids.add(vn.toString(offset, length));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EncodingException e) {
            e.printStackTrace();
        }
        catch (EOFException e) {
            e.printStackTrace();
        }
        catch (EntityException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (XPathParseException e) {
            e.printStackTrace();
        }
        catch (XPathEvalException e) {
            e.printStackTrace();
        }
        catch (NavException e) {
            e.printStackTrace();
        }
        return ids;
    }
}

