/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.xml.AbstractFieldValueSource;
import de.julielab.xml.Options;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

class XPathNavigator
extends AbstractFieldValueSource {
    private VTDNav vn;
    private AutoPilot apFE;
    private AutoPilot apXP;
    private Options options;

    public XPathNavigator(VTDNav nv, AutoPilot apForEach, AutoPilot apXPath, Options options) throws XPathEvalException, NavException, XPathEvalException, NavException, XPathParseException {
        this.vn = nv;
        this.apFE = apForEach;
        this.apXP = apXPath;
        this.options = options;
    }

    @Override
    public Object getFieldValue() throws XPathEvalException, NavException, NavException, IOException, XPathEvalException {
        ArrayList<String> retList = new ArrayList<String>();
        while (this.apFE.evalXPath() != -1) {
            if (this.options.returnXMLFragment) {
                long fragment = this.vn.getElementFragment();
                int offset = (int)fragment;
                int length = (int)(fragment >> 32);
                retList.add(this.options.resolveEntities ? this.vn.toString(offset, length) : this.vn.toRawString(offset, length));
            } else {
                retList.add(this.apXP.evalXPathToString());
            }
            this.apXP.resetXPath();
        }
        this.apFE.resetXPath();
        Object retobj = null;
        if (retList.size() > 0) {
            retobj = this.options.returnArray ? retList.toArray(new String[retList.size()]) : (retList.size() > 1 ? StringUtils.join(retList, this.options.concatString) : retList.get(0));
            if (this.options.performGzip) {
                return this.gzipContent(retobj);
            }
            return retobj;
        }
        return null;
    }
}

