/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.util.FastList;
import com.zaxxer.hikari.util.QueuedSequenceSynchronizer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentBag<T extends IConcurrentBagEntry>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentBag.class);
    private final QueuedSequenceSynchronizer synchronizer;
    private final CopyOnWriteArrayList<T> sharedList;
    private final boolean weakThreadLocals;
    private final ThreadLocal<List> threadList;
    private final IBagStateListener listener;
    private volatile boolean closed;

    public ConcurrentBag(IBagStateListener listener) {
        this.listener = listener;
        this.weakThreadLocals = this.useWeakThreadLocals();
        this.sharedList = new CopyOnWriteArrayList();
        this.synchronizer = new QueuedSequenceSynchronizer();
        this.threadList = this.weakThreadLocals ? new ThreadLocal() : new ThreadLocal<List>(){

            @Override
            protected List initialValue() {
                return new FastList(IConcurrentBagEntry.class, 16);
            }
        };
    }

    public T borrow(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!this.synchronizer.hasQueuedThreads()) {
            ArrayList list = this.threadList.get();
            if (this.weakThreadLocals && list == null) {
                list = new ArrayList(16);
                this.threadList.set(list);
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                IConcurrentBagEntry bagEntry = (IConcurrentBagEntry)(this.weakThreadLocals ? ((WeakReference)list.remove(i)).get() : list.remove(i));
                if (bagEntry == null || !bagEntry.compareAndSet(0, 1)) continue;
                return (T)bagEntry;
            }
        }
        timeout = timeUnit.toNanos(timeout);
        Future<Boolean> addItemFuture = null;
        long startScan = System.nanoTime();
        long originTimeout = timeout;
        while (true) {
            long startSeq = this.synchronizer.currentSequence();
            for (IConcurrentBagEntry bagEntry : this.sharedList) {
                if (!bagEntry.compareAndSet(0, 1)) continue;
                return (T)bagEntry;
            }
            if (startSeq < this.synchronizer.currentSequence()) continue;
            if (addItemFuture == null || addItemFuture.isDone()) {
                addItemFuture = this.listener.addBagItem();
            }
            if ((timeout = originTimeout - (System.nanoTime() - startScan)) <= 1000L || !this.synchronizer.waitUntilSequenceExceeded(startSeq, timeout)) break;
        }
        return null;
    }

    public void requite(T bagEntry) {
        if (bagEntry.compareAndSet(1, 0)) {
            List threadLocalList = this.threadList.get();
            if (threadLocalList != null) {
                threadLocalList.add(this.weakThreadLocals ? new WeakReference<T>(bagEntry) : bagEntry);
            }
            this.synchronizer.signal();
        } else {
            LOGGER.warn("Attempt to remove an object from the bag that does not exist: {}", (Object)bagEntry);
        }
    }

    public void add(T bagEntry) {
        if (this.closed) {
            LOGGER.info("ConcurrentBag has been closed, ignoring add()");
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.sharedList.add(bagEntry);
        this.synchronizer.signal();
    }

    public boolean remove(T bagEntry) {
        if (!(bagEntry.compareAndSet(1, -1) || bagEntry.compareAndSet(-2, -1) || this.closed)) {
            LOGGER.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", (Object)bagEntry);
            return false;
        }
        boolean removed = this.sharedList.remove(bagEntry);
        if (!removed && !this.closed) {
            LOGGER.warn("Attempt to remove an object from the bag that does not exist: {}", (Object)bagEntry);
        }
        return removed;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public List<T> values(int state) {
        ArrayList<IConcurrentBagEntry> list = new ArrayList<IConcurrentBagEntry>(this.sharedList.size());
        for (IConcurrentBagEntry reference : this.sharedList) {
            if (reference.getState() != state) continue;
            list.add(reference);
        }
        return list;
    }

    public List<T> values() {
        return (List)this.sharedList.clone();
    }

    public boolean reserve(T bagEntry) {
        return bagEntry.compareAndSet(0, -2);
    }

    public void unreserve(T bagEntry) {
        if (bagEntry.compareAndSet(-2, 0)) {
            this.synchronizer.signal();
        } else {
            LOGGER.warn("Attempt to relinquish an object to the bag that was not reserved: {}", (Object)bagEntry);
        }
    }

    public int getPendingQueue() {
        return this.synchronizer.getQueueLength();
    }

    public int getCount(int state) {
        int count = 0;
        for (IConcurrentBagEntry reference : this.sharedList) {
            if (reference.getState() != state) continue;
            ++count;
        }
        return count;
    }

    public int size() {
        return this.sharedList.size();
    }

    public void dumpState() {
        for (IConcurrentBagEntry bagEntry : this.sharedList) {
            LOGGER.info(bagEntry.toString());
        }
    }

    private boolean useWeakThreadLocals() {
        try {
            if (System.getProperty("com.zaxxer.hikari.useWeakReferences") != null) {
                return Boolean.getBoolean("com.zaxxer.hikari.useWeakReferences");
            }
            return this.getClass().getClassLoader() != ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException se) {
            return true;
        }
    }

    public static interface IBagStateListener {
        public Future<Boolean> addBagItem();
    }

    public static interface IConcurrentBagEntry {
        public static final int STATE_NOT_IN_USE = 0;
        public static final int STATE_IN_USE = 1;
        public static final int STATE_REMOVED = -1;
        public static final int STATE_RESERVED = -2;

        public boolean compareAndSet(int var1, int var2);

        public int getState();
    }
}

