/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xmlData.dataBase;

import de.julielab.xml.JulieXMLConstants;
import de.julielab.xml.JulieXMLTools;
import de.julielab.xmlData.config.FieldConfig;
import de.julielab.xmlData.dataBase.DBCThreadedIterator;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Exchanger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedColumnsToRetrieveIterator
extends DBCThreadedIterator<byte[][]> {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadedColumnsToRetrieveIterator.class);
    private DataBaseConnector dbc;

    public ThreadedColumnsToRetrieveIterator(DataBaseConnector dbc, List<Object[]> ids, String table, String schemaName) {
        this.dbc = dbc;
        String[] tables = new String[1];
        String[] schemaNames = new String[1];
        tables[0] = table;
        schemaNames[0] = schemaName;
        this.backgroundThread = new ArrayResToListThread(this.listExchanger, ids, tables, null, schemaNames);
        this.update();
    }

    public ThreadedColumnsToRetrieveIterator(DataBaseConnector dbc, List<Object[]> ids, String table, String whereClause, String schemaName) {
        this.dbc = dbc;
        String[] tables = new String[1];
        String[] schemaNames = new String[1];
        tables[0] = table;
        schemaNames[0] = schemaName;
        this.backgroundThread = new ArrayResToListThread(this.listExchanger, ids, tables, whereClause, schemaNames);
        this.update();
    }

    public ThreadedColumnsToRetrieveIterator(DataBaseConnector dbc, List<Object[]> ids, String[] tables, String[] schemaNames) {
        this.dbc = dbc;
        this.backgroundThread = new ArrayResToListThread(this.listExchanger, ids, tables, null, schemaNames);
        this.update();
    }

    @Override
    public void close() {
        super.close();
        ((ArrayResToListThread)this.backgroundThread).end();
    }

    private class ArrayFromDBThread
    extends Thread {
        private Iterator<Object[]> keyIter;
        private Exchanger<ResultSet> resExchanger;
        private StringBuilder queryBuilder;
        private ResultSet currentRes;
        private String selectFrom;
        private Connection conn;
        private String whereClause = null;
        private FieldConfig fieldConfig;
        private volatile boolean end;
        private boolean joined = false;
        private String dataTable;
        private String dataSchema;

        public ArrayFromDBThread(Exchanger<ResultSet> resExchanger, List<Object[]> keyList, String[] table, String whereClause, String[] schemaName) {
            this.conn = ThreadedColumnsToRetrieveIterator.this.dbc.getConn();
            this.resExchanger = resExchanger;
            this.keyIter = keyList.iterator();
            this.queryBuilder = new StringBuilder();
            this.whereClause = whereClause;
            this.dataTable = table[0];
            this.dataSchema = schemaName[0];
            if (table.length > 1 && schemaName.length > 1) {
                this.joined = true;
            }
            this.buildSelectFrom(table, schemaName);
            this.setDaemon(true);
            this.start();
        }

        private void buildSelectFrom(String[] table, String[] schemaName) {
            if (!this.joined) {
                this.fieldConfig = ThreadedColumnsToRetrieveIterator.this.dbc.getFieldConfiguration(this.dataSchema);
                this.selectFrom = "SELECT " + StringUtils.join((Object[])this.fieldConfig.getColumnsToRetrieve(), ",") + " FROM " + this.dataTable + " WHERE ";
            } else {
                String[] primaryKey = null;
                ArrayList<String> select = new ArrayList<String>();
                ArrayList<String> leftJoin = new ArrayList<String>();
                for (int i = 0; i < table.length; ++i) {
                    this.fieldConfig = ThreadedColumnsToRetrieveIterator.this.dbc.getFieldConfiguration(schemaName[i]);
                    String[] columnsToRetrieve = this.fieldConfig.getColumnsToRetrieve();
                    for (int j = 0; j < columnsToRetrieve.length; ++j) {
                        String column = table[i] + "." + columnsToRetrieve[j];
                        select.add(column);
                    }
                    if (i == 0) {
                        primaryKey = this.fieldConfig.getPrimaryKey();
                        continue;
                    }
                    String primaryKeyMatch = "";
                    for (int j = 0; j < primaryKey.length; ++j) {
                        primaryKeyMatch = table[0] + "." + primaryKey[j] + "=" + table[i] + "." + primaryKey[j];
                        if (j == primaryKey.length - 1) continue;
                        primaryKeyMatch = primaryKeyMatch + " AND ";
                    }
                    String join = "LEFT JOIN " + table[i] + " ON " + primaryKeyMatch;
                    leftJoin.add(join);
                }
                this.selectFrom = "SELECT " + StringUtils.join(select, ",") + " FROM " + table[0] + " " + StringUtils.join(leftJoin, " ") + " WHERE ";
                LOG.trace("Querying data via SQL: {}", (Object)this.selectFrom);
            }
        }

        @Override
        public void run() {
            try {
                while (this.keyIter.hasNext() && !this.end) {
                    this.currentRes = this.getFromDB();
                    this.resExchanger.exchange(this.currentRes);
                }
                this.resExchanger.exchange(null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }

        private ResultSet getFromDB() {
            ResultSet res = null;
            String sql = null;
            try {
                this.queryBuilder.delete(0, this.queryBuilder.capacity());
                Statement stmt = this.conn.createStatement();
                ArrayList<String> pkConjunction = new ArrayList<String>();
                for (int i = 0; this.keyIter.hasNext() && i < ThreadedColumnsToRetrieveIterator.this.dbc.getQueryBatchSize(); ++i) {
                    String fieldName;
                    int j;
                    Object[] keys = this.keyIter.next();
                    Object[] nameValuePairs = new String[keys.length];
                    if (!this.joined) {
                        for (j = 0; j < keys.length; ++j) {
                            fieldName = this.fieldConfig.getPrimaryKey()[j];
                            nameValuePairs[j] = String.format("%s = '%s'", fieldName, keys[j]);
                        }
                    } else {
                        for (j = 0; j < keys.length; ++j) {
                            fieldName = this.fieldConfig.getPrimaryKey()[j];
                            nameValuePairs[j] = String.format("%s = '%s'", this.dataTable + "." + fieldName, keys[j]);
                        }
                    }
                    pkConjunction.add("(" + StringUtils.join(nameValuePairs, " AND ") + ")");
                }
                this.queryBuilder.append(this.selectFrom);
                this.queryBuilder.append("(");
                this.queryBuilder.append(StringUtils.join(pkConjunction, " OR "));
                this.queryBuilder.append(")");
                if (this.whereClause != null) {
                    this.queryBuilder.append(" AND " + this.whereClause);
                }
                sql = this.queryBuilder.toString();
                LOG.trace("Fetching data with command \"{}\"", (Object)sql);
                res = stmt.executeQuery(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                LOG.error("SQL: " + sql);
            }
            return res;
        }

        public void end() {
            this.end = true;
        }
    }

    private class ArrayResToListThread
    extends Thread {
        private final ArrayFromDBThread arrayFromDBThread;
        private Exchanger<List<byte[][]>> listExchanger;
        private Exchanger<ResultSet> resExchanger = new Exchanger();
        private ResultSet currentRes;
        private ArrayList<byte[][]> currentList;
        private String[] schemaName;
        private boolean joined = false;
        private volatile boolean end = false;

        ArrayResToListThread(Exchanger<List<byte[][]>> listExchanger, List<Object[]> keyList, String[] tables, String whereClause, String[] schemaName) {
            this.listExchanger = listExchanger;
            this.schemaName = schemaName;
            if (tables.length > 1) {
                this.joined = true;
            }
            this.arrayFromDBThread = new ArrayFromDBThread(this.resExchanger, keyList, tables, whereClause, schemaName);
            try {
                this.currentRes = this.resExchanger.exchange(null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            Pair<Integer, List<Map<String, String>>> numColumnsAndFields = ThreadedColumnsToRetrieveIterator.this.dbc.getNumColumnsAndFields(this.joined, this.schemaName);
            int numColumns = numColumnsAndFields.getLeft();
            List<Map<String, String>> fields = numColumnsAndFields.getRight();
            int i = 0;
            Object retrievedData = null;
            try {
                while (this.currentRes != null && !this.end) {
                    this.currentList = new ArrayList();
                    while (this.currentRes.next()) {
                        retrievedData = new byte[numColumns][];
                        for (i = 0; i < ((byte[][])retrievedData).length; ++i) {
                            retrievedData[i] = this.currentRes.getBytes(i + 1);
                            if (!Boolean.parseBoolean(fields.get(i).get(JulieXMLConstants.GZIP)) || retrievedData[i] == null) continue;
                            retrievedData[i] = JulieXMLTools.unGzipData(retrievedData[i]);
                        }
                        this.currentList.add((byte[][])retrievedData);
                    }
                    if (!this.currentList.isEmpty()) {
                        this.listExchanger.exchange(this.currentList);
                    }
                    this.currentRes = this.resExchanger.exchange(null);
                }
                this.listExchanger.exchange(null);
            }
            catch (IOException | InterruptedException | SQLException e) {
                LOG.error("Exception occured while reading data from result set, index {}. Corresponding field in schema definition is: {}. Read data was: \"{}\"", i + 1, fields.get(i), new String(retrievedData[i]));
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                LOG.debug("NPE on: Index {}, field {}, data {}", i, fields.get(i), retrievedData != null ? retrievedData[i] : null);
                throw e;
            }
        }

        public void end() {
            this.arrayFromDBThread.end();
            this.end = true;
        }
    }
}

