/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.pool.LeakTask;
import com.zaxxer.hikari.pool.PoolBagEntry;
import com.zaxxer.hikari.proxy.ClosedConnection;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.ProxyFactory;
import com.zaxxer.hikari.util.ClockSource;
import com.zaxxer.hikari.util.FastList;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionProxy
implements IHikariConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProxy.class);
    private static final Set<String> SQL_ERRORS;
    private static final ClockSource clockSource;
    protected Connection delegate;
    private final LeakTask leakTask;
    private final PoolBagEntry poolEntry;
    private final FastList<Statement> openStatements;
    private long lastAccess;
    private boolean isCommitStateDirty;
    private boolean isConnectionStateDirty;

    protected ConnectionProxy(PoolBagEntry bagEntry, LeakTask leakTask, long now) {
        this.poolEntry = bagEntry;
        this.leakTask = leakTask;
        this.lastAccess = now;
        this.delegate = bagEntry.connection;
        this.openStatements = bagEntry.openStatements;
    }

    public final String toString() {
        return new StringBuilder(64).append(this.getClass().getSimpleName()).append('@').append(System.identityHashCode(this)).append(" wrapping ").append(this.delegate).toString();
    }

    @Override
    public final PoolBagEntry getPoolBagEntry() {
        return this.poolEntry;
    }

    @Override
    public final SQLException checkException(SQLException sqle) {
        String sqlState = sqle.getSQLState();
        if (sqlState != null) {
            boolean isForceClose;
            boolean bl = isForceClose = sqlState.startsWith("08") || SQL_ERRORS.contains(sqlState);
            if (isForceClose) {
                this.poolEntry.evict = true;
                LOGGER.warn("{} - Connection {} marked as broken because of SQLSTATE({}), ErrorCode({})", this.poolEntry.parentPool, this.poolEntry, sqlState, sqle.getErrorCode(), sqle);
            } else {
                SQLException nse = sqle.getNextException();
                if (nse != null && nse != sqle) {
                    this.checkException(nse);
                }
            }
        }
        return sqle;
    }

    @Override
    public final void untrackStatement(Statement statement) {
        this.openStatements.remove(statement);
    }

    @Override
    public final void markCommitStateDirty() {
        this.isCommitStateDirty = true;
    }

    private final <T extends Statement> T trackStatement(T statement) {
        this.openStatements.add(statement);
        return statement;
    }

    private final void closeOpenStatements() {
        int size = this.openStatements.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                try {
                    Statement statement = this.openStatements.get(i);
                    if (statement == null) continue;
                    statement.close();
                    continue;
                }
                catch (SQLException e) {
                    this.checkException(e);
                }
            }
            this.openStatements.clear();
        }
    }

    @Override
    public final void close() throws SQLException {
        if (this.delegate != ClosedConnection.CLOSED_CONNECTION) {
            this.leakTask.cancel();
            try {
                this.closeOpenStatements();
                if (this.isCommitStateDirty) {
                    this.lastAccess = clockSource.currentTime();
                    if (!this.poolEntry.isAutoCommit) {
                        this.delegate.rollback();
                        LOGGER.debug("{} - Executed rollback on connection {} due to dirty commit state on close().", (Object)this.poolEntry.parentPool, (Object)this.delegate);
                    }
                }
                if (this.isConnectionStateDirty) {
                    this.poolEntry.resetConnectionState();
                    this.lastAccess = clockSource.currentTime();
                }
                this.delegate.clearWarnings();
            }
            catch (SQLException e) {
                if (!this.poolEntry.evict) {
                    throw this.checkException(e);
                }
            }
            finally {
                this.delegate = ClosedConnection.CLOSED_CONNECTION;
                this.poolEntry.releaseConnection(this.lastAccess);
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate == ClosedConnection.CLOSED_CONNECTION;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return ProxyFactory.getProxyStatement(this, this.trackStatement(this.delegate.createStatement()));
    }

    @Override
    public Statement createStatement(int resultSetType, int concurrency) throws SQLException {
        return ProxyFactory.getProxyStatement(this, this.trackStatement(this.delegate.createStatement(resultSetType, concurrency)));
    }

    @Override
    public Statement createStatement(int resultSetType, int concurrency, int holdability) throws SQLException {
        return ProxyFactory.getProxyStatement(this, this.trackStatement(this.delegate.createStatement(resultSetType, concurrency, holdability)));
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return ProxyFactory.getProxyCallableStatement(this, this.trackStatement(this.delegate.prepareCall(sql)));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int concurrency) throws SQLException {
        return ProxyFactory.getProxyCallableStatement(this, this.trackStatement(this.delegate.prepareCall(sql, resultSetType, concurrency)));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int concurrency, int holdability) throws SQLException {
        return ProxyFactory.getProxyCallableStatement(this, this.trackStatement(this.delegate.prepareCall(sql, resultSetType, concurrency, holdability)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return ProxyFactory.getProxyPreparedStatement(this, this.trackStatement(this.delegate.prepareStatement(sql)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return ProxyFactory.getProxyPreparedStatement(this, this.trackStatement(this.delegate.prepareStatement(sql, autoGeneratedKeys)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int concurrency) throws SQLException {
        return ProxyFactory.getProxyPreparedStatement(this, this.trackStatement(this.delegate.prepareStatement(sql, resultSetType, concurrency)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int concurrency, int holdability) throws SQLException {
        return ProxyFactory.getProxyPreparedStatement(this, this.trackStatement(this.delegate.prepareStatement(sql, resultSetType, concurrency, holdability)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return ProxyFactory.getProxyPreparedStatement(this, this.trackStatement(this.delegate.prepareStatement(sql, columnIndexes)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return ProxyFactory.getProxyPreparedStatement(this, this.trackStatement(this.delegate.prepareStatement(sql, columnNames)));
    }

    @Override
    public void commit() throws SQLException {
        this.delegate.commit();
        this.isCommitStateDirty = false;
        this.lastAccess = clockSource.currentTime();
    }

    @Override
    public void rollback() throws SQLException {
        this.delegate.rollback();
        this.isCommitStateDirty = false;
        this.lastAccess = clockSource.currentTime();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.delegate.rollback(savepoint);
        this.isCommitStateDirty = false;
        this.lastAccess = clockSource.currentTime();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.delegate.setAutoCommit(autoCommit);
        this.poolEntry.setAutoCommit(autoCommit);
        this.isConnectionStateDirty = true;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
        this.poolEntry.setReadOnly(readOnly);
        this.isConnectionStateDirty = true;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
        this.poolEntry.setTransactionIsolation(level);
        this.isConnectionStateDirty = true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
        this.poolEntry.setCatalog(catalog);
        this.isConnectionStateDirty = true;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.delegate.setNetworkTimeout(executor, milliseconds);
        this.poolEntry.setNetworkTimeout(milliseconds);
        this.isConnectionStateDirty = true;
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.delegate) || this.delegate instanceof Wrapper && this.delegate.isWrapperFor(iface);
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate instanceof Wrapper) {
            return this.delegate.unwrap(iface);
        }
        throw new SQLException("Wrapped connection is not an instance of " + iface);
    }

    static {
        clockSource = ClockSource.INSTANCE;
        SQL_ERRORS = new HashSet<String>();
        SQL_ERRORS.add("57P01");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("57P03");
        SQL_ERRORS.add("01002");
        SQL_ERRORS.add("JZ0C0");
        SQL_ERRORS.add("JZ0C1");
    }
}

