/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import relations.BasicChunk;
import relations.Chunk;
import relations.ChunkAnalyzer;
import relations.Counter;
import relations.EData;
import relations.KeyData;
import relations.RuleData;
import relations.RuleSet;
import relations.Rules;
import relations.SenAnalyzer;
import relations.SenSimplifier;
import relations.TData;
import relations.VerbChunk;
import relations.Word;
import utils.DBUtils;

public class RuleLearner {
    SenAnalyzer analyzer;
    SenSimplifier simp;
    String current_txt = "";
    String curr_pmid = "";
    int curr_sen_id = 0;
    List<Word> detectedTrgs = null;
    Map<String, Map<String, Counter>> TGCount = new HashMap<String, Map<String, Counter>>();
    Map<String, Map<String, Counter>> subTG = new HashMap<String, Map<String, Counter>>();
    Map<String, Map<String, Counter>> sharedTG = new HashMap<String, Map<String, Counter>>();
    Map<String, Counter> sameChunk = new HashMap<String, Counter>();
    String[] tokens;
    Set<Word> validTG = new HashSet<Word>();
    Map<TData, Word> matchTG = new HashMap<TData, Word>();
    int in_distance = 0;
    int in_total = 0;
    int has_trg = 0;
    int in_count = 0;
    int prep_order_count = 0;
    boolean debug = false;
    public static final Set<String> preps = new HashSet<String>();
    public static final Set<String> prepmap = SenSimplifier.prepmap;
    int nppt = 0;
    int vppt = 0;
    int vppt2 = 0;
    EData curr_event = null;

    public RuleLearner() {
    }

    public RuleLearner(DBUtils sr, DBUtils dest) {
        this.analyzer = new SenAnalyzer(sr, dest);
        this.simp = this.analyzer.simp;
    }

    public static void main(String[] args) {
        DBUtils db1 = new DBUtils();
        String dbsrc = null;
        if (args.length == 1) {
            dbsrc = args[0];
        } else {
            System.out.println("No annotated database declared.");
            System.exit(1);
        }
        db1.openDB(dbsrc);
        RuleLearner learner = new RuleLearner(db1, db1);
        learner.LearnData();
        db1.shutdownDB();
    }

    public void LearnData() {
        int total = 0;
        int skip_pro = 0;
        int miss_pro = 0;
        int skip_dic = 0;
        int miss_vb = 0;
        this.analyzer.init();
        HashSet<TData> usedTG = new HashSet<TData>();
        List<String> ids = this.simp.loadPMIDs();
        System.out.println("Total abstract: " + ids.size());
        HashMap<String, TData> TGmap = new HashMap<String, TData>();
        HashMap<String, EData> EVmap = new HashMap<String, EData>();
        HashMap<String, Word> protMap = new HashMap<String, Word>();
        ChunkAnalyzer op = new ChunkAnalyzer();
        HashMap[] mtrg = new HashMap[SenSimplifier.trigger_type.length];
        Map[] rules = new Map[SenSimplifier.trigger_type.length];
        for (int x = 0; x < SenSimplifier.trigger_type.length; ++x) {
            rules[x] = new HashMap();
            mtrg[x] = new HashMap();
        }
        int miss_events = 0;
        int skip_trg = 0;
        int success = 0;
        int unknown = 0;
        boolean print = false;
        int[] counter = new int[SenSimplifier.trigger_type.length];
        int[] totals = new int[SenSimplifier.trigger_type.length];
        int[] map_count = new int[SenSimplifier.trigger_type.length];
        int[] mis_count = new int[SenSimplifier.trigger_type.length];
        int[] mis_trg = new int[SenSimplifier.trigger_type.length];
        int total_sen = 0;
        int s_events = 0;
        int skip_sen = 0;
        int lv1 = 0;
        int lv2 = 0;
        int lv3 = 0;
        int lv0 = 0;
        for (String string : ids) {
            EVmap.clear();
            TGmap.clear();
            List<Chunk>[] out = this.analyzer.analyze(string);
            List<EData> elist = this.simp.loadEvent(string);
            List<TData> trgList = this.simp.loadTrigger(string);
            for (TData dt : trgList) {
                TGmap.put(dt.tid, dt);
            }
            for (EData ev : elist) {
                EVmap.put(ev.eid, ev);
            }
            for (EData ed : elist) {
                ed.init(this.analyzer.proMap, TGmap, EVmap);
            }
            this.curr_pmid = string;
            List<EData>[] events = this.analyzer.splitEvents(elist);
            for (int i = 0; i < this.analyzer.senpos.length; ++i) {
                Word tg;
                int ev_type;
                usedTG.clear();
                this.validTG.clear();
                this.matchTG.clear();
                this.curr_sen_id = i;
                this.detectedTrgs = this.analyzer.detectedTrg[i];
                total += events[i].size();
                print = false;
                if (out[i] == null) {
                    s_events += events[i].size();
                    for (EData eData : events[i]) {
                        int n = ev_type = SenSimplifier.hashType.get(eData.type).intValue();
                        mis_count[n] = mis_count[n] + 1;
                    }
                    if (events[i].size() <= 0) continue;
                    ++skip_sen;
                    continue;
                }
                ++total_sen;
                int sen_begin = this.analyzer.senpos[i];
                int sen_end = this.analyzer.senpos[i] + this.analyzer.longsen[i].length();
                this.tokens = this.analyzer.tokenList.get(i);
                List<Word> prep = this.analyzer.getPreps(this.tokens);
                protMap.clear();
                for (Word word : this.analyzer.detectedPro[i]) {
                    protMap.put(word.word, word);
                }
                op.curr_text = this.analyzer.shortsen[i];
                this.current_txt = this.analyzer.shortsen[i];
                op.analyzeChunk(out[i], this.analyzer.tagList.get(i), this.tokens);
                this.countTrg(op);
                for (EData eData : events[i]) {
                    tg = this.analyzer.findTrigger(eData.trgdata.list, this.analyzer.detectedTrg[i]);
                    if (tg == null) continue;
                    this.matchTG.put(eData.trgdata, tg);
                    this.validTG.add(tg);
                }
                Iterator<Object> iterator = events[i].iterator();
                block14: while (iterator.hasNext()) {
                    Word pr;
                    TData pro;
                    boolean add;
                    EData eData;
                    this.curr_event = eData = (EData)iterator.next();
                    Word pr2 = null;
                    boolean ev1 = false;
                    boolean ev2 = false;
                    int n = ev_type = SenSimplifier.hashType.get(eData.type).intValue();
                    totals[n] = totals[n] + 1;
                    if (!this.inSentence(sen_begin, sen_end, eData)) {
                        ++skip_pro;
                        continue;
                    }
                    if (!usedTG.contains(eData.trgdata)) {
                        add = true;
                        usedTG.add(eData.trgdata);
                    } else {
                        add = false;
                    }
                    tg = this.matchTG.get(eData.trgdata);
                    if (tg == null) {
                        ++skip_trg;
                        int n2 = ev_type;
                        mis_trg[n2] = mis_trg[n2] + 1;
                        Counter ct = (Counter)mtrg[ev_type].get(eData.trgdata.name.toLowerCase());
                        if (ct != null) {
                            ct.inc();
                            continue;
                        }
                        ct = new Counter();
                        mtrg[ev_type].put(eData.trgdata.name.toLowerCase(), ct);
                        continue;
                    }
                    KeyData kdata = this.simp.sharedDic.get(tg.word);
                    if (kdata.keytype == 1 && !kdata.type.equals(eData.type)) {
                        ++skip_dic;
                        continue;
                    }
                    if (eData.data1 instanceof TData) {
                        pro = (TData)eData.data1;
                        pr = (Word)protMap.get(pro.new_name);
                    } else {
                        pro = ((EData)eData.data1).trgdata;
                        ev1 = true;
                        pr = this.matchTG.get(pro);
                        if (pr == null) {
                            ++skip_trg;
                            continue;
                        }
                    }
                    if (eData.data2 != null) {
                        TData pro2 = eData.data2;
                        pr2 = (Word)protMap.get(pro2.new_name);
                    } else if (eData.ecause != null) {
                        if (eData.ecause instanceof TData) {
                            TData pro2 = (TData)eData.ecause;
                            pr2 = (Word)protMap.get(pro2.new_name);
                        } else {
                            ev2 = true;
                            TData pro2 = ((EData)eData.ecause).trgdata;
                            pr2 = this.matchTG.get(pro2);
                            if (pr2 == null) {
                                ++skip_trg;
                                continue;
                            }
                        }
                    }
                    boolean found = false;
                    for (BasicChunk bs : op.bsList) {
                        if (!bs.belongTO(tg, pr, pr2)) continue;
                        found = this.eventToNP(bs, tg, pr, pr2, prep, rules, ev_type, ev1, ev2, add);
                        break;
                    }
                    if (!found) {
                        for (VerbChunk vc : op.verbList) {
                            if (!vc.belongTO(tg, pr, pr2)) continue;
                            found = this.eventToVP(vc, tg, pr, pr2, prep, rules, ev_type, ev1, ev2, add);
                            break;
                        }
                    }
                    if (found) {
                        ++success;
                        int n3 = ev_type;
                        map_count[n3] = map_count[n3] + 1;
                        switch (eData.getLevel(0)) {
                            case 0: {
                                ++lv0;
                                continue block14;
                            }
                            case 1: {
                                ++lv1;
                                continue block14;
                            }
                            case 2: {
                                ++lv2;
                                continue block14;
                            }
                        }
                        ++lv3;
                        continue;
                    }
                    int n4 = ev_type;
                    counter[n4] = counter[n4] + 1;
                    ++miss_events;
                    if (print) continue;
                    print = true;
                }
                if (!print) continue;
                ++unknown;
            }
        }
        System.out.println("Sub trg list:-------------------------------------------------------------------------------------");
        for (String string : this.subTG.keySet()) {
            Map<String, Counter> ct = this.subTG.get(string);
            Map<String, Counter> ct2 = this.sharedTG.get(string);
            if (ct2 != null) {
                for (String string2 : ct2.keySet()) {
                    ct.remove(string2);
                }
            }
            System.out.println(string + " number of sub tg: " + ct.size());
            for (String string3 : ct.keySet()) {
                System.out.println("            --> " + string3 + "  " + ct.get((Object)string3).count);
            }
            System.out.println("");
        }
        System.out.println("----------------------------------------------------------------------  end sub tg list ----------");
        System.out.println("----------------------------------------------------------------------  end sub tg list ----------");
        System.out.println("---Number of sentence with miss events " + unknown + " Total: " + total_sen + " Skip sen: " + skip_sen + " Rc1:(miss) " + (float)unknown * 1.0f / (float)total_sen + " Rc2:(skip) " + (float)skip_sen * 1.0f / (float)total_sen);
        System.out.println("-----------------------------------------------------------------------------------------------------------------------\n");
        for (int k = 0; k < 9; ++k) {
            System.out.println(SenSimplifier.trigger_type[k] + " : Total: " + totals[k] + " map events: " + map_count[k] + " |  miss map: " + counter[k] + "  ->> recall: " + 1.0f * (float)map_count[k] / (float)totals[k]);
            System.out.println("      Miss due to no trg/pro: " + mis_count[k] + " | miss due to dict: " + mis_trg[k]);
        }
        System.out.println("---------------------------------------------------------------------------------------------------------------------\n");
        System.out.println("Total events skip due to no trg/pro: " + s_events + " mis pro: " + miss_pro);
        System.out.println("    Total events:" + total + " | events map: " + success + " -> Recall: " + (float)success * 1.0f / (float)total + "  | skip trg: " + skip_trg + " | Skip dic: " + skip_dic + " | skip pro: " + skip_pro + " | miss: " + miss_events);
        System.out.println("Number of trig as VB is missed " + miss_vb);
        System.out.println("");
        System.out.println("Level 0: " + lv0 + "  | Level 1: " + lv1 + " | Level 2: " + lv2 + " Level 3: " + lv3);
        System.out.println("Noun count: " + this.nppt + "  Verb count: " + this.vppt + " | Number of event with level >=2 " + this.vppt2);
        System.out.println("----------------missing trgger for each event type-------------------------------");
        for (int i = 0; i <= 8; ++i) {
            System.out.println(SenSimplifier.trigger_type[i] + " total " + mtrg[i].size());
            for (Object object : mtrg[i].keySet()) {
            }
            System.out.println("");
        }
        System.out.println("--------------------------------------------------------------same chunk , tg > pro------------: " + this.sameChunk.size());
        for (String string : this.sameChunk.keySet()) {
            System.out.println(string + " " + this.sameChunk.get((Object)string).count);
        }
        System.out.println("---------------------------------------------------------------------------------");
        System.out.println("Combining rules....");
        System.out.println("---> Storing patterns.....");
        this.storePatterns(rules, this.analyzer.db);
        System.out.println("");
    }

    private void countTrg(ChunkAnalyzer ac) {
        HashSet<BasicChunk> bc = new HashSet<BasicChunk>();
        ArrayList<Chunk> verb = new ArrayList<Chunk>();
        HashSet<Word> used = new HashSet<Word>();
        for (BasicChunk bs : ac.bsList) {
            bc.add(bs);
        }
        for (VerbChunk vc : ac.verbList) {
            bc.add(vc.subject);
            bc.add(vc.object);
            verb.add(vc.verb);
        }
        for (BasicChunk bs : bc) {
            for (Chunk c : bs.chunkList) {
                for (Word w : c.trigs) {
                    if (used.contains(w)) continue;
                    this.add2Map(w.pos_tag, w.word, "NP");
                    used.add(w);
                }
            }
        }
        for (Chunk c : verb) {
            for (Word w : c.trigs) {
                if (used.contains(w)) continue;
                this.add2Map(w.pos_tag, w.word, "VP");
                used.add(w);
            }
        }
    }

    private void add2Map(String pos, String tg, String type) {
        String key;
        Counter c;
        Map<String, Counter> ct = this.TGCount.get(tg);
        if (ct == null) {
            ct = new HashMap<String, Counter>();
            this.TGCount.put(tg, ct);
        }
        if ((c = ct.get(key = pos + type)) == null) {
            c = new Counter(1);
            ct.put(key, c);
        } else {
            c.inc();
        }
    }

    private boolean inSentence(int begin, int end, EData ev) {
        boolean theme = false;
        boolean cause = false;
        TData tg = ev.trgdata;
        if (tg.list[0] >= begin && tg.list[1] <= end) {
            TData pr2;
            if (ev.data1 instanceof TData) {
                TData pr1 = (TData)ev.data1;
                if (pr1.list[0] >= begin && pr1.list[1] <= end) {
                    theme = true;
                }
            } else {
                EData ev1 = (EData)ev.data1;
                theme = this.inSentence(begin, end, ev1);
            }
            if (ev.ecause != null) {
                if (ev.ecause instanceof EData) {
                    cause = this.inSentence(begin, end, (EData)ev.ecause);
                } else {
                    pr2 = (TData)ev.ecause;
                    if (pr2.list[0] >= begin && pr2.list[1] <= end) {
                        cause = true;
                    }
                }
            } else if (ev.data2 != null) {
                pr2 = ev.data2;
                if (pr2.list[0] >= begin && pr2.list[1] <= end) {
                    cause = true;
                }
            } else {
                cause = true;
            }
            if (theme && cause) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean eventToNP(BasicChunk bs, Word tg, Word pr, Word pr2, List<Word> prep, Map<String, Rules>[] rules, int ev_type, boolean evt1, boolean evt2, boolean add) {
        int count1;
        boolean prep2_pos = false;
        boolean prep_order = false;
        boolean in_chunk = false;
        String prep1 = "";
        String prep2 = "";
        int count2 = 0;
        boolean has_theme2 = false;
        String themeTrg = "";
        String causeTrg = "";
        bs.mergeNP();
        String ctype = bs.is_merged ? "CP" : "NP";
        if (evt1) {
            themeTrg = pr.word;
        }
        if (evt2) {
            causeTrg = pr2.word;
        }
        String pos_type = tg.pos_tag;
        boolean prep1_pos = pr.pos > tg.pos;
        ++this.nppt;
        if (pr2 == null) {
            Chunk tgc;
            if (bs.isSameChunk(tg, pr) && !evt1) {
                Counter ct = this.sameChunk.get(tg.word);
                if (ct == null) {
                    ct = new Counter(1);
                    this.sameChunk.put(tg.word, ct);
                } else {
                    ct.inc();
                }
            }
            count1 = bs.countChunks(tg, pr);
            if (prep1_pos) {
                Word sub_tg;
                prep1 = this.getPrep(tg, pr, bs);
                if (ev_type <= 5 && (sub_tg = this.findTrg(tg, pr.pos, bs)) != null) {
                    Counter c;
                    String key = tg.word + tg.pos_tag;
                    Map<String, Counter> ct = this.subTG.get(key);
                    if (ct == null) {
                        ct = new HashMap<String, Counter>();
                        this.subTG.put(key, ct);
                    }
                    if ((c = ct.get(sub_tg.word + sub_tg.pos_tag)) == null) {
                        c = new Counter(1);
                        ct.put(sub_tg.word + sub_tg.pos_tag, c);
                    } else {
                        c.inc();
                    }
                }
            } else if (!evt1 && bs.inChunk(tg, pr)) {
                in_chunk = true;
                count1 = 0;
            } else if (evt1 && tg.pos == pr.pos) {
                in_chunk = true;
                count1 = 0;
            }
            if (in_chunk && !evt1 && (tgc = bs.getChunk(tg.pos)).is_inChunk(tg, this.tokens) && tgc.trigs.size() != 2) {
                // empty if block
            }
        } else {
            has_theme2 = true;
            prep2_pos = pr2.pos > tg.pos;
            count1 = bs.countChunks(tg, pr);
            count2 = bs.countChunks(tg, pr2);
            if (prep1_pos && prep2_pos) {
                if (pr.pos > pr2.pos) {
                    prep1 = this.getPrep2(pr2, pr, bs);
                    prep2 = this.getPrep(tg, pr2, bs);
                    prep_order = true;
                } else {
                    prep2 = this.getPrep2(pr, pr2, bs);
                    prep1 = this.getPrep(tg, pr, bs);
                }
            } else if (prep1_pos && !prep2_pos) {
                prep1 = this.getPrep(tg, pr, bs);
                prep2 = this.getPrepFront(tg, pr2, bs);
            } else if (!prep1_pos && prep2_pos) {
                prep1 = this.getPrepFront(tg, pr, bs);
                prep2 = this.getPrep(tg, pr2, bs);
            } else if (pr.pos > pr2.pos) {
                prep1 = this.getPrepFront(tg, pr, bs);
                prep2 = this.getPrep2(pr2, pr, bs);
                prep_order = true;
            } else {
                prep1 = this.getPrep2(pr, pr2, bs);
                prep2 = this.getPrepFront(tg, pr2, bs);
            }
            if (ev_type == 5) {
                in_chunk = bs.inChunk(tg, pr);
            } else if (ev_type > 5 && !evt2 && !prep2_pos) {
                in_chunk = bs.inChunk(tg, pr2);
            }
        }
        int verb_type = 0;
        Rules rl = rules[ev_type].get(tg.word);
        if (rl == null) {
            rl = new Rules(ev_type, tg.word);
            rules[ev_type].put(tg.word, rl);
        }
        if (ev_type < 5) {
            rl.addPattern(verb_type, pos_type, ctype, prep1_pos, prep1, in_chunk, count1, themeTrg, add);
            return true;
        }
        if (ev_type == 5) {
            rl.addPattern(verb_type, pos_type, ctype, prep1_pos, prep2_pos, prep_order, prep1, prep2, has_theme2, in_chunk, count1, count2, themeTrg, add);
            return true;
        }
        rl.addPattern(verb_type, pos_type, ctype, prep1_pos, prep2_pos, prep_order, prep1, prep2, has_theme2, in_chunk, count1, count2, evt1, evt2, themeTrg, causeTrg, add);
        return true;
    }

    private boolean eventToVP(VerbChunk vc, Word tg, Word pr, Word pr2, List<Word> prep, Map<String, Rules>[] rules, int ev_type, boolean evt1, boolean evt2, boolean add) {
        boolean prep2_pos = false;
        boolean prep_order = false;
        boolean in_chunk = false;
        String prep1 = "";
        String prep2 = "";
        int count1 = 0;
        int count2 = 0;
        boolean has_theme2 = false;
        String childTrg = "";
        String parentTrg = "";
        if (vc.subject.belongTO(tg, pr, pr2)) {
            this.eventToNP(vc.subject, tg, pr, pr2, prep, rules, ev_type, evt1, evt2, add);
        } else if (vc.object.belongTO(tg, pr, pr2)) {
            this.eventToNP(vc.object, tg, pr, pr2, prep, rules, ev_type, evt1, evt2, add);
        } else if (vc.verb.contains(tg)) {
            Rules rl;
            boolean prep1_pos;
            ++this.vppt;
            if (this.curr_event.getLevel(0) >= 2) {
                ++this.vppt2;
            }
            String ctype = "VP";
            String pos_type = tg.pos_tag;
            boolean bl = prep1_pos = tg.pos < pr.pos;
            if (pr2 == null) {
                if (vc.subject.containsKey(pr)) {
                    count1 = vc.subject.getChunkPos(pr.pos);
                    prep1 = this.getPrepFront(tg, pr, vc.subject);
                } else if (vc.object.containsKey(pr)) {
                    count1 = vc.object.getChunkPos(pr.pos);
                    prep1 = this.getPrep(tg, pr, vc.object);
                }
                if (evt1) {
                    childTrg = pr.word;
                }
            } else {
                has_theme2 = true;
                boolean bl2 = prep2_pos = tg.pos < pr2.pos;
                if (prep1_pos && prep2_pos) {
                    count1 = vc.object.getChunkPos(pr.pos);
                    count2 = vc.object.getChunkPos(pr2.pos);
                    if (pr.pos < pr2.pos) {
                        prep1 = this.getPrep(tg, pr, vc.object);
                        prep2 = this.getPrep2(pr, pr2, vc.object);
                    } else {
                        prep2 = this.getPrep(tg, pr2, vc.object);
                        prep1 = this.getPrep2(pr2, pr, vc.object);
                    }
                } else if (prep1_pos && !prep2_pos) {
                    prep1 = this.getPrep(tg, pr, vc.object);
                    prep2 = this.getPrepFront(tg, pr2, vc.subject);
                    count1 = vc.object.getChunkPos(pr.pos);
                    count2 = vc.subject.getChunkPos(pr2.pos);
                } else if (!prep1_pos && prep2_pos) {
                    prep1 = this.getPrepFront(tg, pr, vc.subject);
                    prep2 = this.getPrep(tg, pr2, vc.object);
                    count2 = vc.object.getChunkPos(pr2.pos);
                    count1 = vc.subject.getChunkPos(pr.pos);
                } else if (!prep1_pos && !prep2_pos) {
                    prep1 = this.getPrep2(pr, pr2, vc.subject);
                    prep2 = this.getPrepFront(tg, pr2, vc.subject);
                    count1 = vc.subject.getChunkPos(pr.pos);
                    count2 = vc.subject.getChunkPos(pr2.pos);
                    if (ev_type > 5) {
                        return false;
                    }
                }
                if (ev_type > 5) {
                    if (evt1) {
                        childTrg = pr.word;
                    }
                    if (evt2) {
                        parentTrg = pr2.word;
                    }
                }
            }
            if ((rl = rules[ev_type].get(tg.word)) == null) {
                rl = new Rules(ev_type, tg.word);
                rules[ev_type].put(tg.word, rl);
            }
            if (ev_type < 5) {
                rl.addPattern(vc.verb_type, pos_type, ctype, prep1_pos, prep1, in_chunk, count1, childTrg, add);
            } else if (ev_type == 5) {
                rl.addPattern(vc.verb_type, pos_type, ctype, prep1_pos, prep2_pos, prep_order, prep1, prep2, has_theme2, in_chunk, count1, count2, childTrg, add);
            } else {
                rl.addPattern(vc.verb_type, pos_type, ctype, prep1_pos, prep2_pos, prep_order, prep1, prep2, has_theme2, in_chunk, count1, count2, evt1, evt2, childTrg, parentTrg, add);
            }
        } else {
            BasicChunk new_ch = new BasicChunk();
            new_ch.addChunk(vc.subject);
            new_ch.addChunk(vc.verb);
            new_ch.addChunk(vc.object);
            new_ch.is_merged = true;
            return this.eventToNP(new_ch, tg, pr, pr2, prep, rules, ev_type, evt1, evt2, add);
        }
        return true;
    }

    public String getPrepFront(Word tg, Word pr, BasicChunk bs) {
        int st2;
        int st1 = bs.getChunkPos(tg.pos);
        if (Math.min(st1, st2 = bs.getChunkPos(pr.pos)) >= 0 && st1 > st2) {
            Chunk c = bs.chunkList.get(st1 - 1);
            if (c.type.endsWith("PP") && preps.contains(c.txt)) {
                return c.txt;
            }
        } else if (st1 < 0 && st2 > 0) {
            Chunk c = bs.chunkList.get(bs.chunkList.size() - 1);
            if (c.type.endsWith("PP")) {
                return c.txt;
            }
        }
        return "";
    }

    public String getPrep(Word tg, Word pr, BasicChunk bs) {
        int pos2;
        int pos1 = bs.getChunkPos(tg.pos);
        if (Math.min(pos1, pos2 = bs.getChunkPos(pr.pos)) >= 0 && pos1 < pos2) {
            Chunk c = bs.chunkList.get(pos1 + 1);
            if (c.type.endsWith("PP") && prepmap.contains(c.txt)) {
                return c.txt;
            }
        } else if (pos1 < 0 && pos2 > 0) {
            Chunk c = bs.chunkList.get(0);
            if (c.type.endsWith("PP") && prepmap.contains(c.txt)) {
                return c.txt;
            }
        }
        return "";
    }

    public String getPrep2(Word pr1, Word pr2, BasicChunk bs) {
        int pos2;
        int pos1 = bs.getChunkPos(pr1.pos);
        if (Math.min(pos1, pos2 = bs.getChunkPos(pr2.pos)) >= 0 && pos1 < pos2) {
            for (int i = pos1 + 1; i < pos2; ++i) {
                Chunk c = bs.chunkList.get(i);
                if (!c.type.endsWith("PP") || !prepmap.contains(c.txt)) continue;
                return c.txt;
            }
        }
        return "";
    }

    private Word findTrg(Word tg, int pos2, BasicChunk bs) {
        int pos1 = tg.pos;
        if (pos2 - pos1 > 10) {
            return null;
        }
        Chunk c1 = bs.getChunk(pos1);
        Chunk c2 = bs.getChunk(pos2);
        int begin = c1.begin;
        int end = c2.end;
        for (Chunk c : bs.chunkList) {
            if (c.begin < begin || c.end > end) continue;
            for (Word w : c.trigs) {
                Counter count;
                if (!this.validTG.contains(w) && w.pos > pos1) {
                    return w;
                }
                if (!this.validTG.contains(w) || w.pos <= pos1) continue;
                String key = tg.word + tg.pos_tag;
                Map<String, Counter> ct = this.sharedTG.get(key);
                if (ct == null) {
                    ct = new HashMap<String, Counter>();
                    this.sharedTG.put(key, ct);
                }
                if ((count = ct.get(w.word + w.pos_tag)) == null) {
                    count = new Counter(1);
                    ct.put(w.word + w.pos_tag, count);
                    continue;
                }
                count.inc();
            }
        }
        return null;
    }

    public void storePatterns(Map<String, Rules>[] map, DBUtils db) {
        DBUtils dbs = db;
        try {
            System.out.println("----> Storing patterns.....");
            dbs.dropTable("Patterns");
            Connection cons = dbs.getConnection();
            Statement stms = cons.createStatement();
            String sql = "CREATE CACHED TABLE PATTERNS(TRGKEY VARCHAR(80), TYPE VARCHAR(25), verb_type int, POS varchar(5), chunk_type varchar(5), pos1 boolean, pos2 boolean, prep1 varchar(10), prep2 varchar(10), prep_order boolean,has_theme2 boolean,in_chunk boolean, chunk1 int, chunk2 int, event1 boolean, event2 boolean,trg1 varchar(2000), trg2 varchar(2000), pcount int, detected int)";
            stms.executeUpdate(sql);
            PreparedStatement ps = cons.prepareStatement("INSERT INTO Patterns(trgkey,type,verb_type, pos, chunk_type,pos1, pos2,prep1,prep2,prep_order,has_theme2,in_chunk,chunk1,chunk2,event1,event2,trg1,trg2,pcount,detected) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            for (int i = 0; i < map.length; ++i) {
                Map<String, Rules> m = map[i];
                String type = SenSimplifier.trigger_type[i];
                for (String s : m.keySet()) {
                    Rules rule = m.get(s);
                    for (String st : rule.map.keySet()) {
                        RuleData p = rule.map.get(st);
                        ps.setString(1, s);
                        ps.setString(2, type);
                        ps.setInt(3, p.verb_type);
                        ps.setString(4, p.POS);
                        ps.setString(5, p.chunk_type);
                        ps.setBoolean(6, p.theme_pos);
                        ps.setBoolean(7, p.cause_pos);
                        ps.setString(8, p.prep1);
                        ps.setString(9, p.prep2);
                        ps.setBoolean(10, p.prep_order);
                        ps.setBoolean(11, p.has_cause);
                        ps.setBoolean(12, p.in_chunk);
                        ps.setInt(13, p.dist1);
                        ps.setInt(14, p.dist2);
                        ps.setBoolean(15, p.event1);
                        ps.setBoolean(16, p.event2);
                        ps.setString(17, p.mapToString(p.childMap));
                        ps.setString(18, p.mapToString(p.parentMap));
                        ps.setInt(19, p.count);
                        p.detected = this.getCountDetectedTG(s, p.POS + p.chunk_type);
                        ps.setInt(20, p.detected);
                        ps.executeUpdate();
                    }
                }
            }
            ps.close();
            System.out.println("---DONE---> Saving patterns");
        }
        catch (Exception e) {
            System.out.println("ERORR here ");
            System.out.println(e);
        }
    }

    private void combiningNP(Map<String, Rules> rl, Map<String, RuleSet> ruleset, int i) {
        String[] keys = new String[]{"NNNP", "VBNP", "JJNP", "NNCP", "VBCP", "JJCP"};
        for (String s : rl.keySet()) {
            Rules rule = rl.get(s);
            rule.initMap();
            for (String subkey : keys) {
                List<RuleData> ls = rule.getEvalRules(subkey);
                if (ls == null) continue;
                String rkey = s + i + subkey;
                RuleSet rs = new RuleSet();
                boolean order1 = false;
                boolean order2 = false;
                for (RuleData dt : ls) {
                    if (dt.in_chunk) {
                        rs.in_chunk = true;
                        rs.inchunk_count += dt.count;
                        if (!dt.has_cause) {
                            if (dt.event1) {
                                rs.ecount += dt.count;
                                continue;
                            }
                            rs.pcount += dt.count;
                            continue;
                        }
                        if (i == 5 && dt.has_cause) {
                            rs.t2count += dt.count;
                            rs.pcount += dt.count;
                            rs.dist2 = Math.max(rs.dist2, dt.dist2);
                            continue;
                        }
                        if (i <= 5 || !dt.theme_pos || !dt.has_cause) continue;
                        rs.pcause += dt.count;
                        if (dt.event1) {
                            rs.ecount += dt.count;
                        } else {
                            rs.pcount += dt.count;
                        }
                        rs.dist1 = Math.max(rs.dist1, dt.dist1);
                        continue;
                    }
                    if (dt.theme_pos) {
                        if ((!dt.POS.startsWith("NN") || dt.prep1.isEmpty()) && dt.POS.startsWith("NN")) continue;
                        if (!dt.has_cause) {
                            if (i <= 5) {
                                rs.pcount += dt.count;
                            } else if (dt.event1) {
                                rs.ecount += dt.count;
                            } else {
                                rs.pcount += dt.count;
                            }
                            rs.dist1 = Math.max(rs.dist1, dt.dist1);
                            continue;
                        }
                        if (!dt.cause_pos || dt.prep2.isEmpty() || !dt.POS.startsWith("NN")) continue;
                        if (i == 5) {
                            rs.t2count += dt.count;
                            rs.pcount += dt.count;
                        } else {
                            if (dt.event1) {
                                rs.ecount += dt.count;
                            } else {
                                rs.pcount += dt.count;
                            }
                            if (dt.event2) {
                                rs.ecause += dt.count;
                            } else {
                                rs.pcause += dt.count;
                            }
                        }
                        rs.dist1 = Math.max(rs.dist1, dt.dist1);
                        rs.dist2 = Math.max(rs.dist2, dt.dist2);
                        continue;
                    }
                    if (i != 5 || dt.theme_pos || (!dt.has_cause || !dt.cause_pos) && dt.POS.startsWith("NN")) continue;
                    rs.in_front += dt.count;
                    if (!dt.prep2.isEmpty()) {
                        rs.prep_2.add(dt.prep2);
                    }
                    if (!dt.prep1.isEmpty()) {
                        rs.prep_1.add(dt.prep1);
                    }
                    rs.dist1 = Math.max(rs.dist1, dt.dist1);
                    rs.dist2 = Math.max(rs.dist2, dt.dist2);
                    rs.pcount += dt.count;
                    rs.dist2 = Math.max(rs.dist2, dt.dist2);
                }
                rs.detected = this.getCountDetectedTG(s, subkey);
                if (order2 > order1) {
                    rs.order = false;
                }
                if (rs.getFreq() < 2) continue;
                ruleset.put(rkey, rs);
            }
        }
    }

    private int getCountDetectedTG(String tg, String subkey) {
        Map<String, Counter> ct = this.TGCount.get(tg);
        if (ct != null) {
            Counter c;
            if (((String)subkey).endsWith("CP")) {
                subkey = ((String)subkey).substring(0, ((String)subkey).length() - 2) + "NP";
            }
            return (c = ct.get(subkey)) != null ? c.count : 0;
        }
        return 0;
    }

    private void combiningVP(Map<String, Rules> rl, Map<String, RuleSet> ruleset, int i) {
        String[] keys = new String[]{"VBVP", "JJVP"};
        for (String s : rl.keySet()) {
            Rules rule = rl.get(s);
            rule.initMap();
            for (String subkey : keys) {
                List<RuleData> ls = rule.getEvalRules(subkey);
                if (ls == null) continue;
                String rkey = s + i + subkey;
                RuleSet rs = new RuleSet();
                int order1 = 0;
                for (RuleData dt : ls) {
                    if (dt.count >= 2 || i < 5) {
                        // empty if block
                    }
                    if (!dt.has_cause) {
                        if (i <= 5) {
                            rs.pcount += dt.count;
                        } else if (dt.event1) {
                            rs.ecount += dt.count;
                        } else {
                            rs.pcount += dt.count;
                        }
                    } else if (i == 5) {
                        rs.t2count += dt.count;
                        rs.pcount += dt.count;
                    } else {
                        if (dt.event1) {
                            rs.ecount += dt.count;
                        } else {
                            rs.pcount += dt.count;
                        }
                        if (dt.event2) {
                            rs.ecause += dt.count;
                        } else {
                            rs.pcause += dt.count;
                        }
                    }
                    if (dt.verb_type == 1 && dt.POS.equals("VBN") && dt.theme_pos) {
                        order1 += dt.count;
                    } else if (dt.verb_type == 1 && dt.POS.equals("VBN") && !dt.theme_pos) {
                        order1 -= dt.count;
                    }
                    rs.dist1 = Math.max(rs.dist1, dt.dist1);
                    rs.dist2 = Math.max(rs.dist2, dt.dist2);
                }
                rs.detected = this.getCountDetectedTG(s, subkey);
                if (order1 > 0) {
                    rs.order = false;
                }
                if (rs.getFreq() < 2) continue;
                ruleset.put(rkey, rs);
            }
        }
    }

    public Map<String, RuleSet> combiningRules(Map<String, Rules>[] rules) {
        HashMap<String, RuleSet> ruleset = new HashMap<String, RuleSet>();
        for (int i = 0; i < 9; ++i) {
            Map<String, Rules> rl = rules[i];
            this.combiningNP(rl, ruleset, i);
            this.combiningVP(rl, ruleset, i);
        }
        return ruleset;
    }

    public String setToStr(Set<String> set) {
        Object txt = "";
        for (String s : set) {
            txt = (String)txt + s + " ";
        }
        return txt;
    }

    public String mapToStr(Map<String, Set<String>> map) {
        Object txt = "";
        for (String s : map.keySet()) {
            txt = (String)txt + s + ":";
            for (String key : map.get(s)) {
                txt = (String)txt + key + " ";
            }
            txt = (String)txt + "|";
        }
        return txt;
    }

    public void storeRuleSet(Map<String, RuleSet> map, DBUtils db) {
        DBUtils dbs = db;
        try {
            System.out.println("----> Storing rulesets.....");
            dbs.dropTable("RuleSet");
            Connection cons = dbs.getConnection();
            Statement stms = cons.createStatement();
            String sql = "CREATE CACHED TABLE RULESET(KEY VARCHAR(80), INCHUNK BOOLEAN, DIST1 INT, DIST2 INT, PREP VARCHAR(100), PREP2 VARCHAR(300), T_ORDER BOOLEAN, PCOUNT INT, ECOUNT INT, T2COUNT INT, PCAUSE INT, ECAUSE INT, INPREP VARCHAR(100), in_front int, prep_1 varchar(100), prep_2 varchar(100), detected int, inchunk_count int, apply int)";
            stms.executeUpdate(sql);
            PreparedStatement ps = cons.prepareStatement("INSERT INTO RULESET(key,inchunk,dist1,dist2,prep,prep2,t_order,pcount,ecount,t2count,pcause,ecause,INPREP, in_front, prep_1,prep_2, detected, inchunk_count,apply) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            for (String s : map.keySet()) {
                RuleSet rs = map.get(s);
                ps.setString(1, s);
                ps.setBoolean(2, rs.in_chunk);
                ps.setInt(3, rs.dist1);
                ps.setInt(4, rs.dist2);
                ps.setString(5, this.setToStr(rs.prep));
                ps.setString(6, this.mapToStr(rs.prep2));
                ps.setBoolean(7, rs.order);
                ps.setInt(8, rs.pcount);
                ps.setInt(9, rs.ecount);
                ps.setInt(10, rs.t2count);
                ps.setInt(11, rs.pcause);
                ps.setInt(12, rs.ecause);
                ps.setString(13, this.setToStr(rs.inchunk_prep));
                ps.setInt(14, rs.in_front);
                ps.setString(15, this.setToStr(rs.prep_1));
                ps.setString(16, this.setToStr(rs.prep_2));
                ps.setInt(17, rs.detected);
                ps.setInt(18, rs.inchunk_count);
                ps.setInt(19, rs.apply);
                ps.executeUpdate();
            }
            ps.close();
            System.out.println("---DONE---> Saving patterns");
        }
        catch (Exception e) {
            System.out.println("ERORR here ");
            System.out.println(e.getLocalizedMessage());
        }
    }

    static {
        preps.add("by");
        preps.add("through");
        preps.add("after");
    }
}

