/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.util.List;
import relations.SenSimplifier;
import relations.Word;

public class PData
implements Comparable {
    public String PID = null;
    Word trg = null;
    Word pro1 = null;
    Word pro2 = null;
    PData pdata1 = null;
    PData pdata2 = null;
    int ttype = 0;
    public boolean skip = false;
    public String evt_type = "";
    public String trig_ID = "";

    public Word getPro1() {
        return this.pro1;
    }

    public Word getPro2() {
        return this.pro2;
    }

    public PData getPdata1() {
        return this.pdata1;
    }

    public PData getPdata2() {
        return this.pdata2;
    }

    public PData(Word tg, Object ob1, String ev_type) {
        this.trg = tg;
        this.evt_type = ev_type;
        if (ob1 instanceof Word) {
            this.pro1 = (Word)ob1;
        } else if (ob1 instanceof PData) {
            this.pdata1 = (PData)ob1;
        }
        this.ttype = SenSimplifier.hashType.get(ev_type);
    }

    public void setPID(String pid) {
        this.PID = pid;
    }

    public Word getProtein() {
        if (this.pro1 != null) {
            return this.pro1;
        }
        return this.pdata1.getProtein();
    }

    public Word getTrigger() {
        return this.trg;
    }

    public PData(Word tg, Object ob1, Object ob2, String ev_type) {
        this.trg = tg;
        if (ob1 instanceof Word) {
            this.pro1 = (Word)ob1;
        } else if (ob1 instanceof PData) {
            this.pdata1 = (PData)ob1;
        }
        if (ob2 instanceof Word) {
            this.pro2 = (Word)ob2;
        } else if (ob2 instanceof PData) {
            this.pdata2 = (PData)ob2;
        }
        this.evt_type = ev_type;
        this.ttype = SenSimplifier.hashType.get(ev_type);
    }

    public String getText() {
        String txt = this.evt_type + ": " + this.trg.word;
        if (this.pro1 != null) {
            txt = txt + " pro1: " + this.pro1.word;
        } else if (this.pdata1 != null) {
            txt = txt + " event 1: [" + this.pdata1.getText() + " ] ";
        }
        if (this.pro2 != null && this.ttype == 5) {
            txt = txt + " pro2: " + this.pro2.word;
        } else if (this.pro2 != null && this.ttype > 5) {
            txt = txt + " cause: " + this.pro2.word;
        } else if (this.pdata2 != null) {
            txt = txt + " cause : [ " + this.pdata2.getText() + " ] ";
        }
        return txt;
    }

    public String getWriteID() {
        Object txt = this.trg.TID;
        if (this.pro1 != null) {
            txt = (String)txt + this.pro1.TID;
        } else if (this.pdata1 != null) {
            txt = (String)txt + this.pdata1.PID;
        }
        if (this.pro2 != null && this.ttype == 5) {
            txt = (String)txt + this.pro2.TID;
        } else if (this.pro2 != null && this.ttype > 5) {
            txt = (String)txt + this.pro2.TID;
        } else if (this.pdata2 != null) {
            txt = (String)txt + this.pdata2.PID;
        }
        return txt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.PID);
        sb.append('\t');
        sb.append(this.evt_type);
        sb.append(":");
        sb.append(this.trg.TID);
        sb.append(' ');
        sb.append("Theme:");
        if (this.pro1 != null) {
            sb.append(this.pro1.TID);
        } else if (this.pdata1 != null) {
            sb.append(this.pdata1.PID);
        }
        if (this.pro2 != null && SenSimplifier.hashType.get(this.evt_type) == 5) {
            sb.append(' ');
            sb.append("Theme2:");
            sb.append(this.pro2.TID);
        } else if (this.pro2 != null || this.pdata2 != null) {
            sb.append(' ');
            sb.append("Cause:");
            if (this.pdata2 != null) {
                sb.append(this.pdata2.PID);
            } else {
                sb.append(this.pro2.TID);
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    private void append(StringBuilder sb, List<String> ls, int len) {
        int i;
        int idx = Math.min(ls.size(), len);
        for (i = 0; i < idx; ++i) {
            sb.append(ls.get(i));
            sb.append(',');
        }
        if (idx < len) {
            for (i = idx; i < len; ++i) {
                sb.append("null");
                sb.append(',');
            }
        }
    }

    public int compareTo(Object o) {
        if (o != null) {
            return this.trg.pos - ((PData)o).trg.pos;
        }
        System.out.println("NULL pair ----------------------------------------------------------------------------------->");
        return -1;
    }
}

