/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relations.BasicChunk;
import relations.Chunk;
import relations.ChunkAnalyzer;
import relations.KeyData;
import relations.PData;
import relations.RuleData;
import relations.RuleSet;
import relations.RuleSets;
import relations.Rules;
import relations.SenAnalyzer;
import relations.SenSimplifier;
import relations.VerbChunk;
import relations.Word;
import utils.BioSemException;
import utils.DBUtils;

public class EventExtraction {
    private static final Logger log = LoggerFactory.getLogger(EventExtraction.class);
    SenAnalyzer analyzer;
    SenSimplifier simp;
    ChunkAnalyzer op = new ChunkAnalyzer();
    DBUtils db_sr;
    DBUtils db;
    Map<String, RuleSet> rules;
    Map<String, KeyData> dic;
    int noun_len = 12;
    int verb_len = 8;
    List<Word> usedPro = new ArrayList<Word>();
    BasicChunk cur_sub = null;
    boolean check_pro = false;
    boolean same_role = false;
    Chunk curr_verb = null;
    Set<Word> sameRole = new HashSet<Word>();
    FileWriter writer = null;
    int curr_verb_type = 0;
    String curr_pmid;
    int curr_senID;
    double ecause = 0.1;
    double escore = 0.1;
    double pscore = 0.3;
    double upperValue = 0.85;
    int etype = 0;
    boolean debug = false;
    Map<String, RuleSets> rset;
    List<Chunk>[] out;
    String[] tokens;
    String[] tags;
    Map<String, String> skipTrg = new HashMap<String, String>();
    Map<Word, List<PData>> extractedMap = new HashMap<Word, List<PData>>();
    Set<PData> extractedSet = new HashSet<PData>();
    Set<String> writeEvent = new HashSet<String>();
    Set<Word> usedTrg = new HashSet<Word>();
    int curr_tg;
    int trg_ID;
    int evt_ID;
    public static final Set<String> prepSet = new HashSet<String>();
    public static final String[] ccList = new String[]{"and", "or", "but", "as well as", "but not"};
    public static final String[] prepList = new String[]{"by", "after", "through", "via", "upon"};
    public static final Set<String> ccSet = new HashSet<String>();

    public EventExtraction(DBUtils sr, DBUtils db) {
        this.db = db;
        this.db_sr = sr;
        this.analyzer = new SenAnalyzer(sr, db);
        this.simp = this.analyzer.simp;
    }

    public void init() {
        if (null == this.dic) {
            this.analyzer.init();
            this.dic = this.simp.sharedDic;
            Map<String, Rules>[] rls = this.simp.loadPatterns(this.db_sr);
            this.rset = this.groupRules(rls);
        }
    }

    private boolean hasIts(int pos, String[] tokens) {
        return pos > 0 && tokens[pos - 1].equals("its");
    }

    public void evaluateTrg(BasicChunk bs, List<Word> preps, List<Word> mods, String[] tokens, List<Word> Trgs) {
        RuleSets rule;
        String key;
        int idx;
        KeyData kdt;
        Word tg;
        bs.mergeNP();
        if (bs.trgList.isEmpty()) {
            return;
        }
        int i = 0;
        HashSet<Word> checked = new HashSet<Word>();
        double score = 0.15;
        while (i < bs.trgList.size()) {
            tg = bs.trgList.get(i);
            boolean has_its = this.hasIts(tg.pos, tokens);
            kdt = this.dic.get(tg.word);
            if (kdt.keytype > 1) {
                if (kdt.score < score) {
                    bs.removeTrg(tg);
                    continue;
                }
                kdt = kdt.getDefault();
            }
            if (kdt == null || kdt.type == null) {
                System.out.println("--> BUG: " + tg.word + " --> no type");
                bs.removeTrg(tg);
                continue;
            }
            idx = SenSimplifier.hashType.get(kdt.type);
            key = tg.word + idx + tg.pos_tag + "NP";
            if (bs.inChunkTrg(tg, tokens) || has_its && tg.pos_tag.equals("NN")) {
                rule = this.rset.get(key);
                if (rule == null) {
                    bs.removeTrg(tg);
                    continue;
                }
                boolean found = false;
                if (rule != null && (rule.inChunk() || rule.getFrontScore() > 0.01) && !rule.isSkipped(idx)) {
                    found = true;
                }
                if (!found) {
                    bs.removeTrg(tg);
                    continue;
                }
                boolean has_type = false;
                kdt = this.dic.get(tg.word);
                if (kdt.keytype == 1 && (!kdt.required || has_its)) {
                    tg.type = kdt.type;
                    has_type = true;
                    tg.keytype = 1;
                } else if (kdt.keytype > 1) {
                    List<Word> mod = this.getMod(bs, tg, mods);
                    String evt_type = kdt.getType(mod);
                    if (evt_type != null) {
                        tg.type = evt_type;
                        tg.keytype = kdt.keytype == 2 ? 2 : 1;
                        has_type = true;
                    }
                } else if (kdt.keytype == 1 && kdt.required) {
                    Word wd = this.findTrg(tg.pos, Trgs);
                    if (wd != null && kdt.parent != null) {
                        if (kdt.parent.contains(wd.word)) {
                            has_type = true;
                            tg.type = kdt.type;
                            tg.keytype = 1;
                        }
                    } else if (this.cur_sub == null && this.curr_verb_type == 1 && kdt.parent != null && this.curr_verb.trigs.size() > 0) {
                        wd = this.curr_verb.trigs.get(0);
                        if (kdt.parent.contains(wd.word)) {
                            has_type = true;
                            tg.type = kdt.type;
                            tg.keytype = 1;
                        }
                    }
                }
                if (!has_type) {
                    bs.removeTrg(tg);
                    continue;
                }
                tg.inchunk = true;
                checked.add(tg);
            }
            ++i;
        }
        i = 0;
        while (i < bs.trgList.size()) {
            int pos2;
            boolean has_type;
            Word tg2;
            tg = bs.trgList.get(i);
            if (checked.contains(tg)) {
                ++i;
                continue;
            }
            kdt = this.dic.get(tg.word);
            if (kdt.keytype > 1) {
                if (kdt.score < score) {
                    bs.removeTrg(tg);
                    continue;
                }
                kdt = kdt.getDefault();
            }
            if ((rule = this.rset.get(key = tg.word + (idx = SenSimplifier.hashType.get(kdt.type).intValue()) + tg.pos_tag + "NP")) == null || rule.isSkipped(idx)) {
                bs.removeTrg(tg);
                continue;
            }
            List<Word> pros = null;
            if (tg.pos_tag.startsWith("NN") && i + 1 < bs.trgList.size() && bs.isSameRole(tg, tg2 = bs.trgList.get(i + 1), tokens)) {
                int tgpos1 = bs.getChunkPos(tg.pos);
                int tgpos2 = bs.getChunkPos(tg2.pos);
                if (tgpos2 - tgpos1 == 2) {
                    Chunk c = bs.chunkList.get(tgpos1);
                    c.merge(bs.chunkList.get(tgpos1 + 1));
                    c.merge(bs.chunkList.get(tgpos2));
                    bs.chunkList.remove(tgpos1 + 1);
                    bs.chunkList.remove(tgpos1 + 1);
                }
            }
            String prep = this.getPrep(tg, bs, rule.prep);
            if (tg.pos_tag.startsWith("NN") && !prep.isEmpty()) {
                pros = this.findPro(bs, tg, prep, rule.dist1);
            } else if (!tg.pos_tag.startsWith("NN")) {
                pros = this.findPro(bs, tg, "", rule.dist1);
            }
            if (idx == 5 && pros != null && pros.isEmpty() && rule.getFrontScore() > 0.15) {
                pros = this.findFrontPro(bs, tg, 5);
            }
            kdt = this.dic.get(tg.word);
            if (kdt.keytype > 1 || kdt.required) {
                has_type = false;
                if (pros != null && pros.size() > 0) {
                    Word wd;
                    List<Word> mod = this.getMod(bs, tg, pros, mods);
                    String evt_type = kdt.getType(mod);
                    if (evt_type != null) {
                        tg.type = evt_type;
                        tg.keytype = kdt.keytype == 2 ? 2 : 1;
                        has_type = true;
                    } else if (kdt.keytype == 1 && kdt.required && (wd = this.findTrg(tg.pos, Trgs)) != null && kdt.parent != null && kdt.parent.contains(wd.word)) {
                        has_type = true;
                        tg.type = kdt.type;
                        tg.keytype = 1;
                    }
                } else if (idx > 5 && i < bs.trgList.size() - 1) {
                    Word tg22 = bs.trgList.get(i + 1);
                    pos2 = bs.getChunkPos(tg22.pos);
                    int pos1 = bs.getChunkPos(tg.pos);
                    kdt = kdt.getDefault();
                    if (kdt.child.contains(tg22.word) || pos2 - pos1 > rule.dist1) {
                        // empty if block
                    }
                    tg.type = kdt.type;
                    tg.keytype = 1;
                    has_type = true;
                }
                if (!has_type) {
                    bs.removeTrg(tg);
                    continue;
                }
            } else {
                has_type = false;
                if (pros != null && pros.size() > 0) {
                    tg.type = kdt.type;
                    tg.keytype = 1;
                    has_type = true;
                } else if (idx > 5 && i < bs.trgList.size() - 1) {
                    Word tg23 = bs.trgList.get(i + 1);
                    pos2 = bs.getChunkPos(tg23.pos);
                    int pos1 = bs.getChunkPos(tg.pos);
                    if (kdt.child.contains(tg23.word) || pos2 - pos1 > rule.dist1) {
                        // empty if block
                    }
                    tg.type = kdt.type;
                    tg.keytype = 1;
                    has_type = true;
                }
                if (!has_type) {
                    bs.removeTrg(tg);
                    continue;
                }
            }
            ++i;
        }
    }

    private Word findAnaphora(BasicChunk bs, int dist, Word tg) {
        if (bs.proList.size() == 1) {
            Word pr = bs.proList.get(0);
            if (pr.pos < tg.pos && bs.getChunkPos(tg.pos) - bs.getChunkPos(pr.pos) <= dist) {
                return pr;
            }
        } else if (this.cur_sub != null && this.cur_sub.proList.size() == 1) {
            Word pr = this.cur_sub.proList.get(0);
            if (this.cur_sub.getChunkPos(pr.pos) < dist) {
                return pr;
            }
        }
        return null;
    }

    public Map<String, RuleSets> groupRules(Map<String, Rules>[] map) {
        HashMap<String, RuleSets> ls = new HashMap<String, RuleSets>();
        RuleSets rs = new RuleSets();
        for (int i = 0; i < SenSimplifier.trigger_type.length; ++i) {
            Map<String, Rules> rule = map[i];
            for (String s : rule.keySet()) {
                if (!this.dic.containsKey(s)) continue;
                Rules r = rule.get(s);
                r.initMap();
                for (String key : r.data.keySet()) {
                    List<RuleData> list = r.data.get(key);
                    RuleSets rlset = rs.createRule(list);
                    if (rlset.total < 1) continue;
                    ls.put(s + i + key, rlset);
                }
            }
        }
        return ls;
    }

    private Word findTrg(int pos, List<Word> ls) {
        if (ls == null || ls.isEmpty()) {
            return null;
        }
        for (int i = ls.size() - 1; i >= 0; --i) {
            Word w = ls.get(i);
            if (w.pos >= pos || Math.abs(w.pos - pos) > 10) continue;
            return w;
        }
        return null;
    }

    private Word findTrg(int start, int end, BasicChunk bs) {
        if (bs.trgList == null || bs.trgList.isEmpty()) {
            return null;
        }
        for (Word w : bs.trgList) {
            int pos = bs.getChunkPos(w.pos);
            if (pos > start && pos < end) {
                return w;
            }
            if (pos <= end) continue;
            return null;
        }
        return null;
    }

    public List<PData> extractSimpleNP(Word tg, BasicChunk bc, List<Word> preps) {
        Word pr;
        ArrayList<PData> list = new ArrayList<PData>();
        String ev_type = tg.type;
        int idx = SenSimplifier.hashType.get(tg.type);
        String key = tg.word + idx + tg.pos_tag + "NP";
        RuleSets rule = this.rset.get(key);
        if (rule == null) {
            return list;
        }
        List<Word> pros = null;
        if ((rule.inChunk() || rule.getFrontScore() > 0.01) && tg.inchunk && (pros = this.getInChunkPro(bc, tg)).isEmpty() && this.hasIts(tg.pos, this.tokens) && rule.getFrontScore() > 0.01 && (pr = this.findAnaphora(bc, 5, tg)) != null) {
            pros = new ArrayList<Word>();
            pros.add(pr);
        }
        if (pros == null || pros.isEmpty()) {
            if (tg.pos_tag.startsWith("NN")) {
                String prep = this.getPrep(tg, bc, rule.prep);
                pros = !prep.isEmpty() ? this.findPro(bc, tg, prep, rule.dist1) : this.findPro(bc, tg, "", 3);
            } else {
                pros = this.findPro(bc, tg, "", rule.dist1);
                if (pros.isEmpty() && rule.getFrontScore() > 0.2) {
                    pros = this.findFrontPro(bc, tg, rule.fdist);
                }
            }
        }
        if (pros != null && pros.size() > 0) {
            Word tg2 = null;
            if (tg.keytype == 20) {
                tg2 = tg;
                tg = new Word(tg.word, tg.pos, tg.loc);
                tg.locs = tg2.locs;
                tg.type = "Gene_expression";
                tg.keytype = 1;
                tg2.type = "Positive_regulation";
                tg2.keytype = 1;
            }
            tg.TID = this.getTrgID();
            for (Word w : pros) {
                PData p = new PData(tg, w, ev_type);
                p.PID = this.getEventID();
                this.extractedSet.add(p);
                list.add(p);
                bc.usedPro.add(w);
            }
            if (tg2 != null) {
                this.extractedMap.put(tg, list);
                key = tg2.word + "6" + tg2.pos_tag + "NP";
                rule = this.rset.get(key);
                ArrayList<PData> list1 = new ArrayList<PData>();
                tg2.TID = this.getTrgID();
                tg2.used = true;
                boolean form_event = true;
                if (tg2.inchunk) {
                    if (rule.getEvtScore(0) < 0.5) {
                        form_event = false;
                    }
                } else if (rule.getEvtScore(2) < 0.5) {
                    form_event = false;
                }
                if (form_event) {
                    for (PData pdt : list) {
                        PData p = new PData(tg2, pdt, tg2.type);
                        p.PID = this.getEventID();
                        this.extractedSet.add(p);
                        list1.add(p);
                    }
                } else {
                    for (Word w : pros) {
                        PData p = new PData(tg2, w, tg2.type);
                        p.PID = this.getEventID();
                        this.extractedSet.add(p);
                        list1.add(p);
                        bc.usedPro.add(w);
                    }
                }
                return list1;
            }
        }
        return list;
    }

    public List<PData> extractRegNP(Word tg, BasicChunk bc, List<Word> preps) {
        List<Word> pcause;
        Word tg2;
        String prep1;
        ArrayList<PData> list = new ArrayList<PData>();
        List<Comparable> pro1 = null;
        List<Comparable> pro2 = null;
        KeyData kdt = this.dic.get(tg.word).getKeyData(tg.type);
        int idx = SenSimplifier.hashType.get(tg.type);
        if (kdt.score < 0.15 && idx >= 7 || !(kdt.score < 0.2) || idx == 6) {
            // empty if block
        }
        Set<String> childSet = kdt.child;
        Set<String> parentSet = kdt.parent;
        String key = tg.word + idx + tg.pos_tag + "NP";
        RuleSets rule = this.rset.get(key);
        if (rule == null) {
            return list;
        }
        int len = Math.min(rule.dist1, 0);
        if ((rule.inChunk() || rule.getFrontScore() > 0.01) && tg.inchunk) {
            Word word;
            prep1 = this.getPrep(tg, bc, rule.prep);
            if (rule.getInchunkCause() > 0.05) {
                if ((pro1 == null || pro1.isEmpty()) && rule.getInChunkEvtScore() < this.upperValue) {
                    pro1 = tg.pos_tag.startsWith("NN") ? this.findPro(bc, tg, prep1, rule.dist1) : this.findRegPro(bc, tg, bc.getChunkPos(tg.pos), rule.dist1);
                }
                if ((pro1 == null || pro1.isEmpty()) && rule.getInChunkEvtScore() > this.escore) {
                    if (tg.pos_tag.startsWith("NN")) {
                        if (this.curr_tg < bc.trgList.size() - 1) {
                            tg2 = bc.trgList.get(this.curr_tg + 1);
                            prep1 = this.getPrep(tg, bc, rule.prep);
                            if (prep1 != null && !prep1.isEmpty() && (childSet.contains(tg2.word) || Math.abs(bc.getChunkPos(tg2.pos) - bc.getChunkPos(tg.pos)) <= len)) {
                                ++this.curr_tg;
                                List<PData> list2 = this.extractNP(this.curr_tg, bc, preps);
                                if (list2 != null && !list2.isEmpty()) {
                                    pro1 = list2;
                                }
                            }
                        }
                    } else if (this.curr_tg < bc.trgList.size() - 1) {
                        tg2 = bc.trgList.get(this.curr_tg + 1);
                        if (childSet.contains(tg2.word)) {
                            ++this.curr_tg;
                            List<PData> list3 = this.extractNP(this.curr_tg, bc, preps);
                            if (list3 != null && !list3.isEmpty()) {
                                pro1 = list3;
                            }
                        }
                    }
                }
            }
            if ((pcause = this.findCausePro(bc, tg)).size() > 0) {
                pro1 = this.getInChunkPro(bc, tg);
                pro2 = pcause;
            }
            if ((pro1 == null || pro1.isEmpty()) && (double)((float)rule.count[0] * 1.0f / (float)(rule.count[0] + rule.count[1])) > this.escore) {
                pro1 = this.getInChunkPro(bc, tg);
                if (pro1 != null && pro1.size() > 0) {
                    bc.usedPro.addAll(pro1);
                }
            } else if (pro1 != null && pro1.size() > 0 && pro2 == null) {
                pro2 = this.getInChunkPro(bc, tg);
                if (pro2 != null && pro2.size() > 0) {
                    bc.usedPro.addAll(pro2);
                }
                if (rule.causePrep.contains(prep1)) {
                    List<Word> list4 = pro1;
                    pro1 = pro2;
                    pro2 = list4;
                }
            }
            if (pro1 != null && pro1.isEmpty() && this.hasIts(tg.pos, this.tokens) && rule.getFrontScore() > 0.01 && (word = this.findAnaphora(bc, 5, tg)) != null) {
                pro1 = new ArrayList<Word>();
                pro1.add((PData)((Object)word));
            }
        } else {
            prep1 = this.getPrep(tg, bc, rule.prep);
            if (tg.pos_tag.startsWith("NN")) {
                if (!prep1.isEmpty()) {
                    Object temp2;
                    RuleSets rule2;
                    int[] pairs;
                    if (rule.prepPair.get(prep1) != null && (pairs = this.getPrepPairs(tg.pos, prep1, bc, rule.prepPair.get(prep1), Math.max(rule.dist1, rule.dist2))) != null) {
                        boolean bl;
                        boolean bl2 = false;
                        String txt = bc.chunkList.get((int)pairs[0]).txt + bc.chunkList.get((int)pairs[1]).txt;
                        if (rule.order.contains(txt)) {
                            bl = true;
                        }
                        if (bl) {
                            Word word = this.findTrg(pairs[0], pairs[1], bc);
                            if (word != null && parentSet.contains(word.word)) {
                                ++this.curr_tg;
                                pro2 = this.extractNP(this.curr_tg, bc, preps);
                            }
                            if ((pro2 == null || pro2.isEmpty()) && rule.getEvtCause(3) < this.upperValue && rule.getProCause(3) > this.pscore) {
                                pro2 = this.findPro(bc, pairs[0], pairs[1] - pairs[0] - 1);
                            }
                            if (rule.getEvtScore(3) < this.upperValue && rule.getProScore(3) > this.pscore) {
                                pro1 = this.findRegPro(bc, tg, pairs[1], rule.dist2);
                            }
                            if ((pro1 == null || pro1.isEmpty()) && this.curr_tg < bc.trgList.size() - 1) {
                                Word word2 = bc.trgList.get(this.curr_tg + 1);
                                if (childSet.contains(word2.word)) {
                                    ++this.curr_tg;
                                    List<PData> temp3 = this.extractNP(this.curr_tg, bc, preps);
                                    if (temp3 != null && !temp3.isEmpty()) {
                                        pro1 = temp3;
                                    }
                                }
                            }
                            if (pro1 == null || pro1.isEmpty()) {
                                return list;
                            }
                        } else {
                            Word word = this.findTrg(pairs[0], pairs[1], bc);
                            if (word != null && childSet.contains(word.word)) {
                                ++this.curr_tg;
                                pro1 = this.extractNP(this.curr_tg, bc, preps);
                            }
                            if ((pro1 == null || pro1.isEmpty()) && rule.getEvtScore(3) < this.upperValue && rule.getProScore(3) > this.pscore) {
                                pro1 = this.findPro(bc, pairs[0], pairs[1] - pairs[0] - 1);
                            }
                            if (rule.getEvtCause(3) < this.upperValue && rule.getProCause(3) > this.pscore) {
                                pro2 = this.findRegPro(bc, tg, pairs[1], rule.dist2);
                            }
                            if ((pro2 == null || pro2.isEmpty()) && this.curr_tg < bc.trgList.size() - 1) {
                                Word word3 = bc.trgList.get(this.curr_tg + 1);
                                if (parentSet.contains(word3.word)) {
                                    ++this.curr_tg;
                                    List<PData> temp = this.extractNP(this.curr_tg, bc, preps);
                                    if (temp != null && !temp.isEmpty()) {
                                        pro2 = temp;
                                    }
                                }
                            }
                            if (pro2 != null && pro2.isEmpty()) {
                                pro2 = null;
                            }
                        }
                    }
                    if (pro1 == null || pro1.isEmpty()) {
                        if (rule.getEvtScore(2) < this.upperValue && rule.getProScore(2) > this.pscore) {
                            pro1 = this.findPro(bc, tg, prep1, rule.dist1);
                        }
                        if ((pro1 == null || pro1.isEmpty()) && this.curr_tg < bc.trgList.size() - 1) {
                            tg2 = bc.trgList.get(this.curr_tg + 1);
                            if (childSet.contains(tg2.word)) {
                                ++this.curr_tg;
                                List<PData> list5 = this.extractNP(this.curr_tg, bc, preps);
                                if (list5 != null && !list5.isEmpty()) {
                                    pro1 = list5;
                                }
                            }
                        }
                    }
                    if ((pcause = this.findCausePro(bc, tg)).size() > 0 && pro1 != null && pro1.size() > 0) {
                        pro2 = pcause;
                    }
                    Word word = this.findFrontPrep(tg, bc);
                    if (pro1 != null && pro1.size() > 0 && word != null && this.cur_sub != null && (rule2 = this.rset.get(key = tg.word + idx + tg.pos_tag + "CP")) != null && rule2.frontPrep.contains(word.word)) {
                        pro2 = this.findFrontPro(this.cur_sub, tg, rule2.fdist);
                    }
                    if (pro1 != null && pro1.size() > 0 && pro2 == null && rule.causePrep.contains(prep1) && rule.getEvtCause(5) < this.upperValue && rule.getProCause(5) > this.pscore && (temp2 = this.findFrontPro(bc, tg, rule.fdist)).size() > 0) {
                        pro2 = pro1;
                        pro1 = temp2;
                    }
                } else if (rule.getBehindScore() > rule.getFrontScore()) {
                    // empty if block
                }
            } else {
                if (rule.getBehindScore() > rule.getFrontScore()) {
                    List<Word> list6;
                    List<Word> list7;
                    if (rule.getEvtScore(2) < this.upperValue && rule.getProScore(3) > this.pscore) {
                        pro1 = this.findRegPro(bc, tg, bc.getChunkPos(tg.pos), rule.dist1);
                    }
                    if ((pro1 == null || pro1.isEmpty()) && this.curr_tg < bc.trgList.size() - 1) {
                        tg2 = bc.trgList.get(this.curr_tg + 1);
                        if (childSet.contains(tg2.word)) {
                            ++this.curr_tg;
                            List<PData> list8 = this.extractNP(this.curr_tg, bc, preps);
                            if (list8 != null && !list8.isEmpty()) {
                                pro1 = list8;
                            }
                        }
                    }
                    Word frontPrep = this.findFrontPrep(tg, bc);
                    if (pro1 != null && pro1.size() > 0 && frontPrep != null && rule.frontPrep.contains(frontPrep.word) && (list7 = this.findFrontPro(bc, tg, rule.fdist)).size() > 0) {
                        pro2 = pro1;
                        pro1 = list7;
                    }
                    if (pro1 != null && pro1.size() > 0 && pro2 == null && rule.causePrep.contains(prep1) && rule.getEvtCause(5) < this.upperValue && (list6 = this.findFrontPro(bc, tg, rule.fdist)).size() > 0) {
                        pro2 = pro1;
                        pro1 = list6;
                    }
                }
                if ((pro1 == null || pro1.isEmpty()) && rule.getBehindScore() > 0.1) {
                    if (rule.getEvtCause(5) < this.upperValue) {
                        pro1 = this.findFrontPro(bc, tg, rule.fdist);
                    }
                    if ((pro1 == null || pro1.isEmpty()) && rule.getEvtCause(4) > this.ecause && this.curr_tg >= 1) {
                        tg2 = bc.trgList.get(this.curr_tg - 1);
                        if (childSet.contains(tg2.word) && this.extractedMap.containsKey(tg2)) {
                            pro1 = this.extractedMap.get(tg2);
                        }
                    }
                }
            }
        }
        if (pro1 != null && pro1.size() > 0 && pro2 != null && pro2.size() > 0) {
            this.removeDuplicate(pro1, pro2);
        }
        if (pro1 != null && pro1.size() > 0 && pro2 != null && pro2.size() > 0) {
            tg.TID = this.getTrgID();
            for (Word word : pro1) {
                for (Word word4 : pro2) {
                    PData pair = new PData(tg, word, word4, tg.type);
                    pair.PID = this.getEventID();
                    this.extractedSet.add(pair);
                    list.add(pair);
                }
            }
            return list;
        }
        if (pro1 != null && pro1.size() > 0) {
            tg.TID = this.getTrgID();
            for (Word word : pro1) {
                PData pair = new PData(tg, word, tg.type);
                pair.PID = this.getEventID();
                this.extractedSet.add(pair);
                list.add(pair);
            }
            return list;
        }
        return list;
    }

    public List<PData> extractRegVP(Word tg, VerbChunk vc, List<Word> preps) {
        ArrayList<PData> list = new ArrayList<PData>();
        List pro1 = null;
        List pro2 = null;
        int idx = SenSimplifier.hashType.get(tg.type);
        KeyData kdt = this.dic.get(tg.word).getKeyData(tg.type);
        Set<String> childSet = kdt.child;
        Set<String> parentSet = kdt.parent;
        String key = tg.word + idx + tg.pos_tag + "VP";
        RuleSets rule = this.rset.get(key);
        if (rule == null || rule.isSkipped()) {
            return list;
        }
        String prep1 = this.getPrep(tg, vc.object, rule.prep);
        if (vc.verb_type == 1 && tg.pos_tag.equals("VBN") && rule.passive_order || prep1 != null && prep1.equals("by")) {
            if (rule.passive_order) {
                double cause_score = (float)rule.count[5] * 1.0f / (float)(rule.count[5] + rule.count[4]);
                if (rule.causePrep.contains(prep1) || cause_score > this.ecause) {
                    if (rule.getEvtScore(4) < this.upperValue) {
                        pro1 = this.findFrontPro(vc.subject, tg, rule.fdist);
                    }
                    if ((pro1 == null || pro1.isEmpty()) && rule.getEvtScore(4) > this.escore) {
                        pro1 = this.findEvent(vc.subject, rule.fdist);
                    }
                    if (pro1 != null && pro1.size() > 0 && cause_score > this.ecause) {
                        if (rule.getEvtCause(5) < this.upperValue) {
                            pro2 = this.findRegPro(vc.object, tg, -1, rule.dist1);
                        }
                        if ((pro2 == null || pro2.isEmpty()) && rule.getEvtCause(5) > this.ecause && ((pro2 = this.findEvent(vc.object, rule.dist1)) == null || pro2.isEmpty())) {
                            return list;
                        }
                    }
                } else {
                    if (rule.getEvtScore(4) < this.upperValue) {
                        pro1 = this.findFrontPro(vc.subject, tg, rule.fdist);
                    }
                    if ((pro1 == null || pro1.isEmpty()) && rule.getEvtScore(4) > this.escore) {
                        pro1 = this.findEvent(vc.subject, rule.fdist);
                    }
                }
            }
        } else {
            double fcause = (float)rule.count[5] * 1.0f / (float)(rule.count[4] + rule.count[5]);
            double bcause = (float)rule.count[6] * 1.0f / (float)(rule.count[2] + rule.count[6]);
            if (rule.getEvtScore(2) < this.upperValue) {
                pro1 = this.findRegPro(vc.object, tg, -1, rule.dist1);
            }
            if ((pro1 == null || pro1.isEmpty()) && rule.getEvtScore(2) > this.escore) {
                pro1 = this.findEvent(vc.object, rule.dist1);
            }
            if (pro1 != null && pro1.size() > 0 && bcause > this.ecause) {
                if (rule.getEvtCause(6) < this.upperValue) {
                    pro2 = this.findFrontPro(vc.subject, tg, rule.fdist);
                }
                if ((pro2 == null || pro2.isEmpty()) && rule.getEvtCause(6) > this.ecause) {
                    pro2 = this.findEvent(vc.subject, rule.fdist);
                }
            }
            if ((pro1 == null || pro1.isEmpty()) && (double)((float)(rule.count[4] + rule.count[5]) * 1.0f / (float)rule.total) > this.escore) {
                if (rule.getEvtScore(4) < this.upperValue) {
                    pro1 = this.findFrontPro(vc.subject, tg, rule.fdist);
                }
                if ((pro1 == null || pro1.isEmpty()) && rule.getEvtScore(4) > this.escore) {
                    pro1 = this.findEvent(vc.subject, rule.fdist);
                }
                if (pro1 != null && pro1.size() > 0 && fcause > this.ecause) {
                    if (rule.getEvtCause(5) < this.upperValue) {
                        pro2 = this.findRegPro(vc.object, tg, -1, rule.dist1);
                    }
                    if ((pro2 == null || pro2.isEmpty()) && rule.getEvtCause(5) > this.ecause && ((pro2 = this.findEvent(vc.object, rule.dist1)) == null || pro2.isEmpty())) {
                        return list;
                    }
                }
            }
        }
        if (pro1 != null && pro1.size() > 0 && pro2 != null && pro2.size() > 0) {
            tg.TID = this.getTrgID();
            for (Object obj1 : pro1) {
                for (Object obj2 : pro2) {
                    PData pair = new PData(tg, obj1, obj2, tg.type);
                    pair.PID = this.getEventID();
                    this.extractedSet.add(pair);
                    list.add(pair);
                }
            }
            return list;
        }
        if (pro1 != null && pro1.size() > 0) {
            tg.TID = this.getTrgID();
            for (Object obj1 : pro1) {
                PData pair = new PData(tg, obj1, tg.type);
                pair.PID = this.getEventID();
                this.extractedSet.add(pair);
                list.add(pair);
            }
            return list;
        }
        return list;
    }

    private List<Word>[] splitProByAnd(List<Word> ls, String[] tokens) {
        ArrayList[] rs = new ArrayList[]{new ArrayList(), new ArrayList()};
        int idx = 0;
        if (ls.size() <= 1) {
            rs[0] = ls;
            return rs;
        }
        int pos1 = ls.get((int)0).pos;
        int pos2 = ls.get((int)(ls.size() - 1)).pos;
        for (int i = pos1 + 1; i < pos2; ++i) {
            if (!tokens[i].equals("and")) continue;
            idx = i;
            break;
        }
        if (idx > pos1 && idx < pos2) {
            for (Word w : ls) {
                if (w.pos < idx) {
                    rs[0].add(w);
                    continue;
                }
                rs[1].add(w);
            }
        }
        return rs;
    }

    private List<Word[]> splitProPair(List<Word> pros) {
        ArrayList<Word[]> ls = new ArrayList<Word[]>();
        block0: for (int i = 0; i < pros.size() - 1; ++i) {
            Word pr = pros.get(i);
            for (int j = i + 1; j < pros.size(); ++j) {
                Word pr2 = pros.get(j);
                if (pr2.compound && pr2.pos == pr.pos) {
                    Word[] pair = new Word[]{pr, pr2};
                    ls.add(pair);
                    continue block0;
                }
                if (pr2.pos > pr.pos) continue block0;
            }
        }
        return ls;
    }

    public List<PData> extractBindNP(Word tg, BasicChunk bc, List<Word> preps) {
        String prep;
        ArrayList<PData> list = new ArrayList<PData>();
        String ev_type = tg.type;
        String key = tg.word + "5" + tg.pos_tag + "NP";
        RuleSets rule = this.rset.get(key);
        List<Word> pro1 = null;
        List<Word> pro2 = null;
        boolean inchunk = false;
        if (rule == null) {
            return list;
        }
        if ((rule.getFrontScore() > 0.01 || rule.inChunk()) && tg.inchunk) {
            Word pr;
            pro1 = this.getInChunkPro(bc, tg);
            if (pro1 != null && pro1.size() > 0 && rule.getInchunkCause() > 0.1 && !(prep = this.getPrep(tg, bc, rule.prep)).isEmpty()) {
                pro2 = this.findPro(bc, tg, prep, rule.dist1);
            }
            if (pro1 != null && pro1.size() > 0) {
                inchunk = true;
            }
            if (pro1.isEmpty() && this.hasIts(tg.pos, this.tokens) && rule.getFrontScore() > 0.01 && (pr = this.findAnaphora(bc, 5, tg)) != null) {
                pro1 = new ArrayList<Word>();
                pro1.add(pr);
            }
        }
        if (pro1 == null || pro1.isEmpty()) {
            Word frontPrep;
            prep = this.getPrep(tg, bc, rule.prep);
            if (tg.pos_tag.startsWith("NN")) {
                if (!prep.isEmpty()) {
                    int[] pairs;
                    if (rule.prepPair.get(prep) != null && (pairs = this.getPrepPairs(tg.pos, prep, bc, rule.prepPair.get(prep), rule.dist2)) != null) {
                        int p1 = pairs[0];
                        int p2 = pairs[1];
                        List<Word> list2 = this.findPro(bc, p1, p2 - p1 - 1);
                        List<Word> pros2 = this.findPro(bc, p2, rule.dist2);
                        if (!list2.isEmpty() && !pros2.isEmpty()) {
                            pro1 = list2;
                            pro2 = pros2;
                        } else if (!list2.isEmpty()) {
                            pro1 = list2;
                        }
                    }
                    if (pro1 == null || pro1.isEmpty()) {
                        pro1 = this.findPro(bc, tg, prep, rule.dist1);
                        frontPrep = this.findFrontPrep(tg, bc);
                        if (pro1.size() > 0) {
                            if (prep.equals("between") || tg.word.startsWith("interaction") && prep.equals("of")) {
                                List<Word>[] prs = this.splitProByAnd(pro1, this.tokens);
                                if (prs != null) {
                                    pro1 = prs[0];
                                    pro2 = prs[1];
                                }
                            } else if (frontPrep != null) {
                                String string;
                                RuleSets rule2;
                                if (this.cur_sub != null && (rule2 = this.rset.get(key = tg.word + "5" + tg.pos_tag + "CP")) != null && rule2.frontPrep.contains(frontPrep.word) && !(string = this.getPrep(tg, bc, rule2.prep)).isEmpty()) {
                                    pro1 = this.findFrontPro(this.cur_sub, tg, rule2.fdist);
                                    pro2 = this.findPro(bc, tg, string, rule2.dist1);
                                }
                            } else if ((double)((float)rule.count[3] * 1.0f / (float)rule.total) > 0.2) {
                                // empty if block
                            }
                        }
                    }
                } else {
                    if (rule.getFrontScore() < rule.getBehindScore()) {
                        pro1 = this.findPro(bc, tg, prep, rule.dist1);
                    }
                    if ((pro1 == null || pro1.isEmpty()) && rule.getFrontScore() > 0.1) {
                        pro1 = this.findPro(bc, tg, prep, rule.fdist);
                    }
                }
            } else {
                pro1 = this.findPro(bc, tg, prep, rule.dist1);
                frontPrep = this.findFrontPrep(tg, bc);
                if (frontPrep != null && this.cur_sub != null) {
                    Object prep_2;
                    key = tg.word + "5" + tg.pos_tag + "CP";
                    RuleSets ruleSets = this.rset.get(key);
                    if (ruleSets != null && ruleSets.frontPrep.contains(frontPrep.word) && !((String)(prep_2 = this.getPrep(tg, bc, ruleSets.prep))).isEmpty()) {
                        pro1 = this.findFrontPro(this.cur_sub, tg, ruleSets.fdist);
                        pro2 = this.findPro(bc, tg, (String)prep_2, ruleSets.dist1);
                    }
                } else if (pro1.size() > 0 && prep != null) {
                    Object pros2;
                    if ((double)((float)rule.count[5] * 1.0f / (float)rule.total) > 0.1 && (pros2 = this.findFrontPro(bc, tg, rule.fdist)).size() > 0) {
                        pro2 = pro1;
                        pro1 = pros2;
                    }
                } else if (pro1.isEmpty() && rule.getFrontScore() > 0.1) {
                    pro1 = this.findFrontPro(bc, tg, rule.fdist);
                }
            }
        }
        if (pro1 != null && pro1.size() > 0 && pro2 != null && pro2.size() > 0) {
            this.removeDuplicate(pro1, pro2);
        }
        if (pro1 != null && pro1.size() > 0) {
            List<Word[]> pair;
            bc.usedPro.addAll(pro1);
            if (pro2 != null && pro2.size() > 0) {
                bc.usedPro.addAll((Collection<Word>)pro2);
                tg.TID = this.getTrgID();
                for (Word word : pro1) {
                    for (Word pr2 : pro2) {
                        PData p = new PData(tg, word, pr2, ev_type);
                        p.PID = this.getEventID();
                        this.extractedSet.add(p);
                        list.add(p);
                    }
                }
                return list;
            }
            if (inchunk && pro1.size() == 2 && rule.getInchunkCause() > 0.2 && (pair = this.splitProPair(pro1)).size() > 0) {
                tg.TID = this.getTrgID();
                for (Word[] pw : pair) {
                    PData p = new PData(tg, pw[0], pw[1], ev_type);
                    p.PID = this.getEventID();
                    this.extractedSet.add(p);
                    list.add(p);
                }
                return list;
            }
            tg.TID = this.getTrgID();
            for (Word word : pro1) {
                PData p = new PData(tg, word, ev_type);
                p.PID = this.getEventID();
                this.extractedSet.add(p);
                list.add(p);
            }
            return list;
        }
        return list;
    }

    private int[] getPrepPairs(int pos, String prep1, BasicChunk bs, Set<String> set, int dist) {
        int[] pair = new int[2];
        int idx = bs.getChunkPos(pos);
        int stop = Math.min(idx + dist, bs.chunkList.size() - 1);
        int prepcount = 0;
        block0: for (int i = idx + 1; i < stop; ++i) {
            Chunk c = bs.chunkList.get(i);
            if (!c.txt.equals(prep1)) continue;
            for (int j = i + 1; j < stop; ++j) {
                Chunk c2 = bs.chunkList.get(j);
                if (set.contains(c2.txt)) {
                    pair[0] = i;
                    pair[1] = j;
                    return pair;
                }
                if (c2.type.equals("PP")) {
                    ++prepcount;
                }
                if (prepcount > 1) continue block0;
            }
        }
        return null;
    }

    private Word findFrontPrep(Word tg, BasicChunk bc) {
        int tg_pos = bc.getChunkPos(tg.pos);
        if (tg_pos > 0) {
            for (int i = 1; i <= 4; ++i) {
                int idx = tg_pos - i;
                if (idx < 0) continue;
                Chunk c = bc.chunkList.get(idx);
                if (!prepSet.contains(c.txt)) continue;
                return new Word(c.txt, c.begin, 0);
            }
        }
        return null;
    }

    private void removeDuplicate(List l1, List l2) {
        if (l1.equals(l2)) {
            l2.clear();
        } else {
            for (Object ob : l2) {
                if (!l1.contains(ob)) continue;
                l1.remove(ob);
            }
        }
    }

    private int getPrep(List<Word> pro, BasicChunk bs, Set<String> set, int limit) {
        int pos = 0;
        for (Word w : pro) {
            pos = Math.max(pos, w.pos);
        }
        if ((pos = bs.getChunkPos(pos)) >= 0) {
            return this.getPrep(pos, bs, set, limit);
        }
        return -1;
    }

    private List findEvent(BasicChunk bc, int dist) {
        for (Word w : bc.trgList) {
            int pos = bc.getChunkPos(w.pos);
            if (bc.failed.contains(w) || !this.extractedMap.containsKey(w) || pos > dist) continue;
            return this.extractedMap.get(w);
        }
        return null;
    }

    private int getPrep(int pos, BasicChunk bs, Set<String> prep2, int limit) {
        int stop = Math.min(bs.chunkList.size() - 1, limit);
        for (int i = bs.getChunkPos(pos) + 1; i <= stop; ++i) {
            Chunk c = bs.chunkList.get(i);
            if (!prep2.contains(c.txt)) continue;
            return i;
        }
        return -1;
    }

    public void extractNP(BasicChunk bs, List<Word> preps) {
        this.curr_tg = 0;
        this.sameRole.clear();
        if (bs.extracted) {
            return;
        }
        while (this.curr_tg < bs.trgList.size()) {
            this.extractNP(this.curr_tg, bs, preps);
            ++this.curr_tg;
        }
        bs.extracted = true;
    }

    public List<PData> extractNP(int idx, BasicChunk bs, List<Word> preps) {
        List<PData> temp = null;
        if (idx < bs.trgList.size()) {
            int ev_type;
            Word tg2;
            Word tg = bs.trgList.get(idx);
            if (this.usedTrg.contains(tg) || tg.used) {
                return temp;
            }
            if (idx + 1 < bs.trgList.size() && bs.isSameRole(tg, tg2 = bs.trgList.get(idx + 1), this.tokens)) {
                this.sameRole.add(tg);
                this.sameRole.add(tg2);
            }
            this.same_role = false;
            if (this.sameRole.contains(tg)) {
                this.same_role = true;
            }
            if ((temp = (ev_type = SenSimplifier.hashType.get(tg.type).intValue()) < 5 ? this.extractSimpleNP(tg, bs, preps) : (ev_type == 5 ? this.extractBindNP(tg, bs, preps) : this.extractRegNP(tg, bs, preps))) != null && temp.size() > 0) {
                this.extractedMap.put(tg, temp);
                this.usedTrg.add(tg);
            } else if (temp != null && temp.isEmpty()) {
                bs.failed.add(tg);
            }
        }
        return temp;
    }

    public List<Word> getMod(Chunk c1, Chunk c2, List<Word> ls) {
        ArrayList<Word> list = new ArrayList<Word>();
        int pos1 = Math.min(c1.begin, c2.begin);
        int pos2 = Math.max(c1.end, c2.end);
        for (Word w : ls) {
            if (w.pos < pos1 || w.pos > pos2) continue;
            list.add(w);
        }
        return list;
    }

    public List<Word> getMod(int pos1, int pos2, List<Word> ls) {
        ArrayList<Word> list = new ArrayList<Word>();
        for (Word w : ls) {
            if (w.pos < pos1 || w.pos > pos2) continue;
            list.add(w);
        }
        return list;
    }

    public List<Word> getMod(BasicChunk bs, Word tg, List<Word> ls) {
        ArrayList<Word> list = new ArrayList<Word>();
        Chunk c = bs.getChunk(tg.pos);
        int pos1 = c.begin;
        int pos2 = c.end;
        for (Word w : ls) {
            if (w.pos < pos1 || w.pos > pos2) continue;
            list.add(w);
        }
        return list;
    }

    public List<Word> getMod(BasicChunk bs, Word tg, List<Word> pros, List<Word> ls) {
        Chunk c1 = bs.getChunk(tg.pos);
        int max = 0;
        int min = 1000000;
        for (Word pr : pros) {
            if (pr.pos > max) {
                max = pr.pos;
            }
            if (pr.pos >= min) continue;
            min = pr.pos;
        }
        if (c1 == null) {
            c1 = bs.getChunk(min);
        }
        Chunk c2 = bs.getChunk(max);
        return this.getMod(c1, c2, ls);
    }

    public List<PData> extractSimpleVP(Word tg, VerbChunk vc, List<Word> mods) {
        ArrayList<PData> list = new ArrayList<PData>();
        KeyData kdt = this.dic.get(tg.word);
        if (kdt != null) {
            BasicChunk bc;
            List<Word> pros;
            String key;
            RuleSets rule;
            String ev_type = kdt.getDefault().type;
            int idx = SenSimplifier.hashType.get(ev_type);
            if (kdt.keytype == 2) {
                idx = 0;
            }
            if ((rule = this.rset.get(key = tg.word + idx + tg.pos_tag + "VP")) == null || rule.isSkipped()) {
                return list;
            }
            if (vc.verb_type == 1 && tg.pos_tag.equals("VBN")) {
                pros = null;
                bc = vc.object;
                if (bc.chunkList.size() > 0) {
                    String prep = this.getPrepVerb(bc, rule.prep);
                    if (!prep.isEmpty()) {
                        pros = this.findPro(bc, tg, prep, rule.dist1);
                    }
                    if (pros == null || pros.isEmpty()) {
                        bc = vc.subject;
                        pros = this.findFrontPro(bc, tg, rule.fdist);
                    }
                }
            } else {
                bc = vc.object;
                pros = this.findPro(bc, tg, "", rule.dist1);
                if (pros.isEmpty() && tg.pos_tag.equals("VBN") && rule.getFrontScore() > 0.1) {
                    pros = this.findFrontPro(bc, tg, rule.fdist);
                }
            }
            if (pros != null && pros.size() > 0) {
                Word tg2 = null;
                if (kdt.keytype == 3 || kdt.required && kdt.keytype == 1) {
                    List<Word> mod = this.getMod(bc, tg, pros, mods);
                    ev_type = kdt.getType(mod);
                    if (ev_type == null) {
                        return list;
                    }
                    tg.keytype = kdt.keytype == 2 ? 2 : 1;
                }
                tg.type = ev_type;
                if (tg.keytype == 20) {
                    tg2 = tg;
                    tg = new Word(tg.word, tg.pos, tg.loc);
                    tg.locs = tg2.locs;
                    tg.type = "Gene_expression";
                    tg.keytype = 1;
                    tg2.type = "Positive_regulation";
                    tg2.keytype = 1;
                }
                tg.TID = this.getTrgID();
                for (Word w : pros) {
                    PData p = new PData(tg, w, ev_type);
                    p.PID = this.getEventID();
                    this.extractedSet.add(p);
                    list.add(p);
                    bc.usedPro.add(w);
                }
                if (tg2 != null) {
                    this.extractedMap.put(tg, list);
                    ArrayList<PData> list1 = new ArrayList<PData>();
                    tg2.TID = this.getTrgID();
                    for (PData pdt : list) {
                        PData p = new PData(tg2, pdt, tg2.type);
                        p.PID = this.getEventID();
                        this.extractedSet.add(p);
                        list1.add(p);
                    }
                    return list1;
                }
            }
        }
        return list;
    }

    public List<PData> extractBindVP(Word tg, VerbChunk vc, List<Word> preps) {
        ArrayList<PData> list;
        block8: {
            List<Word> pros2;
            list = new ArrayList<PData>();
            String ev_type = tg.type;
            String key = tg.word + "5" + tg.pos_tag + "VP";
            RuleSets rule = this.rset.get(key);
            if (rule == null || rule.isSkipped()) {
                return list;
            }
            List<Word> pro1 = null;
            List<Word> pro2 = null;
            String prep = this.getPrepVerb(vc.object, rule.prep);
            pro1 = this.findPro(vc.object, tg, prep, rule.dist1);
            if (pro1.size() > 0 && (double)((float)rule.count[5] * 1.0f / (float)rule.total) > 0.1 && (pros2 = this.findFrontPro(vc.subject, tg, rule.fdist)).size() > 0) {
                pro2 = pro1;
                pro1 = pros2;
            }
            if (pro1 == null || pro1.isEmpty()) {
                pro1 = this.findFrontPro(vc.subject, tg, rule.dist1);
            }
            if (pro1 == null || pro1.size() <= 0) break block8;
            if (pro2 != null && pro2.size() > 0) {
                tg.TID = this.getTrgID();
                for (Word pr1 : pro1) {
                    for (Word pr2 : pro2) {
                        PData p = new PData(tg, pr1, pr2, ev_type);
                        p.PID = this.getEventID();
                        this.extractedSet.add(p);
                        list.add(p);
                    }
                }
            } else {
                tg.TID = this.getTrgID();
                for (Word w : pro1) {
                    PData p = new PData(tg, w, ev_type);
                    p.PID = this.getEventID();
                    this.extractedSet.add(p);
                    list.add(p);
                }
            }
        }
        return list;
    }

    public List<Word> getInChunkPro(BasicChunk bs, Word tg) {
        Chunk chunk = bs.getChunk(tg.pos);
        if (chunk != null) {
            return chunk.getInChunkPro(tg, this.tokens);
        }
        return new ArrayList<Word>();
    }

    public List<Word> findPro(BasicChunk bs, Word tg, String prep, int len) {
        ArrayList<Word> ls = new ArrayList<Word>();
        boolean found_pro = false;
        len = Math.min(len, this.noun_len);
        Chunk chunk = bs.getChunk(tg.pos);
        int pos = 0;
        if (chunk != null) {
            pos = bs.chunkList.indexOf(chunk);
        } else if (!bs.proList.isEmpty() && !bs.trgList.isEmpty()) {
            Word p1 = bs.proList.get(0);
            Word t1 = bs.trgList.get(0);
            if (p1.pos > t1.pos) {
                return ls;
            }
        }
        int stop = Math.min(len + pos, bs.chunkList.size() - 1);
        int idx = pos;
        if (!prep.isEmpty() && chunk != null) {
            idx = pos + 2;
        } else if (chunk != null) {
            List<Word> temp = chunk.getPro(tg, this.tokens);
            if (temp.size() > 0) {
                for (Word w : temp) {
                    if (w.pos <= tg.pos || bs.usedPro.contains(w) && !this.same_role) continue;
                    ls.add(w);
                }
            }
            if (ls.size() > 0) {
                found_pro = true;
            }
            ++idx;
        }
        for (int i = idx; i <= stop; ++i) {
            Chunk c = bs.chunkList.get(i);
            if (c.type.equals("VP") || c.type.equals("PP") && found_pro) break;
            List<Word> temp = c.getPro(this.tokens);
            if (temp.size() > 0 && temp.size() > 0) {
                for (Word w : temp) {
                    if (bs.usedPro.contains(w) && !this.same_role) continue;
                    ls.add(w);
                }
                if (!ls.isEmpty()) {
                    found_pro = true;
                }
            }
            if (c.trigs.size() > 0 && !this.same_role) break;
            if (c.trigs.size() <= 0 || !this.same_role) continue;
            this.same_role = false;
        }
        return ls;
    }

    private int getStop(BasicChunk bs, Word tg) {
        if (bs.trgList.isEmpty()) {
            return bs.chunkList.size() - 1;
        }
        int i = 0;
        while (i < bs.trgList.size()) {
            Word c = bs.trgList.get(i);
            if (c.pos < tg.pos) {
                ++i;
                continue;
            }
            if (bs.isSameRole(tg, c, this.tokens)) {
                ++i;
                continue;
            }
            return bs.getChunkPos(c.pos);
        }
        return bs.chunkList.size() - 1;
    }

    public List<Word> findCausePro(BasicChunk bs, Word tg) {
        ArrayList<Word> ls = new ArrayList<Word>();
        int pos = bs.getChunkPos(tg.pos);
        if (pos >= 0) {
            Chunk c = bs.chunkList.get(pos);
            return c.cause;
        }
        return ls;
    }

    public List<Word> findPro(BasicChunk bs, int start, int len) {
        ArrayList<Word> ls = new ArrayList<Word>();
        int stop = Math.min(len + start, bs.chunkList.size() - 1);
        int idx = start;
        boolean found_pro = false;
        for (int i = idx; i <= stop; ++i) {
            Chunk c = bs.chunkList.get(i);
            List<Word> temp = c.getPro(this.tokens);
            if (temp.size() > 0 && temp.size() > 0) {
                for (Word w : temp) {
                    if (bs.usedPro.contains(w) && !this.same_role) continue;
                    ls.add(w);
                }
                if (!ls.isEmpty()) {
                    found_pro = true;
                }
            }
            if (c.type.equals("VP") || c.type.equals("PP") && found_pro || c.trigs.size() > 0 && !this.same_role) break;
            if (c.trigs.size() <= 0 || !this.same_role) continue;
            this.same_role = false;
        }
        return ls;
    }

    public List<Word> findRegPro(BasicChunk bs, Word tg, int start, int len) {
        ArrayList<Word> ls = new ArrayList<Word>();
        int pos = start;
        int tg_pos = -1;
        boolean prep_count = false;
        boolean found_pro = false;
        int limit = bs.chunkList.size() - 1;
        if (pos >= 0) {
            Chunk chunk;
            List<Word> temp;
            int pos1 = bs.trgList.indexOf(tg);
            if (pos1 < bs.trgList.size() - 1) {
                Word tg2 = bs.trgList.get(pos1 + 1);
                if (this.sameRole.contains(tg2)) {
                    if (pos1 < bs.trgList.size() - 2) {
                        tg_pos = bs.trgList.get((int)(pos1 + 2)).pos;
                    }
                } else {
                    tg_pos = tg2.pos;
                }
            }
            if ((temp = (chunk = bs.chunkList.get(pos)).getPro(tg, this.tokens)).size() > 0) {
                for (Word w : temp) {
                    if ((w.pos <= tg.pos || bs.usedPro.contains(w)) && !this.same_role) continue;
                    ls.add(w);
                }
            }
            if (ls.size() > 0) {
                found_pro = true;
            }
        } else {
            if (bs.trgList.size() > 0) {
                tg_pos = bs.trgList.get((int)0).pos;
            }
            pos = 0;
        }
        if (tg_pos > 0) {
            limit = bs.getChunkPos(tg_pos);
        }
        int idx = pos;
        int stop = Math.min(len + pos, limit);
        for (int i = idx; i <= stop; ++i) {
            Chunk c = bs.chunkList.get(i);
            List<Word> temp = c.getPro(this.tokens);
            if (temp.size() > 0 && temp.size() > 0) {
                for (Word w : temp) {
                    if (bs.usedPro.contains(w) && !this.same_role) continue;
                    ls.add(w);
                }
                if (!ls.isEmpty()) {
                    found_pro = true;
                }
            }
            if (c.type.equals("VP") || c.type.equals("PP") && found_pro || c.trigs.size() > 0 && !this.same_role) break;
            if (c.trigs.size() <= 0 || !this.same_role) continue;
            this.same_role = false;
        }
        return ls;
    }

    public List<Word> findFrontPro(BasicChunk bs, Word tg, int len) {
        ArrayList<Word> ls = new ArrayList<Word>();
        boolean found_pro = false;
        len = Math.min(len, this.noun_len);
        Chunk chunk = bs.getChunk(tg.pos);
        int start = 0;
        if (chunk == null) {
            if (!bs.proList.isEmpty() && !bs.trgList.isEmpty()) {
                Word p1 = bs.proList.get(0);
                Word t1 = bs.trgList.get(0);
                if (p1.pos > t1.pos) {
                    return ls;
                }
            }
            int pos = bs.chunkList.size() - 1;
            int idx = Math.min(len, pos);
            for (int i = start; i <= idx; ++i) {
                Chunk c = bs.chunkList.get(i);
                List<Word> temp = c.getPro(this.tokens);
                if (temp.size() > 0) {
                    for (Word w : temp) {
                        if (bs.usedPro.contains(w) && !this.check_pro) continue;
                        ls.add(w);
                    }
                    if (!ls.isEmpty()) {
                        found_pro = true;
                    }
                }
                if ((c.type.equals("VP") || c.type.equals("PP")) && found_pro || c.pros.isEmpty() && c.trigs.size() > 0) break;
            }
            return ls;
        }
        int pos = bs.chunkList.indexOf(chunk);
        int end = Math.max(0, pos - len);
        int idx = pos;
        List<Word> temp1 = bs.chunkList.get(idx).getInChunkPro(tg, this.tokens);
        if (temp1.size() > 0) {
            for (Word w : temp1) {
                if (bs.usedPro.contains(w) && !this.check_pro && !this.same_role) continue;
                ls.add(w);
            }
            if (!ls.isEmpty()) {
                found_pro = true;
            }
        } else {
            temp1 = chunk.getPro(this.tokens);
            for (Word w : temp1) {
                if (bs.usedPro.contains(w) && !this.check_pro && !this.same_role) continue;
                ls.add(w);
            }
            if (!ls.isEmpty()) {
                found_pro = true;
            }
        }
        for (int i = idx - 1; i >= end; --i) {
            Chunk c = bs.chunkList.get(i);
            List<Word> temp = c.getProFront();
            if (temp.size() > 0 && temp.size() > 0) {
                for (Word w : temp) {
                    if (bs.usedPro.contains(w) && !this.check_pro && !this.same_role) continue;
                    ls.add(w);
                }
                if (!ls.isEmpty()) {
                    found_pro = true;
                }
            }
            if (c.type.equals("VP") || c.type.equals("PP") && found_pro || c.pros.isEmpty() && c.trigs.size() > 0) break;
        }
        return ls;
    }

    private String getPrep(Word tg, BasicChunk bs, Set<String> prep) {
        int tg_pos = bs.getChunkPos(tg.pos);
        if (tg_pos >= 0 && tg_pos < bs.chunkList.size() - 1) {
            int pos = bs.trgList.indexOf(tg);
            if (pos < bs.trgList.size() - 1) {
                Word tg2 = bs.trgList.get(pos + 1);
                int pos2 = bs.getChunkPos(tg2.pos);
                if (tg_pos == pos2 && tg2.pos - tg.pos == 1) {
                    return "";
                }
            }
            Chunk c = bs.chunkList.get(tg_pos + 1);
            if (prep.contains(c.txt)) {
                return c.txt;
            }
        } else if (bs.chunkList.size() > 0) {
            Chunk c = bs.chunkList.get(0);
            if (prep.contains(c.txt)) {
                return c.txt;
            }
        }
        return "";
    }

    private String getPrepVerb(BasicChunk bs, Set<String> prep) {
        if (bs.chunkList.isEmpty()) {
            return "";
        }
        for (Chunk c : bs.chunkList) {
            if (prep.contains(c.txt)) {
                return c.txt;
            }
            if (c.type.startsWith("AD")) continue;
            return "";
        }
        return "";
    }

    public void initSentence(String id) {
        this.out = this.analyzer.analyze(id);
        this.trg_ID = this.analyzer.proList.size();
        OptionalInt maxGeneIdNumber = this.analyzer.proList.stream().map(prot -> prot.tid).mapToInt(tid -> Integer.parseInt(tid.substring(1))).max();
        if (maxGeneIdNumber.isPresent()) {
            this.trg_ID = maxGeneIdNumber.getAsInt() + 1;
        }
        this.evt_ID = 0;
    }

    public void extractSentence(int i) {
        if (this.out[i] == null) {
            return;
        }
        this.curr_senID = i;
        this.tokens = this.analyzer.tokenList.get(i);
        List<Word> prep = this.analyzer.getPreps(this.tokens);
        List<Word> mods = this.analyzer.getModifier(this.tokens);
        if (this.debug) {
            System.out.print("----Text: ");
            System.out.println(this.analyzer.shortsen[i]);
            this.analyzer.printChunk(this.out[i]);
        }
        this.op.curr_text = this.analyzer.shortsen[i];
        this.tags = this.analyzer.tagList.get(i);
        this.op.analyzeChunk(this.out[i], this.tags, this.tokens);
        for (BasicChunk bc : this.op.bsList) {
            this.evaluateTrg(bc, prep, mods, this.tokens, this.analyzer.detectedTrg[i]);
            this.extractNP(bc, prep);
        }
        this.usedTrg.clear();
        for (VerbChunk vc : this.op.verbList) {
            this.cur_sub = null;
            this.curr_verb = vc.verb;
            this.curr_verb_type = vc.verb_type;
            this.check_pro = vc.subject_type == 1;
            this.evaluateTrg(vc.subject, prep, mods, this.tokens, this.analyzer.detectedTrg[i]);
            this.extractNP(vc.subject, prep);
            this.cur_sub = vc.subject;
            this.evaluateTrg(vc.object, prep, mods, this.tokens, this.analyzer.detectedTrg[i]);
            this.extractNP(vc.object, prep);
            this.extractVP(vc, prep, mods);
        }
    }

    public void printChunkList() {
        for (BasicChunk bs : this.op.bsList) {
            bs.printChunk();
            System.out.println("");
        }
        for (VerbChunk vc : this.op.verbList) {
            if (!vc.isQualify()) {
                // empty if block
            }
            vc.print();
            System.out.println("");
        }
    }

    public void extractVP(VerbChunk vc, List<Word> preps, List<Word> mods) {
        for (int i = 0; i < vc.verb.trigs.size(); ++i) {
            int idx;
            Word tg2;
            Word tg = vc.verb.trigs.get(i);
            if (i + 1 < vc.verb.trigs.size() && vc.verb.isSameRole(tg, tg2 = vc.verb.trigs.get(i + 1), this.tokens)) {
                this.sameRole.add(tg2);
            }
            this.same_role = false;
            if (this.sameRole.contains(tg)) {
                this.same_role = true;
                this.sameRole.clear();
            }
            KeyData kdt = this.dic.get(tg.word);
            List<PData> ls = null;
            if (kdt == null) continue;
            if (kdt.keytype > 1) {
                String ev_type = kdt.getDefault().type;
                idx = SenSimplifier.hashType.get(ev_type);
                if (idx >= 5) {
                    tg.type = ev_type;
                }
            } else {
                tg.type = kdt.type;
                idx = SenSimplifier.hashType.get(tg.type);
            }
            if ((ls = idx < 5 ? this.extractSimpleVP(tg, vc, mods) : (idx == 5 ? this.extractBindVP(tg, vc, preps) : this.extractRegVP(tg, vc, preps))) == null || ls.isEmpty()) continue;
            this.extractedMap.put(tg, ls);
        }
    }

    private String getTrgID() {
        ++this.trg_ID;
        return "T" + this.trg_ID;
    }

    private String getEventID() {
        ++this.evt_ID;
        return "E" + this.evt_ID;
    }

    public void Test(String outPath) {
        try {
            this.init();
            this.removeOldFiles(outPath);
            List<String> ids = this.simp.loadPMIDs();
            log.debug("Loading abstracts: {}", (Object)ids.size());
            Iterator<String> iterator = ids.iterator();
            while (iterator.hasNext()) {
                String id;
                this.curr_pmid = id = iterator.next();
                this.extractEvents(id);
                this.writeResult(id, outPath);
            }
        }
        catch (Exception ex) {
            throw new BioSemException(ex);
        }
    }

    public void Test() {
        try {
            this.init();
            List<String> ids = this.simp.loadPMIDs();
            log.debug("Loading abstracts: {}", (Object)ids.size());
            Iterator<String> iterator = ids.iterator();
            while (iterator.hasNext()) {
                String id;
                this.curr_pmid = id = iterator.next();
                this.extractEvents(id);
            }
        }
        catch (Exception ex) {
            log.debug("Caught exception, recognition of events is skipped for current document(s). Error occurred in document " + this.curr_pmid + ":", (Throwable)ex);
        }
    }

    public void extractEvents(String id) {
        this.extractedMap.clear();
        this.extractedSet.clear();
        this.initSentence(id);
        for (int i = 0; i < this.analyzer.senpos.length; ++i) {
            this.extractSentence(i);
        }
        this.unifyEvents(id);
    }

    private void unifyEvents(String id) {
        boolean duplicatesFound;
        do {
            List<PData> equals;
            HashSet<PData> uniqueEvents = new HashSet<PData>();
            HashSet<PData> duplicates = new HashSet<PData>();
            ArrayList<PData> lst = new ArrayList<PData>(this.extractedSet);
            duplicatesFound = false;
            HashMap<PData, List<PData>> eqClasses = new HashMap<PData, List<PData>>();
            for (int i = 0; i < lst.size(); ++i) {
                PData pdt = (PData)lst.get(i);
                if (duplicates.contains(pdt)) continue;
                equals = new ArrayList();
                for (int j = i + 1; j < lst.size(); ++j) {
                    PData pdt2 = (PData)lst.get(j);
                    boolean equal = true;
                    if (!pdt.evt_type.equals(pdt2.evt_type)) {
                        equal = false;
                    } else if (pdt.trg == null ^ pdt2.trg == null) {
                        equal = false;
                    } else if (pdt.pro1 == null ^ pdt2.pro1 == null) {
                        equal = false;
                    } else if (pdt.pro2 == null ^ pdt2.pro2 == null) {
                        equal = false;
                    } else if (pdt.pdata1 == null ^ pdt2.pdata1 == null) {
                        equal = false;
                    } else if (pdt.pdata2 == null ^ pdt2.pdata2 == null) {
                        equal = false;
                    } else if (pdt.trg != null && pdt2.trg != null && !pdt.trg.TID.equals(pdt2.trg.TID)) {
                        equal = false;
                    } else if (pdt.pro1 != null && pdt2.pro1 != null && !pdt.pro1.TID.equals(pdt2.pro1.TID)) {
                        equal = false;
                    } else if (pdt.pro2 != null && pdt2.pro2 != null && !pdt.pro2.TID.equals(pdt2.pro2.TID)) {
                        equal = false;
                    } else if (pdt.pdata1 != null && pdt2.pdata1 != null && !pdt.pdata1.PID.equals(pdt2.pdata1.PID)) {
                        equal = false;
                    } else if (pdt.pdata2 != null && pdt2.pdata2 != null && !pdt.pdata2.PID.equals(pdt2.pdata2.PID)) {
                        equal = false;
                    }
                    if (!equal) continue;
                    equals.add(pdt2);
                    duplicates.add(pdt2);
                    duplicatesFound = true;
                }
                eqClasses.put(pdt, equals);
            }
            for (PData pdt : eqClasses.keySet()) {
                equals = (List)eqClasses.get(pdt);
                for (PData pdt3 : lst) {
                    for (PData pdt4 : equals) {
                        if (pdt3.pdata1 != null && pdt3.pdata1.PID.equals(pdt4.PID)) {
                            pdt3.pdata1 = pdt;
                        }
                        if (pdt3.pdata2 == null || !pdt3.pdata2.PID.equals(pdt4.PID)) continue;
                        pdt3.pdata2 = pdt;
                    }
                }
            }
            for (PData pdt5 : lst) {
                if (duplicates.contains(pdt5)) continue;
                uniqueEvents.add(pdt5);
            }
            this.extractedSet = uniqueEvents;
        } while (duplicatesFound);
    }

    private void writeResult(String id, String path) {
        try {
            File dPath = new File(path);
            if (!dPath.exists()) {
                dPath.mkdirs();
            }
            this.writer = new FileWriter(path + "/" + id + ".a2");
            for (Word w : this.extractedMap.keySet()) {
                this.writer.append(w.toString());
            }
            this.writeEvent.clear();
            for (PData pdt : this.extractedSet) {
                String e_id = pdt.getWriteID();
                if (this.writeEvent.contains(e_id)) continue;
                this.writer.append(pdt.toString());
                this.writeEvent.add(e_id);
            }
            this.closeFile();
        }
        catch (Exception ex) {
            System.out.println("Loi roi :-(");
            System.out.println(ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    private void removeOldFiles(String filename) {
        try {
            File file = new File(filename);
            if (file.isDirectory()) {
                File[] list;
                for (File f : list = file.listFiles()) {
                    f.delete();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    private void closeFile() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public Set<Word> getExtractedTriggers() {
        return this.extractedMap.keySet();
    }

    public Set<PData> getExtractedEvents() {
        return this.extractedSet;
    }

    public static void main(String[] args) {
        String sr_path = null;
        String dest_path = null;
        String outPath = null;
        if (args.length == 3) {
            sr_path = args[0];
            dest_path = args[1];
            outPath = args[2];
        } else {
            System.out.println("Declare the trained database, the test database and the output path.");
            System.exit(1);
        }
        DBUtils sr = new DBUtils();
        sr.openDB(sr_path);
        DBUtils dest = new DBUtils();
        dest.openDB(dest_path);
        EventExtraction xtr = new EventExtraction(sr, dest);
        xtr.Test(outPath);
        sr.closeDB();
    }

    public void setDb(DBUtils docDb) {
        this.analyzer.setDB(docDb);
    }

    static {
        prepSet.addAll(Arrays.asList(prepList));
        ccSet.addAll(Arrays.asList(ccList));
    }
}

