/*
 * Decompiled with CFR 0.152.
 */
package relations;

import relations.BasicChunk;
import relations.Chunk;
import relations.Word;

public class VerbChunk {
    BasicChunk subject = null;
    BasicChunk object = null;
    Chunk verb = null;
    int verb_type = 0;
    int subject_type = 0;

    public void addVerb(Chunk v) {
        this.verb = v;
    }

    public boolean isQualify() {
        int trgCount = this.subject.trgCount() + this.object.trgCount() + this.verb.trigs.size();
        int prCount = this.subject.proCount() + this.object.proCount() + this.verb.pros.size();
        return trgCount > 0 && prCount > 0;
    }

    public BasicChunk merge() {
        BasicChunk bsc = new BasicChunk();
        bsc.addChunk(this.subject);
        bsc.addChunk(this.verb);
        bsc.addChunk(this.object);
        bsc.is_merged = true;
        return bsc;
    }

    public boolean belongTO(Word trg, Word pro) {
        if (this.verb.contains(trg) && (this.subject.containsKey(pro) || this.object.containsKey(pro))) {
            return true;
        }
        if (this.subject.belongTO(trg, pro) || this.object.belongTO(trg, pro)) {
            return true;
        }
        return this.subject.containsKey(pro) && this.object.containsKey(trg) || this.subject.containsKey(trg) && this.object.containsKey(pro);
    }

    public boolean belongTO(Word trg, Word pro, Word pro2) {
        if (this.subject.belongTO(trg, pro, pro2)) {
            return true;
        }
        if (this.object.belongTO(trg, pro, pro2)) {
            return true;
        }
        if (pro2 == null) {
            return this.belongTO(trg, pro);
        }
        if (this.verb.contains(trg)) {
            if (this.subject.containsKey(pro) && this.object.containsKey(pro2) || this.subject.containsKey(pro2) && this.object.containsKey(pro)) {
                return true;
            }
            if (this.subject.containsKey(pro) && this.subject.containsKey(pro2) || this.object.containsKey(pro) && this.object.containsKey(pro2)) {
                return true;
            }
        } else if (this.subject.belongTO(trg, pro) && this.object.containsKey(pro2) || this.subject.belongTO(trg, pro2) && this.object.containsKey(pro) || this.object.belongTO(trg, pro) && this.subject.containsKey(pro2) || this.object.belongTO(trg, pro2) && this.subject.containsKey(pro)) {
            return true;
        }
        return false;
    }

    public void print() {
        System.out.print("-> Sub: ");
        this.subject.printChunk();
        if (this.verb != null) {
            System.out.print(" -> Verb: " + this.verb.getText());
        }
        System.out.print("-> Object: ");
        this.object.printChunk();
    }
}

