/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.Parser;
import relations.Chunk;
import relations.ChunkAnalyzer;
import relations.Counter;
import relations.EData;
import relations.KeyData;
import relations.SenSimplifier;
import relations.TData;
import relations.VerbChunk;
import relations.Word;
import utils.DBUtils;
import utils.SentenceSplitter;

public class SenAnalyzer {
    SenSimplifier simp;
    Map<String, TData> proMap = new HashMap<String, TData>();
    List<TData> proList;
    String longtxt;
    String current;
    String[] shortsen;
    String[] longsen;
    @Deprecated
    String shorttxt;
    TData trig;
    TData pro;
    int[] senpos;
    String current_id;
    public Map<String, String> proIDMap = new HashMap<String, String>();
    List<Word> allTriggers;
    List<Word>[] longTrg;
    List<Word>[] detectedTrg;
    List<Word>[] detectedPro;
    List<TData>[] longPro;
    List<String[]> tokenList = new ArrayList<String[]>();
    List<String[]> tagList = new ArrayList<String[]>();
    Parser parser = new Parser();
    boolean default_db = true;
    Set<String> simpleDic;
    DBUtils db_sr;
    DBUtils db;
    double[] conf = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.15, 0.1, 0.1};
    int[] tgfreq = new int[]{5, 5, 3, 3, 3, 5, 5, 5, 5};
    int ecount = 0;
    int ecounter = 0;
    static final Map<String, Set<String>> notTrg = new HashMap<String, Set<String>>();
    static final String[] notrigger;

    public SenAnalyzer(SenSimplifier simp) {
        this.simp = simp;
        this.simpleDic = simp.simpleDic;
    }

    public SenAnalyzer(DBUtils sr, DBUtils db_dest) {
        this.db_sr = sr;
        this.db = db_dest;
        this.simp = new SenSimplifier(this.db);
    }

    public void setDB(DBUtils dbs) {
        this.db = dbs;
        this.simp.setDB(this.db);
    }

    public void closeDB() {
        if (this.db != null) {
            this.db.shutdownDB();
        }
    }

    public void init() {
        this.simp.loadDict(this.db_sr);
        this.simpleDic = this.simp.simpleDic;
    }

    public boolean initAbstract(String pid) {
        int i;
        this.proMap.clear();
        this.proIDMap.clear();
        this.longtxt = this.simp.loadSentence(pid);
        if (this.longtxt == null) {
            System.out.println("PMID: " + pid + " -> no text");
            return false;
        }
        SentenceSplitter.BioSemSentence[] originalSentences = this.simp.doSentenceSplitting(this.longtxt, "\n");
        this.longsen = new String[originalSentences.length];
        this.senpos = new int[this.longsen.length];
        for (i = 1; i < originalSentences.length; ++i) {
            this.senpos[i] = originalSentences[i].begin;
        }
        for (i = 0; i < originalSentences.length; ++i) {
            this.longsen[i] = originalSentences[i].text;
        }
        this.proList = this.simp.loadProtein(pid);
        this.allTriggers = this.detectTrg(this.longtxt);
        this.longPro = this.splitData(this.proList, this.senpos);
        this.longTrg = this.splitTrg(this.allTriggers, this.senpos);
        ArrayList<Word> trgRemoveList = new ArrayList<Word>();
        ArrayList proRemoveList = new ArrayList();
        for (int i2 = 0; i2 < this.senpos.length; ++i2) {
            trgRemoveList.clear();
            proRemoveList.clear();
            for (Word w : this.longTrg[i2]) {
                for (TData dt : this.longPro[i2]) {
                    if ((w.locs[0] < dt.list[0] || w.locs[0] >= dt.list[1]) && (w.locs[1] <= dt.list[0] || w.locs[1] > dt.list[1])) continue;
                    trgRemoveList.add(w);
                }
            }
            for (Word w : trgRemoveList) {
                this.longTrg[i2].remove(w);
            }
            for (TData td : proRemoveList) {
                this.longPro[i2].remove(td);
                this.proList.remove(td);
            }
        }
        this.shortsen = this.simp.doSimplifySentenceWise(originalSentences, this.proList);
        if (this.shortsen.length != this.longsen.length) {
            System.out.println("Skip due to number of long sentences != short sentences---> " + pid);
            return false;
        }
        for (TData dt : this.proList) {
            this.proMap.put(dt.tid, dt);
            this.proIDMap.put(dt.new_name, dt.tid);
        }
        return true;
    }

    public boolean initData(String id) {
        this.current_id = id;
        if (!this.initAbstract(id)) {
            System.out.println(" Skip this sentence due to init failed " + id);
            return false;
        }
        this.detectedPro = new ArrayList[this.senpos.length];
        this.detectedTrg = new ArrayList[this.senpos.length];
        this.tokenList.clear();
        for (int i = 0; i < this.senpos.length; ++i) {
            this.current = this.shortsen[i];
            String[] token = this.parser.splitWord(this.current);
            this.tokenList.add(token);
            if (this.current.length() < 5) {
                this.detectedPro[i] = new ArrayList<Word>();
                this.detectedTrg[i] = new ArrayList<Word>();
                continue;
            }
            this.processSentence(this.current, token, i);
            if (this.detectedTrg[i].size() != this.longTrg[i].size()) {
                HashSet<String> longTrgs = new HashSet<String>();
                for (Word w : this.longTrg[i]) {
                    longTrgs.add(w.word);
                }
                Iterator<Word> detectedIt = this.detectedTrg[i].iterator();
                while (detectedIt.hasNext()) {
                    Word word = detectedIt.next();
                    if (longTrgs.contains(word.word)) continue;
                    detectedIt.remove();
                }
            }
            if (this.detectedTrg[i].size() == this.longTrg[i].size()) {
                for (int f = 0; f < this.detectedTrg[i].size(); ++f) {
                    Word w1 = this.detectedTrg[i].get(f);
                    Word w2 = this.longTrg[i].get(f);
                    w1.locs = w2.locs;
                }
            } else {
                throw new IllegalStateException();
            }
            if (this.detectedPro[i].size() != this.longPro[i].size()) {
                throw new IllegalStateException();
            }
            for (Word pr : this.detectedPro[i]) {
                pr.TID = this.proIDMap.get(pr.word);
                if (pr.TID == null) {
                    int maxLength = 0;
                    String bestCandidate = null;
                    for (String prName : this.proIDMap.keySet()) {
                        if (!pr.word.startsWith(prName) || prName.length() <= maxLength) continue;
                        maxLength = prName.length();
                        bestCandidate = prName;
                    }
                    pr.TID = this.proIDMap.get(bestCandidate);
                }
                pr.locs = this.proMap.get((Object)pr.TID).list;
            }
        }
        return true;
    }

    public List<Chunk>[] analyze(String id) {
        ArrayList[] list = null;
        boolean init = this.initData(id);
        if (!init) {
            return list;
        }
        list = new ArrayList[this.senpos.length];
        this.tagList.clear();
        Map<String, KeyData> dic = this.simp.sharedDic;
        for (int i = 0; i < this.senpos.length; ++i) {
            if (this.detectedPro[i].isEmpty() || this.detectedTrg[i].isEmpty()) {
                list[i] = null;
                this.tagList.add(new String[0]);
                continue;
            }
            String[] tokens = this.tokenList.get(i);
            String[] tags = this.parser.POSTag(tokens);
            this.tagList.add(tags);
            this.parser.old_txt = this.shortsen[i];
            List<Chunk> chunks = this.parser.parse(tokens, tags);
            int pidx = 0;
            int tidx = 0;
            List<Word> pros = this.detectedPro[i];
            List<Word> trgs = this.detectedTrg[i];
            int pcount = 0;
            int tcount = 0;
            block1: for (int cidx = 0; cidx < chunks.size(); ++cidx) {
                boolean remove;
                Chunk c = chunks.get(cidx);
                while (tidx < trgs.size()) {
                    int freq;
                    double threshold;
                    Word trg = trgs.get(tidx);
                    KeyData kdt = dic.get(trg.word);
                    remove = false;
                    if (kdt.keytype == 1) {
                        int e_idx = SenSimplifier.hashType.get(kdt.type);
                        threshold = this.conf[e_idx];
                        freq = this.tgfreq[e_idx];
                    } else {
                        threshold = 0.15;
                        freq = 10;
                    }
                    if (kdt.score < threshold || kdt.freq < freq) {
                        // empty if block
                    }
                    if (c.contains(trg) && !trg.word.contains(" ")) {
                        if (notTrg.containsKey(trg.word) && trg.pos < tokens.length - 1) {
                            String key = tokens[trg.pos + 1];
                            if (notTrg.get(trg.word).contains(key)) {
                                remove = true;
                            }
                        }
                        if (!remove) {
                            c.addTrigger(trg);
                        }
                        ++tcount;
                        ++tidx;
                        trg.pos_tag = tags[trg.pos];
                        trg.chunk_type = c.type;
                        continue;
                    }
                    if (!c.contains(trg) || !trg.word.contains(" ")) break;
                    if (trg.pos + 1 > c.end) {
                        if (cidx < chunks.size() - 1) {
                            Chunk c1 = chunks.get(cidx + 1);
                            c.merge(c1);
                            chunks.remove(c);
                        } else {
                            System.out.println(this.shortsen[i]);
                            this.printChunk(chunks);
                            System.out.println(trg.word + " Pos: " + trg.pos);
                            remove = true;
                        }
                    }
                    if (!remove) {
                        c.addTrigger(trg);
                    }
                    ++tcount;
                    ++tidx;
                    trg.pos_tag = tags[trg.pos + 1];
                    trg.chunk_type = c.type;
                }
                while (pidx < pros.size()) {
                    Word prot = pros.get(pidx);
                    remove = false;
                    if (prot.pos < c.begin || prot.pos > c.end) continue block1;
                    if (prot.fullword != null && (prot.fullword.contains(prot.word + "+") || prot.fullword.endsWith("+") || prot.fullword.startsWith("anti"))) {
                        remove = true;
                    }
                    if (!remove) {
                        c.addPro(prot);
                    }
                    ++pcount;
                    ++pidx;
                }
            }
            if (pcount != pros.size() || tcount != trgs.size()) {
                System.out.println("----BUG---> Sen analyzer: protein or trigger is missing");
                if (pcount != pros.size()) {
                    System.out.println("Protein missed");
                } else if (tcount != trgs.size()) {
                    System.out.println("Trigger missed");
                }
                for (Chunk ch : chunks) {
                    System.out.print(ch + " ");
                }
                System.out.println("");
                ++this.ecounter;
            }
            list[i] = chunks;
        }
        return list;
    }

    public List<Word>[] splitTrg(List<Word> list, int[] pos) {
        List[] dlist = new List[pos.length];
        for (int i = 0; i < pos.length; ++i) {
            dlist[i] = new ArrayList();
        }
        for (Word dt : list) {
            int loc = dt.locs[0];
            int idx = this.pos2sen(pos, loc);
            dlist[idx].add(dt);
        }
        return dlist;
    }

    private int pos2sen(int[] senpos, int pos) {
        for (int i = senpos.length - 1; i > 0; --i) {
            if (pos < senpos[i]) continue;
            return i;
        }
        return 0;
    }

    public List<TData>[] splitData(List<TData> list, int[] pos) {
        List[] dlist = new List[pos.length];
        for (int i = 0; i < pos.length; ++i) {
            dlist[i] = new ArrayList();
        }
        for (TData dt : list) {
            int loc = dt.list[0];
            int idx = this.pos2sen(pos, loc);
            dlist[idx].add(dt);
        }
        return dlist;
    }

    public void testSentence() {
        this.init();
        String txt = "This is surprising, since IFN-alpha-inducible signaling cascades are present in A3.01 T cells: we showed that the control plasmid harboring interferon-responsive GAS elements was markedly induced by IFN-alpha treatment.";
        List<Word> ls = this.detectTrg(txt);
        for (Word w : ls) {
            System.out.println(w.word + " Pos: " + w.pos + " --> " + txt.substring(w.locs[0], w.locs[1]));
        }
    }

    public List<Word> detectTrg(String txt) {
        List<String>[] tokens = SentenceSplitter.wordSpliter(txt);
        String[] words = tokens[0].toArray(new String[0]);
        ArrayList<Word> trgList = new ArrayList<Word>();
        Object w2 = null;
        int i = 0;
        int loc = 0;
        while (i < words.length) {
            String[] ww;
            loc += tokens[1].get(i).length();
            Word word = null;
            String w1 = words[i];
            int len = w1.length();
            String temp = w1.toLowerCase();
            if (this.simpleDic.contains(temp)) {
                if (temp.contains("-") && this.simpleDic.contains((ww = temp.split("-"))[0] + ww[1])) {
                    word = new Word(ww[0] + ww[1], i, loc);
                }
                if (word == null) {
                    word = new Word(temp, i, loc);
                }
                int[] pos = new int[]{loc, loc + len};
                word.locs = pos;
                trgList.add(word);
            } else if (temp.contains("-") && temp.length() >= 8) {
                int[] pos;
                ww = temp.split("-");
                int pt = ww.length - 1;
                String s = ww[pt];
                if (ww.length == 2 && this.simpleDic.contains(ww[0] + ww[1])) {
                    word = new Word(ww[0] + ww[1], i, loc);
                    pos = new int[]{loc, loc + len};
                    word.locs = pos;
                    trgList.add(word);
                } else if (this.simpleDic.contains(s)) {
                    word = new Word(s, i, loc + temp.indexOf(s));
                    pos = new int[]{loc + temp.indexOf(s), pos[0] + s.length()};
                    word.locs = pos;
                    trgList.add(word);
                }
            }
            ++i;
            loc += len;
        }
        return trgList;
    }

    public void processSentence(String txt, String[] token, int idx) {
        String[] words = token;
        ArrayList<Word> trgList = new ArrayList<Word>();
        ArrayList<Word> protList = new ArrayList<Word>();
        Object w2 = null;
        int i = 0;
        boolean combine = false;
        while (i < words.length) {
            int pt;
            String pid;
            Object ww;
            combine = false;
            String w1 = words[i];
            String temp = w1.toLowerCase();
            Word word = null;
            if (this.simpleDic.contains(temp)) {
                if (temp.contains("-") && this.simpleDic.contains((ww = temp.split("-"))[0] + ww[1])) {
                    word = new Word((String)ww[0] + (String)ww[1], i, 0);
                }
                if (word == null) {
                    word = new Word(temp, i, 0);
                }
                trgList.add(word);
                ++i;
                continue;
            }
            if (this.proIDMap.containsKey(w1)) {
                word = new Word(w1, i, 0);
                pid = this.proIDMap.get(w1);
                TData pr = this.proMap.get(pid);
                word.locs = pr.list;
                protList.add(word);
                ++i;
                continue;
            }
            List<String> list = this.simp.getProteins(w1);
            if (list.size() > 0) {
                if (w1.contains("-") && w1.length() >= 8 && this.simpleDic.contains(((String)(ww = w1.split("-"))[pt = ((Object)ww).length - 1]).toLowerCase())) {
                    word = new Word(((String)ww[pt]).toLowerCase(), i, 0);
                    word.compound = true;
                    if (this.proIDMap.containsKey(ww[0]) && ((Object)ww).length == 2) {
                        word.combined = true;
                        combine = true;
                    }
                    word.fullword = w1;
                    trgList.add(word);
                }
                ww = list.iterator();
                while (ww.hasNext()) {
                    String s = (String)ww.next();
                    word = new Word(s, i, 0);
                    word.compound = true;
                    word.combined = combine;
                    word.fullword = w1;
                    pid = this.proIDMap.get(s);
                    TData pr = this.proMap.get(pid);
                    if (pr != null) {
                        word.locs = pr.list;
                    } else {
                        String s1;
                        word.word = s1 = s.substring(0, s.length() - 1);
                        pid = this.proIDMap.get(s1);
                        pr = this.proMap.get(pid);
                        word.locs = pr != null ? pr.list : new int[2];
                    }
                    protList.add(word);
                }
                ++i;
                continue;
            }
            if (temp.contains("-") && temp.length() >= 8) {
                ww = temp.split("-");
                pt = ((Object)ww).length - 1;
                if (((Object)ww).length == 2 && this.simpleDic.contains((String)ww[0] + (String)ww[1])) {
                    word = new Word((String)ww[0] + (String)ww[1], i, 0);
                    trgList.add(word);
                } else if (pt >= 0 && this.simpleDic.contains(ww[pt])) {
                    word = new Word((String)ww[pt], i, 0);
                    word.compound = true;
                    word.fullword = w1;
                    trgList.add(word);
                }
            }
            ++i;
        }
        this.detectedPro[idx] = protList;
        this.detectedTrg[idx] = trgList;
    }

    private void removePro(List<Word> pro, List<String> names) {
        ArrayList<Word> rm = new ArrayList<Word>();
        for (String s : names) {
            for (Word w : pro) {
                if (!w.word.equals(s)) continue;
                rm.add(w);
            }
        }
        for (Word w : rm) {
            pro.remove(w);
        }
    }

    public int findEquiv(String txt) {
        int count = 0;
        StringBuilder sb = new StringBuilder(txt);
        int[] openP = new int[15];
        int index = -1;
        List<Object> alter = new ArrayList();
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '(') {
                openP[++index] = i;
                continue;
            }
            if (sb.charAt(i) != ')') continue;
            int k = i + 1;
            if (index < 0) continue;
            String sub = sb.substring(openP[index], k);
            alter = this.simp.getProteins(sub);
            if (alter.isEmpty()) {
                i = openP[index];
            } else if (alter.size() == 1) {
                ArrayList<CallSite> foundList = new ArrayList<CallSite>();
                int pidx = this.simp.getPIndex((String)alter.get(0));
                if (pidx > 0) {
                    String pr1 = "PRO" + pidx;
                    String pro2 = "PRO" + (pidx - 1);
                    foundList.add((CallSite)((Object)pro2));
                    ++count;
                }
            }
            --index;
        }
        return count;
    }

    public Word findTrigger(int[] loc, List<Word> relWord) {
        for (Word w : relWord) {
            if (w.locs[0] != loc[0] && w.locs[1] != loc[1]) continue;
            return w;
        }
        return null;
    }

    public List<EData>[] splitEvents(List<EData> list) {
        List[] dlist = new List[this.longsen.length];
        for (int i = 0; i < this.longsen.length; ++i) {
            dlist[i] = new ArrayList();
        }
        for (EData dt : list) {
            TData tg = dt.trgdata;
            int pos = tg.list[0];
            int idx = this.pos2sen(this.senpos, pos);
            dlist[idx].add(dt);
        }
        return dlist;
    }

    public void testAll() {
        this.init();
        int total = 0;
        int detected = 0;
        int match = 0;
        int recognized = 0;
        List<String> ids = this.simp.loadPMIDs();
        System.out.println("Total abstract: " + ids.size());
        HashMap<String, String> TGmap = new HashMap<String, String>();
        ArrayList<TData> candidate = new ArrayList<TData>();
        HashMap<String, TData> map = new HashMap<String, TData>();
        HashMap<String, Counter> miss = new HashMap<String, Counter>();
        String key = "";
        for (String id : ids) {
            map.clear();
            List<EData> elist = this.simp.loadEvent(id);
            List<TData> trgList = this.simp.loadTrigger(id);
            for (TData dt : trgList) {
                map.put(dt.tid, dt);
            }
            this.initData(id);
            List<EData>[] events = this.splitEvents(elist);
            for (int i = 0; i < this.senpos.length; ++i) {
                TGmap.clear();
                for (EData ev : events[i]) {
                    if (TGmap.containsKey(ev.trigID)) continue;
                    TGmap.put(ev.trigID, ev.trigID);
                }
                total += TGmap.size();
                candidate.clear();
                for (String s : TGmap.keySet()) {
                    TData tg = (TData)map.get(s);
                    if (this.simp.sharedDic.containsKey(tg.name.toLowerCase())) {
                        candidate.add(tg);
                        continue;
                    }
                    Counter c = (Counter)miss.get(tg.name.toLowerCase());
                    if (c == null) {
                        c = new Counter(1);
                        miss.put(tg.name.toLowerCase(), c);
                        continue;
                    }
                    c.inc();
                }
                recognized += candidate.size();
                for (TData dt : candidate) {
                    for (Word w : this.detectedTrg[i]) {
                        if (dt.list[0] != w.locs[0] && dt.list[1] != w.locs[1]) continue;
                        ++match;
                    }
                }
                if (this.detectedTrg[i] == null) continue;
                detected += this.detectedTrg[i].size();
            }
        }
        System.out.println("Total non-repeat triggers: " + total);
        System.out.println("Recognized triggers: " + recognized + " -> Recall: " + 1.0f * (float)recognized / (float)total);
        System.out.println("Match trigger: " + match + " -> Recall: " + 1.0f * (float)match / (float)total);
        System.out.println("Missed triggers: " + (detected - match));
        int recover = 0;
        for (String s : miss.keySet()) {
            Counter c = (Counter)miss.get(s);
            if (c.count < 2) continue;
            System.out.println(s + " " + ((Counter)miss.get((Object)s)).count);
            recover += c.count;
        }
        System.out.println("Number of trggers can recovers: " + recover);
    }

    public List<Word> getPreps(String[] tokens) {
        ArrayList<Word> list = new ArrayList<Word>();
        for (int i = 0; i < tokens.length; ++i) {
            String s = tokens[i];
            if (!SenSimplifier.prepmap.contains(s)) continue;
            Word w = new Word(s, i, 0);
            list.add(w);
        }
        return list;
    }

    public List<Word> getModifier(String[] tokens) {
        ArrayList<Word> list = new ArrayList<Word>();
        for (int i = 0; i < tokens.length; ++i) {
            String s = tokens[i];
            if (!SenSimplifier.modifiers.containsKey(s)) continue;
            Word w = new Word(s, i, 0);
            list.add(w);
        }
        return list;
    }

    public void printChunk(List<Chunk> ls) {
        for (Chunk c : ls) {
            System.out.print("[" + c.type + " " + c.txt + "]");
        }
        System.out.println("");
    }

    private void printChunkValue(List<Chunk> ls) {
        for (Chunk c : ls) {
            System.out.print(c.getValues());
        }
        System.out.println("");
    }

    public void testChunks() {
        this.init();
        ChunkAnalyzer op = new ChunkAnalyzer();
        List<String> ids = this.simp.loadPMIDs();
        int count = 0;
        for (String id : ids) {
            List<Chunk>[] out = this.analyze(id);
            for (int i = 0; i < out.length; ++i) {
                ++this.ecount;
                if (out[i] == null) continue;
                op.curr_text = this.shortsen[i];
                op.analyzeChunk(out[i], this.tagList.get(i), this.tokenList.get(i));
                if (op.verbList.size() <= 0) continue;
                for (VerbChunk vb : op.verbList) {
                    vb.subject.mergeNP();
                    vb.object.mergeNP();
                }
            }
        }
        System.out.println("Total sentences: " + this.ecount);
        System.out.println("Total error due to trigger detection " + this.ecounter);
        System.out.println("Number of abstract: " + ids.size() + " Number of sentences: " + count);
        System.out.println("---Number of unknown subject cases: " + op.sub_count);
    }

    public void printInChunks() {
        ChunkAnalyzer op = new ChunkAnalyzer();
        List<String> ids = this.simp.loadPMIDs();
        int count = 0;
        for (String id : ids) {
            List<Chunk>[] out = this.analyze(id);
            for (int i = 0; i < out.length; ++i) {
                if (out[i] == null) continue;
                for (Chunk c : out[i]) {
                    if (c.trigs.size() != 2) continue;
                    System.out.println(c.getValues());
                }
            }
            ++count;
        }
        System.out.println("Total cases: " + this.ecount);
        System.out.println("Total error due to trigger detection " + this.ecounter);
        System.out.println("Number of abstract: " + ids.size() + " Number of sentences: " + count);
        System.out.println("---Number of unknown subject cases: " + op.sub_count);
    }

    public static void main(String[] args) {
    }

    static {
        for (String s : notrigger = new String[]{"binding->site|sites|domain|element|elements|complexes|protein|proteins|subunit|subunits|complex", "transcription->factor|factors|initiation|sites|site|start"}) {
            String[] st = s.split("->");
            String[] sub = st[1].split("\\|");
            HashSet<String> mapsub = new HashSet<String>();
            mapsub.addAll(Arrays.asList(sub));
            notTrg.put(st[0], mapsub);
        }
    }
}

