/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class RuleData
implements Comparable {
    int count = 0;
    int verb_type = 0;
    String POS = "";
    String chunk_type = "";
    boolean theme_pos = false;
    boolean cause_pos = false;
    boolean prep_order = false;
    String prep1 = "";
    boolean has_cause = false;
    String prep2 = "";
    boolean in_chunk = false;
    int dist1 = 0;
    int dist2 = 0;
    boolean event1 = false;
    boolean event2 = false;
    String theme = "";
    String cause = "";
    String key = "";
    public int extracted = 0;
    public Set<String> childMap = new HashSet<String>();
    public Set<String> parentMap = new HashSet<String>();
    int detected = 0;

    public RuleData() {
    }

    public RuleData(int verb_type, String pos, String ctype, boolean pos1, String prep, boolean inchunk, int ccount, String childTrg) {
        this.POS = pos;
        this.verb_type = verb_type;
        this.chunk_type = ctype;
        this.theme_pos = pos1;
        this.prep1 = prep;
        this.in_chunk = inchunk;
        this.count = 1;
        this.theme = childTrg;
        if (this.dist1 < ccount) {
            this.dist1 = ccount;
        }
        this.key = this.chunk_type.equals("NP") || this.chunk_type.equals("CP") ? this.chunk_type + this.POS + this.in_chunk + this.theme_pos + this.prep1 : this.chunk_type + this.POS + verb_type + this.theme_pos + this.prep1;
        this.setChildTrigger(childTrg);
    }

    public RuleData(int verb_type, String pos, String ctype, boolean pos1, boolean pos2, boolean order, String pr1, String pr2, boolean has_theme2, boolean inchunk, int ccount1, int ccount2, String childTrg) {
        this.POS = pos;
        this.verb_type = verb_type;
        this.chunk_type = ctype;
        this.theme_pos = pos1;
        this.cause_pos = pos2;
        this.prep_order = order;
        this.prep1 = pr1;
        this.prep2 = pr2;
        this.in_chunk = inchunk;
        this.has_cause = has_theme2;
        this.count = 1;
        this.dist1 = ccount1;
        this.dist2 = ccount2;
        this.theme = childTrg;
        this.setChildTrigger(childTrg);
        this.key = this.chunk_type.equals("NP") || this.chunk_type.equals("CP") ? this.chunk_type + this.POS + this.in_chunk + has_theme2 + this.theme_pos + this.prep1 + this.cause_pos + this.prep2 + this.prep_order : this.chunk_type + this.POS + verb_type + has_theme2 + this.theme_pos + this.prep1 + this.cause_pos + this.prep2 + this.prep_order;
    }

    public RuleData(int verbtype, String pos, String ctype, boolean pos1, boolean pos2, boolean order, String pr1, String pr2, boolean hastheme2, boolean inchunk, int ccount1, int ccount2, boolean pro1, boolean pro2, String trg1, String trg2) {
        this.POS = pos;
        this.verb_type = verbtype;
        this.chunk_type = ctype;
        this.theme_pos = pos1;
        this.cause_pos = pos2;
        this.prep_order = order;
        this.prep1 = pr1;
        this.prep2 = pr2;
        this.in_chunk = inchunk;
        this.has_cause = hastheme2;
        this.event1 = pro1;
        this.event2 = pro2;
        this.theme = trg1;
        this.cause = trg2;
        this.count = 1;
        this.dist1 = ccount1;
        this.dist2 = ccount2;
        this.key = this.chunk_type.equals("NP") || this.chunk_type.equals("CP") ? this.chunk_type + this.POS + this.in_chunk + this.has_cause + this.theme_pos + this.prep1 + this.cause_pos + this.prep2 + this.prep_order + this.event1 + this.event2 : this.chunk_type + this.POS + this.verb_type + this.has_cause + this.theme_pos + this.prep1 + this.cause_pos + this.prep2 + this.prep_order + this.event1 + this.event2;
        this.setChildTrigger(trg1);
        this.setParentTrigger(trg2);
    }

    public void setChildTrigger(String tg) {
        if (tg.isEmpty()) {
            return;
        }
        String[] st = tg.split(",");
        this.childMap.addAll(Arrays.asList(st));
    }

    public void setParentTrigger(String tg) {
        if (tg.isEmpty()) {
            return;
        }
        String[] st = tg.split(",");
        this.parentMap.addAll(Arrays.asList(st));
    }

    public String mapToString(Set<String> map) {
        Object txt = null;
        for (String s : map) {
            if (txt == null) {
                txt = s;
                continue;
            }
            txt = (String)txt + "," + s;
        }
        if (txt == null) {
            return "";
        }
        return txt;
    }

    public String getKey() {
        return this.key;
    }

    public String getSubKey() {
        return this.POS + this.chunk_type;
    }

    public String getKeyInfo() {
        String txt;
        if (this.chunk_type.equals("NP") || this.chunk_type.equals("CP")) {
            txt = this.chunk_type + " | Pos: " + this.POS + " | InChunk: " + this.in_chunk + " | Has theme2: " + this.has_cause + " | Prep1 pos: " + this.theme_pos + " | Prep1: " + this.prep1 + " | Prep2 pos: " + this.cause_pos + " | Prep2: " + this.prep2 + " Count: " + this.count;
            txt = txt + " -> " + this.mapToString(this.childMap) + " ->> " + this.mapToString(this.parentMap);
        } else {
            txt = this.chunk_type + " | Pos: " + this.POS + " | Verb type: " + this.verb_type + " | Has theme2: " + this.has_cause + " | Prep1 pos: " + this.theme_pos + " | Prep1: " + this.prep1 + " | Prep2 pos: " + this.cause_pos + " | Prep2: " + this.prep2 + " Count: " + this.count;
            txt = txt + " -> " + this.mapToString(this.childMap) + " ->> " + this.mapToString(this.parentMap);
        }
        return txt;
    }

    public int compareTo(Object ob) {
        return ((RuleData)ob).count - this.count;
    }
}

