/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import relations.Word;

public class KeyData
implements Comparable {
    String key;
    int freq = 0;
    int found = 0;
    String type = null;
    int keytype = 0;
    public double score = 0.0;
    public boolean required = false;
    int pcount = 0;
    int ecount = 0;
    int pcause = 0;
    int ecause = 0;
    int t2count = 0;
    int itype = -1;
    public double escore = 0.0;
    public double cscore = 0.0;
    public double t2score = 0.0;
    Set<String> child = new HashSet<String>();
    Set<String> parent = new HashSet<String>();
    Set<String> modifier = new HashSet<String>();
    Map<String, KeyData> trgMap = new HashMap<String, KeyData>();
    public boolean init = false;

    public KeyData(String word, String tgtype, int fq, int ktype, int total) {
        this.key = word;
        this.type = tgtype;
        this.freq = fq;
        this.keytype = ktype;
        this.found = total;
    }

    public KeyData getDefault() {
        if (this.keytype == 1) {
            return this;
        }
        if (this.keytype == 2) {
            return this.trgMap.get("Gene_expression");
        }
        KeyData tmkey = null;
        int tmfreq = 0;
        for (String s : this.trgMap.keySet()) {
            KeyData tmk = this.trgMap.get(s);
            if (tmk.freq <= tmfreq) continue;
            tmkey = tmk;
            tmfreq = tmk.freq;
        }
        return tmkey;
    }

    public int compareTo(Object o) {
        return ((KeyData)o).freq - this.freq;
    }

    public void initData(String l1, String l2) {
        String[] ls;
        this.score = (float)this.freq * 1.0f / ((float)this.found * 1.0f);
        this.t2score = (float)this.t2count * 1.0f / ((float)this.pcount * 1.0f);
        for (String st : ls = l1.split(",")) {
            if (st.length() < 1) continue;
            this.child.add(st);
        }
        for (String st : ls = l2.split(",")) {
            if (st.length() < 1) continue;
            this.parent.add(st);
        }
        this.init = true;
    }

    public void addToMap(KeyData dt) {
        this.trgMap.put(dt.type, dt);
    }

    public Map<String, KeyData> getMap() {
        return this.trgMap;
    }

    public KeyData getKeyData(String etype) {
        if (this.keytype == 1) {
            return this;
        }
        return this.trgMap.get(etype);
    }

    public void setModifiers(String[] ls) {
        this.modifier.addAll(Arrays.asList(ls));
    }

    public String set2String(Set<String> map) {
        StringBuilder sb = new StringBuilder();
        for (String s : map) {
            sb.append(s);
            sb.append(',');
        }
        return sb.toString();
    }

    public String getType(List<Word> tokens) {
        String s = null;
        if (this.keytype == 1) {
            if (!this.required) {
                return this.type;
            }
            for (Word w : tokens) {
                if (!this.modifier.contains(w.word)) continue;
                return this.type;
            }
        } else {
            KeyData tmkey;
            if (this.keytype == 2) {
                return "Gene_expression";
            }
            for (String etype : this.trgMap.keySet()) {
                tmkey = this.trgMap.get(etype);
                for (Word w : tokens) {
                    if (!tmkey.modifier.contains(w.word)) continue;
                    return tmkey.type;
                }
            }
            tmkey = null;
            int tmfreq = 0;
            for (String w : this.trgMap.keySet()) {
                KeyData tmk = this.trgMap.get(w);
                if (tmk.required || tmk.freq <= tmfreq) continue;
                tmkey = tmk;
                tmfreq = tmk.freq;
            }
            if (tmkey != null) {
                return tmkey.type;
            }
        }
        return s;
    }
}

