/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Iterators;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;

public class ShortPriorityQueue<E>
extends AbstractSet<E>
implements Queue<E>,
SortedSet<E> {
    private final Comparator<? super E> mComparator;
    private final E[] mElts;
    private int mSize = 0;

    public ShortPriorityQueue(Comparator<? super E> comparator, int maxSize) {
        Object[] elts = new Object[maxSize];
        this.mElts = elts;
        this.mComparator = comparator;
    }

    public int maxSize() {
        return this.mElts.length;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.arraySlice(this.mElts, 0, this.mSize);
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.mSize) {
            this.mElts[i] = null;
            ++i;
        }
        this.mSize = 0;
    }

    @Override
    public E peek() {
        return this.isEmpty() ? null : (E)this.mElts[0];
    }

    @Override
    public E element() {
        E result = this.peek();
        if (result == null) {
            throw new NoSuchElementException("");
        }
        return result;
    }

    public E peekLast() {
        return this.isEmpty() ? null : (E)this.mElts[this.mSize - 1];
    }

    @Override
    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.mElts[0];
    }

    @Override
    public E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.mElts[this.mSize - 1];
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        TreeSet<E> result = new TreeSet<E>();
        for (E e : this) {
            if (this.mComparator.compare(e, toElement) >= 0) break;
            result.add(e);
        }
        return result;
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        TreeSet<E> result = new TreeSet<E>();
        for (E e : this) {
            if (this.mComparator.compare(e, fromElement) < 0) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.mComparator;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        int c = this.mComparator.compare(fromElement, toElement);
        if (c >= 0) {
            String msg = "Lower bound must not be greater than the upper bound. Found fromElement=" + fromElement + " toElement=" + toElement;
            throw new IllegalArgumentException(msg);
        }
        TreeSet<E> result = new TreeSet<E>();
        for (E e : this) {
            if (this.mComparator.compare(e, fromElement) < 0) continue;
            if (this.mComparator.compare(e, toElement) >= 0) break;
            result.add(e);
        }
        return result;
    }

    @Override
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        E result = this.mElts[0];
        int i = 1;
        while (i < this.mSize) {
            this.mElts[i - 1] = this.mElts[i];
            ++i;
        }
        --this.mSize;
        return result;
    }

    @Override
    public E remove() {
        E result = this.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.mSize == 0;
    }

    @Override
    public boolean offer(E elt) {
        if (this.mSize == this.mElts.length) {
            int c = this.mComparator.compare(this.mElts[this.mElts.length - 1], elt);
            if (c >= 0) {
                return false;
            }
            this.mElts[this.mElts.length - 1] = elt;
        }
        if (this.mSize < this.mElts.length) {
            this.mElts[this.mSize] = elt;
            ++this.mSize;
        }
        int i = this.mSize - 1;
        while (--i >= 0 && this.mComparator.compare(this.mElts[i], this.mElts[i + 1]) < 0) {
            E temp = this.mElts[i];
            this.mElts[i] = this.mElts[i + 1];
            this.mElts[i + 1] = temp;
        }
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        int i = 0;
        while (i < this.mSize) {
            if (obj.equals(this.mElts[i])) {
                ++i;
                while (i < this.mSize) {
                    this.mElts[i - 1] = this.mElts[i];
                    ++i;
                }
                --this.mSize;
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ShortPriorityQueue(comparator=" + this.mComparator.getClass());
        sb.append(" maxLength=" + this.mElts.length + ")\n");
        int i = 0;
        while (i < this.mSize) {
            sb.append("  [" + i + "]=" + this.mElts[i] + "\n");
            ++i;
        }
        return sb.toString();
    }
}

