/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Tokenization
implements Serializable {
    static final long serialVersionUID = 3806073293589459401L;
    private final String mText;
    private final List<String> mTokens;
    private final List<String> mWhitespaces;
    private final int[] mTokenStarts;
    private final int[] mTokenEnds;

    public Tokenization(char[] cs, int start, int length, TokenizerFactory factory) {
        this(new String(cs, start, length), factory.tokenizer(cs, start, length));
    }

    public Tokenization(String text, TokenizerFactory factory) {
        this(text, factory.tokenizer(text.toCharArray(), 0, text.length()));
    }

    public Tokenization(String text, List<String> tokens, List<String> whitespaces, int[] tokenStarts, int[] tokenEnds) {
        this(text, new ArrayList<String>(tokens), new ArrayList<String>(whitespaces), (int[])tokenStarts.clone(), (int[])tokenEnds.clone(), false);
        if (tokens.size() != whitespaces.size() - 1) {
            String msg = "Require one more whitespace than token. Found tokens.size()=" + tokens.size() + " whitespaces.size()=" + whitespaces.size();
            throw new IllegalArgumentException(msg);
        }
        if (tokenStarts.length != tokens.size()) {
            String msg = "Require token starts to be same length as tokens Found tokenStarts.length=" + tokenStarts.length + " tokenEnds.length=" + tokenEnds.length;
            throw new IllegalArgumentException(msg);
        }
        if (tokenEnds.length != tokens.size()) {
            String msg = "Require token starts to be same length as tokens Found tokenEnds.length=" + tokenEnds.length + " tokenEnds.length=" + tokenEnds.length;
            throw new IllegalArgumentException(msg);
        }
        int i = 0;
        while (i < tokenStarts.length) {
            if (tokenStarts[i] < 0) {
                String msg = "Token starts must be non-negative. Found tokenStarts[" + i + "]=" + tokenStarts[i];
                throw new IllegalArgumentException(msg);
            }
            if (tokenEnds[i] > text.length()) {
                String msg = "Token ends must be less than or equal to text length. Found tokenEnds[" + i + "]=" + tokenEnds[i] + " text.length()=" + text.length();
                throw new IllegalArgumentException(msg);
            }
            if (tokenStarts[i] > tokenEnds[i]) {
                String msg = "Token starts must be less than or equal to ends. Found tokenStarts[" + i + "]=" + tokenStarts[i] + " tokenEnds[" + i + "]=" + tokenEnds[i];
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
    }

    Tokenization(String text, List<String> tokens, List<String> whitespaces, int[] tokenStarts, int[] tokenEnds, boolean ignore) {
        this.mText = text;
        this.mTokens = tokens;
        this.mWhitespaces = whitespaces;
        this.mTokenStarts = tokenStarts;
        this.mTokenEnds = tokenEnds;
    }

    Tokenization(String text, Tokenizer tokenizer) {
        String token;
        this.mText = text;
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> whitespaces = new ArrayList<String>();
        ArrayList<Integer> starts = new ArrayList<Integer>();
        ArrayList<Integer> ends = new ArrayList<Integer>();
        whitespaces.add(tokenizer.nextWhitespace());
        while ((token = tokenizer.nextToken()) != null) {
            tokens.add(token);
            whitespaces.add(tokenizer.nextWhitespace());
            starts.add(tokenizer.lastTokenStartPosition());
            ends.add(tokenizer.lastTokenEndPosition());
        }
        this.mTokens = tokens;
        this.mWhitespaces = whitespaces;
        this.mTokenStarts = new int[starts.size()];
        this.mTokenEnds = new int[starts.size()];
        int i = 0;
        while (i < starts.size()) {
            this.mTokenStarts[i] = (Integer)starts.get(i);
            this.mTokenEnds[i] = (Integer)ends.get(i);
            ++i;
        }
    }

    public String text() {
        return this.mText;
    }

    public int numTokens() {
        return this.mTokens.size();
    }

    public String token(int n) {
        return this.mTokens.get(n);
    }

    public String whitespace(int n) {
        return this.mWhitespaces.get(n);
    }

    public int tokenStart(int n) {
        return this.mTokenStarts[n];
    }

    public int tokenEnd(int n) {
        return this.mTokenEnds[n];
    }

    public String[] tokens() {
        return this.mTokens.toArray(Strings.EMPTY_STRING_ARRAY);
    }

    public String[] whitespaces() {
        return this.mWhitespaces.toArray(Strings.EMPTY_STRING_ARRAY);
    }

    public List<String> tokenList() {
        return Collections.unmodifiableList(this.mTokens);
    }

    public List<String> whitespaceList() {
        return Collections.unmodifiableList(this.mWhitespaces);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Tokenization)) {
            return false;
        }
        Tokenization thatT = (Tokenization)that;
        if (!this.text().equals(thatT.text())) {
            return false;
        }
        if (this.numTokens() != thatT.numTokens()) {
            return false;
        }
        int n = 0;
        while (n < this.numTokens()) {
            if (!this.token(n).equals(thatT.token(n))) {
                return false;
            }
            if (!this.whitespace(n).equals(thatT.whitespace(n))) {
                return false;
            }
            if (this.tokenStart(n) != thatT.tokenStart(n)) {
                return false;
            }
            if (this.tokenEnd(n) != thatT.tokenEnd(n)) {
                return false;
            }
            ++n;
        }
        return this.whitespace(this.numTokens()).equals(thatT.whitespace(this.numTokens()));
    }

    public int hashCode() {
        return 31 * this.mText.hashCode() + this.mTokens.size();
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 5248361056143805108L;
        Tokenization mToks;

        public Serializer() {
            this(null);
        }

        public Serializer(Tokenization toks) {
            this.mToks = toks;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.mToks.mText);
            out.writeInt(this.mToks.mTokens.size());
            for (String token : this.mToks.mTokens) {
                out.writeUTF(token);
            }
            for (String whitespace : this.mToks.mWhitespaces) {
                out.writeUTF(whitespace);
            }
            Serializer.writeInts(this.mToks.mTokenStarts, out);
            Serializer.writeInts(this.mToks.mTokenEnds, out);
        }

        @Override
        public Object read(ObjectInput in) throws IOException {
            String text = in.readUTF();
            int len = in.readInt();
            ArrayList<String> tokens = new ArrayList<String>(len);
            int i = 0;
            while (i < len) {
                tokens.add(in.readUTF());
                ++i;
            }
            ArrayList<String> whitespaces = new ArrayList<String>(len + 1);
            int i2 = 0;
            while (i2 <= len) {
                whitespaces.add(in.readUTF());
                ++i2;
            }
            int[] tokenStarts = Serializer.readInts(in);
            int[] tokenEnds = Serializer.readInts(in);
            boolean ignoreMe = true;
            return new Tokenization(text, tokens, whitespaces, tokenStarts, tokenEnds, ignoreMe);
        }
    }
}

