/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.Tokenization;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class TokenNGramTokenizerFactory
implements TokenizerFactory,
Serializable {
    static final long serialVersionUID = -2133429510163306074L;
    private final int mMin;
    private final int mMax;
    private final TokenizerFactory mTokenizerFactory;

    public TokenNGramTokenizerFactory(TokenizerFactory factory, int min, int max) {
        this.mTokenizerFactory = factory;
        this.mMin = min;
        this.mMax = max;
        if (min < 1) {
            String msg = "Minimum must be > 0. Found min=" + min;
            throw new IllegalArgumentException(msg);
        }
        if (min > max) {
            String msg = "Require min <= max. Found min=" + min + " max=" + max;
            throw new IllegalArgumentException(msg);
        }
    }

    public int minNGram() {
        return this.mMin;
    }

    public int maxNGram() {
        return this.mMax;
    }

    public TokenizerFactory baseTokenizerFactory() {
        return this.mTokenizerFactory;
    }

    @Override
    public Tokenizer tokenizer(char[] cs, int start, int len) {
        Tokenization tokenization = new Tokenization(cs, start, len, this.mTokenizerFactory);
        return new TokenNGramTokenizer(tokenization, this.mMin, this.mMax);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "\n  min ngram=" + this.mMin + "\n  max ngram=" + this.mMax + "\n  base factory=\n    " + this.baseTokenizerFactory().toString().replace("\n", "\n    ");
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 4080546796365073045L;
        final TokenNGramTokenizerFactory mFactory;

        public Serializer() {
            this(null);
        }

        public Serializer(TokenNGramTokenizerFactory factory) {
            this.mFactory = factory;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.mFactory.mMin);
            out.writeInt(this.mFactory.mMax);
            out.writeObject(this.mFactory.mTokenizerFactory);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            int min = in.readInt();
            int max = in.readInt();
            TokenizerFactory factory = (TokenizerFactory)in.readObject();
            return new TokenNGramTokenizerFactory(factory, min, max);
        }
    }

    static class TokenNGramTokenizer
    extends Tokenizer {
        private final int mMax;
        private final Tokenization mTokenization;
        private int mNGram;
        private int mPos = 0;
        private int mLastTokenStartPosition = -1;
        private int mLastTokenEndPosition = -1;

        public TokenNGramTokenizer(Tokenization tokenization, int min, int max) {
            this.mTokenization = tokenization;
            this.mMax = max;
            this.mNGram = min;
        }

        @Override
        public String nextToken() {
            if (this.mNGram > this.mMax) {
                return null;
            }
            int endPos = this.mPos + this.mNGram - 1;
            if (endPos >= this.mTokenization.numTokens()) {
                ++this.mNGram;
                this.mPos = 0;
                return this.nextToken();
            }
            this.mLastTokenStartPosition = this.mTokenization.tokenStart(this.mPos);
            this.mLastTokenEndPosition = this.mTokenization.tokenEnd(endPos);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.mNGram) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(this.mTokenization.token(this.mPos + i));
                ++i;
            }
            ++this.mPos;
            return sb.toString();
        }

        @Override
        public int lastTokenStartPosition() {
            return this.mLastTokenStartPosition;
        }

        @Override
        public int lastTokenEndPosition() {
            return this.mLastTokenEndPosition;
        }
    }
}

