/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.xml;

import com.aliasi.test.unit.MockObjectHelper;
import com.aliasi.test.unit.xml.MockDefaultHandler;
import com.aliasi.util.Tuple;
import com.aliasi.xml.SAXFilterHandler;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleElementHandlerTest {
    @Test
    public void testSimpleElement() throws SAXException {
        FilterHandlerTester filter = new FilterHandlerTester();
        MockDefaultHandler mockHandler = new MockDefaultHandler();
        MockObjectHelper helper = new MockObjectHelper();
        filter.setHandler(mockHandler);
        Attributes atts = SAXFilterHandler.createAttributes("att", "val");
        filter.startSimpleElement("foo", atts);
        helper.add("startElement", null, "foo", "foo", MockDefaultHandler.toString(atts));
        filter.startSimpleElement("elt");
        helper.add("startElement", null, "elt", "elt", MockDefaultHandler.EMPTY_ATTS_STRING);
        filter.endSimpleElement("elt");
        helper.add("endElement", null, "elt", "elt");
        Assert.assertEquals((Object)helper.getCalls(), (Object)mockHandler.getCalls());
    }

    @Test
    public void testSingleElementAtts() throws SAXException {
        FilterHandlerTester filter = new FilterHandlerTester();
        MockDefaultHandler mockHandler = new MockDefaultHandler();
        filter.setHandler(mockHandler);
        filter.startSimpleElement("bar", "att", "val");
        ArrayList calls = mockHandler.getCalls();
        Assert.assertEquals(((Tuple)calls.get(0)).get(4), (Object)"att=val");
    }

    @Test
    public void testCreateAtts() {
        Attributes atts = SAXFilterHandler.createAttributes("foo", "bar");
        Assert.assertEquals((int)1, (int)atts.getLength());
        Assert.assertEquals((String)"bar", (String)atts.getValue("foo"));
        Assert.assertEquals((String)"CDATA", (String)atts.getType(0));
        Assert.assertEquals((String)"foo", (String)atts.getQName(0));
        Assert.assertEquals((String)"foo", (String)atts.getLocalName(0));
        Assert.assertEquals(null, (String)atts.getURI(0));
        Assert.assertEquals((String)"bar", (String)atts.getValue(0));
        Attributes atts2 = SAXFilterHandler.createAttributes("foo1", "bar1", "foo2", "bar2");
        Assert.assertEquals((int)2, (int)atts2.getLength());
        Assert.assertEquals((String)"bar1", (String)atts2.getValue("foo1"));
        Assert.assertEquals((String)"bar2", (String)atts2.getValue("foo2"));
        AttributesImpl impl = new AttributesImpl();
        Assert.assertEquals((int)0, (int)impl.getLength());
        SAXFilterHandler.addSimpleAttribute(impl, "ping", "pong");
        SAXFilterHandler.addSimpleAttribute(impl, "base", "ball");
        Assert.assertEquals((int)2, (int)impl.getLength());
        Assert.assertEquals((String)"pong", (String)impl.getValue("ping"));
        Assert.assertEquals((String)"ball", (String)impl.getValue("base"));
    }

    static class FilterHandlerTester
    extends SAXFilterHandler {
        FilterHandlerTester() {
        }

        public DefaultHandler noOpHandler() {
            return NO_OP_DEFAULT_HANDLER;
        }
    }
}

