/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.ObjectToSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class ObjectToSetTest {
    @Test
    public void testRemove2() {
        ObjectToSet<String, Long> ots = new ObjectToSet<String, Long>();
        ots.addMember("a", 1L);
        ots.addMember("a", 2L);
        Assert.assertNotNull(ots.get("a"));
        ots.addMember("b", 3L);
        Assert.assertNotNull(ots.get("b"));
        Assert.assertNull(ots.get("c"));
        ots.removeMember("a", 1L);
        Assert.assertNotNull(ots.get("a"));
        ots.removeMember("a", 2L);
        Assert.assertNull(ots.get("a"));
    }

    @Test
    public void testConstructor() {
        ObjectToSet ots = new ObjectToSet();
        Assert.assertNotNull(ots);
        Assert.assertEquals((int)0, (int)ots.size());
    }

    @Test
    public void testRemove() {
        ObjectToSet<String, String> ots = new ObjectToSet<String, String>();
        ots.addMember("a", "b");
        HashSet<String> s1 = new HashSet<String>();
        s1.add("b");
        Assert.assertEquals(s1, ots.get("a"));
        boolean removed = ots.removeMember("a", "b");
        Assert.assertTrue((boolean)removed);
        Assert.assertEquals((int)0, (int)ots.getSet("a").size());
    }

    @Test
    public void testOne() {
        ObjectToSet<String, String> ots = new ObjectToSet<String, String>();
        Set foos = ots.getSet("foo");
        Assert.assertEquals(null, ots.get("foo"));
        Assert.assertEquals((Object)Collections.EMPTY_SET, ots.getSet("foo"));
        ots.addMember("foo", "bar");
        foos = ots.getSet("foo");
        Assert.assertEquals(ots.get("foo"), foos);
        Assert.assertEquals((int)1, (int)foos.size());
        Assert.assertTrue((boolean)foos.contains("bar"));
        Assert.assertFalse((boolean)foos.contains("fiz"));
        ots.addMember("foo", "baz");
        foos = (Set)ots.get("foo");
        Assert.assertEquals((int)2, (int)foos.size());
        Assert.assertTrue((boolean)foos.contains("bar"));
        Assert.assertTrue((boolean)foos.contains("baz"));
        Assert.assertFalse((boolean)foos.contains("fiz"));
        ots.addMember("boo", "bar");
        foos = (Set)ots.get("foo");
        Assert.assertEquals((int)2, (int)foos.size());
        Assert.assertTrue((boolean)foos.contains("bar"));
        Assert.assertTrue((boolean)foos.contains("baz"));
        Assert.assertFalse((boolean)foos.contains("fiz"));
        Set boos = (Set)ots.get("boo");
        Assert.assertEquals((int)1, (int)boos.size());
        Assert.assertTrue((boolean)boos.contains("bar"));
        Assert.assertFalse((boolean)boos.contains("fiz"));
        ots.addMembers("boo", Collections.EMPTY_SET);
        boos = (Set)ots.get("boo");
        Assert.assertEquals((int)1, (int)boos.size());
        Assert.assertTrue((boolean)boos.contains("bar"));
        HashSet<String> members = new HashSet<String>();
        members.add("1");
        members.add("2");
        ots.addMembers("boo", members);
        boos = (Set)ots.get("boo");
        Assert.assertEquals((int)3, (int)boos.size());
        Assert.assertTrue((boolean)boos.contains("1"));
        Assert.assertTrue((boolean)boos.contains("bar"));
        Assert.assertFalse((boolean)boos.contains("fiz"));
        HashSet<String> allMembers = new HashSet<String>();
        allMembers.add("bar");
        allMembers.add("baz");
        allMembers.add("1");
        allMembers.add("2");
        Assert.assertEquals(allMembers, ots.memberValues());
    }

    @Test
    public void testMemberIterator() {
        ObjectToSet<String, String> ots = new ObjectToSet<String, String>();
        HashSet<String> expected = new HashSet<String>();
        this.assertMemberIterator(ots, expected, 0);
        ots.addMember("a", "1");
        expected.add("1");
        this.assertMemberIterator(ots, expected, 1);
        ots.addMember("a", "2");
        expected.add("2");
        this.assertMemberIterator(ots, expected, 2);
        ots.addMember("a", "3");
        expected.add("3");
        this.assertMemberIterator(ots, expected, 3);
        ots.addMember("b", "3");
        this.assertMemberIterator(ots, expected, 4);
        ots.addMember("b", "2");
        this.assertMemberIterator(ots, expected, 5);
        ots.addMember("c", "4");
        expected.add("4");
        this.assertMemberIterator(ots, expected, 6);
    }

    void assertMemberIterator(ObjectToSet ots, Set expected, int expectedCount) {
        HashSet found = new HashSet();
        Iterator it = ots.memberIterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            found.add(it.next());
        }
        Assert.assertEquals((int)expectedCount, (int)count);
        Assert.assertEquals((Object)expected, found);
    }
}

