/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.CommaSeparatedValues;
import java.io.CharArrayReader;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class CommaSeparatedValuesTest {
    @Test
    public void testUnexpected() throws IOException {
        String input = "\"DVP-NC655P\",\"DVP-NC655CP\",FALSE\n\"DVP-NC655P\",\"#NAME?\",\"#NAME?\"\n\"DVP-NC655P\",\"DVP-NC655C\",FALSE";
        this.assertCsv(input, new String[][]{{"DVP-NC655P", "DVP-NC655CP", "FALSE"}, {"DVP-NC655P", "#NAME?", "#NAME?"}, {"DVP-NC655P", "DVP-NC655C", "FALSE"}});
    }

    @Test
    public void testUnquoted() throws IOException {
        this.assertCsv("", new String[0][]);
        this.assertCsv("a", new String[][]{{"a"}});
        this.assertCsv("a,b", new String[][]{{"a", "b"}});
        this.assertCsv("a,b\nc", new String[][]{{"a", "b"}, {"c"}});
        String input1 = "aa,b,c\nd,e,f";
        String[][] expected1 = new String[][]{{"aa", "b", "c"}, {"d", "e", "f"}};
        this.assertCsv(input1, expected1);
        String input2 = " aa ,b,  c\nd  ,e  ,   f";
        String[][] expected2 = expected1;
        this.assertCsv(input2, expected2);
        this.assertEqualsCsv("1997,Ford,E350", "1997,   Ford   , E350");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalA() throws IOException {
        this.assertCsv("a\",b", null);
    }

    @Test
    public void testQuoted() throws IOException {
        this.assertEqualsCsv("1997,Ford,E350", "\"1997\",Ford,E350");
        String in = "1997,Ford,E350,\"ac, abs, moon\",3000.00\n1999,Chevy,\"Venture \"\"Extended Edition\"\"\",4900.00\n1996,Jeep,Grand Cherokee,\"MUST SELL!\nair, moon roof, loaded\",4799.00";
        String[][] expected = new String[][]{{"1997", "Ford", "E350", "ac, abs, moon", "3000.00"}, {"1999", "Chevy", "Venture \"Extended Edition\"", "4900.00"}, {"1996", "Jeep", "Grand Cherokee", "MUST SELL!\nair, moon roof, loaded", "4799.00"}};
        this.assertCsv(in, expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testErrorB() throws IOException {
        this.assertCsv("\"abc", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testErrorC() throws IOException {
        this.assertCsv("\"abc\"  d,e", null);
    }

    void assertEqualsCsv(String input1, String input2) throws IOException {
        CharArrayReader reader1 = new CharArrayReader(input1.toCharArray());
        CommaSeparatedValues csv = new CommaSeparatedValues(reader1);
        String[][] expected = csv.getArray();
        this.assertCsv(input2, expected);
    }

    void assertCsv(String input, String[][] expected) throws IOException {
        CharArrayReader reader = new CharArrayReader(input.toCharArray());
        CommaSeparatedValues csv = new CommaSeparatedValues(reader);
        this.assertVals(csv, expected);
    }

    void assertVals(CommaSeparatedValues csv, String[][] expected) {
        String[][] found = csv.getArray();
        junit.framework.Assert.assertEquals((int)found.length, (int)expected.length);
        int i = 0;
        while (i < expected.length) {
            Assert.assertArrayEquals((Object[])expected[i], (Object[])found[i]);
            ++i;
        }
    }
}

