/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.test.unit.Asserts;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.BinaryMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class BinaryMapTest {
    static final Integer TEST_ONE = new Integer(1);

    @Test
    public void testSerializable() throws IOException {
        BinaryMap<String> map = new BinaryMap<String>();
        map.put("foo", TEST_ONE);
        Map map2 = (Map)AbstractExternalizable.serializeDeserialize(map);
        Assert.assertEquals(map, (Object)map2);
    }

    @Test
    public void testEmpty() {
        BinaryMap map = new BinaryMap();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((int)0, (int)map.size());
        Assert.assertFalse((boolean)map.containsKey("foo"));
        Assert.assertFalse((boolean)map.containsValue(TEST_ONE));
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.containsKey("foo"));
        Assert.assertFalse((boolean)map.containsValue(TEST_ONE));
        Assert.assertTrue((boolean)map.entrySet().isEmpty());
        Assert.assertNull(map.get("foo"));
        Assert.assertNull(map.remove("foo"));
        HashMap map2 = new HashMap();
        Assert.assertEquals(map, map2);
        Assert.assertEquals(map2, map);
        Assert.assertEquals((int)map.hashCode(), (int)map2.hashCode());
        Assert.assertEquals(map2.entrySet(), map.entrySet());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsuppSetKey() {
        BinaryMap map = new BinaryMap();
        map.put("foo", TEST_ONE);
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = it.next();
        entry.setValue(new Integer(0));
    }

    @Test
    public void testSingleton() {
        BinaryMap map = new BinaryMap();
        map.put("foo", new Integer(1));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertTrue((boolean)map.containsKey("foo"));
        Assert.assertFalse((boolean)map.containsKey("bar"));
        Assert.assertTrue((boolean)map.containsValue(TEST_ONE));
        Assert.assertFalse((boolean)map.containsValue(new Integer(0)));
        Assert.assertFalse((boolean)map.entrySet().isEmpty());
        Assert.assertNull(map.get("bar"));
        Assert.assertEquals((Object)TEST_ONE, map.get("foo"));
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        map2.put("foo", new Integer(1));
        Assert.assertEquals(map, map2);
        Assert.assertEquals(map2, map);
        Assert.assertEquals((int)map.hashCode(), (int)map2.hashCode());
        Assert.assertEquals(map2.entrySet(), map.entrySet());
        Assert.assertEquals(new HashSet(map2.values()), new HashSet(map.values()));
        Assert.assertEquals(map2.keySet(), map.keySet());
        Assert.assertNull(map.remove("bar"));
        Assert.assertEquals((Object)TEST_ONE, map.remove("foo"));
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testPair() {
        BinaryMap map = new BinaryMap();
        map.put("foo", new Integer(1));
        map.put("bar", new Integer(1));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertTrue((boolean)map.containsKey("foo"));
        Assert.assertTrue((boolean)map.containsKey("bar"));
        Assert.assertFalse((boolean)map.containsKey("baz"));
        Assert.assertTrue((boolean)map.containsValue(TEST_ONE));
        Assert.assertFalse((boolean)map.containsValue(new Integer(0)));
        Assert.assertFalse((boolean)map.entrySet().isEmpty());
        Assert.assertNull(map.get("baz"));
        Assert.assertEquals((Object)TEST_ONE, map.get("foo"));
        Assert.assertEquals((Object)TEST_ONE, map.get("bar"));
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        map2.put("foo", new Integer(1));
        map2.put("bar", new Integer(1));
        Assert.assertEquals(map, map2);
        Assert.assertEquals(map2, map);
        Assert.assertEquals((int)map.hashCode(), (int)map2.hashCode());
        Assert.assertEquals(map2.entrySet(), map.entrySet());
        Assert.assertEquals(new HashSet(map2.values()), new HashSet(map.values()));
        Assert.assertEquals(map2.keySet(), map.keySet());
        Assert.assertNull(map.remove("baz"));
        Assert.assertEquals((Object)TEST_ONE, map.remove("foo"));
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertNull(map.remove("baz2"));
        Assert.assertEquals((Object)TEST_ONE, map.remove("bar"));
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testMutableEntrySet() {
        BinaryMap map = new BinaryMap();
        map.put("foo", new Integer(1));
        map.put("bar", new Integer(1));
        Set entrySet = map.entrySet();
        Assert.assertTrue((boolean)entrySet.contains(new SNEntry("foo")));
        Assert.assertTrue((boolean)entrySet.contains(new SNEntry("bar")));
        Assert.assertFalse((boolean)entrySet.contains(new SNEntry("baz")));
        Assert.assertTrue((boolean)entrySet.remove(new SNEntry("foo")));
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertFalse((boolean)entrySet.remove(new SNEntry("baz")));
        Assert.assertFalse((boolean)entrySet.remove(new SNEntry("bar", new Integer(4))));
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertEquals((int)1, (int)entrySet.size());
        map.put("baz", new Integer(1));
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertEquals((int)2, (int)entrySet.size());
        try {
            entrySet.add(new SNEntry("biz"));
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Asserts.succeed();
        }
        entrySet.clear();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertTrue((boolean)entrySet.isEmpty());
        map.put("foo", new Integer(1));
        map.put("bar", new Integer(1));
        entrySet.remove(new SNEntry("foo"));
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertEquals((int)1, (int)entrySet.size());
        Assert.assertEquals((Object)TEST_ONE, map.get("bar"));
        Assert.assertNull(map.get("foo"));
    }

    @Test
    public void testMutableKeySet() {
        BinaryMap map = new BinaryMap();
        map.put("foo", new Integer(1));
        map.put("bar", new Integer(1));
        Set keySet = map.keySet();
        Assert.assertTrue((boolean)keySet.contains("foo"));
        Assert.assertTrue((boolean)keySet.contains("bar"));
        Assert.assertFalse((boolean)keySet.contains("baz"));
        Assert.assertTrue((boolean)keySet.remove("foo"));
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertFalse((boolean)keySet.remove("baz"));
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertEquals((int)1, (int)keySet.size());
        map.put("baz", new Integer(1));
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertEquals((int)2, (int)keySet.size());
        keySet.add("bing");
        Assert.assertEquals((int)3, (int)map.size());
        Assert.assertEquals((int)3, (int)keySet.size());
        keySet.clear();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertTrue((boolean)keySet.isEmpty());
        map.put("foo", new Integer(1));
        map.put("bar", new Integer(1));
        keySet.remove("foo");
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertEquals((int)1, (int)keySet.size());
        Assert.assertEquals((Object)TEST_ONE, map.get("bar"));
        Assert.assertNull(map.get("foo"));
    }

    @Test
    public void testMutableValues() {
        BinaryMap map = new BinaryMap();
        map.put("foo", new Integer(1));
        map.put("bar", new Integer(1));
        Collection values = map.values();
        Assert.assertTrue((boolean)values.contains(TEST_ONE));
        Assert.assertFalse((boolean)values.contains(new Integer(4)));
        Assert.assertEquals((int)1, (int)values.size());
        Assert.assertFalse((boolean)values.isEmpty());
        Assert.assertFalse((boolean)values.remove(new Integer(54)));
        Assert.assertTrue((boolean)values.remove(TEST_ONE));
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((int)0, (int)map.size());
        Assert.assertEquals((int)0, (int)values.size());
        map.put("foo", new Integer(1));
        map.put("baz", new Integer(1));
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertEquals((int)1, (int)values.size());
        try {
            values.add(new Integer(3));
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Asserts.succeed();
        }
        values.clear();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertTrue((boolean)values.isEmpty());
        map.put("foo", new Integer(1));
        map.put("bar", new Integer(1));
        Assert.assertEquals((int)1, (int)values.size());
        Assert.assertFalse((boolean)values.removeAll(Arrays.asList(new Integer(2), new Integer(3))));
        Assert.assertEquals((int)1, (int)values.size());
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertTrue((boolean)values.removeAll(Arrays.asList(new Integer(2), new Integer(3), new Integer(1))));
        Assert.assertTrue((boolean)values.isEmpty());
        Assert.assertTrue((boolean)map.isEmpty());
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        map2.put("foo", new Integer(1));
        map2.put("bar", new Integer(1));
        Assert.assertFalse((boolean)map2.isEmpty());
        map2.values().removeAll(Arrays.asList(TEST_ONE));
        Assert.assertTrue((boolean)map2.isEmpty());
    }

    static class SNEntry
    implements Map.Entry<String, Integer> {
        final String mS;
        final Integer mN;

        public SNEntry(String s) {
            this(s, 1);
        }

        public SNEntry(String s, int n) {
            this.mS = s;
            this.mN = new Integer(n);
        }

        @Override
        public String getKey() {
            return this.mS;
        }

        @Override
        public Integer getValue() {
            return this.mN;
        }

        @Override
        public boolean equals(Object that) {
            if (!(that instanceof Map.Entry)) {
                return false;
            }
            SNEntry e1 = this;
            Map.Entry e2 = (Map.Entry)that;
            return (e1.getKey() == null ? e2.getKey() == null : e1.getKey().equals(e2.getKey())) && (e1.getValue() == null ? e2.getValue() == null : e1.getValue().equals(e2.getValue()));
        }

        @Override
        public Integer setValue(Integer n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            SNEntry e = this;
            return (e.getKey() == null ? 0 : e.getKey().hashCode()) ^ (e.getValue() == null ? 0 : e.getValue().hashCode());
        }
    }
}

