/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.test.unit.Asserts;
import com.aliasi.util.AbstractCommand;
import java.util.Properties;
import junit.framework.Assert;
import org.junit.Test;

public class AbstractCommandTest {
    @Test
    public void test1() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testOne() {
        CommandLineArguments args = new CommandLineArguments(new String[0]);
        Assert.assertFalse((boolean)args.hasFlag("foo"));
        Assert.assertNull((Object)args.getBareArgument(1));
        Assert.assertNull((Object)args.getArgument("bar"));
    }

    @Test
    public void testFilePrefixes() {
        new TestCmd(new String[]{"-file1=abc", "-file2=build/b", "c"}).run();
    }

    @Test
    public void testTwo() {
        CommandLineArguments args = new CommandLineArguments(new String[]{"foo", "bar"});
        Assert.assertFalse((boolean)args.hasFlag("foo"));
        Assert.assertEquals((String)"foo", (String)args.getBareArgument(0));
        Assert.assertEquals((String)"bar", (String)args.getBareArgument(1));
        Assert.assertNull((Object)args.getArgument("bar"));
    }

    @Test
    public void testThree() {
        CommandLineArguments args = new CommandLineArguments(new String[]{"-foo", "bar"});
        Assert.assertTrue((boolean)args.hasFlag("foo"));
        Assert.assertEquals((String)"bar", (String)args.getBareArgument(0));
        Assert.assertNull((Object)args.getArgument("baz"));
    }

    @Test
    public void testFour() {
        CommandLineArguments args = new CommandLineArguments(new String[]{"-foo", "bar", "-baz=ping"});
        Assert.assertTrue((boolean)args.hasFlag("foo"));
        Assert.assertEquals((String)"bar", (String)args.getBareArgument(0));
        Assert.assertEquals((String)"ping", (String)args.getArgument("baz"));
    }

    @Test
    public void testFive() {
        Properties defaults = new Properties();
        defaults.setProperty("a", "b");
        CommandLineArguments args = new CommandLineArguments(new String[]{"-foo", "bar", "-baz=ping"}, defaults);
        Assert.assertTrue((boolean)args.hasFlag("foo"));
        Assert.assertEquals((String)"bar", (String)args.getBareArgument(0));
        Assert.assertEquals((String)"ping", (String)args.getArgument("baz"));
        Assert.assertEquals((String)"b", (String)args.getArgument("a"));
    }

    @Test
    public void testExceptions1() {
        new CommandLineArguments(new String[]{"bar", "-foo="});
        Asserts.succeed();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptions2() {
        new CommandLineArguments(new String[]{"-=val", "bar"});
    }

    @Test
    public void testHasArgument() {
        String[] argArray = new String[]{"-foo", "-bar=17", "-baz=17a"};
        CommandLineArguments args = new CommandLineArguments(argArray);
        Assert.assertTrue((boolean)args.hasArgument("bar"));
        Assert.assertFalse((boolean)args.hasArgument("abc"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetInt() {
        String[] argArray = new String[]{"-foo", "-bar=17", "-baz=17a"};
        CommandLineArguments args = new CommandLineArguments(argArray);
        Assert.assertEquals((int)17, (int)args.getArgumentInt("bar"));
        boolean threw = false;
        args.getArgumentInt("baz");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDouble() {
        String[] argArray = new String[]{"-foo", "-bar=17.9", "-baz=17a"};
        CommandLineArguments args = new CommandLineArguments(argArray);
        Assert.assertEquals((double)17.9, (double)args.getArgumentDouble("bar"), (double)0.005);
        boolean threw = false;
        args.getArgumentInt("baz");
    }

    @Test
    public void testHasProperty() {
        String[] argArray = new String[]{"-foo", "-bar=17.9", "-baz=17a"};
        CommandLineArguments args = new CommandLineArguments(argArray);
        Assert.assertTrue((boolean)args.hasFlag("foo"));
        Assert.assertFalse((boolean)args.hasFlag("bar"));
        Assert.assertFalse((boolean)args.hasFlag("boo"));
        Assert.assertFalse((boolean)args.hasProperty("foo"));
        Assert.assertTrue((boolean)args.hasProperty("bar"));
        Assert.assertTrue((boolean)args.hasProperty("baz"));
    }

    private static class CommandLineArguments
    extends AbstractCommand {
        public CommandLineArguments(String[] args) {
            super(args);
        }

        public CommandLineArguments(String[] args, Properties props) {
            super(args, props);
        }

        @Override
        public void run() {
        }
    }

    private static class TestCmd
    extends AbstractCommand {
        public TestCmd(String[] args) {
            super(args);
        }

        @Override
        public void run() {
            this.getArgumentCreatableFile("file1");
        }
    }
}

