/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.test.unit.Asserts;
import com.aliasi.test.unit.tokenizer.TokenizerTest;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.SoundexTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import junit.framework.Assert;
import org.junit.Test;

public class SoundexTokenizerFactoryTest {
    @Test
    public void testFactory() {
        IndoEuropeanTokenizerFactory ieFactory = IndoEuropeanTokenizerFactory.INSTANCE;
        SoundexTokenizerFactory soundexFactory = new SoundexTokenizerFactory(ieFactory);
        TokenizerTest.assertFactory((TokenizerFactory)soundexFactory, "", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)soundexFactory, "1", "0000");
        TokenizerTest.assertFactory((TokenizerFactory)soundexFactory, "1 1", "0000", "0000");
        TokenizerTest.assertFactory((TokenizerFactory)soundexFactory, "Robert 1 Guttierez", "R163", "0000", "G362");
    }

    @Test
    public void testNotSerializable() {
        SoundexTokenizerFactory unserializable = new SoundexTokenizerFactory(TokenizerTest.UNSERIALIZABLE_FACTORY);
        Asserts.assertNotSerializable(unserializable);
    }

    @Test
    public void testSoundex() {
        this.assertSoundex("", "0000");
        this.assertSoundex("1", "0000");
        this.assertSoundex("34", "0000");
        this.assertSoundex("#$%^&*(", "0000");
        this.assertSoundex("Gutierrez", "G362");
        this.assertSoundex("Pfister", "P236");
        this.assertSoundex("Jackson", "J250");
        this.assertSoundex("Tymczak", "T522");
        this.assertSoundex("VanDeusen", "V532");
        this.assertSoundex("Ashcraft", "A261");
        this.assertSoundex("Robert", "R163");
        this.assertSoundex("Rupert", "R163");
        this.assertSoundex("Rubin", "R150");
        this.assertSoundex("Euler", "E460");
        this.assertSoundex("Gauss", "G200");
        this.assertSoundex("Hilbert", "H416");
        this.assertSoundex("Knuth", "K530");
        this.assertSoundex("Lloyd", "L300");
        this.assertSoundex("Lukasiewicz", "L222");
        this.assertSoundex("Wachs", "W200");
        this.assertSoundex("Ellery", "E460");
        this.assertSoundex("Ghosh", "G200");
        this.assertSoundex("Heilbronn", "H416");
        this.assertSoundex("Kant", "K530");
        this.assertSoundex("Liddy", "L300");
        this.assertSoundex("Lissajous", "L222");
        this.assertSoundex("Waugh", "W200");
    }

    void assertSoundex(String in, String soundexToken) {
        String encodedToken = SoundexTokenizerFactory.soundexEncoding(in);
        Assert.assertEquals((String)("in=" + in + " soundex=" + soundexToken + " found=" + encodedToken), (String)soundexToken, (String)encodedToken);
    }
}

