/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.PoissonConstant;
import com.aliasi.test.unit.stats.PoissonDistributionTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import org.junit.Test;

public class PoissonConstantTest {
    @Test
    public void testOne() {
        PoissonConstant dist = new PoissonConstant(2.0);
        PoissonDistributionTest.assertPoissonTwo(dist);
    }

    @Test
    public void testCompile() throws ClassNotFoundException, IOException {
        PoissonConstant dist = new PoissonConstant(2.0);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        dist.compileTo(objOut);
        byte[] bytes = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        ObjectInputStream dataIn = new ObjectInputStream(bytesIn);
        PoissonConstant dist2 = (PoissonConstant)dataIn.readObject();
        PoissonDistributionTest.assertPoissonTwo(dist2);
    }

    @Test
    public void testExceptions() {
        PoissonConstant dist = new PoissonConstant(2.0);
        Assert.assertTrue((Double.NEGATIVE_INFINITY == dist.log2Probability(-1L) ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)dist.probability(-1L), (double)0.005);
        try {
            new PoissonConstant(-2.0);
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

