/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.OnlineNormalEstimator;
import com.aliasi.util.Math;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class OnlineNormalEstimatorTest {
    public void testBadUnHandle1() {
        OnlineNormalEstimator estimator = new OnlineNormalEstimator();
        estimator.unHandle(2.0);
    }

    @Test(expected=IllegalStateException.class)
    public void testBadUnhandle2() {
        OnlineNormalEstimator estimator = new OnlineNormalEstimator();
        estimator.handle(2.0);
        estimator.unHandle(2.0);
        estimator.unHandle(2.0);
    }

    public void testUnhandle() {
        OnlineNormalEstimator estimator = new OnlineNormalEstimator();
        estimator.handle(1.0);
        Assert.assertEquals((long)1L, (long)estimator.numSamples());
        estimator.unHandle(1.0);
        Assert.assertEquals((long)0L, (long)estimator.numSamples());
        estimator.handle(2.0);
        Assert.assertEquals((long)1L, (long)estimator.numSamples());
        Assert.assertEquals((double)2.0, (double)estimator.mean(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)estimator.variance(), (double)1.0E-4);
        estimator.handle(1.0);
        Assert.assertEquals((long)2L, (long)estimator.numSamples());
        Assert.assertEquals((double)1.5, (double)estimator.mean(), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)estimator.variance(), (double)1.0E-4);
        estimator.unHandle(2.0);
        Assert.assertEquals((long)1L, (long)estimator.numSamples());
        Assert.assertEquals((double)1.0, (double)estimator.mean(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)estimator.variance(), (double)1.0E-4);
        estimator.handle(2.0);
        estimator.handle(3.0);
        estimator.unHandle(2.0);
        Assert.assertEquals((long)2L, (long)estimator.numSamples());
        Assert.assertEquals((double)2.0, (double)estimator.mean(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)estimator.variance(), (double)1.0E-4);
    }

    @Test
    public void testNumSamples() {
        OnlineNormalEstimator estimator = OnlineNormalEstimatorTest.estimator(new double[0]);
        Assert.assertEquals((long)0L, (long)estimator.numSamples());
        estimator.handle(5.0);
        Assert.assertEquals((long)1L, (long)estimator.numSamples());
        estimator.handle(6.0);
        Assert.assertEquals((long)2L, (long)estimator.numSamples());
    }

    @Test
    public void testMean() {
        int i = 0;
        while (i < 10) {
            double[] xs = OnlineNormalEstimatorTest.randomArray(42L, 500);
            Assert.assertEquals((double)OnlineNormalEstimatorTest.mean(xs), (double)OnlineNormalEstimatorTest.estimator(xs).mean(), (double)1.0E-4);
            ++i;
        }
    }

    @Test
    public void testVariance() {
        int i = 0;
        while (i < 10) {
            double[] xs = OnlineNormalEstimatorTest.randomArray(42L, 500);
            Assert.assertEquals((double)OnlineNormalEstimatorTest.variance(xs), (double)OnlineNormalEstimatorTest.estimator(xs).variance(), (double)1.0E-4);
            Assert.assertEquals((double)java.lang.Math.sqrt(OnlineNormalEstimatorTest.variance(xs)), (double)OnlineNormalEstimatorTest.estimator(xs).standardDeviation(), (double)1.0E-4);
            Assert.assertEquals((double)(1.002004008016032 * OnlineNormalEstimatorTest.variance(xs)), (double)OnlineNormalEstimatorTest.estimator(xs).varianceUnbiased(), (double)1.0E-4);
            Assert.assertEquals((double)java.lang.Math.sqrt(1.002004008016032 * OnlineNormalEstimatorTest.variance(xs)), (double)OnlineNormalEstimatorTest.estimator(xs).standardDeviationUnbiased(), (double)1.0E-4);
            ++i;
        }
    }

    static double[] randomArray(long seed, int length) {
        Random random = new Random(seed);
        double[] xs = new double[length];
        int i = 0;
        while (i < xs.length) {
            xs[i] = random.nextDouble();
            ++i;
        }
        return xs;
    }

    static OnlineNormalEstimator estimator(double[] xs) {
        OnlineNormalEstimator est = new OnlineNormalEstimator();
        int i = 0;
        while (i < xs.length) {
            est.handle(xs[i]);
            ++i;
        }
        return est;
    }

    static double mean(double[] xs) {
        return Math.sum(xs) / (double)xs.length;
    }

    static double variance(double[] xs) {
        return OnlineNormalEstimatorTest.sumSquareDiffs(xs, OnlineNormalEstimatorTest.mean(xs)) / (double)xs.length;
    }

    static double sumSquareDiffs(double[] xs, double mean) {
        double sum = 0.0;
        int i = 0;
        while (i < xs.length) {
            double diff = xs[i] - mean;
            sum += diff * diff;
            ++i;
        }
        return sum;
    }
}

