/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.MultivariateDistribution;
import com.aliasi.util.Math;
import junit.framework.Assert;
import org.junit.Test;

public class MultivariateDistributionTest {
    @Test
    public void testOne() {
        Distro distro = new Distro();
        Assert.assertEquals((int)10, (int)distro.numDimensions());
        Assert.assertEquals((long)0L, (long)distro.minOutcome());
        Assert.assertEquals((long)9L, (long)distro.maxOutcome());
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbabilityLess(4L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbabilityLess(-1L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityLess(9L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityLess(20L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbabilityGreater(5L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbabilityGreater(10L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityGreater(0L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityGreater(-20L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(1L, 5L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(-3L, 4L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(-3L, 4L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbability(-3L, -4L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbability(-3L, 15L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbability(0L, 9L), (double)0.001);
        Assert.assertEquals((double)0.1, (double)distro.probability(0L), (double)1.0E-4);
        Assert.assertEquals((double)0.1, (double)distro.probability(5L), (double)1.0E-4);
        Assert.assertEquals((double)0.1, (double)distro.probability(9L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)distro.probability(17L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(0L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(5L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(9L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.0), (double)distro.log2Probability(17L), (double)1.0E-4);
        double mean = 4.5;
        double variance = 0.0;
        int i = 0;
        while (i < 10) {
            double diff = mean - (double)i;
            variance += diff * diff;
            ++i;
        }
        Assert.assertEquals((double)mean, (double)distro.mean(), (double)1.0E-4);
        Assert.assertEquals((double)(variance /= 10.0), (double)distro.variance(), (double)1.0E-4);
        double entropy = 0.0;
        int i2 = 0;
        while (i2 <= 9) {
            entropy += -distro.probability(i2) * distro.log2Probability(i2);
            ++i2;
        }
        Assert.assertEquals((double)entropy, (double)distro.entropy(), (double)1.0E-4);
        Assert.assertEquals((String)"1", (String)distro.label(1L));
        Assert.assertEquals((long)1L, (long)distro.outcome("1"));
        try {
            Assert.assertEquals((String)"-1", (String)distro.label(-1L));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertEquals((long)-1L, (long)distro.outcome("foo"));
    }

    public static class Distro
    extends MultivariateDistribution {
        @Override
        public double probability(long outcome) {
            if (outcome < this.minOutcome() || outcome > this.maxOutcome()) {
                return 0.0;
            }
            return 0.1;
        }

        @Override
        public int numDimensions() {
            return 10;
        }
    }
}

