/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.BernoulliConstant;
import com.aliasi.stats.BinomialDistribution;
import com.aliasi.test.unit.Asserts;
import com.aliasi.util.Math;
import junit.framework.Assert;
import org.junit.Test;

public class BinomialDistributionTest {
    @Test
    public void testProbability() {
        BernoulliConstant bernoulli = new BernoulliConstant(0.4);
        BinomialDistribution distro = new BinomialDistribution(bernoulli, 15);
        double log2Success = Math.log2(0.4);
        double log2Fail = Math.log2(0.6);
        Assert.assertEquals((double)(BinomialDistribution.log2BinomialCoefficient(15L, 3L) + 3.0 * log2Success + 12.0 * log2Fail), (double)distro.log2Probability(3L), (double)1.0E-4);
        double sum = 0.0;
        long i = 0L;
        while (i <= 15L) {
            sum += distro.probability(i);
            ++i;
        }
        Assert.assertEquals((double)1.0, (double)sum, (double)0.001);
    }

    @Test
    public void testZandP() {
        double expectedZ4 = 0.7000000000000002 / java.lang.Math.sqrt(2.3099999999999996);
        Assert.assertEquals((double)expectedZ4, (double)BinomialDistribution.z(0.3, 4, 11), (double)1.0E-4);
        BernoulliConstant bernoulli = new BernoulliConstant(0.3);
        BinomialDistribution distro = new BinomialDistribution(bernoulli, 11);
        Assert.assertEquals((double)expectedZ4, (double)distro.z(4), (double)1.0E-4);
    }

    @Test
    public void testExceptions() {
        BernoulliConstant bernoulli = new BernoulliConstant(0.4);
        try {
            new BinomialDistribution(bernoulli, -1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            BinomialDistribution.z(-2.0, 3, 10);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            BinomialDistribution.z(Double.POSITIVE_INFINITY, 3, 11);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            BinomialDistribution.z(2.0, 5, 10);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            BinomialDistribution.z(0.5, -1, 10);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            BinomialDistribution.z(0.5, 2, 1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }

    @Test
    public void testCoeff() {
        Assert.assertEquals((double)(Math.log2Factorial(5L) - Math.log2Factorial(3L) - Math.log2Factorial(2L)), (double)BinomialDistribution.log2BinomialCoefficient(5L, 2L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)BinomialDistribution.log2BinomialCoefficient(3L, 3L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)BinomialDistribution.log2BinomialCoefficient(3L, 0L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)BinomialDistribution.log2BinomialCoefficient(0L, 0L), (double)1.0E-4);
        try {
            BinomialDistribution.log2BinomialCoefficient(3L, 4L);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }
}

