/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.spell;

import com.aliasi.spell.JaroWinklerDistance;
import junit.framework.Assert;
import org.junit.Test;

public class JaroWinklerDistanceTest {
    @Test
    public void testOnes() {
        this.testDistance("", "", 1.0, 1.0);
        this.testDistance("a", "a", 1.0, 1.0);
        this.testDistance("ab", "ab", 1.0, 1.0);
        this.testDistance("abc", "abc", 1.0, 1.0);
        this.testDistance("abcd", "abcd", 1.0, 1.0);
        this.testDistance("abcde", "abcde", 1.0, 1.0);
        this.testDistance("aa", "aa", 1.0, 1.0);
        this.testDistance("aaa", "aaa", 1.0, 1.0);
        this.testDistance("aaaa", "aaaa", 1.0, 1.0);
        this.testDistance("aaaaa", "aaaaa", 1.0, 1.0);
        this.testDistance("a", "b", 0.0, 0.0);
        this.testDistance("", "abc", 0.0, 0.0);
        this.testDistance("abcd", "", 0.0, 0.0);
    }

    @Test
    public void testLastNames() {
        this.testDistance("shackleford", "shackelford", 0.97, 0.982);
        this.testDistance("dunningham", "cunnigham", 0.896, 0.896);
        this.testDistance("nichleson", "nichulson", 0.926, 0.956);
        this.testDistance("jones", "johnson", 0.79, 0.832);
        this.testDistance("massey", "massie", 0.889, 0.933);
        this.testDistance("abroms", "abrams", 0.889, 0.922);
        this.testDistance("hardin", "martinez", 0.722, 0.722);
        this.testDistance("itman", "smith", 0.467, 0.467);
    }

    @Test
    public void testFirstNames() {
        this.testDistance("jeraldine", "geraldine", 0.926, 0.926);
        this.testDistance("marhta", "martha", 0.944, 0.961);
        this.testDistance("michelle", "michael", 0.869, 0.921);
        this.testDistance("julies", "julius", 0.889, 0.933);
        this.testDistance("tanya", "tonya", 0.867, 0.88);
        this.testDistance("dwayne", "duane", 0.822, 0.84);
        this.testDistance("sean", "susan", 0.783, 0.805);
        this.testDistance("jon", "john", 0.917, 0.933);
        this.testDistance("jon", "jan", 0.778, 0.8);
    }

    void testDistance(String s1, String s2, double expectedJaro, double expectedWinkler) {
        Assert.assertEquals((double)expectedJaro, (double)JaroWinklerDistance.JARO_DISTANCE.proximity(s1, s2), (double)0.002);
        Assert.assertEquals((double)expectedWinkler, (double)JaroWinklerDistance.JARO_WINKLER_DISTANCE.proximity(s1, s2), (double)0.002);
        Assert.assertEquals((double)(1.0 - expectedJaro), (double)JaroWinklerDistance.JARO_DISTANCE.distance(s1, s2), (double)0.002);
        Assert.assertEquals((double)(1.0 - expectedWinkler), (double)JaroWinklerDistance.JARO_WINKLER_DISTANCE.distance(s1, s2), (double)0.002);
    }
}

